/*
 * Decompiled with CFR 0.152.
 */
package Watches;

import CATALYST.Control.ColumnData;
import CATALYST.Control.MarketWatch;
import CATALYST.Control.MarketWatchEvent;
import CATALYST.Control.MarketWatchListner;
import CATALYST.Control.Utilities;
import MyDocking.Mediator;
import Utilities.LoadLogs;
import Utilities.ThreadWithName;
import common.gui.component.JTextFieldFilter;
import common.gui.util.AppConfig;
import common.gui.util.FormName;
import common.gui.util.LogCommon;
import common.gui.util.MyColors;
import common.gui.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.text.Document;
import kse.util.UtilKSE;
import languages.LanguageCentre;
import languages.LanguageConstant;

public class SpotWatch
extends JPanel
implements MarketWatchListner,
ActionListener {
    private Mediator mediator = Mediator.getInstance();
    public MarketWatch Mwh;
    JLabel lblSymbolName = new JLabel();
    private JTextField txtSymbol;
    private JLabel lblSymbol;
    private String SpotSymbols = "";
    private boolean LoadSpot = true;
    private HashMap<String, Integer> columnIndex = new HashMap();
    private LanguageCentre languageCentre = new LanguageCentre();

    private void setColumnIndex() {
        int index = 0;
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Market), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Scrip), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.LowerLock), index++);
        this.columnIndex.put(this.languageCentre.getValue("Payout"), index++);
        this.columnIndex.put(this.languageCentre.getValue("BuyVol"), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Buy), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Sell), index++);
        this.columnIndex.put(this.languageCentre.getValue("SellVol"), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.UpperCap), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.LastPrice), index++);
        this.columnIndex.put(this.languageCentre.getValue("Change"), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.PercentChange), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Trade), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.CompanySnapshot), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Analytics), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Graph), index++);
        this.columnIndex.put(this.languageCentre.getValue("Dir"), index++);
        this.columnIndex.put(this.languageCentre.getValue("LTrdTime"), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.TotalVolume), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Low), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Average), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.High), index++);
        this.columnIndex.put(this.languageCentre.getValue("TotalTrd"), index++);
        this.columnIndex.put(this.languageCentre.getValue("LTrdVolume"), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.ClosePrice), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.OpenPrice), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.State), index++);
        this.columnIndex.put(this.languageCentre.getValue(LanguageConstant.Flag), index++);
    }

    public SpotWatch() {
        this.setColumnIndex();
        this.mediator.setSpotWatch(this);
        this.Mwh = new MarketWatch("Spot Watch", this.columnIndex);
        ColumnData[] m_columns = new ColumnData[]{new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Market), 50, 2), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Scrip), 100, 2), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.LowerLock), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("Payout"), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("BuyVol"), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Buy), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Sell), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("SellVol"), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.UpperCap), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.LastPrice), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("Change"), 70, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.PercentChange), 70, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("Dir"), 40, 0), new ColumnData(this.Mwh, this.languageCentre.getValue("LTrdTime"), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.TotalVolume), 100, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Low), 70, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Average), 70, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.High), 70, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("TotalTrd"), 70, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("LTrdVolume"), 100, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.ClosePrice), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.OpenPrice), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.State), 50, 2), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Flag), 50, 2), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Trade), 80, 0), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.CompanySnapshot), 150, 0), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Analytics), 100, 0), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Graph), 100, 0)};
        this.Mwh.isHistoricalDataWatch = false;
        this.Mwh.ChangeAllColorAndFonts(MyColors.MarketWatchRowColor, MyColors.MarketWatchSelectedRowColor, MyColors.MarketWatchIncreaseColor, MyColors.MarketWatchDecreaseColor, LogCommon.MarketWatchFont);
        this.Mwh.SetHeight = new JFrame().getToolkit().getScreenSize().height - 500;
        this.Mwh.SetWidth = new JFrame().getToolkit().getScreenSize().width + 130;
        this.Mwh.setMarket(LogCommon.markets);
        this.Mwh.Debug = false;
        this.Mwh.addListener((MarketWatchListner)this);
        this.Mwh.isUserAddScrip = false;
        this.Mwh.ShowTradeButton = AppConfig.ShowTradeButton;
        this.Mwh.ShowCompanySnapButton = AppConfig.ShowCompanySnapshotButton;
        this.Mwh.ShowGraphButton = AppConfig.ShowGraphButton;
        this.Mwh.ShowAnalyticsButton = AppConfig.ShowAnalyticsButton;
        this.Mwh.isStandardCapital = AppConfig.isStandardCapital;
        this.Mwh.init(m_columns);
        this.Mwh.comboBox.setModel(new DefaultComboBoxModel<String>(LogCommon.markets));
        this.Mwh.comboBox.removeItem("");
        this.Mwh.m_table.moveColumn(this.Mwh.m_table.getColumnModel().getColumnIndex(this.languageCentre.getValue(LanguageConstant.Trade)), 9);
        if (this.Mwh.m_table.isColumnExist(this.languageCentre.getValue(LanguageConstant.CompanySnapshot))) {
            this.Mwh.m_table.moveColumn(this.Mwh.m_table.getColumnModel().getColumnIndex(this.languageCentre.getValue(LanguageConstant.CompanySnapshot)), 10);
        }
        this.lblSymbol = new JLabel();
        this.lblSymbol.setFont(this.lblSymbol.getFont().deriveFont(1));
        this.lblSymbol.setText("Scrip ");
        this.lblSymbol.setIcon(new ImageIcon(this.getClass().getResource("/Images/search12.png")));
        this.lblSymbol.setHorizontalTextPosition(2);
        this.txtSymbol = new JTextField();
        this.txtSymbol.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                SpotWatch.this.txtSymbol.selectAll();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        final JLabel lblScripBrowse = new JLabel("<html><b>" + this.languageCentre.getValue(LanguageConstant.ScripBrowse) + "</b></html>");
        lblScripBrowse.setForeground(new Color(0, 0, 0));
        lblScripBrowse.setPreferredSize(new Dimension(100, 20));
        lblScripBrowse.setMinimumSize(new Dimension(100, 20));
        lblScripBrowse.setMaximumSize(new Dimension(100, 20));
        lblScripBrowse.setIcon(new ImageIcon(this.getClass().getResource("/Images/symDetail2.png")));
        lblScripBrowse.setVisible(false);
        this.lblSymbolName.setFont(this.lblSymbolName.getFont().deriveFont(1));
        this.lblSymbol.setHorizontalAlignment(4);
        JPanel p1 = new JPanel();
        p1.setMaximumSize(new Dimension(Short.MAX_VALUE, 25));
        p1.setMinimumSize(new Dimension(0, 25));
        p1.setPreferredSize(new Dimension(473, 25));
        GroupLayout layout = new GroupLayout(p1);
        p1.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(10, 10, 10).addComponent(lblScripBrowse, -2, 95, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblSymbol, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtSymbol, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblSymbolName, -1, 137, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(3, 3, 3).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblSymbolName).addComponent(this.lblSymbol, -2, 14, -2).addComponent(lblScripBrowse, -2, 14, -2).addComponent(this.txtSymbol, -2, -1, -2)).addContainerGap()));
        JPanel p2 = new JPanel(false);
        p2.setLayout(new GridLayout(1, 1));
        p2.add((Component)this.Mwh, "Center");
        this.setLayout(new BoxLayout(this, 1));
        this.add(p1);
        this.add(p2);
        lblScripBrowse.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ((SpotWatch)SpotWatch.this).mediator.tradecast.ShowDynamicForm(FormName.ScripBrowse, LanguageConstant.ScripBrowse);
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                lblScripBrowse.setCursor(Cursor.getPredefinedCursor(12));
                lblScripBrowse.setText("<html><u><b>" + SpotWatch.this.languageCentre.getValue(LanguageConstant.ScripBrowse) + "</b></u></html>");
            }

            @Override
            public void mouseExited(MouseEvent e) {
                lblScripBrowse.setCursor(Cursor.getPredefinedCursor(0));
                lblScripBrowse.setText("<html><b>" + SpotWatch.this.languageCentre.getValue(LanguageConstant.ScripBrowse) + "</b></html>");
            }
        });
        this.txtSymbol.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    String symbol = SpotWatch.this.txtSymbol.getText();
                    Object sm = null;
                    if (symbol.indexOf("-") < 1) {
                        if (SpotWatch.this.SpotSymbols.indexOf(symbol) > 0) {
                            SpotWatch.this.Mwh.AddSymbolInMarketWatch(symbol + ";REG", false, false);
                        }
                    } else {
                        if (SpotWatch.this.SpotSymbols.indexOf(symbol) > 0) {
                            SpotWatch.this.Mwh.AddSymbolInMarketWatch(symbol + ";" + UtilKSE.GetMarketFromsymbol((String)SpotWatch.this.txtSymbol.getText()), false, false);
                        } else {
                            SpotWatch.this.txtSymbol.select(0, SpotWatch.this.txtSymbol.getText().length());
                        }
                        return;
                    }
                    SpotWatch.this.txtSymbol.select(0, SpotWatch.this.txtSymbol.getText().length());
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.txtSymbol.setDocument((Document)new JTextFieldFilter("ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-"));
    }

    public synchronized void MarketWatchMessageReceived(MarketWatchEvent event) {
        this.mediator.MarketWatchMessageReceived(event, null);
    }

    public void SymbolChange(String string) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    public void GetSymbol() {
        if (this.LoadSpot) {
            LoadLogs log = new LoadLogs("SpotSymbol=", true);
            new ThreadWithName(log, "SpotSymbol").start();
        } else {
            this.SendFeedRequest();
        }
    }

    public void setSymbol(String str) {
        this.LoadSpot = false;
        this.SpotSymbols = str;
        this.SendFeedRequest();
        this.Mwh.RemoveAllSymbolFromWatch();
        String[] Symbols = str.split("\\;", -1);
        for (int i = 0; i < Symbols.length; ++i) {
            if (Symbols[i].length() <= 0) continue;
            String[] symbolmarket = Symbols[i].split("\\:", -1);
            String payout = "";
            if (MarketWatch.Payout.containsKey(symbolmarket[0])) {
                payout = (String)MarketWatch.Payout.get(symbolmarket[0]);
            }
            this.Mwh.AddSymbolInSpotMarketWatch(symbolmarket[0], symbolmarket[1], payout, false, false);
        }
        this.Mwh.SelectRow(0);
        Util.ScrollToFirstOrLastRow((boolean)true, (JTable)this.Mwh.GetTable(), (JScrollPane)this.Mwh.scrollPane);
    }

    public void SendFeedRequest() {
        String str = "";
        if ((this.SpotSymbols != null || !this.SpotSymbols.equalsIgnoreCase("")) && this.mediator.MwPanel.getSelectedTab().equalsIgnoreCase("Spot Watch")) {
            this.mediator.SendMsgToFeedServer("MKT-FEED|" + this.SpotSymbols, "Spot Watch : SendFeedRequest");
        }
    }

    public void SetEmpty(String symbol) {
        this.txtSymbol.setText("");
        this.lblSymbolName.setText("");
    }

    public void SetSymbol(String symbol) {
        this.txtSymbol.setText(symbol);
        if (symbol.indexOf("-") >= 0) {
            symbol = symbol.split("\\-", -1)[0];
        }
        if (symbol.length() > 0 && LogCommon.SymbolAndSymbolName.size() > 0 && !LogCommon.SymbolAndSymbolName.containsKey(symbol.trim())) {
            this.lblSymbolName.setText("Invalid Scrip");
        } else {
            this.lblSymbolName.setText(this.mediator.getSymbolTitle(symbol));
        }
    }

    public void AddSymbol(String Symbol) {
        String payout = "";
        if (MarketWatch.Payout.containsKey(Symbol)) {
            payout = (String)MarketWatch.Payout.get(Symbol);
        }
        this.Mwh.AddSymbolInSpotMarketWatch(Symbol, Utilities.GetMarketFromsymbol((String)Symbol), payout, false, false);
        if (this.SpotSymbols.toUpperCase().indexOf(Symbol.toUpperCase()) <= -1) {
            this.SpotSymbols = this.SpotSymbols + Symbol + ":" + Utilities.GetMarketFromsymbol((String)Symbol) + ";";
            this.SendFeedRequest();
        }
    }

    void SymbolRemove(String string) {
    }
}

