/*
 * Decompiled with CFR 0.152.
 */
package testing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.Year;
import org.jfree.data.xy.XYDataset;

public class ChartPanelDemo {
    private static final String title = "Return On Investment";
    private ChartPanel chartPanel = this.createChart();

    public ChartPanelDemo() {
        JFrame f = new JFrame(title);
        f.setTitle(title);
        f.setDefaultCloseOperation(3);
        f.setLayout(new BorderLayout(0, 5));
        f.add((Component)this.chartPanel, "Center");
        this.chartPanel.setMouseWheelEnabled(true);
        this.chartPanel.setHorizontalAxisTrace(true);
        this.chartPanel.setVerticalAxisTrace(true);
        JPanel panel = new JPanel(new FlowLayout(2));
        panel.add(this.createTrace());
        panel.add(this.createDate());
        panel.add(this.createZoom());
        f.add((Component)panel, "South");
        f.pack();
        f.setLocationRelativeTo(null);
        f.setVisible(true);
    }

    private JComboBox createTrace() {
        final JComboBox<String> trace = new JComboBox<String>();
        final String[] traceCmds = new String[]{"Enable Trace", "Disable Trace"};
        trace.setModel(new DefaultComboBoxModel<String>(traceCmds));
        trace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (traceCmds[0].equals(trace.getSelectedItem())) {
                    ChartPanelDemo.this.chartPanel.setHorizontalAxisTrace(true);
                    ChartPanelDemo.this.chartPanel.setVerticalAxisTrace(true);
                    ChartPanelDemo.this.chartPanel.repaint();
                } else {
                    ChartPanelDemo.this.chartPanel.setHorizontalAxisTrace(false);
                    ChartPanelDemo.this.chartPanel.setVerticalAxisTrace(false);
                    ChartPanelDemo.this.chartPanel.repaint();
                }
            }
        });
        return trace;
    }

    private JComboBox createDate() {
        final JComboBox<String> date = new JComboBox<String>();
        final String[] dateCmds = new String[]{"Horizontal Dates", "Vertical Dates"};
        date.setModel(new DefaultComboBoxModel<String>(dateCmds));
        date.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFreeChart chart = ChartPanelDemo.this.chartPanel.getChart();
                XYPlot plot = (XYPlot)chart.getPlot();
                DateAxis domain = (DateAxis)plot.getDomainAxis();
                if (dateCmds[0].equals(date.getSelectedItem())) {
                    domain.setVerticalTickLabels(false);
                } else {
                    domain.setVerticalTickLabels(true);
                }
            }
        });
        return date;
    }

    private JButton createZoom() {
        JButton auto = new JButton(new AbstractAction("Auto Zoom"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChartPanelDemo.this.chartPanel.restoreAutoBounds();
            }
        });
        return auto;
    }

    private ChartPanel createChart() {
        XYDataset roiData = this.createDataset();
        JFreeChart chart = ChartFactory.createTimeSeriesChart((String)title, (String)"Date", (String)"Value", (XYDataset)roiData, (boolean)true, (boolean)true, (boolean)false);
        XYPlot plot = chart.getXYPlot();
        XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)plot.getRenderer();
        renderer.setBaseShapesVisible(true);
        NumberFormat currency = NumberFormat.getCurrencyInstance();
        currency.setMaximumFractionDigits(0);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setNumberFormatOverride(currency);
        return new ChartPanel(chart);
    }

    private XYDataset createDataset() {
        TimeSeriesCollection tsc = new TimeSeriesCollection();
        tsc.addSeries(this.createSeries("Projected", 200.0));
        tsc.addSeries(this.createSeries("Actual", 100.0));
        return tsc;
    }

    private TimeSeries createSeries(String name, double scale) {
        TimeSeries series = new TimeSeries((Comparable)((Object)name));
        for (int i = 0; i < 6; ++i) {
            series.add((RegularTimePeriod)new Year(2005 + i), Math.pow(2.0, i) * scale);
        }
        return series;
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ChartPanelDemo cpd = new ChartPanelDemo();
            }
        });
    }
}

