/*
 * Decompiled with CFR 0.152.
 */
package windows;

import CATALYST.Socket.EncryptDecrypt;
import MyDocking.Mediator;
import MyDocking.TradeCast;
import common.gui.component.NxGDialogBox;
import common.gui.util.AppConfig;
import common.gui.util.LogCommon;
import common.gui.util.MessageType;
import common.gui.util.Util;
import common.services.WebService;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import languages.LanguageCentre;
import languages.LanguageConstant;
import org.jdesktop.swingx.JXButton;
import org.jdesktop.swingx.JXLabel;

public class AttendendModeLogin
extends NxGDialogBox {
    private boolean status = false;
    private LanguageCentre languageCentre = new LanguageCentre();
    private JXButton btnSwitch;
    private JSeparator jSeparator1;
    private JXLabel jXLabel2;
    private JXLabel lblMessage;
    private JPasswordField txtPassword;

    public AttendendModeLogin() {
        super((Frame)TradeCast.getInstance().frame, true);
        this.initComponents();
        this.setBounds(0, 0, 317, 110);
        this.setDialogLocation(TradeCast.getInstance().frame);
        this.setLanguageValues();
        this.setVisible(true);
    }

    private void setDialogLocation(JFrame f) {
        Rectangle r = f.getBounds();
        int x = r.x + (r.width - this.getSize().width) / 2;
        int y = r.y + (r.height - this.getSize().height) / 2;
        this.setLocation(x, y);
    }

    private void initComponents() {
        this.lblMessage = new JXLabel();
        this.txtPassword = new JPasswordField();
        this.btnSwitch = new JXButton();
        this.jSeparator1 = new JSeparator();
        this.jXLabel2 = new JXLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Switch to Normal mode");
        this.setAlwaysOnTop(true);
        this.setResizable(false);
        this.getContentPane().setLayout(null);
        this.getContentPane().add((Component)this.lblMessage);
        this.lblMessage.setBounds(20, 57, 270, 20);
        this.txtPassword.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttendendModeLogin.this.txtPasswordActionPerformed(evt);
            }
        });
        this.txtPassword.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                AttendendModeLogin.this.txtPasswordFocusGained(evt);
            }
        });
        this.getContentPane().add(this.txtPassword);
        this.txtPassword.setBounds(80, 17, 110, 20);
        this.btnSwitch.setText("Normal Mode");
        this.btnSwitch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttendendModeLogin.this.btnSwitchActionPerformed(evt);
            }
        });
        this.getContentPane().add((Component)this.btnSwitch);
        this.btnSwitch.setBounds(200, 17, 100, 23);
        this.getContentPane().add(this.jSeparator1);
        this.jSeparator1.setBounds(0, 52, 320, 10);
        this.jXLabel2.setText("Password");
        this.getContentPane().add((Component)this.jXLabel2);
        this.jXLabel2.setBounds(20, 17, 60, 20);
        this.pack();
    }

    private void btnSwitchActionPerformed(ActionEvent evt) {
        this.setLogin();
    }

    private void txtPasswordFocusGained(FocusEvent evt) {
        this.txtPassword.selectAll();
    }

    private void txtPasswordActionPerformed(ActionEvent evt) {
        this.setLogin();
    }

    public boolean getStatus() {
        return this.status;
    }

    private void setLogin() {
        if (this.txtPassword.getText().length() <= 0) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)this.languageCentre.getValue(LanguageConstant.PleaseEnterPassword));
            this.txtPassword.requestFocus();
        } else {
            final EncryptDecrypt end = EncryptDecrypt.getInstance();
            new Thread(){

                @Override
                public void run() {
                    Util.setMessage((JLabel)AttendendModeLogin.this.lblMessage, (MessageType)MessageType.Loading, (String)AppConfig.VerifyMessage);
                    AttendendModeLogin.this.btnSwitch.setEnabled(false);
                    try {
                        String result = WebService.getInstance().getPort().secureAuthontication(end.EncryptText(LogCommon.UserID), end.EncryptText(AttendendModeLogin.this.txtPassword.getText()));
                        if (result.indexOf("true") > -1) {
                            AttendendModeLogin.this.status = true;
                            AttendendModeLogin.this.dispose();
                        } else {
                            Util.setMessage((JLabel)AttendendModeLogin.this.lblMessage, (MessageType)MessageType.Error, (String)AttendendModeLogin.this.languageCentre.getValue(LanguageConstant.InvalidPassword));
                            AttendendModeLogin.this.btnSwitch.setEnabled(true);
                            Mediator.getInstance().println(result);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        Util.setMessage((JLabel)AttendendModeLogin.this.lblMessage, (MessageType)MessageType.Error, (String)AttendendModeLogin.this.languageCentre.getValue(LanguageConstant.ErrorInSwitching));
                        AttendendModeLogin.this.btnSwitch.setEnabled(true);
                    }
                }
            }.start();
        }
    }

    private void setLanguageValues() {
        this.setTitle(this.languageCentre.getValue(LanguageConstant.SwitchToNormalMode));
        this.btnSwitch.setText(this.languageCentre.getValue(LanguageConstant.NormalMode));
        this.jXLabel2.setText(this.languageCentre.getValue(LanguageConstant.Password));
    }
}

