/*
 * Decompiled with CFR 0.152.
 */
package windows;

import MyDocking.Mediator;
import MyDocking.TradeCast;
import common.bean.ContractBrowseBean;
import common.gui.component.NxGTable;
import common.gui.render.SearchHighLighterRender;
import common.gui.util.AppConfig;
import common.gui.util.CompressManager;
import common.gui.util.LogCommon;
import common.gui.util.MessageType;
import common.gui.util.Util;
import common.services.WebService;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import kse.gui.model.BankHistoricalModel;
import org.jdesktop.swingx.JXSearchField;
import windows.pmex.PMEX_ContractBrowseDialog;

public class BankHistorical
extends JPanel
implements ActionListener {
    private Mediator mediator = Mediator.getInstance();
    private TradeCast tradeCast = TradeCast.getInstance();
    private ContractBrowseBean selectedValue = new ContractBrowseBean();
    private List<String[]> allRows = new ArrayList<String[]>();
    private Vector<String[]> rows = new Vector();
    private Vector<String> columns = new Vector();
    private BankHistoricalModel model = null;
    private SearchHighLighterRender render = null;
    private ButtonGroup buttonGroup = new ButtonGroup();
    private int searchingColumn = -123;
    private PMEX_ContractBrowseDialog dialog = null;
    private Color Background = new Color(255, 102, 102);
    private Icon Cancel_ICON = null;
    private Icon Search_ICON = null;
    final Cursor handCursor = new Cursor(12);
    final Cursor defaultCursor = new Cursor(0);
    private JButton btnExportToCSV;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JLabel lblMessage;
    private JLabel lblName;
    private JPopupMenu popupMenu;
    private NxGTable table;
    private JXSearchField txtSearchField;

    public BankHistorical() {
        this.initComponents();
        Mediator.getInstance().setBankHistorical(this);
        this.model = new BankHistoricalModel(this.rows, this.columns);
        this.table.setModel((TableModel)this.model);
        this.getData();
        this.render = new SearchHighLighterRender((JTable)this.table);
        ((JLabel)((Object)this.table.getTableHeader().getDefaultRenderer())).setHorizontalAlignment(0);
        this.table.setDefaultRenderer(Object.class, (TableCellRenderer)this.render);
        this.table.setDefaultRenderer(String.class, (TableCellRenderer)this.render);
        this.table.setDefaultRenderer(Integer.class, (TableCellRenderer)this.render);
        this.table.setDefaultRenderer(Double.class, (TableCellRenderer)this.render);
        this.table.setAutoCreateRowSorter(true);
        this.table.setHorizontalScrollEnabled(true);
        this.table.setSelectionMode(1);
        this.table.setRowHeight(AppConfig.rowHeight);
    }

    private void setupSearchField() {
        this.txtSearchField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BankHistorical.this.rowsFillter(BankHistorical.this.txtSearchField.getText().trim());
            }
        });
        this.txtSearchField.setFindPopupMenu(this.popupMenu);
        for (int i = 0; i < this.columns.size(); ++i) {
            JRadioButtonMenuItem rb = new JRadioButtonMenuItem(this.columns.get(i));
            rb.setActionCommand(i + "");
            rb.addActionListener(this);
            this.buttonGroup.add(rb);
            this.popupMenu.add(rb);
        }
        this.popupMenu.addSeparator();
        JRadioButtonMenuItem rb = new JRadioButtonMenuItem("Search");
        rb.setActionCommand("-123");
        rb.setSelected(true);
        rb.addActionListener(this);
        this.buttonGroup.add(rb);
        this.popupMenu.add(rb);
        this.lblName.setText("Search");
    }

    private void rowsFillter(String str) {
        Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.EMPTY, (String)"");
        this.render.setSearchText(str);
        this.render.setSearchingColumn(this.searchingColumn);
        this.rows.clear();
        this.txtSearchField.setBackground(Color.WHITE);
        Util.removeRowsTable((DefaultTableModel)this.model);
        if (str.length() == 0) {
            for (int i = 0; i < this.allRows.size(); ++i) {
                String[] bean = this.allRows.get(i);
                this.rows.add(bean);
                this.txtSearchField.setBackground(Color.WHITE);
            }
        } else {
            for (int i = 0; i < this.allRows.size(); ++i) {
                String[] bean = this.allRows.get(i);
                String data = this.getStringData(bean);
                if (this.searchingColumn == -123) {
                    if (data.toUpperCase().indexOf(str.toUpperCase()) < 0) continue;
                    this.rows.add(bean);
                    continue;
                }
                if (bean[this.searchingColumn].toUpperCase().indexOf(str.toUpperCase()) < 0) continue;
                this.rows.add(bean);
            }
        }
        this.tableDataChange(false);
        if (this.rows.size() <= 0) {
            this.txtSearchField.setBackground(this.Background);
        }
        if (this.rows.size() == 1) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)(Util.format0digit((String)(this.rows.size() + "")) + " record found out of " + Util.format0digit((String)(this.allRows.size() + ""))));
        } else if (this.rows.size() > 1) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)(Util.format0digit((String)(this.rows.size() + "")) + " records found out of " + Util.format0digit((String)(this.allRows.size() + ""))));
        }
    }

    public void setDialog(PMEX_ContractBrowseDialog dialog) {
        this.dialog = dialog;
    }

    public void setSearchText(String text) {
        this.rowsFillter("");
    }

    private void initComponents() {
        this.popupMenu = new JPopupMenu();
        this.lblName = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.table = new NxGTable();
        this.lblMessage = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.txtSearchField = new JXSearchField();
        this.btnExportToCSV = new JButton();
        this.lblName.setFont(new Font("Tahoma", 1, 11));
        this.lblName.setText("Company");
        this.lblName.setHorizontalTextPosition(2);
        this.table.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                BankHistorical.this.tableMouseClicked(evt);
            }
        });
        this.table.addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                BankHistorical.this.tableMouseMoved(evt);
            }
        });
        this.jScrollPane2.setViewportView((Component)this.table);
        this.lblMessage.setText("jLabel1");
        this.btnExportToCSV.setIcon(new ImageIcon(this.getClass().getResource("/Images/export.png")));
        this.btnExportToCSV.setText("Export to CSV");
        this.btnExportToCSV.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BankHistorical.this.btnExportToCSVActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lblName, -2, 126, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.txtSearchField, -2, 149, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnExportToCSV, -2, 125, -2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jScrollPane2, -1, 452, Short.MAX_VALUE)).addContainerGap()).addComponent(this.jSeparator1).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.lblMessage, -1, -1, Short.MAX_VALUE).addGap(80, 80, 80)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblName, -2, 20, -2).addComponent((Component)this.txtSearchField, -2, -1, -2).addComponent(this.btnExportToCSV)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane2, -1, 223, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, -1, -2).addGap(2, 2, 2).addComponent(this.lblMessage, -2, 20, -2)));
    }

    private void tableMouseClicked(MouseEvent evt) {
    }

    private void tableMouseMoved(MouseEvent evt) {
    }

    private void btnExportToCSVActionPerformed(ActionEvent evt) {
        this.mediator.exportTableDataIntoCSV((JTable)this.table, "Bank Historical");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj instanceof JRadioButtonMenuItem) {
            JRadioButtonMenuItem rb = (JRadioButtonMenuItem)obj;
            try {
                this.searchingColumn = Integer.parseInt(rb.getActionCommand());
                if (this.searchingColumn == -123) {
                    this.lblName.setText("Search");
                } else {
                    this.lblName.setText(this.columns.get(this.searchingColumn));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.rowsFillter(this.txtSearchField.getText());
        }
    }

    private void setTxtSearchFieldIcon() {
        try {
            this.Cancel_ICON = new ImageIcon(this.getClass().getResource("/common/gui/images/cross.png"));
            this.txtSearchField.getCancelButton().setIcon(this.Cancel_ICON);
            this.txtSearchField.getCancelButton().setRolloverIcon(this.Cancel_ICON);
            this.txtSearchField.getCancelButton().setPressedIcon(this.Cancel_ICON);
            this.txtSearchField.updateUI();
            this.Search_ICON = new ImageIcon(this.getClass().getResource("/common/gui/images/search26x20.png"));
            this.txtSearchField.getFindButton().setIcon(this.Search_ICON);
            this.txtSearchField.getFindButton().setRolloverIcon(this.Search_ICON);
            this.txtSearchField.updateUI();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void dispose() {
        if (this.dialog != null) {
            this.dialog.dispose();
        }
    }

    private void getData() {
        Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Loading, (String)AppConfig.loadingMessage);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    byte[] data = WebService.getInstance().getPort().getCompressedData(LogCommon.UserID, "BankHistorical=", "");
                    String values = CompressManager.unzipStringFromBytes((byte[])data);
                    if (values.equalsIgnoreCase("Error")) {
                        Util.setMessage((JLabel)BankHistorical.this.lblMessage, (MessageType)MessageType.Error, (String)"Error in loading data");
                    } else {
                        BankHistorical.this.mediator.println("BankHistorical = " + values);
                        if (values.contains("$")) {
                            String[] allData = values.split("\\$", -1);
                            String column_ = allData[0];
                            String rows_ = allData[1];
                            if (column_.contains(";")) {
                                String[] col = column_.split("\\;", -1);
                                BankHistorical.this.columns.addAll(Arrays.asList(col));
                            }
                            BankHistorical.this.columns.remove("");
                            if (rows_.contains("@")) {
                                String[] all_Rows = rows_.split("\\@", -1);
                                for (int i = 0; i < all_Rows.length; ++i) {
                                    String rowVal = all_Rows[i];
                                    if (i == 0) {
                                        BankHistorical.this.setColumnClass(rowVal, i);
                                    }
                                    if (!rowVal.contains(";")) continue;
                                    String[] colVal = rowVal.split("\\;", -1);
                                    BankHistorical.this.allRows.add(colVal);
                                }
                            }
                        }
                        BankHistorical.this.tableDataChange(true);
                        BankHistorical.this.setupSearchField();
                        BankHistorical.this.rowsFillter("");
                        BankHistorical.this.setTxtSearchFieldIcon();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    Mediator.getInstance().WriteExceptionInClientMachine(ex);
                }
            }
        }).start();
    }

    private void tableDataChange(final boolean isPack) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.model.fireTableStructureChanged();
            this.model.fireTableDataChanged();
            if (isPack) {
                this.table.packAll();
            }
            this.table.addNotify();
            this.table.repaint();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BankHistorical.this.model.fireTableStructureChanged();
                    BankHistorical.this.model.fireTableDataChanged();
                    if (isPack) {
                        BankHistorical.this.table.packAll();
                    }
                    BankHistorical.this.table.addNotify();
                    BankHistorical.this.table.repaint();
                }
            });
        }
    }

    private void setColumnClass(String rowVal, int i) {
        if (rowVal.contains(";")) {
            String[] colVal = rowVal.split("\\;", -1);
            for (int j = 0; j < colVal.length; ++j) {
                String string = colVal[j];
                try {
                    Integer.parseInt(string);
                    this.model.getColumnClass().add(Integer.class);
                    continue;
                }
                catch (Exception ex) {
                    try {
                        Double.parseDouble(string);
                        this.model.getColumnClass().add(Double.class);
                        continue;
                    }
                    catch (Exception exc) {
                        this.model.getColumnClass().add(String.class);
                    }
                }
            }
        }
    }

    private String getStringData(String[] bean) {
        StringBuilder sb = new StringBuilder();
        for (String string : bean) {
            sb.append(string).append(";");
        }
        return sb.toString();
    }
}

