/*
 * Decompiled with CFR 0.152.
 */
package windows;

import CustomComponent.JTableFilter;
import Exposure.Collateral;
import Exposure.CumulativeSummary;
import Exposure.OpenPosition;
import MyDocking.Mediator;
import MyDocking.TradeCast;
import RendersNModels.CollateralModel;
import RendersNModels.CollateralTableCellRender;
import RendersNModels.CommSummaryTableCellRenderer;
import RendersNModels.CumulativeSummaryModel;
import RendersNModels.OpenPositionModel;
import RendersNModels.OpenPositionTableCellRenderer;
import RendersNModels.PrograssBar;
import Utilities.LoadLogs;
import Utilities.LogsTC;
import Utilities.ThreadWithName;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import common.gui.util.AppConfig;
import common.gui.util.LogCommon;
import common.gui.util.Util;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import languages.LanguageCentre;
import languages.LanguageConstant;

public class ExposureWatch
extends JPanel {
    String[] columnNames = new String[]{"", "", "", "", "", ""};
    public Vector rows = null;
    Vector columns = new Vector();
    Mediator mediator = Mediator.getInstance();
    Collateral collateral = new Collateral(this);
    OpenPosition openPosition = new OpenPosition(this);
    CumulativeSummary cumulativeSummary = new CumulativeSummary(this);
    public static boolean isOpen = false;
    public static boolean isFromShortCutKey = false;
    private String tabname;
    public TableRowSorter<TableModel> collateralsSorter = null;
    public TableRowSorter<TableModel> openSorter = null;
    DefaultTableModel exposureModel = new DefaultTableModel(){

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    };
    Vector collateralColumns = new Vector();
    public Vector collateraRow = new Vector();
    public DefaultTableModel collateralModel = null;
    public DefaultTableModel commSummaryModel = null;
    public DefaultTableModel openModel = null;
    public TableRowSorter<TableModel> cummSorter = null;
    Vector openColumns = new Vector();
    public Vector openRow = new Vector();
    Vector commColumns = new Vector();
    public Vector commRow = new Vector();
    JTableHeader Eheader1;
    ArrayList commSummaryFilterType = new ArrayList();
    JTableFilter commSummaryfilter = null;
    JTableFilter opePositionFilter = null;
    JTableFilter collateralFilter = null;
    ImageIcon loaderIcon = new ImageIcon(this.getClass().getResource(AppConfig.loaderIconPath));
    private static boolean isHelpShow;
    private LanguageCentre languageCentre = new LanguageCentre();
    private JPanel Collateral;
    private JPanel CommSummary;
    private JPanel Exposure;
    private JPanel Openposition;
    public JButton btnRefresh;
    public JComboBox cbAccountNo;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    protected JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    public JLabel lblCollateralTotal;
    public JLabel lblCollateralsMesssage;
    public JLabel lblCumSummaryMessage;
    private JLabel lblExposureMessage;
    public JLabel lblMTMAmount;
    public JLabel lblOpenPositionMessage;
    public JLabel lblPLAmount;
    public JLabel lblTransAmount;
    private JPanel pnlCollateralsFilter;
    private JPanel pnlCommSummaryFilter;
    private JPanel pnlOpenOpsitionFilter;
    private JTabbedPane tbdPane;
    public JTable tblCollateral;
    public JTable tblCommSummary;
    private JTable tblExposure;
    public JTable tblOpenPosition;
    private JTextField txtAfterHaircut;
    private JTextField txtCollat;
    private JTextField txtGrad;
    private JTextField txtLedgerBalance;
    private JTextField txtLiquidity;
    private JTextField txtLoan;
    private JTextField txtMTMPL;
    private JTextField txtMarginPosted;
    private JTextField txtNetCash;
    private JTextField txtPL;
    private JTextField txtSoldCollat;
    private JTextField txtTotal;

    public ExposureWatch() {
        this.mediator.setExposure(this);
        this.rows = new Vector();
        this.collateralColumns.add("Scrip");
        this.collateralColumns.add("Volume");
        this.collateralColumns.add("MTM Price");
        this.collateralColumns.add("Haircut %");
        this.collateralColumns.add("Marginized Value");
        this.collateralColumns.add("Reg Amount");
        this.collateralColumns.add("Fut Amount");
        this.collateralColumns.add("MTM Amount");
        this.collateralModel = new CollateralModel(this.collateraRow, this.collateralColumns);
        this.openColumns.addElement("Market");
        this.openColumns.addElement("Scrip");
        this.openColumns.addElement("Volume");
        this.openColumns.addElement("Transaction Price");
        this.openColumns.addElement("Transaction Amount");
        this.openColumns.addElement("MTM Price");
        this.openColumns.addElement("MTM Amount");
        this.openColumns.addElement("Profit/Loss");
        this.openModel = new OpenPositionModel(this.openRow, this.openColumns);
        this.commColumns.addElement("Account");
        this.commColumns.addElement("Client");
        this.commColumns.addElement("Portfolio Value");
        this.commColumns.addElement("Ledger Balance");
        this.commColumns.addElement("Profit/Loss");
        this.commColumns.addElement("Sold Collaterals");
        this.commColumns.addElement("Net Collateral");
        this.commColumns.addElement("Net Exposure");
        this.commColumns.addElement("Call");
        this.commColumns.addElement("Short Fall");
        this.commColumns.addElement("Short Fall/collat");
        this.commSummaryModel = new CumulativeSummaryModel(this.commRow, this.commColumns);
        this.init();
        this.setCommSummaryFilter();
        this.setCollateralFilter();
        this.setOpenPositionFilter();
        this.doRefresh();
    }

    public void init() {
        this.initComponents();
        this.cbAccountNo.setModel(new DefaultComboBoxModel<Object>(LogsTC.accountAll.keySet().toArray()));
        AutoCompleteSupport support = AutoCompleteSupport.install((JComboBox)this.cbAccountNo, (EventList)GlazedLists.eventListOf((Object[])LogsTC.accountAll.keySet().toArray()));
        if (LogCommon.preferredAccount.equalsIgnoreCase("")) {
            this.cbAccountNo.setSelectedItem("");
        } else {
            this.cbAccountNo.setSelectedItem(LogCommon.preferredAccount);
        }
        for (int i = 0; i < this.columnNames.length; ++i) {
            this.columns.addElement(this.columnNames[i]);
        }
        this.exposureModel.setDataVector(this.rows, this.columns);
        this.tblExposure.setModel(this.exposureModel);
        this.tabname = this.tbdPane.getTitleAt(this.tbdPane.getSelectedIndex());
        this.tblCollateral.setModel(this.collateralModel);
        this.tblOpenPosition.setModel(this.openModel);
        this.tblCommSummary.setModel(this.commSummaryModel);
        this.tblCollateral.setRowHeight(AppConfig.rowHeight);
        this.tblCommSummary.setRowHeight(AppConfig.rowHeight);
        this.tblExposure.setRowHeight(AppConfig.rowHeight);
        this.tblOpenPosition.setRowHeight(AppConfig.rowHeight);
        this.tblCollateral.getTableHeader().setReorderingAllowed(false);
        this.tblCommSummary.getTableHeader().setReorderingAllowed(false);
        this.tblExposure.getTableHeader().setReorderingAllowed(false);
        this.tblOpenPosition.getTableHeader().setReorderingAllowed(false);
        this.tblCollateral.setSelectionMode(0);
        this.tblCommSummary.setSelectionMode(0);
        this.tblExposure.setSelectionMode(0);
        this.tblOpenPosition.setSelectionMode(0);
        this.setRenders();
        this.tblExposure.setDefaultRenderer(Object.class, new PrograssBar());
        this.tblCollateral.getColumnModel().getColumn(0).setPreferredWidth(94);
        this.tblOpenPosition.getColumnModel().getColumn(0).setPreferredWidth(72);
        this.tblOpenPosition.getColumnModel().getColumn(1).setPreferredWidth(94);
        this.tblCollateral.getColumnModel().getColumn(0).setMaxWidth(94);
        this.tblOpenPosition.getColumnModel().getColumn(0).setMaxWidth(72);
        this.tblOpenPosition.getColumnModel().getColumn(1).setMaxWidth(94);
        this.tblCollateral.getColumnModel().getColumn(0).setMinWidth(94);
        this.tblOpenPosition.getColumnModel().getColumn(0).setMinWidth(72);
        this.tblOpenPosition.getColumnModel().getColumn(1).setMinWidth(94);
        this.lblTransAmount.setFont(this.lblTransAmount.getFont().deriveFont(1));
        this.lblMTMAmount.setFont(this.lblMTMAmount.getFont().deriveFont(1));
        this.lblPLAmount.setFont(this.lblPLAmount.getFont().deriveFont(1));
        this.lblCollateralTotal.setFont(this.lblCollateralTotal.getFont().deriveFont(1));
        this.collateralsSorter = new TableRowSorter<DefaultTableModel>(this.collateralModel);
        this.tblCollateral.setRowSorter(this.collateralsSorter);
        this.openSorter = new TableRowSorter<DefaultTableModel>(this.openModel);
        this.tblOpenPosition.setRowSorter(this.openSorter);
        this.cummSorter = new TableRowSorter<DefaultTableModel>(this.commSummaryModel);
        this.tblCommSummary.setRowSorter(this.cummSorter);
        TableColumn tcol = this.tblCollateral.getColumnModel().getColumn(this.tblCollateral.getColumnModel().getColumnIndex("Reg Amount"));
        this.tblCollateral.removeColumn(tcol);
        tcol = this.tblCollateral.getColumnModel().getColumn(this.tblCollateral.getColumnModel().getColumnIndex("Fut Amount"));
        this.tblCollateral.removeColumn(tcol);
    }

    private void setCollateralFilter() {
        this.pnlCollateralsFilter.removeAll();
        ArrayList<String> collateralsFilterType = new ArrayList<String>();
        collateralsFilterType.add("String");
        collateralsFilterType.add("Double");
        collateralsFilterType.add("Double");
        collateralsFilterType.add("Double");
        collateralsFilterType.add("Double");
        collateralsFilterType.add("Double");
        if (this.collateralFilter == null) {
            this.collateralFilter = new JTableFilter(this.tblCollateral, collateralsFilterType);
            this.collateralFilter.setPrefMinMax();
        }
        this.pnlCollateralsFilter.add(this.collateralFilter);
        this.tblCollateral.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent e) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
                ExposureWatch.this.collateralFilter.changeMargin();
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }
        });
        this.repaint();
    }

    private void setOpenPositionFilter() {
        this.pnlOpenOpsitionFilter.removeAll();
        ArrayList<String> opePositionFilterType = new ArrayList<String>();
        opePositionFilterType.add("String");
        opePositionFilterType.add("String");
        opePositionFilterType.add("Double");
        opePositionFilterType.add("Double");
        opePositionFilterType.add("Double");
        opePositionFilterType.add("Double");
        opePositionFilterType.add("Double");
        opePositionFilterType.add("Double");
        if (this.opePositionFilter == null) {
            this.opePositionFilter = new JTableFilter(this.tblOpenPosition, opePositionFilterType);
            this.opePositionFilter.setPrefMinMax();
        }
        this.pnlOpenOpsitionFilter.add(this.opePositionFilter);
        this.tblOpenPosition.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent e) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
                ExposureWatch.this.opePositionFilter.changeMargin();
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }
        });
        this.repaint();
    }

    public void setCommSummaryFilter() {
        this.commSummaryFilterType.add("String");
        this.commSummaryFilterType.add("String");
        this.commSummaryFilterType.add("Double");
        this.commSummaryFilterType.add("Double");
        this.commSummaryFilterType.add("Double");
        this.commSummaryFilterType.add("Double");
        this.commSummaryFilterType.add("Double");
        this.commSummaryFilterType.add("Double");
        this.commSummaryFilterType.add("String");
        this.commSummaryFilterType.add("Double");
        this.commSummaryFilterType.add("Double");
        this.commSummaryfilter = new JTableFilter(this.tblCommSummary, this.commSummaryFilterType);
        this.pnlCommSummaryFilter.add(this.commSummaryfilter);
        this.tblCommSummary.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent e) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
                ExposureWatch.this.commSummaryfilter.changeMargin();
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }
        });
    }

    public synchronized void ExpouserForm(String msg) {
        String[] resArray = msg.split("\\~", -1);
        String[] str = resArray[0].split("\\#", -1);
        String[] headerFeed = str[0].split("\\;", -1);
        for (int i = 0; i < headerFeed.length - 1; ++i) {
            this.columns.addElement(headerFeed[i] + "");
        }
        this.exposureModel.setDataVector(this.rows, this.columns);
        this.rows.clear();
        this.tblExposure.removeNotify();
        String[] strB = str[1].split("\\;", -1);
        Vector<Object> per = new Vector<Object>();
        for (int i = 0; i < strB.length - 1; ++i) {
            try {
                int pers = (int)(Double.parseDouble(strB[i]) * 100.0) / 100;
                if (pers > 100) {
                    pers = 100;
                }
                per.addElement(pers);
                continue;
            }
            catch (Exception e) {
                per.addElement(strB[i]);
            }
        }
        this.rows.addElement(per);
        for (int j = 2; j < str.length - 1; ++j) {
            Vector<String> row = new Vector<String>();
            String[] str123 = str[j].split("\\;", -1);
            for (int i = 0; i < str123.length - 1; ++i) {
                String string = str123[i];
                if (i > 0) {
                    try {
                        row.addElement(" " + Util.format2digit((String)string.toString().trim().replaceAll("\\,", "")) + " ");
                    }
                    catch (NumberFormatException ex) {
                        row.addElement(string);
                    }
                    continue;
                }
                row.addElement(string);
            }
            this.rows.addElement(row);
        }
        String[] text = resArray[1].split("\\;", -1);
        for (int i = 0; i < text.length - 1; ++i) {
            if (text[i] == null) {
                text[i] = " 0.00 ";
                continue;
            }
            if (!text[i].equalsIgnoreCase("")) continue;
            text[i] = " 0.00 ";
        }
        String temp = Util.format2digit((String)text[0].toString().trim().replaceAll("\\,", ""));
        if (temp.equalsIgnoreCase("")) {
            this.txtLedgerBalance.setText(" 0.00 ");
        } else {
            this.txtLedgerBalance.setText(" " + temp + " ");
        }
        temp = Util.format2digit((String)text[1].toString().trim().replaceAll("\\,", ""));
        if (temp.equalsIgnoreCase("")) {
            this.txtPL.setText(" 0.00 ");
        } else {
            this.txtPL.setText(" " + temp + " ");
        }
        temp = Util.format2digit((String)text[2].toString().trim().replaceAll("\\,", ""));
        if (temp.equalsIgnoreCase("")) {
            this.txtMTMPL.setText(" 0.00 ");
        } else {
            this.txtMTMPL.setText(" " + temp + " ");
        }
        temp = Util.format2digit((String)text[3].toString().trim().replaceAll("\\,", ""));
        if (temp.equalsIgnoreCase("")) {
            this.txtSoldCollat.setText(" 0.00 ");
        } else {
            this.txtSoldCollat.setText(" " + temp + " ");
        }
        double d = Double.parseDouble(text[0]) + Double.parseDouble(text[1]) + Double.parseDouble(text[2]) + Double.parseDouble(text[3]) + Double.parseDouble(text[6]);
        temp = Util.format2digit((String)(d + "".toString().trim().replaceAll("\\,", "")));
        if (temp.equalsIgnoreCase("")) {
            this.txtTotal.setText(" 0.00 ");
        } else {
            this.txtTotal.setText(" " + temp + " ");
        }
        temp = Util.format2digit((String)text[4].toString().trim().replaceAll("\\,", ""));
        if (temp.equalsIgnoreCase("")) {
            this.txtCollat.setText(" 0.00 ");
        } else {
            this.txtCollat.setText(" " + temp + " ");
        }
        temp = Util.format2digit((String)text[5].toString().trim().replaceAll("\\,", ""));
        if (temp.equalsIgnoreCase("")) {
            this.txtAfterHaircut.setText(" 0.00 ");
        } else {
            this.txtAfterHaircut.setText(" " + temp + " ");
        }
        this.txtLiquidity.setText(this.txtTotal.getText());
        double ddd = Double.parseDouble(text[5]) + Double.parseDouble(this.txtLiquidity.getText().trim().replaceAll("\\,", ""));
        temp = Util.format2digit((String)(ddd + "".trim().replaceAll("\\,", "")));
        if (temp.equalsIgnoreCase("")) {
            this.txtGrad.setText(" 0.00 ");
        } else {
            this.txtGrad.setText(" " + temp + " ");
        }
        temp = Util.format2digit((String)text[6].toString().trim().replaceAll("\\,", ""));
        if (temp.equalsIgnoreCase("")) {
            this.txtLoan.setText(" 0.00 ");
        } else {
            this.txtLoan.setText(" " + temp + " ");
        }
        temp = Util.format2digit((String)text[7].toString().trim().replaceAll("\\,", ""));
        if (temp.equalsIgnoreCase("")) {
            this.txtNetCash.setText(" 0.00 ");
        } else {
            this.txtNetCash.setText(" " + temp + " ");
        }
        temp = Util.format2digit((String)text[8].toString().trim().replaceAll("\\,", ""));
        if (temp.equalsIgnoreCase("")) {
            this.txtMarginPosted.setText(" 0.00 ");
        } else {
            this.txtMarginPosted.setText(" " + temp + " ");
        }
        this.tblExposure.getColumnModel().getColumn(0).setPreferredWidth(180);
        this.tblExposure.addNotify();
        this.lblExposureMessage.setIcon(null);
        this.lblExposureMessage.setText(" ");
    }

    private void accountChanged() {
        try {
            String account = (String)this.cbAccountNo.getSelectedItem();
            if (account == null) {
                return;
            }
            if (account.trim().equalsIgnoreCase("")) {
                this.setEmptyAccountData();
                return;
            }
            this.tabname = this.tbdPane.getTitleAt(this.tbdPane.getSelectedIndex());
            if (this.tabname.equalsIgnoreCase("Exposure")) {
                this.lblExposureMessage.setIcon(this.loaderIcon);
                this.lblExposureMessage.setText(this.languageCentre.getValue(LanguageConstant.Loading));
                this.mediator.SendMsgToTradeServer("MSG-CLIENT|EXPOSURE_LIMIT|" + account + "|" + LogCommon.UserID + "|*");
            }
            if (this.tabname.equalsIgnoreCase("Collaterals")) {
                this.mediator.SendMsgToTradeServer("MSG-CLIENT|COLLATERAL|" + account + "|" + LogCommon.UserID + "|*");
                this.lblCollateralsMesssage.setText(this.languageCentre.getValue(LanguageConstant.Loading));
                this.lblCollateralsMesssage.setIcon(this.loaderIcon);
            }
            if (this.tabname.equalsIgnoreCase("Open Position")) {
                this.mediator.SendMsgToTradeServer("MSG-CLIENT|OPENPOSITION|" + account + "|" + LogCommon.UserID + "|*");
                this.lblOpenPositionMessage.setText(this.languageCentre.getValue(LanguageConstant.Loading));
                this.lblOpenPositionMessage.setIcon(this.loaderIcon);
            } else if (this.tabname.equalsIgnoreCase("Cumulative Summary")) {
                this.lblCumSummaryMessage.setText(this.languageCentre.getValue(LanguageConstant.Loading));
                this.lblCumSummaryMessage.setIcon(this.loaderIcon);
                LoadLogs loadLogs = new LoadLogs("CommSummary=", true);
                new ThreadWithName(loadLogs, "CommSummary1").start();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void fillCumulativeSummary(String result) {
        this.cumulativeSummary.fillCumulativeSummary(result);
    }

    public synchronized void fillExposureNew(String feed, String tabname) {
        if (tabname.equalsIgnoreCase("Exposure")) {
            if (feed.trim().equalsIgnoreCase("")) {
                this.emptyExposure();
                return;
            }
            if (feed.trim().length() <= 0) {
                this.emptyExposure();
                return;
            }
            this.ExpouserForm(feed);
            return;
        }
        if (tabname.equalsIgnoreCase("Collaterals")) {
            this.collateral.fillCollateral(feed);
        } else if (tabname.equalsIgnoreCase("OpenPosition")) {
            this.openPosition.fillOpenPosition(feed);
        }
    }

    public void doRefresh() {
        if (LogCommon.UserID == null) {
            return;
        }
        String account = (String)this.cbAccountNo.getSelectedItem();
        if (account == null) {
            return;
        }
        if (account.equalsIgnoreCase("")) {
            this.setEmptyAccountData();
            return;
        }
        if (this.tbdPane.getTitleAt(this.tbdPane.getSelectedIndex()).equalsIgnoreCase("Exposure")) {
            this.lblExposureMessage.setIcon(this.loaderIcon);
            this.lblExposureMessage.setText(this.languageCentre.getValue(LanguageConstant.Loading));
            this.mediator.SendMsgToTradeServer("MSG-CLIENT|EXPOSURE_LIMIT|" + account + "|" + LogCommon.UserID + "|*");
            this.tabname = this.tbdPane.getTitleAt(this.tbdPane.getSelectedIndex());
        } else if (this.tbdPane.getTitleAt(this.tbdPane.getSelectedIndex()).equalsIgnoreCase("Collaterals")) {
            this.tabname = this.tbdPane.getTitleAt(this.tbdPane.getSelectedIndex());
            this.lblCollateralsMesssage.setIcon(this.loaderIcon);
            this.lblCollateralsMesssage.setText(this.languageCentre.getValue(LanguageConstant.Loading));
            this.mediator.SendMsgToTradeServer("MSG-CLIENT|COLLATERAL|" + account + "|" + LogCommon.UserID + "|*");
        } else if (this.tbdPane.getTitleAt(this.tbdPane.getSelectedIndex()).equalsIgnoreCase("Open Position")) {
            this.tabname = this.tbdPane.getTitleAt(this.tbdPane.getSelectedIndex());
            this.lblOpenPositionMessage.setIcon(this.loaderIcon);
            this.lblOpenPositionMessage.setText(this.languageCentre.getValue(LanguageConstant.Loading));
            this.mediator.SendMsgToTradeServer("MSG-CLIENT|OPENPOSITION|" + account + "|" + LogCommon.UserID + "|*");
        } else if (this.tbdPane.getTitleAt(this.tbdPane.getSelectedIndex()).equalsIgnoreCase("Cumulative Summary")) {
            this.lblCumSummaryMessage.setIcon(this.loaderIcon);
            this.lblCumSummaryMessage.setText(this.languageCentre.getValue(LanguageConstant.Loading));
            LoadLogs loadLogs = new LoadLogs("CommSummary=", true);
            new ThreadWithName(loadLogs, "CommSummary2").start();
        }
    }

    private void emptyExposure() {
        this.lblExposureMessage.setIcon(null);
        this.lblExposureMessage.setText(" ");
        this.txtNetCash.setText("");
        this.txtLedgerBalance.setText("");
        this.txtLoan.setText("");
        this.txtMarginPosted.setText("");
        this.txtPL.setText("");
        this.txtMTMPL.setText("");
        this.txtSoldCollat.setText("");
        this.txtTotal.setText("");
        this.txtCollat.setText("");
        this.txtAfterHaircut.setText("");
        this.txtLiquidity.setText("");
        this.txtGrad.setText("");
        this.removeExpTableOnly();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.cbAccountNo = new JComboBox();
        this.btnRefresh = new JButton();
        this.tbdPane = new JTabbedPane();
        this.Exposure = new JPanel();
        this.jPanel5 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.txtLedgerBalance = new JTextField();
        this.txtPL = new JTextField();
        this.txtMTMPL = new JTextField();
        this.txtSoldCollat = new JTextField();
        this.txtTotal = new JTextField();
        this.txtNetCash = new JTextField();
        this.jLabel7 = new JLabel();
        this.txtLoan = new JTextField();
        this.jLabel12 = new JLabel();
        this.txtMarginPosted = new JTextField();
        this.jLabel13 = new JLabel();
        this.jPanel6 = new JPanel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jLabel11 = new JLabel();
        this.txtGrad = new JTextField();
        this.txtCollat = new JTextField();
        this.txtLiquidity = new JTextField();
        this.txtAfterHaircut = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.tblExposure = new JTable();
        this.jSeparator4 = new JSeparator();
        this.lblExposureMessage = new JLabel();
        this.Collateral = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.tblCollateral = new JTable(this.collateralModel);
        this.jLabel14 = new JLabel();
        this.lblCollateralTotal = new JLabel();
        this.lblCollateralsMesssage = new JLabel();
        this.pnlCollateralsFilter = new JPanel();
        this.jSeparator3 = new JSeparator();
        this.Openposition = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.tblOpenPosition = new JTable(this.openModel);
        this.jLabel15 = new JLabel();
        this.lblTransAmount = new JLabel();
        this.jLabel16 = new JLabel();
        this.lblMTMAmount = new JLabel();
        this.jLabel17 = new JLabel();
        this.lblPLAmount = new JLabel();
        this.lblOpenPositionMessage = new JLabel();
        this.pnlOpenOpsitionFilter = new JPanel();
        this.jSeparator1 = new JSeparator();
        this.CommSummary = new JPanel();
        this.jScrollPane4 = new JScrollPane();
        this.tblCommSummary = new JTable(this.commSummaryModel);
        this.lblCumSummaryMessage = new JLabel();
        this.pnlCommSummaryFilter = new JPanel();
        this.jSeparator2 = new JSeparator();
        this.jLabel1.setText("Account");
        this.cbAccountNo.setEditable(true);
        this.cbAccountNo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ExposureWatch.this.cbAccountNoItemStateChanged(evt);
            }
        });
        this.cbAccountNo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExposureWatch.this.cbAccountNoActionPerformed(evt);
            }
        });
        this.btnRefresh.setIcon(new ImageIcon(this.getClass().getResource("/Images/refresh.png")));
        this.btnRefresh.setText("Refresh");
        this.btnRefresh.setName("ExposureWatch -> btnRefersh");
        this.btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExposureWatch.this.btnRefreshActionPerformed(evt);
            }
        });
        this.tbdPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ExposureWatch.this.tbdPaneStateChanged(evt);
            }
        });
        this.jPanel5.setBorder(BorderFactory.createTitledBorder(null, " Liquidity ", 0, 0, new Font("Tahoma", 1, 12)));
        this.jLabel2.setText("Ledger Balance");
        this.jLabel3.setText("Profit / Loss");
        this.jLabel4.setText("MTM / Profit / Loss");
        this.jLabel5.setText("Sold Collateral Values");
        this.jLabel6.setText("Total");
        this.txtLedgerBalance.setEditable(false);
        this.txtLedgerBalance.setHorizontalAlignment(4);
        this.txtPL.setEditable(false);
        this.txtPL.setHorizontalAlignment(4);
        this.txtMTMPL.setEditable(false);
        this.txtMTMPL.setHorizontalAlignment(4);
        this.txtSoldCollat.setEditable(false);
        this.txtSoldCollat.setHorizontalAlignment(4);
        this.txtTotal.setEditable(false);
        this.txtTotal.setHorizontalAlignment(4);
        this.txtNetCash.setEditable(false);
        this.txtNetCash.setHorizontalAlignment(4);
        this.jLabel7.setText("Net Cash");
        this.txtLoan.setEditable(false);
        this.txtLoan.setHorizontalAlignment(4);
        this.jLabel12.setText("Loan");
        this.txtMarginPosted.setEditable(false);
        this.txtMarginPosted.setHorizontalAlignment(4);
        this.jLabel13.setText("Margin Posted");
        GroupLayout jPanel5Layout = new GroupLayout(this.jPanel5);
        this.jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addComponent(this.jLabel7).addGap(62, 62, 62).addComponent(this.txtNetCash, -2, 152, -2)).addGroup(jPanel5Layout.createSequentialGroup().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel5Layout.createSequentialGroup().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel12).addComponent(this.jLabel13).addComponent(this.jLabel3).addComponent(this.jLabel5).addComponent(this.jLabel6)).addGap(4, 4, 4)).addGroup(jPanel5Layout.createSequentialGroup().addComponent(this.jLabel4).addGap(18, 18, 18))).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtSoldCollat, -2, 152, -2).addComponent(this.txtMTMPL, -2, 152, -2).addComponent(this.txtPL, -2, 152, -2).addComponent(this.txtMarginPosted, -2, 152, -2).addComponent(this.txtLoan, -2, 152, -2).addComponent(this.txtLedgerBalance, -2, 152, -2).addComponent(this.txtTotal, -2, 152, -2))))));
        jPanel5Layout.setVerticalGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel5Layout.createSequentialGroup().addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.txtNetCash, -2, -1, -2)).addGap(5, 5, 5).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.txtLedgerBalance, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtLoan, -2, -1, -2).addComponent(this.jLabel12)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel13).addComponent(this.txtMarginPosted, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.txtPL, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtMTMPL, -2, -1, -2).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.txtSoldCollat, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel6).addComponent(this.txtTotal, -2, -1, -2))));
        jPanel5Layout.linkSize(1, this.jLabel2, this.jLabel3, this.jLabel4, this.jLabel5, this.jLabel6, this.txtLedgerBalance);
        this.jPanel6.setBorder(BorderFactory.createTitledBorder(null, " Collaterals ", 0, 0, new Font("Tahoma", 1, 12)));
        this.jLabel8.setText("Liquidity Total");
        this.jLabel9.setText("After Haircut");
        this.jLabel10.setText("Collateral Values");
        this.jLabel11.setText("Grad Total");
        this.txtGrad.setEditable(false);
        this.txtGrad.setHorizontalAlignment(4);
        this.txtCollat.setEditable(false);
        this.txtCollat.setHorizontalAlignment(4);
        this.txtLiquidity.setEditable(false);
        this.txtLiquidity.setHorizontalAlignment(4);
        this.txtAfterHaircut.setEditable(false);
        this.txtAfterHaircut.setHorizontalAlignment(4);
        GroupLayout jPanel6Layout = new GroupLayout(this.jPanel6);
        this.jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addContainerGap().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel9).addComponent(this.jLabel10).addComponent(this.jLabel8)).addGap(27, 27, 27).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtCollat, -2, 152, -2).addComponent(this.txtLiquidity, -2, 152, -2).addComponent(this.txtAfterHaircut, -2, 152, -2))).addGroup(GroupLayout.Alignment.TRAILING, jPanel6Layout.createSequentialGroup().addComponent(this.jLabel11).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.txtGrad, -2, 152, -2))).addContainerGap()));
        jPanel6Layout.setVerticalGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel6Layout.createSequentialGroup().addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel10).addComponent(this.txtCollat, -2, -1, -2)).addGap(11, 11, 11).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtAfterHaircut, -2, -1, -2).addComponent(this.jLabel9)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtLiquidity, -2, -1, -2).addComponent(this.jLabel8)).addGap(100, 100, 100).addGroup(jPanel6Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtGrad, -2, -1, -2).addComponent(this.jLabel11))));
        this.tblExposure.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.tblExposure.setSelectionBackground(new Color(163, 193, 255));
        this.tblExposure.setSelectionForeground(new Color(0, 0, 0));
        this.jScrollPane1.setViewportView(this.tblExposure);
        this.lblExposureMessage.setText(" ");
        GroupLayout ExposureLayout = new GroupLayout(this.Exposure);
        this.Exposure.setLayout(ExposureLayout);
        ExposureLayout.setHorizontalGroup(ExposureLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator4).addGroup(ExposureLayout.createSequentialGroup().addContainerGap().addGroup(ExposureLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addGroup(ExposureLayout.createSequentialGroup().addGroup(ExposureLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ExposureLayout.createSequentialGroup().addComponent(this.jPanel5, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel6, -2, -1, -2)).addComponent(this.lblExposureMessage, -2, 879, -2)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        ExposureLayout.setVerticalGroup(ExposureLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ExposureLayout.createSequentialGroup().addContainerGap().addGroup(ExposureLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel5, 0, -1, Short.MAX_VALUE).addComponent(this.jPanel6, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 30, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblExposureMessage, -2, 15, -2)));
        this.tbdPane.addTab("Exposure", this.Exposure);
        this.tblCollateral.setModel(new DefaultTableModel(new Object[0][], new String[]{"Symbol", "Volume", "MTM Price", "Haircut %", "Marginized Value", "MTM Amount"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, Float.class, Float.class, Float.class, Float.class, Float.class};
                this.canEdit = new boolean[]{false, false, false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.tblCollateral.setSelectionForeground(new Color(0, 0, 0));
        this.jScrollPane2.setViewportView(this.tblCollateral);
        this.jLabel14.setText("MTM Amount Total");
        this.lblCollateralTotal.setHorizontalAlignment(2);
        this.lblCollateralTotal.setText("0.0");
        this.lblCollateralsMesssage.setText(" ");
        this.pnlCollateralsFilter.setLayout(new GridLayout(1, 0));
        GroupLayout CollateralLayout = new GroupLayout(this.Collateral);
        this.Collateral.setLayout(CollateralLayout);
        CollateralLayout.setHorizontalGroup(CollateralLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, CollateralLayout.createSequentialGroup().addContainerGap().addComponent(this.lblCollateralsMesssage, -2, 391, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 268, Short.MAX_VALUE).addComponent(this.jLabel14, -2, 98, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblCollateralTotal, -2, 112, -2).addContainerGap()).addComponent(this.pnlCollateralsFilter, -1, 899, Short.MAX_VALUE).addComponent(this.jSeparator3, -1, 899, Short.MAX_VALUE).addComponent(this.jScrollPane2, -1, 899, Short.MAX_VALUE));
        CollateralLayout.setVerticalGroup(CollateralLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, CollateralLayout.createSequentialGroup().addComponent(this.pnlCollateralsFilter, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 249, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator3, -2, -1, -2).addGap(3, 3, 3).addGroup(CollateralLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblCollateralsMesssage, -2, 17, -2).addComponent(this.lblCollateralTotal).addComponent(this.jLabel14))));
        CollateralLayout.linkSize(1, this.jLabel14, this.lblCollateralTotal);
        this.tbdPane.addTab("Collaterals", this.Collateral);
        this.tblOpenPosition.setModel(new DefaultTableModel(new Object[0][], new String[]{"Market", "Scrip", "Volume", "Transaction Price", "Transaction Amount", "MTM Price", "MTM Amount", "Profit/Loss"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false, false, false, false, false, false, false};
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.tblOpenPosition.setSelectionForeground(new Color(51, 51, 51));
        this.jScrollPane3.setViewportView(this.tblOpenPosition);
        this.jLabel15.setText("Transaction Amount Total");
        this.lblTransAmount.setHorizontalAlignment(2);
        this.lblTransAmount.setText("0.0");
        this.jLabel16.setText("MTM Amount Total");
        this.lblMTMAmount.setHorizontalAlignment(2);
        this.lblMTMAmount.setText("0.0");
        this.jLabel17.setText("Profit/Loss Amount Total");
        this.lblPLAmount.setHorizontalAlignment(2);
        this.lblPLAmount.setText("0.0");
        this.lblOpenPositionMessage.setText(" ");
        this.pnlOpenOpsitionFilter.setLayout(new GridLayout(1, 0));
        GroupLayout OpenpositionLayout = new GroupLayout(this.Openposition);
        this.Openposition.setLayout(OpenpositionLayout);
        OpenpositionLayout.setHorizontalGroup(OpenpositionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, OpenpositionLayout.createSequentialGroup().addContainerGap().addComponent(this.lblOpenPositionMessage, -2, 184, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel15).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblTransAmount, -2, 108, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel16).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblMTMAmount, -2, 110, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel17).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblPLAmount, -2, 103, -2).addContainerGap()).addComponent(this.pnlOpenOpsitionFilter, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane3).addComponent(this.jSeparator1));
        OpenpositionLayout.setVerticalGroup(OpenpositionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, OpenpositionLayout.createSequentialGroup().addComponent(this.pnlOpenOpsitionFilter, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane3, -1, 249, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 2, -2).addGap(3, 3, 3).addGroup(OpenpositionLayout.createParallelGroup(GroupLayout.Alignment.BASELINE, false).addComponent(this.lblOpenPositionMessage, -2, 17, -2).addComponent(this.jLabel16).addComponent(this.lblTransAmount).addComponent(this.jLabel15, -2, 16, -2).addComponent(this.jLabel17).addComponent(this.lblPLAmount).addComponent(this.lblMTMAmount))));
        OpenpositionLayout.linkSize(1, this.jLabel15, this.jLabel16, this.jLabel17, this.lblMTMAmount, this.lblPLAmount, this.lblTransAmount);
        this.tbdPane.addTab("Open Position", this.Openposition);
        this.tblCommSummary.setAutoCreateRowSorter(true);
        this.tblCommSummary.setModel(new DefaultTableModel(new Object[0][], new String[]{"Account", "Client", "Portfolio Value", "Ledger Balance", "Profit/Loss", "Sold Collaterals", "Net Collateral", "Net Exposure", "Call", "Short Fall", "Short Fall/collat"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false, false, false, false, false, false, false, false, false, false};
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.tblCommSummary.setSelectionForeground(new Color(0, 0, 0));
        this.jScrollPane4.setViewportView(this.tblCommSummary);
        this.lblCumSummaryMessage.setText(" ");
        this.pnlCommSummaryFilter.setLayout(new GridLayout(1, 0));
        GroupLayout CommSummaryLayout = new GroupLayout(this.CommSummary);
        this.CommSummary.setLayout(CommSummaryLayout);
        CommSummaryLayout.setHorizontalGroup(CommSummaryLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlCommSummaryFilter, -1, 899, Short.MAX_VALUE).addComponent(this.jSeparator2, -1, 899, Short.MAX_VALUE).addComponent(this.jScrollPane4, GroupLayout.Alignment.TRAILING, -1, 899, Short.MAX_VALUE).addGroup(CommSummaryLayout.createSequentialGroup().addContainerGap().addComponent(this.lblCumSummaryMessage, -2, 521, -2).addContainerGap()));
        CommSummaryLayout.setVerticalGroup(CommSummaryLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, CommSummaryLayout.createSequentialGroup().addComponent(this.pnlCommSummaryFilter, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane4, -1, 249, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator2, -2, -1, -2).addGap(3, 3, 3).addComponent(this.lblCumSummaryMessage, -2, 17, -2)));
        this.tbdPane.addTab("Cumulative Summary", this.CommSummary);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbAccountNo, -2, 149, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnRefresh).addContainerGap()).addComponent(this.tbdPane));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.cbAccountNo, -2, -1, -2).addComponent(this.btnRefresh)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tbdPane)));
    }

    private void removeExpTableOnly() {
        int numrows = this.exposureModel.getRowCount();
        for (int i = 0; i < numrows; ++i) {
            this.exposureModel.removeRow(0);
        }
    }

    private void setEmptyAccountData() {
        String tab = this.tbdPane.getTitleAt(this.tbdPane.getSelectedIndex());
        if (tab.equalsIgnoreCase("Exposure")) {
            this.emptyExposure();
        } else if (tab.equalsIgnoreCase("Collaterals")) {
            this.collateral.removeCollTable();
            this.lblCollateralsMesssage.setText("No Record(s) found");
            this.lblCollateralsMesssage.setIcon(null);
            this.lblCollateralTotal.setText("0.0");
        } else if (tab.equalsIgnoreCase("Open Position")) {
            this.openPosition.removeOpenTable();
            this.lblOpenPositionMessage.setText("No Record(s) found");
            this.lblOpenPositionMessage.setIcon(null);
            this.lblTransAmount.setText("0.0");
            this.lblMTMAmount.setText("0.0");
            this.lblPLAmount.setText("0.0");
        } else if (tab.equalsIgnoreCase("Cumulative Summary")) {
            this.lblCumSummaryMessage.setText("No Record(s) found");
            this.lblCumSummaryMessage.setIcon(null);
        }
    }

    private void setRenders() {
        int k;
        for (k = 0; k < this.collateralColumns.size(); ++k) {
            this.tblCollateral.getColumn(this.collateralColumns.elementAt(k)).setCellRenderer(new CollateralTableCellRender());
        }
        for (k = 0; k < this.openColumns.size(); ++k) {
            this.tblOpenPosition.getColumn(this.openColumns.elementAt(k)).setCellRenderer(new OpenPositionTableCellRenderer());
        }
        for (k = 0; k < this.commColumns.size(); ++k) {
            this.tblCommSummary.getColumn(this.commColumns.elementAt(k)).setCellRenderer(new CommSummaryTableCellRenderer());
        }
    }

    private void tbdPaneStateChanged(ChangeEvent evt) {
        String account = (String)this.cbAccountNo.getSelectedItem();
        this.setEmptyAccountData();
        if (this.tbdPane.getTitleAt(this.tbdPane.getSelectedIndex()).equalsIgnoreCase("Exposure")) {
            this.lblExposureMessage.setIcon(this.loaderIcon);
            this.lblExposureMessage.setText(this.languageCentre.getValue(LanguageConstant.Loading));
            this.tabname = this.tbdPane.getTitleAt(this.tbdPane.getSelectedIndex());
            this.mediator.SendMsgToTradeServer("MSG-CLIENT|EXPOSURE_LIMIT|" + account + "|" + LogCommon.UserID + "|*");
        } else if (this.tbdPane.getTitleAt(this.tbdPane.getSelectedIndex()).equalsIgnoreCase("Collaterals")) {
            if (!isHelpShow) {
                TradeCast.getInstance().setTrayMessage("Exposure Watch: ", "Please use special search fields at the top, for your specific search!", TrayIcon.MessageType.INFO);
                isHelpShow = true;
            }
            this.tabname = this.tbdPane.getTitleAt(this.tbdPane.getSelectedIndex());
            this.lblCollateralsMesssage.setIcon(this.loaderIcon);
            this.lblCollateralsMesssage.setText(this.languageCentre.getValue(LanguageConstant.Loading));
            this.mediator.SendMsgToTradeServer("MSG-CLIENT|COLLATERAL|" + account + "|" + LogCommon.UserID + "|*");
        } else if (this.tbdPane.getTitleAt(this.tbdPane.getSelectedIndex()).equalsIgnoreCase("Open Position")) {
            this.lblOpenPositionMessage.setIcon(this.loaderIcon);
            this.lblOpenPositionMessage.setText(this.languageCentre.getValue(LanguageConstant.Loading));
            this.tabname = this.tbdPane.getTitleAt(this.tbdPane.getSelectedIndex());
            this.mediator.SendMsgToTradeServer("MSG-CLIENT|OPENPOSITION|" + account + "|" + LogCommon.UserID + "|*");
        } else if (this.tbdPane.getTitleAt(this.tbdPane.getSelectedIndex()).equalsIgnoreCase("Cumulative Summary")) {
            LoadLogs loadLogs = new LoadLogs("CommSummary=", true);
            new ThreadWithName(loadLogs, "CommSummary2").start();
            this.lblCumSummaryMessage.setText(this.languageCentre.getValue(LanguageConstant.Loading));
            this.lblCumSummaryMessage.setIcon(this.loaderIcon);
        }
    }

    private void btnRefreshActionPerformed(ActionEvent evt) {
        this.doRefresh();
    }

    private void cbAccountNoItemStateChanged(ItemEvent evt) {
    }

    private void cbAccountNoActionPerformed(ActionEvent evt) {
        this.accountChanged();
    }
}

