/*
 * Decompiled with CFR 0.152.
 */
package windows;

import CustomComponent.JTextFieldLimit;
import CustomComponent.MyTime;
import MyDocking.Mediator;
import common.gui.util.AppConfig;
import common.gui.util.ImageUtil;
import common.gui.util.MyColors;
import common.services.WebService;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import login.LoginServer;

public class ForgotPassword
extends JDialog {
    LoginServer port = null;
    private JButton btnCancel;
    private JButton btnOK;
    private JLabel lblBGImage;
    private JLabel lblEmail;
    private JLabel lblImage;
    private JLabel lblLoading;
    private JLabel lblRetMsg;
    private JLabel lblUser;
    private JLabel lblYear;
    private JTextField txtEmailAddress;
    private JTextField txtUserID;

    public ForgotPassword(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setTitle("Forgot Password");
        this.setTextForeColor();
        this.setloadingImage(false);
        this.lblImage.setVisible(AppConfig.isShowLogo);
        this.setSize(500, 296);
        this.setResizable(false);
        this.lblImage.setIcon(null);
        new Thread(new Runnable(){

            @Override
            public void run() {
                ForgotPassword.this.setBGImage();
                ForgotPassword.this.repaint();
            }
        }).start();
        try {
            if (AppConfig.smallHosueLogo == null) {
                AppConfig.smallHosueLogo = ImageUtil.downloadImage((String)(AppConfig.TradeCastURL + "/HouseImages/SmallHouseLogo.png"));
            }
            if (AppConfig.smallHosueLogo != null) {
                this.lblImage.setIcon(new ImageIcon(AppConfig.smallHosueLogo));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.txtUserID.setDocument(new JTextFieldLimit(100));
        this.lblUser.setText(AppConfig.UserIDTitle);
        this.setYear();
    }

    private void setBGImage() {
        block4: {
            this.lblBGImage.setIcon(null);
            Image img = null;
            try {
                img = ImageUtil.downloadImage((String)(AppConfig.TradeCastURL + "/HouseImages/SmallHouseBGImage.png"));
                if (img == null) {
                    ImageIcon imw = new ImageIcon(this.getClass().getResource("/Images/ForgetSplash.jpg"));
                    img = imw.getImage();
                    this.lblBGImage.setIcon(new ImageIcon(img));
                    this.setHouseLogo();
                } else {
                    this.lblBGImage.setIcon(new ImageIcon(img));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (img != null) break block4;
                ImageIcon imw = new ImageIcon(this.getClass().getResource("/Images/ForgetSplash.jpg"));
                img = imw.getImage();
                this.lblBGImage.setIcon(new ImageIcon(img));
                this.setHouseLogo();
            }
        }
    }

    private void setHouseLogo() {
        try {
            BufferedImage image = ImageUtil.downloadImage((String)(AppConfig.TradeCastURL + "/HouseImages/HouseLogo.png"));
            if (image != null) {
                this.lblImage.setIcon(new ImageIcon(image));
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    private void initComponents() {
        this.btnOK = new JButton();
        this.txtUserID = new JTextField();
        this.lblRetMsg = new JLabel();
        this.btnCancel = new JButton();
        this.txtEmailAddress = new JTextField();
        this.lblUser = new JLabel();
        this.lblEmail = new JLabel();
        this.lblLoading = new JLabel();
        this.lblImage = new JLabel();
        this.lblBGImage = new JLabel();
        this.lblYear = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(500, 266));
        this.getContentPane().setLayout(null);
        this.btnOK.setIcon(new ImageIcon(this.getClass().getResource("/Images/tick.png")));
        this.btnOK.setText("OK");
        this.btnOK.setName("ForgotPassword -> btnOK");
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ForgotPassword.this.btnOKActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.btnOK);
        this.btnOK.setBounds(100, 160, 85, 25);
        this.txtUserID.setName("txtUserID");
        this.getContentPane().add(this.txtUserID);
        this.txtUserID.setBounds(100, 100, 175, 20);
        this.lblRetMsg.setName("lblRetMsg");
        this.getContentPane().add(this.lblRetMsg);
        this.lblRetMsg.setBounds(100, 190, 380, 30);
        this.btnCancel.setIcon(new ImageIcon(this.getClass().getResource("/Images/close.png")));
        this.btnCancel.setText("Cancel");
        this.btnCancel.setName("ForgotPassword -> btnCancel");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ForgotPassword.this.btnCancelActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.btnCancel);
        this.btnCancel.setBounds(190, 160, 85, 25);
        this.txtEmailAddress.setName("txtEmailAddress");
        this.txtEmailAddress.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ForgotPassword.this.txtEmailAddressActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.txtEmailAddress);
        this.txtEmailAddress.setBounds(100, 130, 175, 20);
        this.lblUser.setText("User ID");
        this.lblUser.setName("lblUser");
        this.getContentPane().add(this.lblUser);
        this.lblUser.setBounds(30, 100, 36, 14);
        this.lblEmail.setText("Email Address");
        this.lblEmail.setName("lblEmail");
        this.getContentPane().add(this.lblEmail);
        this.lblEmail.setBounds(30, 130, 66, 14);
        this.lblLoading.setIcon(new ImageIcon(this.getClass().getResource("/Images/loading.gif")));
        this.lblLoading.setName("lblLoading");
        this.getContentPane().add(this.lblLoading);
        this.lblLoading.setBounds(60, 160, 24, 24);
        this.lblImage.setIcon(new ImageIcon(this.getClass().getResource("/Images/SmallHouseLogo.png")));
        this.lblImage.setName("lblImage");
        this.getContentPane().add(this.lblImage);
        this.lblImage.setBounds(330, 14, 145, 66);
        this.lblBGImage.setBackground(new Color(255, 255, 255));
        this.lblBGImage.setIcon(new ImageIcon(this.getClass().getResource("/Images/ForgetSplash.jpg")));
        this.lblBGImage.setText("jLabel3");
        this.lblBGImage.setName("lblBGImage");
        this.lblBGImage.setOpaque(true);
        this.lblBGImage.setPreferredSize(new Dimension(500, 266));
        this.getContentPane().add(this.lblBGImage);
        this.lblBGImage.setBounds(0, 0, 500, 266);
        this.lblYear.setName("lblYear");
        this.getContentPane().add(this.lblYear);
        this.lblYear.setBounds(147, 245, 350, 20);
        this.pack();
    }

    private void btnOKActionPerformed(ActionEvent evt) {
        try {
            if (this.txtUserID.getText().length() < 1) {
                this.lblRetMsg.setText("Please enter " + AppConfig.UserIDTitle + "!");
                this.lblRetMsg.setForeground(MyColors.errorMessageFG);
                return;
            }
            if (this.txtEmailAddress.getText().length() < 1) {
                this.lblRetMsg.setText("Please enter your email address!");
                this.lblRetMsg.setForeground(MyColors.errorMessageFG);
                return;
            }
            this.setloadingImage(true);
            ForgetPasswordThread forgetpwdthread = new ForgetPasswordThread();
            new Thread(forgetpwdthread).start();
        }
        catch (Exception e) {
            this.lblRetMsg.setText("<html>Unable to send new password on your registered email address.<br>Please contact administrator for further help.</html>");
            this.lblRetMsg.setForeground(MyColors.errorMessageFG);
            this.setloadingImage(false);
            Mediator.getInstance().PrintLog(e, "");
            e.printStackTrace();
        }
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void txtEmailAddressActionPerformed(ActionEvent evt) {
        this.btnOK.doClick();
    }

    public void setloadingImage(Boolean isLoading) {
        if (isLoading.booleanValue()) {
            this.lblLoading.setIcon(new ImageIcon(this.getClass().getResource("/Images/loading.gif")));
        } else {
            this.lblLoading.setIcon(null);
        }
    }

    public void Dispose() {
        this.dispose();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ForgotPassword dialog = new ForgotPassword((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    private void setYear() {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append("<div>");
        String year = MyTime.getInstance().getYear();
        if (MyColors.LoginWindowTextColor == null) {
            sb.append("<span style='font-family: Calibiri Regular; font-size:7px; color: #2d2d2d;'>");
        } else {
            sb.append("<span style='font-family: Calibiri Regular; font-size:7px; color: #").append(AppConfig.GetSixCharacterHexColor((String)System.getProperty("LoginWindowTextColor"))).append("; '>");
        }
        sb.append("Copyright 2010 - ").append(year).append(" CATALYST IT Solutions (Pvt.) Limited.<span style=\"font-style:italic\">All Rights Reserved.</span>");
        sb.append("</span>");
        sb.append("</div>");
        sb.append("</html>");
        this.lblYear.setText(sb.toString());
    }

    private void setTextForeColor() {
        if (MyColors.LoginWindowTextColor != null) {
            this.lblUser.setForeground(MyColors.LoginWindowTextColor);
            this.lblEmail.setForeground(MyColors.LoginWindowTextColor);
        }
    }

    public class ForgetPasswordThread
    implements Runnable {
        boolean Login = false;

        @Override
        public void run() {
            String result = "";
            try {
                ForgotPassword.this.port = WebService.getInstance().getPort();
                String userName = ForgotPassword.this.txtUserID.getText();
                String EmailAddress = ForgotPassword.this.txtEmailAddress.getText();
                result = ForgotPassword.this.port.forgotPassword(userName, EmailAddress);
                ForgotPassword.this.setloadingImage(false);
                if (result.equalsIgnoreCase("Success")) {
                    JOptionPane.showMessageDialog(new JFrame(), "Your new password has been sent to your registered email address!");
                    ForgotPassword.this.Dispose();
                } else if (result.equalsIgnoreCase("Fail")) {
                    ForgotPassword.this.lblRetMsg.setText("<html>Unable to send new password on your registered email address.<br>Please contact administrator for further help.</html>");
                    ForgotPassword.this.lblRetMsg.setForeground(MyColors.errorMessageFG);
                } else {
                    ForgotPassword.this.lblRetMsg.setText(result);
                    ForgotPassword.this.lblRetMsg.setForeground(MyColors.errorMessageFG);
                }
            }
            catch (Exception e) {
                ForgotPassword.this.setloadingImage(false);
                ForgotPassword.this.lblRetMsg.setText("<html>Unable to send new password on your provided email address.<br>Please contact administrator for further help.</html>");
                ForgotPassword.this.lblRetMsg.setForeground(MyColors.errorMessageFG);
                Mediator.getInstance().PrintLog(e, result);
                e.printStackTrace();
            }
        }
    }
}

