/*
 * Decompiled with CFR 0.152.
 */
package windows;

import Beans.MBOFeed;
import CATALYST.Control.MarketFeed;
import CustomComponent.MyTime;
import MyDocking.Mediator;
import MyDocking.TradeCast;
import RendersNModels.MBORender;
import Utilities.OutstandingLogUtil;
import common.gui.component.JTextFieldFilter;
import common.gui.util.AppConfig;
import common.gui.util.FormName;
import common.gui.util.LogCommon;
import common.gui.windows.MBODetail;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.NumberFormat;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.text.Document;
import kse.gui.bean.OutstandingLogBean;
import kse.util.LogsKSE;
import kse.util.UtilKSE;
import languages.LanguageCentre;
import languages.LanguageConstant;
import org.jdesktop.swingx.JXCollapsiblePane;

public class MBO1
extends JPanel
implements ActionListener,
FocusListener {
    public static boolean isOpen = false;
    MBODetail MBODetail = null;
    Vector rows = null;
    Vector columns = null;
    private String dummyFeed = ";;;,,,$,,,$,,,$,,,$,,,$,,,$,,,$,,,$,,,$,,,$;,,,$,,,$,,,$,,,$,,,$,,,$,,,$,,,$,,,$,,,$|";
    Mediator mediator = Mediator.getInstance();
    TradeCast tradeCast = TradeCast.getInstance();
    private String LastMBOMsg = "";
    private String lastTime = "";
    private JPopupMenu popupMenu;
    private MBORender render = new MBORender();
    private String orderNo = "-1";
    private LanguageCentre languageCentre = new LanguageCentre();
    private JComboBox cbMarket;
    private JXCollapsiblePane collapsiblePane;
    private JLabel lblDetail;
    private JLabel lblLTrade;
    private JLabel lblLastUpdate;
    private JLabel lblMarket;
    private JLabel lblMessage;
    private JLabel lblSymbol;
    private JScrollPane scrollPane;
    private JTable table;
    private JTextField txtLTrade;
    private JTextField txtSymbol;

    public MBO1(String Caption) {
        this.mediator.setMBO(this);
        this.rows = new Vector();
        this.columns = new Vector();
        this.columns.addElement(this.languageCentre.getValue(LanguageConstant.Order) + " #");
        this.columns.addElement(this.languageCentre.getValue(LanguageConstant.Flag));
        this.columns.addElement(this.languageCentre.getValue(LanguageConstant.Volume));
        this.columns.addElement(this.languageCentre.getValue(LanguageConstant.Buy));
        this.columns.addElement(this.languageCentre.getValue(LanguageConstant.Sell));
        this.columns.addElement(this.languageCentre.getValue(LanguageConstant.Volume) + " ");
        this.columns.addElement(this.languageCentre.getValue(LanguageConstant.Flag) + " ");
        this.columns.addElement(this.languageCentre.getValue(LanguageConstant.Order) + " # ");
        this.table = new JTable(this.rows, this.columns);
        this.initComponents();
        this.MBODetail = new MBODetail(true, true, this.table);
        this.collapsiblePane.add((Component)this.MBODetail);
        FontMetrics metrics = this.getFontMetrics(LogCommon.MarketDepthFont);
        int fontHeight = metrics.getHeight();
        if (fontHeight <= 18) {
            this.table.setRowHeight(18);
        } else {
            this.table.setRowHeight(fontHeight);
        }
        this.table.setEnabled(true);
        for (int c = 0; c < this.table.getColumnCount(); ++c) {
            Class<?> col_class = this.table.getColumnClass(c);
            this.table.setDefaultEditor(col_class, null);
        }
        this.table.getTableHeader().setReorderingAllowed(false);
        JTableHeader header = this.table.getTableHeader();
        ((JLabel)((Object)header.getDefaultRenderer())).setHorizontalAlignment(0);
        for (int k = 0; k < this.columns.size(); ++k) {
            this.table.getColumn(this.columns.elementAt(k)).setCellRenderer(this.render);
        }
        this.table.getColumnModel().removeColumn(this.table.getColumn(this.languageCentre.getValue(LanguageConstant.Order) + " #"));
        this.table.getColumnModel().removeColumn(this.table.getColumn(this.languageCentre.getValue(LanguageConstant.Order) + " # "));
        this.table.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent e) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
                int scrWidth = 0;
                if (MBO1.this.scrollPane.getVerticalScrollBar().isShowing()) {
                    scrWidth = ((MBO1)MBO1.this).scrollPane.getVerticalScrollBar().getPreferredSize().width;
                }
                MBO1.this.MBODetail.changeMargin(scrWidth);
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }
        });
        this.init();
        this.setLanguageValues();
        this.setCollaspe();
        this.setpopupMenu();
        this.txtSymbol.addFocusListener(this);
    }

    public void init() {
        this.setMarkets();
        this.cbMarket.addActionListener(this);
        this.txtSymbol.addActionListener(this);
        this.txtSymbol.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                this.KeyReleased(evt);
            }

            @Override
            public void keyPressed(KeyEvent evt) {
            }

            private void KeyReleased(KeyEvent evt) {
                if (evt.getKeyCode() != 10 && MBO1.this.txtSymbol.getText().length() < 1) {
                    MBO1.this.MBODetail.setDetailEmpty();
                    MBO1.this.update(MBO1.this.dummyFeed);
                    MBO1.this.SendMBOMessage("", "");
                }
            }
        });
        this.lblLastUpdate.setText("  ");
        this.setFontOnComponent(this.lblLastUpdate, AppConfig.defaultPlanFont);
        this.lblLastUpdate.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                MBO1.this.lblLastUpdate.setText(MBO1.this.lastTime);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                MBO1.this.lblLastUpdate.setText("  ");
            }
        });
        this.lblMessage.setText("");
        this.lblDetail.setMaximumSize(new Dimension(55, 14));
        this.lblDetail.setMinimumSize(new Dimension(55, 14));
        this.lblDetail.setPreferredSize(new Dimension(55, 14));
        this.lblDetail.setCursor(Cursor.getPredefinedCursor(12));
        this.lblDetail.setText("<html>" + this.languageCentre.getValue(LanguageConstant.Details) + "</html>");
        this.txtSymbol.setDocument((Document)new JTextFieldFilter("ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-"));
        this.setFontOnComponent(this.txtLTrade, AppConfig.defaultPlanFont);
        this.setFontOnComponent(this.cbMarket, AppConfig.defaultPlanFont);
        this.setFontOnComponent(this.txtSymbol, AppConfig.defaultPlanFont);
    }

    public void setMarkets() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.cbMarket.setModel(new DefaultComboBoxModel<String>(LogCommon.markets));
            this.cbMarket.removeItem("");
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MBO1.this.cbMarket.setModel(new DefaultComboBoxModel<String>(LogCommon.markets));
                    MBO1.this.cbMarket.removeItem("");
                }
            });
        }
    }

    private void setpopupMenu() {
        this.scrollPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MBO1.this.showPoupMenu(e, MBO1.this.scrollPane);
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MBO1.this.showPoupMenu(e, MBO1.this.table);
            }
        });
    }

    public void createPopupMenu() {
        this.popupMenu = new JPopupMenu();
        this.popupMenu.removeAll();
        JMenuItem menuItem = new JMenuItem(this.languageCentre.getValue(LanguageConstant.Buy));
        menuItem.setIcon(new ImageIcon(this.getClass().getResource("/Images/Buy.png")));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MBO1.this.openWindow(FormName.Buy);
            }
        });
        this.popupMenu.add(menuItem);
        menuItem = new JMenuItem(this.languageCentre.getValue(LanguageConstant.Sell));
        menuItem.setIcon(new ImageIcon(this.getClass().getResource("/Images/Sell.png")));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MBO1.this.openWindow(FormName.Sell);
            }
        });
        this.popupMenu.add(menuItem);
        menuItem = new JMenuItem(this.languageCentre.getValue(LanguageConstant.GraphsAndCharts));
        menuItem.setIcon(new ImageIcon(this.getClass().getResource("/Images/graph.png")));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MBO1.this.openWindow(FormName.GraphsAndCharts);
            }
        });
        if (AppConfig.GraphURL.length() > 0) {
            this.popupMenu.add(menuItem);
            this.popupMenu.addSeparator();
        }
        menuItem = new JMenuItem(this.languageCentre.getValue(LanguageConstant.ShortSell));
        menuItem.setIcon(new ImageIcon(this.getClass().getResource("/Images/ShortSell.png")));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MBO1.this.openWindow(FormName.ShortSell);
            }
        });
        if (AppConfig.isShortSell) {
            this.popupMenu.add(menuItem);
            this.popupMenu.addSeparator();
        }
        menuItem = new JMenuItem(this.languageCentre.getValue(LanguageConstant.ChangeOrder));
        menuItem.setIcon(new ImageIcon(this.getClass().getResource("/Images/Change.png")));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MBO1.this.openWindow(FormName.ChangeOrder);
            }
        });
        this.popupMenu.add(menuItem);
        this.popupMenu.addSeparator();
        menuItem = new JMenuItem(this.languageCentre.getValue(LanguageConstant.Cancel));
        menuItem.setIcon(new ImageIcon(this.getClass().getResource("/Images/Cancel.png")));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MBO1.this.openWindow(FormName.Cancel);
            }
        });
        this.popupMenu.add(menuItem);
        this.popupMenu.addSeparator();
        menuItem = new JMenuItem(this.languageCentre.getValue(LanguageConstant.MarketDepthByPrice));
        menuItem.setIcon(new ImageIcon(this.getClass().getResource("/Images/MBP.png")));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MBO1.this.openWindow(FormName.MBP);
            }
        });
        this.popupMenu.add(menuItem);
        menuItem = new JMenuItem(this.languageCentre.getValue(LanguageConstant.DetailedQuote));
        menuItem.setIcon(new ImageIcon(this.getClass().getResource("/Images/detailQuote.png")));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MBO1.this.openWindow(FormName.DetailedQuote);
            }
        });
        this.popupMenu.add(menuItem);
        this.popupMenu.addSeparator();
        menuItem = new JMenuItem(this.languageCentre.getValue(LanguageConstant.FontSetting) + "          ");
        menuItem.setIcon(new ImageIcon(this.getClass().getResource("/Images/font.png")));
        this.popupMenu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MBO1.this.openWindow(FormName.Prefernces);
            }
        });
        this.popupMenu.add(menuItem);
    }

    private void showPoupMenu(MouseEvent e, JScrollPane sp) {
        int rowNo = this.table.rowAtPoint(e.getPoint());
        int columnNo = this.table.columnAtPoint(e.getPoint());
        if (rowNo >= 0) {
            if (columnNo <= 2) {
                this.orderNo = ((Vector)this.rows.get(rowNo)).get(0).toString();
            } else if (columnNo > 2) {
                this.orderNo = ((Vector)this.rows.get(rowNo)).get(7).toString();
            }
            OutstandingLogBean bean = OutstandingLogUtil.GetOrderToCancel(this.orderNo);
            if (bean == null) {
                this.orderNo = "-1";
            }
        }
        if (SwingUtilities.isRightMouseButton(e)) {
            this.createPopupMenu();
            this.popupMenu.show(this.scrollPane, e.getX(), e.getY());
        } else if (e.getClickCount() >= 2) {
            this.openWindow(FormName.Cancel);
        }
    }

    private void showPoupMenu(MouseEvent e, JTable tb) {
        int rowNo = this.table.rowAtPoint(e.getPoint());
        int columnNo = this.table.columnAtPoint(e.getPoint());
        if (rowNo >= 0) {
            if (columnNo <= 2) {
                this.orderNo = ((Vector)this.rows.get(rowNo)).get(0).toString();
            } else if (columnNo > 2) {
                this.orderNo = ((Vector)this.rows.get(rowNo)).get(7).toString();
            }
            OutstandingLogBean bean = OutstandingLogUtil.GetOrderToCancel(this.orderNo);
            if (bean == null) {
                this.orderNo = "-1";
            }
        }
        if (SwingUtilities.isRightMouseButton(e)) {
            this.createPopupMenu();
            this.popupMenu.show(tb, e.getX(), e.getY());
        } else if (e.getClickCount() >= 2) {
            this.openWindow(FormName.Cancel);
        }
    }

    public void openWindow(FormName formName) {
        if (formName == FormName.GraphsAndCharts) {
            TradeCast.getInstance().ShowGraphWindow(FormName.GraphsAndCharts, LanguageConstant.GraphsAndCharts, this.cbMarket.getSelectedItem().toString(), this.txtSymbol.getText());
        } else if (formName == FormName.Buy) {
            TradeCast.getInstance().ShowDynamicForm(FormName.Buy, LanguageConstant.Buy);
            if (this.mediator.buysell != null) {
                this.mediator.buysell.initBuySell("BUY", LogCommon.UserID, this.getMarket(), this.txtSymbol.getText().trim(), FormName.Buy, "");
            }
        } else if (formName == FormName.Sell) {
            TradeCast.getInstance().ShowDynamicForm(FormName.Sell, LanguageConstant.Sell);
            if (this.mediator.buysell != null) {
                this.mediator.buysell.initBuySell(LanguageConstant.Sell, LogCommon.UserID, this.getMarket(), this.txtSymbol.getText().trim(), FormName.Sell, "");
            }
        } else if (formName == FormName.ShortSell) {
            if (AppConfig.isShortSell) {
                TradeCast.getInstance().ShowDynamicForm(FormName.ShortSell, LanguageConstant.ShortSell);
                if (this.mediator.shortsell != null) {
                    this.mediator.shortsell.initBuySell("SHORT SELL", LogCommon.UserID, this.getMarket(), this.txtSymbol.getText().trim(), FormName.ShortSell, "");
                }
            }
        } else if (formName == FormName.ChangeOrder) {
            TradeCast.getInstance().ShowDynamicForm(FormName.ChangeOrder, LanguageConstant.ChangeOrder);
        } else if (formName == FormName.Cancel) {
            TradeCast.getInstance().ShowDynamicForm(FormName.Cancel, LanguageConstant.Cancel);
            if (this.mediator.cancel != null) {
                this.mediator.cancel.initBuySell("CANCEL", LogCommon.UserID, this.getMarket(), this.txtSymbol.getText().trim(), FormName.Cancel, this.orderNo);
            }
        } else if (formName == FormName.MBO) {
            this.tradeCast.showStaticWindow(LanguageConstant.MarketDepthByOrder, false);
            if (this.mediator.mbo != null) {
                this.mediator.mbo.AddSymbol(this.txtSymbol.getText().trim(), this.getMarket());
            }
        } else if (formName == FormName.MBP) {
            this.tradeCast.showStaticWindow(LanguageConstant.MarketDepthByPrice, false);
            if (this.mediator.mbp != null) {
                this.mediator.mbp.AddSymbol(this.txtSymbol.getText().trim(), this.getMarket());
            }
        } else if (formName == FormName.DetailedQuote) {
            TradeCast.getInstance().ShowDynamicForm(FormName.DetailedQuote, LanguageConstant.DetailedQuote);
            if (this.mediator.detailedQuote != null) {
                this.mediator.detailedQuote.AddSymbol(this.getMarket(), this.txtSymbol.getText().trim());
                this.mediator.detailedQuote.setTitle("");
            }
        } else if (formName == FormName.Prefernces) {
            TradeCast.getInstance().ShowDynamicForm(FormName.Prefernces, LanguageConstant.Fonts);
            if (this.mediator.prefrences != null) {
                this.mediator.prefrences.selectFontTab(this.languageCentre.getValue(LanguageConstant.Others));
            }
        }
    }

    public void AddSymbol(String Symbol_, String Market) {
        if (this.txtSymbol.getText().compareTo(Symbol_) != 0 || this.cbMarket.getSelectedItem().toString().compareTo(Market) != 0) {
            this.rows.clear();
            this.tableDataChange();
            this.txtSymbol.setText(Symbol_);
            this.cbMarket.setSelectedItem(Market);
            this.SendMBOMessage(Symbol_, Market);
        }
    }

    @Override
    public void update(Graphics g) {
        try {
            this.paint(g);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void setFontOnComponent(final JComponent com, final Font font) {
        if (SwingUtilities.isEventDispatchThread()) {
            com.setFont(font);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    com.setFont(font);
                }
            });
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String sym = this.txtSymbol.getText();
        String sa = UtilKSE.GetMarketFromsymbol((String)sym);
        Object source = e.getSource();
        if (sym.length() < 1) {
            this.update(this.dummyFeed);
            this.MBODetail.setDetailEmpty();
            this.SendMBOMessage("", "");
            this.lblMessage.setFont(this.lblMessage.getFont().deriveFont(0));
            this.lblMessage.setText(this.languageCentre.getValue(LanguageConstant.PleaseEnterScrip));
            return;
        }
        if (source == this.txtSymbol) {
            this.cbMarket.setSelectedItem(sa.toString());
        }
        this.SendMBOMessage(this.txtSymbol.getText().trim(), this.cbMarket.getSelectedItem().toString());
    }

    public void update(String Msg) {
        double buyVolTot = 0.0;
        double selVolTot = 0.0;
        double buyPriceTot = 0.0;
        double selPriceTot = 0.0;
        try {
            String[] feeds = Msg.split("\\|", -1);
            for (int iteration = 0; iteration < feeds.length; ++iteration) {
                if (feeds[iteration].trim().length() > 0 && feeds[iteration].indexOf(";") >= 0) {
                    String[] feed = feeds[iteration].split("\\;", -1);
                    MBOFeed mbofeed = new MBOFeed();
                    mbofeed.feedString = feeds[iteration];
                    mbofeed.symbol = feed[0];
                    mbofeed.market = feed[1];
                    mbofeed.buy = feed[3];
                    mbofeed.sell = feed[4];
                    mbofeed.lastPrice = feed[2];
                    MarketFeed mktFeed = this.mediator.MwPanel.GetSingleFeed(this.txtSymbol.getText(), this.cbMarket.getSelectedItem() + "");
                    if (mktFeed == null) {
                        this.txtLTrade.setText(mbofeed.lastPrice);
                    } else {
                        this.txtLTrade.setText(mktFeed.lTrdPrice);
                    }
                    String[] BuyValues = mbofeed.buy.split("\\$", -1);
                    String[] SellValues = mbofeed.sell.split("\\$", -1);
                    String[] BuyVal = new String[]{"", "", "", ""};
                    String[] SellVal = new String[]{"", "", "", ""};
                    this.rows.clear();
                    for (int i = 0; i < 10; ++i) {
                        SellVal[3] = "";
                        SellVal[2] = "";
                        SellVal[1] = "";
                        SellVal[0] = "";
                        BuyVal[3] = "";
                        BuyVal[2] = "";
                        BuyVal[1] = "";
                        BuyVal[0] = "";
                        Vector<String> v = new Vector<String>();
                        if (i < BuyValues.length - 1) {
                            BuyVal = BuyValues[i].split("\\,", -1);
                        }
                        if (i < SellValues.length - 1) {
                            SellVal = SellValues[i].split("\\,", -1);
                        }
                        try {
                            NumberFormat nf;
                            v.addElement(BuyVal[3]);
                            v.addElement(BuyVal[2]);
                            try {
                                nf = NumberFormat.getInstance();
                                nf.setGroupingUsed(true);
                                long vol = Integer.parseInt(BuyVal[1]);
                                Long Vol = vol;
                                v.addElement(nf.format(Vol));
                                buyVolTot = (double)vol + buyVolTot;
                            }
                            catch (Exception e) {
                                v.addElement(BuyVal[1]);
                            }
                            v.addElement(BuyVal[0]);
                            v.addElement(SellVal[0]);
                            try {
                                double price = Double.parseDouble(BuyVal[0]);
                                long vol = Integer.parseInt(BuyVal[1]);
                                double res = price * (double)vol;
                                buyPriceTot += res;
                            }
                            catch (Exception price) {
                                // empty catch block
                            }
                            try {
                                double price = Double.parseDouble(SellVal[0]);
                                int vol = Integer.parseInt(SellVal[1]);
                                double res = price * (double)vol;
                                selPriceTot += res;
                            }
                            catch (Exception price) {
                                // empty catch block
                            }
                            try {
                                nf = NumberFormat.getInstance();
                                nf.setGroupingUsed(true);
                                int vol = Integer.parseInt(SellVal[1]);
                                Integer Vol = vol;
                                v.addElement(nf.format(Vol));
                                selVolTot = (double)vol + selVolTot;
                            }
                            catch (Exception e) {
                                v.addElement(SellVal[1]);
                            }
                            v.addElement(SellVal[2]);
                            v.addElement(SellVal[3]);
                            this.rows.insertElementAt(v, i);
                            continue;
                        }
                        catch (Exception ex) {
                            this.mediator.PrintLog(ex, Msg);
                        }
                    }
                    this.tableDataChange();
                    this.lastTime = MyTime.getInstance().getTime();
                    this.lblLastUpdate.setToolTipText(this.languageCentre.getValue(LanguageConstant.LastUpdateTime) + " " + this.lastTime);
                }
                double capsLower = 0.0;
                double capsUpper = 0.0;
                String cps = this.mediator.logsCommon.getCaps(this.txtSymbol.getText(), this.cbMarket.getSelectedItem() + "");
                if (cps.length() > 0) {
                    try {
                        capsUpper = Double.parseDouble(cps.split(":")[0]);
                        capsLower = Double.parseDouble(cps.split(":")[1]);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                this.MBODetail.setValues(capsUpper, capsLower, buyVolTot, selVolTot, buyPriceTot, selPriceTot);
            }
        }
        catch (Exception ex) {
            this.mediator.PrintLog(ex, Msg);
        }
        this.lblMessage.setFont(this.lblMessage.getFont().deriveFont(this.lblMessage.getFont().getStyle() | 1));
        this.lblMessage.setText(this.mediator.getSymbolTitle(this.txtSymbol.getText()));
    }

    private void tableDataChange() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.table.addNotify();
            this.table.repaint();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MBO1.this.table.addNotify();
                    MBO1.this.table.repaint();
                }
            });
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        Object source = e.getSource();
        if (source == this.txtSymbol) {
            this.txtSymbol.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    public void SendMBOMessage(String Symbol, String Market) {
        if (!this.LastMBOMsg.equalsIgnoreCase(Symbol + ":" + Market)) {
            this.update(this.dummyFeed);
            this.MBODetail.setDetailEmpty();
            if (Symbol.length() > 0 && LogCommon.SymbolAndSymbolName.size() > 0 && !LogCommon.SymbolAndSymbolName.containsKey(Symbol.trim())) {
                this.lblMessage.setText(this.languageCentre.getValue(LanguageConstant.InvalidScrip));
            } else {
                this.lblMessage.setText("");
            }
            this.LastMBOMsg = Symbol + ":" + Market;
            this.mediator.SendMsgToFeedServer("MBO-FEED|" + this.LastMBOMsg, "MBO : SendMBOMessage");
        }
    }

    public Font GetMBOFont() {
        return this.table.getFont();
    }

    public void Refresh() {
        FontMetrics metrics = this.getFontMetrics(LogCommon.MarketDepthFont);
        int fontHeight = metrics.getHeight();
        if (fontHeight <= 18) {
            this.table.setRowHeight(18);
        } else {
            this.table.setRowHeight(fontHeight);
        }
        if (this.MBODetail != null) {
            this.MBODetail.Refresh();
        }
        this.tableDataChange();
    }

    private void initComponents() {
        this.lblMarket = new JLabel();
        this.lblSymbol = new JLabel();
        this.lblLTrade = new JLabel();
        this.txtSymbol = new JTextField();
        this.txtLTrade = new JTextField();
        this.cbMarket = new JComboBox();
        this.lblLastUpdate = new JLabel();
        this.lblMessage = new JLabel();
        this.lblDetail = new JLabel();
        this.scrollPane = new JScrollPane();
        this.table = new JTable(this.rows, this.columns);
        this.collapsiblePane = new JXCollapsiblePane();
        this.setAlignmentX(0.0f);
        this.setAlignmentY(0.0f);
        this.lblMarket.setText("Market");
        this.lblSymbol.setText("Scrip");
        this.lblLTrade.setText("L.Trade");
        this.txtLTrade.setHorizontalAlignment(4);
        this.txtLTrade.setEnabled(false);
        this.cbMarket.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.lblLastUpdate.setHorizontalAlignment(4);
        this.lblLastUpdate.setIcon(new ImageIcon(this.getClass().getResource("/Images/lastUpdateTime16.png")));
        this.lblLastUpdate.setText("PKT 88:88:88");
        this.lblLastUpdate.setToolTipText("Yet not updated");
        this.lblLastUpdate.setHorizontalTextPosition(2);
        this.lblMessage.setText("A");
        this.lblMessage.setMaximumSize(new Dimension(7, 16));
        this.lblMessage.setMinimumSize(new Dimension(7, 16));
        this.lblMessage.setPreferredSize(new Dimension(7, 16));
        this.lblDetail.setIcon(new ImageIcon(this.getClass().getResource("/Images/downarrowgray.png")));
        this.lblDetail.setText("Detail");
        this.lblDetail.setMaximumSize(new Dimension(49, 14));
        this.lblDetail.setMinimumSize(new Dimension(49, 14));
        this.lblDetail.setPreferredSize(new Dimension(49, 14));
        this.lblDetail.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                MBO1.this.lblDetailMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                MBO1.this.lblDetailMouseExited(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                MBO1.this.lblDetailMousePressed(evt);
            }
        });
        this.scrollPane.setViewportView(this.table);
        this.collapsiblePane.setCollapsed(true);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent((Component)this.collapsiblePane, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.lblMessage, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblLastUpdate, -2, 93, -2)).addComponent(this.scrollPane, GroupLayout.Alignment.LEADING, 0, 0, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.lblMarket).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbMarket, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblSymbol).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtSymbol, -2, 43, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblLTrade).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtLTrade, -2, 41, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.lblDetail, -2, -1, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblMarket).addComponent(this.lblSymbol).addComponent(this.txtSymbol, -2, -1, -2).addComponent(this.txtLTrade, -2, -1, -2).addComponent(this.cbMarket, -2, -1, -2).addComponent(this.lblLTrade).addComponent(this.lblDetail, -2, 14, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scrollPane, -1, 165, Short.MAX_VALUE).addGap(0, 0, 0).addComponent((Component)this.collapsiblePane, -2, -1, -2).addGap(2, 2, 2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblMessage, -2, -1, -2).addComponent(this.lblLastUpdate))));
        layout.linkSize(1, this.lblDetail, this.txtLTrade);
    }

    private void lblDetailMousePressed(MouseEvent evt) {
        this.setCollaspe();
    }

    private void lblDetailMouseExited(MouseEvent evt) {
        this.lblDetail.setText("<html>" + this.languageCentre.getValue(LanguageConstant.Details) + "</html>");
    }

    private void lblDetailMouseEntered(MouseEvent evt) {
        this.lblDetail.setText("<html><U>" + this.languageCentre.getValue(LanguageConstant.Details) + "</U></html>");
    }

    private void setCollaspe() {
        boolean state = this.collapsiblePane.isCollapsed();
        this.collapsiblePane.setCollapsed(!state);
        if (state) {
            this.lblDetail.setIcon(new ImageIcon(this.getClass().getResource("/Images/uparrowgray.png")));
        } else {
            this.lblDetail.setIcon(new ImageIcon(this.getClass().getResource("/Images/downarrowgray.png")));
        }
    }

    private String getMarket() {
        if (this.cbMarket.getSelectedItem() == null) {
            return LogsKSE.SelectedMarket;
        }
        if (this.cbMarket.getSelectedItem().toString().trim().equalsIgnoreCase("")) {
            return LogsKSE.SelectedMarket;
        }
        return this.cbMarket.getSelectedItem().toString().trim();
    }

    private void setLanguageValues() {
        this.lblMarket.setText(this.languageCentre.getValue(LanguageConstant.Market));
        this.lblSymbol.setText(this.languageCentre.getValue(LanguageConstant.Scrip));
        this.lblLTrade.setText(this.languageCentre.getValue(LanguageConstant.LastTradePrice));
    }
}

