/*
 * Decompiled with CFR 0.152.
 */
package windows;

import Beans.MBPFeed;
import CATALYST.Control.MarketFeed;
import CustomComponent.MyTime;
import MyDocking.Mediator;
import MyDocking.TradeCast;
import common.gui.component.JTextFieldFilter;
import common.gui.util.AppConfig;
import common.gui.util.FormName;
import common.gui.util.LogCommon;
import common.gui.windows.MBODetail;
import common.gui.windows.render.MBPRender;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.NumberFormat;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.Document;
import kse.util.LogsKSE;
import kse.util.UtilKSE;
import languages.LanguageCentre;
import languages.LanguageConstant;
import org.jdesktop.swingx.JXCollapsiblePane;
import org.jdesktop.swingx.VerticalLayout;

public class MBP1
extends JPanel
implements ActionListener,
FocusListener {
    Mediator mediator = Mediator.getInstance();
    TradeCast tradeCast = TradeCast.getInstance();
    public static boolean isOpen = false;
    MBODetail MBPDetail = null;
    Vector rows = null;
    Vector columns = null;
    private String dummyFeed = ";;;,,$,,$,,$,,$,,$,,$,,$,,$,,$,,$;,,$,,$,,$,,$,,$,,$,,$,,$,,$,,$|";
    private String LastMBPMsg = "";
    private String lastTime = " ";
    private JPopupMenu popupMenu;
    private MBPRender render = new MBPRender(null);
    private LanguageCentre languageCentre = new LanguageCentre();
    private JComboBox cbMarket;
    private JXCollapsiblePane collapsiblePane;
    private JLabel lblDetail;
    private JLabel lblLTrade;
    private JLabel lblLastUpdate;
    private JLabel lblMarket;
    private JLabel lblMessage;
    private JLabel lblSymbol;
    private JScrollPane scrollPane;
    private JTable table;
    private JTextField txtLTrade;
    private JTextField txtSymbol;

    public MBP1(String Caption) {
        this.mediator.setMBP(this);
        this.rows = new Vector();
        this.columns = new Vector();
        this.columns.addElement(this.languageCentre.getValue(LanguageConstant.Flag));
        this.columns.addElement(this.languageCentre.getValue(LanguageConstant.Volume));
        this.columns.addElement(this.languageCentre.getValue(LanguageConstant.Price));
        this.columns.addElement(this.languageCentre.getValue(LanguageConstant.Price) + " ");
        this.columns.addElement(this.languageCentre.getValue(LanguageConstant.Volume) + " ");
        this.columns.addElement(this.languageCentre.getValue(LanguageConstant.Flag) + " ");
        this.table = new JTable(this.rows, this.columns);
        this.initComponents();
        this.MBPDetail = new MBODetail(false, true, this.table);
        this.collapsiblePane.add((Component)this.MBPDetail);
        FontMetrics metrics = this.getFontMetrics(LogCommon.MarketDepthFont);
        int fontHeight = metrics.getHeight();
        if (fontHeight <= 18) {
            this.table.setRowHeight(18);
        } else {
            this.table.setRowHeight(fontHeight);
        }
        this.table.setEnabled(false);
        this.table.getTableHeader().setReorderingAllowed(false);
        JTableHeader header = this.table.getTableHeader();
        ((JLabel)((Object)header.getDefaultRenderer())).setHorizontalAlignment(0);
        for (int k = 0; k < this.columns.size(); ++k) {
            this.table.getColumn(this.columns.elementAt(k)).setCellRenderer((TableCellRenderer)this.render);
        }
        this.table.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent e) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
                int scrWidth = 0;
                if (MBP1.this.scrollPane.getVerticalScrollBar().isShowing()) {
                    scrWidth = ((MBP1)MBP1.this).scrollPane.getVerticalScrollBar().getPreferredSize().width;
                }
                MBP1.this.MBPDetail.changeMargin(scrWidth);
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }
        });
        this.init();
        this.setpopupMenu();
        this.setLanguageValues();
        this.setCollaspe();
        this.txtSymbol.addFocusListener(this);
    }

    public void init() {
        this.setMarkets();
        this.cbMarket.addActionListener(this);
        this.txtSymbol.addActionListener(this);
        this.txtSymbol.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                this.KeyReleased(evt);
            }

            @Override
            public void keyPressed(KeyEvent evt) {
            }

            private void KeyReleased(KeyEvent evt) {
                if (evt.getKeyCode() != 10 && MBP1.this.txtSymbol.getText().length() < 1) {
                    MBP1.this.update(MBP1.this.dummyFeed);
                    MBP1.this.MBPDetail.setDetailEmpty();
                    MBP1.this.SendMBPMessage("", "");
                }
            }
        });
        this.lblLastUpdate.setText("  ");
        this.setFontOnComponent(this.lblLastUpdate, AppConfig.defaultPlanFont);
        this.lblLastUpdate.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                MBP1.this.lblLastUpdate.setText(MBP1.this.lastTime);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                MBP1.this.lblLastUpdate.setText("  ");
            }
        });
        this.lblMessage.setText("");
        this.lblDetail.setMaximumSize(new Dimension(55, 14));
        this.lblDetail.setMinimumSize(new Dimension(55, 14));
        this.lblDetail.setPreferredSize(new Dimension(55, 14));
        this.lblDetail.setCursor(Cursor.getPredefinedCursor(12));
        this.lblDetail.setText("<html>" + this.languageCentre.getValue(LanguageConstant.Details) + "</html>");
        this.txtSymbol.setDocument((Document)new JTextFieldFilter("ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-"));
        this.setFontOnComponent(this.txtLTrade, AppConfig.defaultPlanFont);
        this.setFontOnComponent(this.cbMarket, AppConfig.defaultPlanFont);
        this.setFontOnComponent(this.txtSymbol, AppConfig.defaultPlanFont);
    }

    public void setMarkets() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.cbMarket.setModel(new DefaultComboBoxModel<String>(LogCommon.markets));
            this.cbMarket.removeItem("");
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MBP1.this.cbMarket.setModel(new DefaultComboBoxModel<String>(LogCommon.markets));
                    MBP1.this.cbMarket.removeItem("");
                }
            });
        }
    }

    private void setpopupMenu() {
        this.scrollPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MBP1.this.showPoupMenu(e, MBP1.this.scrollPane);
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MBP1.this.showPoupMenu(e, MBP1.this.table);
            }
        });
    }

    public void createPopupMenu() {
        this.popupMenu = new JPopupMenu();
        this.popupMenu.removeAll();
        JMenuItem menuItem = new JMenuItem(this.languageCentre.getValue(LanguageConstant.Buy));
        menuItem.setIcon(new ImageIcon(this.getClass().getResource("/Images/Buy.png")));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MBP1.this.openWindow(FormName.Buy);
            }
        });
        this.popupMenu.add(menuItem);
        menuItem = new JMenuItem(this.languageCentre.getValue(LanguageConstant.Sell));
        menuItem.setIcon(new ImageIcon(this.getClass().getResource("/Images/Sell.png")));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MBP1.this.openWindow(FormName.Sell);
            }
        });
        this.popupMenu.add(menuItem);
        menuItem = new JMenuItem(this.languageCentre.getValue(LanguageConstant.GraphsAndCharts));
        menuItem.setIcon(new ImageIcon(this.getClass().getResource("/Images/graph.png")));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MBP1.this.openWindow(FormName.GraphsAndCharts);
            }
        });
        if (AppConfig.GraphURL.length() > 0) {
            this.popupMenu.add(menuItem);
            this.popupMenu.addSeparator();
        }
        menuItem = new JMenuItem(this.languageCentre.getValue(LanguageConstant.ShortSell));
        menuItem.setIcon(new ImageIcon(this.getClass().getResource("/Images/ShortSell.png")));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MBP1.this.openWindow(FormName.ShortSell);
            }
        });
        if (AppConfig.isShortSell) {
            this.popupMenu.add(menuItem);
            this.popupMenu.addSeparator();
        }
        menuItem = new JMenuItem(this.languageCentre.getValue(LanguageConstant.ChangeOrder));
        menuItem.setIcon(new ImageIcon(this.getClass().getResource("/Images/Change.png")));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MBP1.this.openWindow(FormName.ChangeOrder);
            }
        });
        this.popupMenu.add(menuItem);
        this.popupMenu.addSeparator();
        menuItem = new JMenuItem(this.languageCentre.getValue(LanguageConstant.Cancel));
        menuItem.setIcon(new ImageIcon(this.getClass().getResource("/Images/Cancel.png")));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MBP1.this.openWindow(FormName.Cancel);
            }
        });
        this.popupMenu.add(menuItem);
        this.popupMenu.addSeparator();
        menuItem = new JMenuItem(this.languageCentre.getValue(LanguageConstant.MarketDepthByOrder));
        menuItem.setIcon(new ImageIcon(this.getClass().getResource("/Images/MBO.png")));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MBP1.this.openWindow(FormName.MBO);
            }
        });
        this.popupMenu.add(menuItem);
        menuItem = new JMenuItem(this.languageCentre.getValue(LanguageConstant.DetailedQuote));
        menuItem.setIcon(new ImageIcon(this.getClass().getResource("/Images/detailQuote.png")));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MBP1.this.openWindow(FormName.DetailedQuote);
            }
        });
        this.popupMenu.add(menuItem);
        this.popupMenu.addSeparator();
        menuItem = new JMenuItem(this.languageCentre.getValue(LanguageConstant.FontSetting) + "          ");
        menuItem.setIcon(new ImageIcon(this.getClass().getResource("/Images/font.png")));
        this.popupMenu.add(menuItem);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MBP1.this.openWindow(FormName.Prefernces);
            }
        });
        this.popupMenu.add(menuItem);
    }

    private void showPoupMenu(MouseEvent e, JScrollPane sp) {
        if (SwingUtilities.isRightMouseButton(e)) {
            this.createPopupMenu();
            this.popupMenu.show(this.scrollPane, e.getX(), e.getY());
        }
    }

    private void showPoupMenu(MouseEvent e, JTable tb) {
        if (SwingUtilities.isRightMouseButton(e)) {
            this.createPopupMenu();
            this.popupMenu.show(tb, e.getX(), e.getY());
        }
    }

    public void openWindow(FormName formName) {
        if (formName == FormName.GraphsAndCharts) {
            TradeCast.getInstance().ShowGraphWindow(FormName.GraphsAndCharts, LanguageConstant.GraphsAndCharts, this.cbMarket.getSelectedItem().toString(), this.txtSymbol.getText());
        } else if (formName == FormName.Buy) {
            TradeCast.getInstance().ShowDynamicForm(FormName.Buy, LanguageConstant.Buy);
            if (this.mediator.buysell != null) {
                this.mediator.buysell.initBuySell("BUY", LogCommon.UserID, this.getMarket(), this.txtSymbol.getText().trim(), FormName.Buy, "");
            }
        } else if (formName == FormName.Sell) {
            TradeCast.getInstance().ShowDynamicForm(FormName.Sell, LanguageConstant.Sell);
            if (this.mediator.buysell != null) {
                this.mediator.buysell.initBuySell("Sell", LogCommon.UserID, this.getMarket(), this.txtSymbol.getText().trim(), FormName.Sell, "");
            }
        } else if (formName == FormName.ShortSell) {
            if (AppConfig.isShortSell) {
                TradeCast.getInstance().ShowDynamicForm(FormName.ShortSell, LanguageConstant.ShortSell);
                if (this.mediator.shortsell != null) {
                    this.mediator.shortsell.initBuySell("SHORT SELL", LogCommon.UserID, this.getMarket(), this.txtSymbol.getText().trim(), FormName.ShortSell, "");
                }
            }
        } else if (formName == FormName.ChangeOrder) {
            TradeCast.getInstance().ShowDynamicForm(FormName.ChangeOrder, LanguageConstant.ChangeOrder);
        } else if (formName == FormName.Cancel) {
            TradeCast.getInstance().ShowDynamicForm(FormName.Cancel, LanguageConstant.Cancel);
            if (this.mediator.cancel != null) {
                this.mediator.cancel.initBuySell("CANCEL", LogCommon.UserID, this.getMarket(), this.txtSymbol.getText().trim(), FormName.Cancel, "");
            }
        } else if (formName == FormName.MBO) {
            this.tradeCast.showStaticWindow(LanguageConstant.MarketDepthByOrder, false);
            if (this.mediator.mbo != null) {
                this.mediator.mbo.AddSymbol(this.txtSymbol.getText().trim(), this.getMarket());
            }
        } else if (formName == FormName.MBP) {
            this.tradeCast.showStaticWindow(LanguageConstant.MarketDepthByPrice, false);
            if (this.mediator.mbp != null) {
                this.mediator.mbp.AddSymbol(this.txtSymbol.getText().trim(), this.getMarket());
            }
        } else if (formName == FormName.DetailedQuote) {
            TradeCast.getInstance().ShowDynamicForm(FormName.DetailedQuote, LanguageConstant.DetailedQuote);
            if (this.mediator.detailedQuote != null) {
                this.mediator.detailedQuote.AddSymbol(this.getMarket(), this.txtSymbol.getText().trim());
                this.mediator.detailedQuote.setTitle("");
            }
        } else if (formName == FormName.Prefernces) {
            TradeCast.getInstance().ShowDynamicForm(FormName.Prefernces, LanguageConstant.Fonts);
            if (this.mediator.prefrences != null) {
                this.mediator.prefrences.selectFontTab(this.languageCentre.getValue(LanguageConstant.Others));
            }
        }
    }

    @Override
    public void update(Graphics g) {
        try {
            this.paint(g);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String getMarketAndSymbol() {
        return this.txtSymbol.getText() + ":" + this.cbMarket.getSelectedItem();
    }

    public void AddSymbol(String Symbol_, String Market) {
        if (this.txtSymbol.getText().compareTo(Symbol_) != 0 || this.cbMarket.getSelectedItem().toString().compareTo(Market) != 0) {
            this.rows.clear();
            this.tableDataChange();
            this.txtSymbol.setText(Symbol_);
            this.cbMarket.setSelectedItem(Market);
            this.SendMBPMessage(Symbol_, Market);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String sym = this.txtSymbol.getText();
        String sa = UtilKSE.GetMarketFromsymbol((String)sym);
        Object source = e.getSource();
        if (sym.length() < 1) {
            this.update(this.dummyFeed);
            this.MBPDetail.setDetailEmpty();
            this.SendMBPMessage("", "");
            this.lblMessage.setFont(this.lblMessage.getFont().deriveFont(0));
            this.lblMessage.setText(this.languageCentre.getValue(LanguageConstant.PleaseEnterScrip));
            return;
        }
        if (source == this.txtSymbol) {
            this.cbMarket.setSelectedItem(sa.toString());
        }
        this.SendMBPMessage(this.txtSymbol.getText().trim(), this.cbMarket.getSelectedItem().toString());
    }

    private void setFontOnComponent(final JComponent com, final Font font) {
        if (SwingUtilities.isEventDispatchThread()) {
            com.setFont(font);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    com.setFont(font);
                }
            });
        }
    }

    public void update(String Msg) {
        double buyVolTot = 0.0;
        double selVolTot = 0.0;
        double buyPriceTot = 0.0;
        double selPriceTot = 0.0;
        try {
            String[] feeds = Msg.split("\\|", -1);
            for (int iteration = 0; iteration < feeds.length; ++iteration) {
                if (feeds[iteration].trim().length() > 0 && feeds[iteration].indexOf(";") >= 0) {
                    String[] feed = feeds[iteration].split("\\;", -1);
                    MBPFeed mbpfeed = new MBPFeed();
                    mbpfeed.feedString = feeds[iteration];
                    mbpfeed.symbol = feed[0];
                    mbpfeed.market = feed[1];
                    mbpfeed.buy = feed[3];
                    mbpfeed.sell = feed[4];
                    mbpfeed.lastPrice = feed[2];
                    MarketFeed mktFeed = this.mediator.MwPanel.GetSingleFeed(this.txtSymbol.getText(), this.cbMarket.getSelectedItem() + "");
                    if (mktFeed == null) {
                        this.txtLTrade.setText(mbpfeed.lastPrice);
                    } else {
                        this.txtLTrade.setText(mktFeed.lTrdPrice);
                    }
                    String[] BuyValues = mbpfeed.buy.split("\\$", -1);
                    String[] SellValues = mbpfeed.sell.split("\\$", -1);
                    String[] BuyVal = new String[]{"", "", ""};
                    String[] SellVal = new String[]{"", "", ""};
                    this.rows.clear();
                    for (int i = 0; i < 10; ++i) {
                        SellVal[2] = "";
                        SellVal[1] = "";
                        SellVal[0] = "";
                        BuyVal[2] = "";
                        BuyVal[1] = "";
                        BuyVal[0] = "";
                        Vector<String> v = new Vector<String>();
                        if (i < BuyValues.length - 1) {
                            BuyVal = BuyValues[i].split("\\,", -1);
                        }
                        if (i < SellValues.length - 1) {
                            SellVal = SellValues[i].split("\\,", -1);
                        }
                        try {
                            NumberFormat nf;
                            v.addElement(BuyVal[0]);
                            try {
                                nf = NumberFormat.getInstance();
                                nf.setGroupingUsed(true);
                                long vol = Integer.parseInt(BuyVal[1]);
                                Long Vol = vol;
                                v.addElement(nf.format(Vol));
                                buyVolTot = (double)vol + buyVolTot;
                            }
                            catch (Exception e) {
                                v.addElement(BuyVal[1]);
                            }
                            v.addElement(BuyVal[2]);
                            v.addElement(SellVal[2]);
                            try {
                                double price = Double.parseDouble(BuyVal[2]);
                                long vol = Integer.parseInt(BuyVal[1]);
                                double res = price * (double)vol;
                                buyPriceTot += res;
                            }
                            catch (Exception price) {
                                // empty catch block
                            }
                            try {
                                double price = Double.parseDouble(SellVal[2]);
                                int vol = Integer.parseInt(SellVal[1]);
                                double res = price * (double)vol;
                                selPriceTot += res;
                            }
                            catch (Exception price) {
                                // empty catch block
                            }
                            try {
                                nf = NumberFormat.getInstance();
                                nf.setGroupingUsed(true);
                                int vol = Integer.parseInt(SellVal[1]);
                                Integer Vol = vol;
                                v.addElement(nf.format(Vol));
                                selVolTot = (double)vol + selVolTot;
                            }
                            catch (Exception e) {
                                v.addElement(SellVal[1]);
                            }
                            v.addElement(SellVal[0]);
                            this.rows.insertElementAt(v, i);
                            continue;
                        }
                        catch (Exception ex) {
                            this.mediator.PrintLog(ex, Msg);
                        }
                    }
                    this.tableDataChange();
                    this.lastTime = MyTime.getInstance().getTime();
                    this.lblLastUpdate.setToolTipText(this.languageCentre.getValue(LanguageConstant.LastUpdateTime) + " " + this.lastTime);
                }
                String cps = this.mediator.logsCommon.getCaps(this.txtSymbol.getText(), this.cbMarket.getSelectedItem() + "");
                double capsLower = 0.0;
                double capsUpper = 0.0;
                if (cps.length() > 0) {
                    try {
                        capsUpper = Double.parseDouble(cps.split(":")[0]);
                        capsLower = Double.parseDouble(cps.split(":")[1]);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                this.MBPDetail.setValues(capsUpper, capsLower, buyVolTot, selVolTot, buyPriceTot, selPriceTot);
            }
        }
        catch (Exception ex) {
            this.mediator.PrintLog(ex, Msg);
        }
        this.lblMessage.setFont(this.lblMessage.getFont().deriveFont(this.lblMessage.getFont().getStyle() | 1));
        String symbol = this.txtSymbol.getText();
        if (symbol.indexOf("-") >= 0) {
            symbol = symbol.split("\\-", -1)[0];
        }
        this.lblMessage.setText(this.mediator.getSymbolTitle(symbol));
    }

    private void tableDataChange() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.table.addNotify();
            this.table.repaint();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MBP1.this.table.addNotify();
                    MBP1.this.table.repaint();
                }
            });
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        Object source = e.getSource();
        if (source == this.txtSymbol) {
            this.txtSymbol.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    private void SendMBPMessage(String Symbol, String Market) {
        if (!this.LastMBPMsg.equalsIgnoreCase(Symbol + ":" + Market)) {
            this.update(this.dummyFeed);
            this.MBPDetail.setDetailEmpty();
            if (Symbol.length() > 0 && LogCommon.SymbolAndSymbolName.size() > 0 && !LogCommon.SymbolAndSymbolName.containsKey(Symbol.trim())) {
                this.lblMessage.setText(this.languageCentre.getValue(LanguageConstant.InvalidScrip));
            } else {
                this.lblMessage.setText("");
            }
            this.LastMBPMsg = Symbol + ":" + Market;
            this.mediator.SendMsgToFeedServer("MBP-FEED|" + this.LastMBPMsg, "MBP : SendMBOMessage");
        }
    }

    public Font GetMBPFont() {
        return this.table.getFont();
    }

    public void Refresh() {
        FontMetrics metrics = this.getFontMetrics(LogCommon.MarketDepthFont);
        int fontHeight = metrics.getHeight();
        if (fontHeight <= 18) {
            this.table.setRowHeight(18);
        } else {
            this.table.setRowHeight(fontHeight);
        }
        if (this.MBPDetail != null) {
            this.MBPDetail.Refresh();
        }
        this.tableDataChange();
    }

    private void initComponents() {
        this.lblSymbol = new JLabel();
        this.lblMarket = new JLabel();
        this.lblLastUpdate = new JLabel();
        this.txtLTrade = new JTextField();
        this.txtSymbol = new JTextField();
        this.cbMarket = new JComboBox();
        this.lblLTrade = new JLabel();
        this.lblDetail = new JLabel();
        this.lblMessage = new JLabel();
        this.scrollPane = new JScrollPane();
        this.table = new JTable(this.rows, this.columns);
        this.collapsiblePane = new JXCollapsiblePane();
        this.lblSymbol.setText("Scrip");
        this.lblMarket.setText("Market");
        this.lblLastUpdate.setHorizontalAlignment(4);
        this.lblLastUpdate.setIcon(new ImageIcon(this.getClass().getResource("/Images/lastUpdateTime16.png")));
        this.lblLastUpdate.setText("PKT 88:88:88");
        this.lblLastUpdate.setToolTipText("Yet not updated");
        this.lblLastUpdate.setHorizontalTextPosition(2);
        this.txtLTrade.setHorizontalAlignment(4);
        this.txtLTrade.setEnabled(false);
        this.cbMarket.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.lblLTrade.setText("L.Trade");
        this.lblDetail.setIcon(new ImageIcon(this.getClass().getResource("/Images/downarrowgray.png")));
        this.lblDetail.setText("Details");
        this.lblDetail.setMaximumSize(new Dimension(49, 14));
        this.lblDetail.setMinimumSize(new Dimension(49, 14));
        this.lblDetail.setPreferredSize(new Dimension(49, 14));
        this.lblDetail.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                MBP1.this.lblDetailMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                MBP1.this.lblDetailMouseExited(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                MBP1.this.lblDetailMousePressed(evt);
            }
        });
        this.lblMessage.setText("A");
        this.lblMessage.setMaximumSize(new Dimension(7, 16));
        this.lblMessage.setMinimumSize(new Dimension(7, 16));
        this.lblMessage.setPreferredSize(new Dimension(7, 16));
        this.scrollPane.setViewportView(this.table);
        this.collapsiblePane.setCollapsed(true);
        VerticalLayout verticalLayout1 = new VerticalLayout();
        verticalLayout1.setGap(2);
        this.collapsiblePane.getContentPane().setLayout((LayoutManager)verticalLayout1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.scrollPane, GroupLayout.Alignment.LEADING, -1, 312, Short.MAX_VALUE).addComponent((Component)this.collapsiblePane, GroupLayout.Alignment.LEADING, -1, 312, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.lblMarket).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbMarket, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblSymbol).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtSymbol, -2, 43, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblLTrade).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtLTrade, -2, 41, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.lblDetail, -2, 55, -2)).addGroup(layout.createSequentialGroup().addComponent(this.lblMessage, -1, 209, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblLastUpdate, -2, 93, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblMarket).addComponent(this.lblSymbol).addComponent(this.txtSymbol, -2, -1, -2).addComponent(this.txtLTrade, -2, -1, -2).addComponent(this.cbMarket, -2, -1, -2).addComponent(this.lblDetail, -2, 19, -2).addComponent(this.lblLTrade)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scrollPane, -1, 165, Short.MAX_VALUE).addGap(0, 0, 0).addComponent((Component)this.collapsiblePane, -2, -1, -2).addGap(2, 2, 2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblMessage, -2, -1, -2).addComponent(this.lblLastUpdate))));
        layout.linkSize(1, this.lblDetail, this.txtLTrade);
    }

    private void lblDetailMousePressed(MouseEvent evt) {
        this.setCollaspe();
    }

    private void lblDetailMouseEntered(MouseEvent evt) {
        this.lblDetail.setText("<html><U>" + this.languageCentre.getValue(LanguageConstant.Details) + "</U></html>");
    }

    private void lblDetailMouseExited(MouseEvent evt) {
        this.lblDetail.setText("<html>" + this.languageCentre.getValue(LanguageConstant.Details) + "</html>");
    }

    private void setCollaspe() {
        boolean state = this.collapsiblePane.isCollapsed();
        this.collapsiblePane.setCollapsed(!state);
        if (state) {
            this.lblDetail.setIcon(new ImageIcon(this.getClass().getResource("/Images/uparrowgray.png")));
        } else {
            this.lblDetail.setIcon(new ImageIcon(this.getClass().getResource("/Images/downarrowgray.png")));
        }
    }

    private String getMarket() {
        if (this.cbMarket.getSelectedItem() == null) {
            return LogsKSE.SelectedMarket;
        }
        if (this.cbMarket.getSelectedItem().toString().trim().equalsIgnoreCase("")) {
            return LogsKSE.SelectedMarket;
        }
        return this.cbMarket.getSelectedItem().toString().trim();
    }

    private void setLanguageValues() {
        this.lblMarket.setText(this.languageCentre.getValue(LanguageConstant.Market));
        this.lblSymbol.setText(this.languageCentre.getValue(LanguageConstant.Scrip));
        this.lblLTrade.setText(this.languageCentre.getValue(LanguageConstant.LastTradePrice));
    }
}

