/*
 * Decompiled with CFR 0.152.
 */
package windows;

import CustomComponent.ImageProgressBar;
import CustomComponent.MyTime;
import MyDocking.TradeCast;
import common.gui.util.AppConfig;
import common.gui.util.FormName;
import common.gui.util.ImageUtil;
import common.gui.util.Util;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import kse.util.LogsKSE;
import languages.LanguageCentre;
import languages.LanguageConstant;
import windows.ChangePasswordPrompt;

public class MySplashScreen
extends JWindow
implements Runnable,
PropertyChangeListener {
    public static MySplashScreen instance;
    int num = 0;
    public int StartNum = 5;
    private Task task;
    private BufferedImage splash = null;
    JLabel lblBGImage = new JLabel();
    JLabel lblImage = new JLabel();
    private LanguageCentre languageCentre = new LanguageCentre();
    public ImageProgressBar progressBar;
    TradeCast TC1 = null;
    boolean Continue = true;
    int ProgressInterval = 50;

    public static MySplashScreen getInstance() {
        if (instance == null) {
            instance = new MySplashScreen();
        }
        return instance;
    }

    private MySplashScreen() {
        UIManager.put("ProgressBar.selectionBackground", new ColorUIResource(Color.black));
        UIManager.put("ProgressBar.selectionForeground", new ColorUIResource(Color.WHITE));
    }

    public void ShowSplashScreen() {
        this.setAlwaysOnTop(false);
        this.lblBGImage = new JLabel(new ImageIcon(this.getClass().getResource("/Images/ForgetSplash.jpg")));
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append("<div>");
        String year = MyTime.getInstance().getYear();
        sb.append("<span style='font-family: Calibiri Regular; font-size:7px; color: #2d2d2d; '>");
        sb.append(this.languageCentre.getValue(LanguageConstant.Copyright)).append(" 2010 - ").append(year).append(" CATALYST IT Solutions (Pvt.) Limited.<span style=\"font-style:italic\">").append(this.languageCentre.getValue(LanguageConstant.AllRightsReserved)).append(".</span>");
        sb.append("</span>");
        sb.append("</div>");
        sb.append("</html>");
        JLabel lblText = new JLabel(sb.toString());
        lblText.setHorizontalAlignment(4);
        this.lblImage.setIcon(null);
        this.lblImage.setVisible(AppConfig.isShowLogo);
        new Thread(new Runnable(){

            @Override
            public void run() {
                MySplashScreen.this.setBGImage();
                MySplashScreen.this.setHouseLogo();
                MySplashScreen.this.repaint();
            }
        }).start();
        this.progressBar = new ImageProgressBar(0, 0, 100);
        this.getContentPane().setLayout(null);
        this.progressBar.setOrientation(0);
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        this.getContentPane().add(this.progressBar);
        this.progressBar.setBounds(25, 180, 450, 20);
        Util.setWindowOpaque((Window)this, (boolean)false);
        BufferedImage image = null;
        try {
            image = ImageIO.read(this.getClass().getResource("/Images/Loading.png"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (image != null) {
            if (AppConfig.loadingSplash != null) {
                this.progressBar.setImage(AppConfig.loadingSplash);
            } else {
                this.progressBar.setImage(image);
            }
        }
        this.progressBar.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.getContentPane().add(this.lblImage);
        this.getContentPane().add(lblText);
        lblText.setBounds(100, 240, 395, 30);
        this.lblImage.setBounds(330, 14, 145, 66);
        this.getContentPane().add(this.lblBGImage);
        this.lblBGImage.setBounds(0, 0, 500, 266);
        this.setVisible(true);
        this.task = new Task();
        this.task.addPropertyChangeListener(this);
        this.task.execute();
        this.pack();
        this.setVisible(true);
        int width = 500;
        int height = 266;
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screen.width - width) / 2;
        int y = (screen.height - height) / 2;
        this.setBounds(x, y, width, height);
        new Thread((Runnable)this, "MySplashScreen1").run();
    }

    private void setBGImage() {
        block4: {
            this.lblBGImage.setIcon(null);
            Image img = null;
            try {
                img = ImageUtil.downloadImage((String)(AppConfig.TradeCastURL + "/HouseImages/SmallHouseBGImage.png"));
                if (img == null) {
                    ImageIcon imw = new ImageIcon(this.getClass().getResource("/Images/ForgetSplash.jpg"));
                    img = imw.getImage();
                    this.lblBGImage.setIcon(new ImageIcon(img));
                } else {
                    this.lblBGImage.setIcon(new ImageIcon(img));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (img != null) break block4;
                ImageIcon imw = new ImageIcon(this.getClass().getResource("/Images/ForgetSplash.jpg"));
                img = imw.getImage();
                this.lblBGImage.setIcon(new ImageIcon(img));
            }
        }
    }

    private void setHouseLogo() {
        try {
            if (AppConfig.smallHosueLogo == null) {
                AppConfig.smallHosueLogo = ImageUtil.downloadImage((String)(AppConfig.TradeCastURL + "/HouseImages/SmallHouseLogo.png"));
            }
            if (AppConfig.smallHosueLogo != null) {
                this.lblImage.setIcon(new ImageIcon(AppConfig.smallHosueLogo));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.splash != null) {
            g.drawImage(this.splash, 0, 0, null);
        }
        super.paint(g);
    }

    private void createShadowPicture(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        int extra = 14;
        this.setSize(new Dimension(width + extra, height + extra));
        this.setLocationRelativeTo(null);
        Rectangle windowRect = this.getBounds();
        this.splash = new BufferedImage(width + extra, height + extra, 2);
        Graphics2D g2 = (Graphics2D)this.splash.getGraphics();
        try {
            Robot robot = new Robot(this.getGraphicsConfiguration().getDevice());
            BufferedImage capture = robot.createScreenCapture(new Rectangle(windowRect.x, windowRect.y, windowRect.width + extra, windowRect.height + extra));
            g2.drawImage(capture, null, 0, 0);
        }
        catch (Exception robot) {
            // empty catch block
        }
        BufferedImage shadow = new BufferedImage(width + extra, height + extra, 2);
        Graphics g = shadow.getGraphics();
        g.setColor(new Color(0.0f, 0.0f, 0.0f, 0.3f));
        g.fillRoundRect(6, 6, width, height, 12, 12);
        g2.drawImage(shadow, this.getBlurOp(7), 0, 0);
        g2.drawImage((Image)image, 0, 0, this);
    }

    private ConvolveOp getBlurOp(int size) {
        float[] data = new float[size * size];
        float value = 1.0f / (float)(size * size);
        for (int i = 0; i < data.length; ++i) {
            data[i] = value;
        }
        return new ConvolveOp(new Kernel(size, size, data));
    }

    public int GetRandomNumber(int Lower, int Upper) {
        Random generator = new Random();
        return generator.nextInt(Upper) + Lower;
    }

    public void DisposeMe() {
        this.dispose();
    }

    private void initComponents() {
        this.pack();
    }

    public static void main(String[] arguments) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        MySplashScreen frame = MySplashScreen.getInstance();
        frame.ShowSplashScreen();
        frame.pack();
        frame.setVisible(true);
        int width = 525;
        int height = 263;
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screen.width - width) / 2;
        int y = (screen.height - height) / 2;
        frame.setBounds(x, y, width, height);
        new Thread((Runnable)frame, "MySplashScreen2").start();
    }

    @Override
    public void run() {
        TradeCast TC;
        this.setName("TradeCast()");
        this.TC1 = TC = new TradeCast();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("progress" == evt.getPropertyName()) {
            int progress = (Integer)evt.getNewValue();
            this.progressBar.setValue(progress);
        }
    }

    class Task
    extends SwingWorker<Void, Void> {
        Task() {
        }

        @Override
        public Void doInBackground() {
            Random random = new Random();
            int progress = 0;
            this.setProgress(0);
            int FirstCheck = MySplashScreen.this.GetRandomNumber(20, 30);
            int SecondCheck = MySplashScreen.this.GetRandomNumber(55, 15);
            int ThirdCheck = MySplashScreen.this.GetRandomNumber(75, 10);
            int FourthCheck = MySplashScreen.this.GetRandomNumber(94, 4);
            while (progress < 100) {
                if (progress == FirstCheck) {
                    MySplashScreen.this.ProgressInterval = 25;
                    while (MySplashScreen.this.TC1 == null) {
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                if (MySplashScreen.this.TC1 != null && progress == SecondCheck) {
                    ++progress;
                    MySplashScreen.this.Continue = false;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MySplashScreen.this.setName("TC1.Initialize1");
                            MySplashScreen.this.TC1.Initialize1();
                            MySplashScreen.this.Continue = true;
                        }
                    });
                }
                if (MySplashScreen.this.TC1 != null && progress == ThirdCheck) {
                    ++progress;
                    MySplashScreen.this.Continue = false;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MySplashScreen.this.setName("TC1.Initialize2");
                            MySplashScreen.this.TC1.Initialize2();
                            MySplashScreen.this.Continue = true;
                        }
                    });
                }
                if (MySplashScreen.this.TC1 != null && progress == FourthCheck) {
                    ++progress;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MySplashScreen.this.setName("TC1.Initialize3");
                            MySplashScreen.this.TC1.Initialize3();
                            MySplashScreen.this.Continue = true;
                        }
                    });
                }
                try {
                    Thread.sleep(MySplashScreen.this.ProgressInterval);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (MySplashScreen.this.Continue) {
                    ++progress;
                }
                this.setProgress(Math.min(progress, 100));
            }
            return null;
        }

        @Override
        public void done() {
            Toolkit.getDefaultToolkit().beep();
            MySplashScreen.this.setCursor(null);
            MySplashScreen.this.DisposeMe();
            if (!LogsKSE.ChangePasswordForcefully && !LogsKSE.ChangePinCodeForcefully) {
                MySplashScreen.this.TC1.frame.setVisible(true);
                MySplashScreen.this.TC1.toFront(true);
                MySplashScreen.this.TC1.SetLastDockLayOut();
            } else {
                MySplashScreen.this.TC1.toolBar.setVisible(false);
                MySplashScreen.this.TC1.statusbar.setVisible(false);
                if (MySplashScreen.this.TC1.ExStats != null) {
                    MySplashScreen.this.TC1.ExStats.setVisible(false);
                }
                if (MySplashScreen.this.TC1.ViewMarketWatch != null) {
                    MySplashScreen.this.TC1.ViewMarketWatch.close();
                }
                if (MySplashScreen.this.TC1.ViewMessageWindow != null) {
                    MySplashScreen.this.TC1.ViewMessageWindow.close();
                }
                if (MySplashScreen.this.TC1.ViewTradeLog != null) {
                    MySplashScreen.this.TC1.ViewTradeLog.close();
                }
                if (MySplashScreen.this.TC1.ViewOutStanding != null) {
                    MySplashScreen.this.TC1.ViewOutStanding.close();
                }
                if (MySplashScreen.this.TC1.ViewActivityLog != null) {
                    MySplashScreen.this.TC1.ViewActivityLog.close();
                }
                if (MySplashScreen.this.TC1.ViewMBO != null) {
                    MySplashScreen.this.TC1.ViewMBO.close();
                }
                if (MySplashScreen.this.TC1.ViewMBP != null) {
                    MySplashScreen.this.TC1.ViewMBP.close();
                }
                if (MySplashScreen.this.TC1.ViewHistoricalData != null) {
                    MySplashScreen.this.TC1.ViewHistoricalData.close();
                }
                if (MySplashScreen.this.TC1.View_PMEX_WorkingOrder != null) {
                    MySplashScreen.this.TC1.View_PMEX_WorkingOrder.close();
                }
                if (MySplashScreen.this.TC1.View_PMEX_Ladder_Dock != null) {
                    MySplashScreen.this.TC1.View_PMEX_Ladder_Dock.close();
                }
                if (MySplashScreen.this.TC1.View_PMEX_MarketWatch != null) {
                    MySplashScreen.this.TC1.View_PMEX_MarketWatch.close();
                }
                if (MySplashScreen.this.TC1.View_PMEX_Matrix != null) {
                    MySplashScreen.this.TC1.View_PMEX_Matrix.close();
                }
                if (MySplashScreen.this.TC1.View_PMEX_OrderActivity != null) {
                    MySplashScreen.this.TC1.View_PMEX_OrderActivity.close();
                }
                if (MySplashScreen.this.TC1.View_PMEX_TradedOrder != null) {
                    MySplashScreen.this.TC1.View_PMEX_TradedOrder.close();
                }
                if (MySplashScreen.this.TC1.pmex_BuyingPower_Dock != null) {
                    MySplashScreen.this.TC1.pmex_BuyingPower_Dock.setVisible(false);
                }
                for (int i = 0; i < MySplashScreen.this.TC1.menu.getMenuCount(); ++i) {
                    if (MySplashScreen.this.TC1.menu.getMenu(i) == null) continue;
                    MySplashScreen.this.TC1.menu.getMenu(i).setEnabled(false);
                }
                MySplashScreen.this.TC1.toFront(true);
                if (LogsKSE.ChangePasswordForcefully) {
                    if (LogsKSE.Identifier.equalsIgnoreCase("11") || LogsKSE.Identifier.equalsIgnoreCase("12")) {
                        new ChangePasswordPrompt(MySplashScreen.this.TC1.frame, true);
                    } else {
                        JOptionPane.showMessageDialog(MySplashScreen.this.TC1.frame, LogsKSE.ChangePasswordMessage, "Trade Cast " + AppConfig.version, 1);
                    }
                    MySplashScreen.this.TC1.ShowDynamicForm(FormName.Prefernces, LanguageConstant.ChangePassword);
                } else if (LogsKSE.ChangePinCodeForcefully) {
                    JOptionPane.showMessageDialog(MySplashScreen.this.TC1.frame, LogsKSE.ChangePinCodeMessage, "Trade Cast " + AppConfig.version, 1);
                    MySplashScreen.this.TC1.ShowDynamicForm(FormName.Prefernces, LanguageConstant.ChangePIN);
                }
            }
        }
    }
}

