/*
 * Decompiled with CFR 0.152.
 */
package windows;

import MyDocking.Mediator;
import RendersNModels.ApprovedScripCellRenderer;
import RendersNModels.ScripSearchCellRenderer;
import Utilities.LoadLogs;
import Utilities.LogsTC;
import Utilities.MyDradAndDrop;
import Utilities.ThreadWithName;
import common.gui.util.AppConfig;
import common.gui.util.FormName;
import common.gui.util.LogCommon;
import common.gui.util.Util;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ToolTipManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import kse.util.UtilKSE;
import languages.LanguageCentre;
import languages.LanguageConstant;

public class ScripBrowse
extends JPanel {
    private Mediator mediator = Mediator.getInstance();
    private LanguageCentre languageCentre = new LanguageCentre();
    DefaultTableModel scripBrowseModel = new DefaultTableModel(new Object[0][], new String[]{this.languageCentre.getValue(LanguageConstant.Market), this.languageCentre.getValue(LanguageConstant.Scrip), this.languageCentre.getValue(LanguageConstant.CompanyName)}){

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    };
    DefaultTableModel symbolByCompanyDetailmodel = new DefaultTableModel(new Object[0][], new String[]{this.languageCentre.getValue(LanguageConstant.CompanyName), this.languageCentre.getValue(LanguageConstant.Scrip)}){

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    };
    DefaultTableModel approvedScripBrowseModel = new DefaultTableModel(new Object[0][], new String[]{this.languageCentre.getValue(LanguageConstant.Market), this.languageCentre.getValue(LanguageConstant.Scrip), this.languageCentre.getValue(LanguageConstant.Status)}){

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    };
    DefaultTableModel allScripBrowseModel = new DefaultTableModel(new Object[0][], new String[]{this.languageCentre.getValue(LanguageConstant.Scrip), this.languageCentre.getValue(LanguageConstant.CompanyName)}){

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    };
    ImageIcon loaderIcon = new ImageIcon(this.getClass().getResource(AppConfig.loaderIconPath));
    private int prevRow;
    private int prevCol;
    ScripSearchCellRenderer renderScripBrowse = new ScripSearchCellRenderer();
    ApprovedScripCellRenderer renderApporved = new ApprovedScripCellRenderer();
    ScripSearchCellRenderer renderAllScrip = new ScripSearchCellRenderer();
    private ButtonGroup buttonGroup1;
    private JLabel jLabel3;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JLabel lblMsgAllSymbol;
    private JLabel lblMsgApprovedSymbol;
    private JLabel lblMsgBySymbol;
    private JLabel lblName;
    private JPanel panelAllSymbol;
    private JPanel panelApprovedSymbol;
    private JPanel panelBySymbol;
    public static JRadioButton rbCompany;
    public static JRadioButton rbMarket;
    public static JRadioButton rbScrip;
    private JTabbedPane tbdPane;
    private JTable tblAllScrip;
    private JTable tblApprovedScrip;
    private JTable tblScripBrowse;
    public static JTextField txtApprovedSymbol;
    public static JTextField txtSymbolDetail;

    public ScripBrowse() {
        this.initComponents();
        this.mediator.setSymbolDetails(this);
        this.tblScripBrowse.setModel(this.scripBrowseModel);
        this.tblScripBrowse.setDefaultRenderer(Object.class, this.renderScripBrowse);
        this.tblApprovedScrip.setModel(this.approvedScripBrowseModel);
        this.tblApprovedScrip.setDefaultRenderer(Object.class, this.renderApporved);
        this.tblAllScrip.setModel(this.allScripBrowseModel);
        this.tblAllScrip.setDefaultRenderer(Object.class, this.renderAllScrip);
        this.tblAllScrip.setRowHeight(AppConfig.rowHeight);
        this.tblAllScrip.setRowHeight(AppConfig.rowHeight);
        this.tblApprovedScrip.setRowHeight(AppConfig.rowHeight);
        this.tblScripBrowse.setRowHeight(AppConfig.rowHeight);
        this.tblAllScrip.getColumnModel().getColumn(1).setPreferredWidth(220);
        this.tblScripBrowse.getColumnModel().getColumn(2).setPreferredWidth(220);
        this.tblApprovedScrip.getColumnModel().getColumn(2).setPreferredWidth(220);
        this.tblAllScrip.getTableHeader().setReorderingAllowed(false);
        this.tblScripBrowse.getTableHeader().setReorderingAllowed(false);
        this.tblApprovedScrip.getTableHeader().setReorderingAllowed(false);
        this.tblScripBrowse.setSelectionMode(0);
        this.tblAllScrip.setSelectionMode(0);
        this.tblApprovedScrip.setSelectionMode(0);
        this.tbdPane.remove(2);
        this.getApprovedSymbol();
        JTableHeader header = this.tblScripBrowse.getTableHeader();
        ((JLabel)((Object)header.getDefaultRenderer())).setHorizontalAlignment(0);
        header = this.tblScripBrowse.getTableHeader();
        ((JLabel)((Object)header.getDefaultRenderer())).setHorizontalAlignment(0);
        header = this.tblApprovedScrip.getTableHeader();
        ((JLabel)((Object)header.getDefaultRenderer())).setHorizontalAlignment(0);
        this.lblName.setPreferredSize(new Dimension(73, 19));
        this.lblName.setMaximumSize(new Dimension(73, 19));
        this.lblName.setMinimumSize(new Dimension(73, 19));
        MyDradAndDrop myDradAndDrop = new MyDradAndDrop(this.tblScripBrowse, 1, FormName.MarketWatch);
        MyDradAndDrop myDradAndDrop1 = new MyDradAndDrop(this.tblAllScrip, 1, FormName.MarketWatch);
        MyDradAndDrop myDradAndDrop2 = new MyDradAndDrop(this.tblApprovedScrip, 1, FormName.MarketWatch);
        this.setLanguageValues();
    }

    public void fillSymbolDetail(String result) {
        this.lblMsgBySymbol.setText(this.languageCentre.getValue(LanguageConstant.Loading));
        this.lblMsgBySymbol.setIcon(this.loaderIcon);
        this.scripBrowseModel = (DefaultTableModel)this.tblScripBrowse.getModel();
        this.removeSymbolDetailTable();
        String[] str = result.split("\\|", -1);
        for (int col = 0; col < str.length - 1; ++col) {
            if (str[col].indexOf(";") < 0) continue;
            String[] temp = str[col].split(";");
            this.scripBrowseModel.addRow(new String[]{UtilKSE.GetMarketFromsymbol((String)temp[0]), temp[0], temp[1]});
        }
        this.tblScripBrowse.setModel(this.scripBrowseModel);
        this.lblMsgBySymbol.setText(Util.format0digit((String)(this.tblScripBrowse.getRowCount() + "".trim().replaceAll("\\,", ""))) + " " + this.languageCentre.getValue(LanguageConstant.RecordsFound));
        this.lblMsgBySymbol.setIcon(null);
        this.repaint();
    }

    public void fillApprovedSymbolData(String data) {
        String[] str = data.split("\\|", -1);
        for (int col = 0; col < str.length - 1; ++col) {
            String[] str2;
            if (str[col].indexOf(";") < 0 || LogsTC.ApprovedScrip.containsKey((str2 = str[col].split(";"))[0])) continue;
            LogsTC.ApprovedScrip.put(str2[0], str2[1]);
        }
        this.fillApprovedSymbolDetail();
    }

    public void getFocus() {
        txtSymbolDetail.requestFocus();
    }

    public void searchApprovedSymbol(String sr) {
        sr = sr.toUpperCase();
        this.lblMsgApprovedSymbol.setText(this.languageCentre.getValue(LanguageConstant.Loading));
        this.approvedScripBrowseModel = (DefaultTableModel)this.tblApprovedScrip.getModel();
        this.removeApprovedSymbolTable();
        Vector v = new Vector(LogsTC.ApprovedScrip.keySet());
        Collections.sort(v);
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            String key = e.nextElement().toString();
            if (key.toUpperCase().indexOf(sr) < 0) continue;
            Vector<String> row = new Vector<String>();
            row.add(UtilKSE.GetMarketFromsymbol((String)key));
            row.add(key);
            row.add(LogsTC.ApprovedScrip.get(key).toString());
            this.approvedScripBrowseModel.addRow(row);
        }
        this.tblApprovedScrip.setModel(this.approvedScripBrowseModel);
        this.lblMsgApprovedSymbol.setText(Util.format0digit((String)(this.tblApprovedScrip.getRowCount() + "".trim().replaceAll("\\,", ""))) + " " + this.languageCentre.getValue(LanguageConstant.RecordsFound));
        this.repaint();
    }

    public void fillApprovedSymbolDetail() {
        this.approvedScripBrowseModel = (DefaultTableModel)this.tblApprovedScrip.getModel();
        this.removeApprovedSymbolTable();
        Vector v = new Vector(LogsTC.ApprovedScrip.keySet());
        Collections.sort(v);
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            String key = e.nextElement().toString();
            Vector<String> row = new Vector<String>();
            row.add(UtilKSE.GetMarketFromsymbol((String)key));
            row.add(key);
            row.add(LogsTC.ApprovedScrip.get(key).toString());
            this.approvedScripBrowseModel.addRow(row);
        }
        this.tblApprovedScrip.setModel(this.approvedScripBrowseModel);
        this.lblMsgApprovedSymbol.setText(Util.format0digit((String)(this.tblApprovedScrip.getRowCount() + "".trim().replaceAll("\\,", ""))) + " " + this.languageCentre.getValue(LanguageConstant.RecordsFound));
        this.repaint();
    }

    public void fillAllScripBrowse() {
        this.allScripBrowseModel = (DefaultTableModel)this.tblAllScrip.getModel();
        this.removeAllSymbolTable();
        Vector v = new Vector(LogCommon.SymbolAndSymbolName.keySet());
        Collections.sort(v);
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            String key = e.nextElement().toString();
            Vector<String> row = new Vector<String>();
            row.add(key);
            row.add(((String)LogCommon.SymbolAndSymbolName.get(key)).toString());
            this.allScripBrowseModel.addRow(row);
        }
        this.tblAllScrip.setModel(this.allScripBrowseModel);
        this.lblMsgAllSymbol.setText(Util.format0digit((String)(this.tblAllScrip.getRowCount() + "".trim().replaceAll("\\,", ""))) + " " + this.languageCentre.getValue(LanguageConstant.RecordsFound));
        this.repaint();
    }

    private void removeSymbolDetailTable() {
        DefaultTableModel model = (DefaultTableModel)this.tblScripBrowse.getModel();
        int numrows = model.getRowCount();
        for (int i = 0; i < numrows; ++i) {
            model.removeRow(0);
        }
    }

    public void callSearch() {
        if (rbMarket.isSelected()) {
            if (txtSymbolDetail.getText().trim().length() <= 0) {
                this.getSymbolDetailByName();
            } else if (txtSymbolDetail.getText().trim().length() > 0) {
                this.getSymbolDetailByMarket(txtSymbolDetail.getText());
            }
        } else if (rbScrip.isSelected()) {
            if (txtSymbolDetail.getText().trim().length() <= 0) {
                this.getSymbolDetailByName();
            } else if (txtSymbolDetail.getText().trim().length() > 0) {
                this.getSymbolDetailByName(txtSymbolDetail.getText());
            }
        } else if (rbCompany.isSelected()) {
            if (txtSymbolDetail.getText().trim().length() <= 0) {
                this.getSymbolDetailByName();
            } else if (txtSymbolDetail.getText().trim().length() > 0) {
                this.getSymbolDetailByCompany(txtSymbolDetail.getText());
            }
        }
    }

    private void removeApprovedSymbolTable() {
        DefaultTableModel model = (DefaultTableModel)this.tblApprovedScrip.getModel();
        int numrows = model.getRowCount();
        for (int i = 0; i < numrows; ++i) {
            model.removeRow(0);
        }
    }

    private void removeAllSymbolTable() {
        DefaultTableModel model = (DefaultTableModel)this.tblAllScrip.getModel();
        int numrows = model.getRowCount();
        for (int i = 0; i < numrows; ++i) {
            model.removeRow(0);
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.tbdPane = new JTabbedPane();
        this.panelBySymbol = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tblScripBrowse = new JTable();
        txtSymbolDetail = new JTextField();
        this.lblName = new JLabel();
        this.lblMsgBySymbol = new JLabel();
        rbScrip = new JRadioButton();
        rbCompany = new JRadioButton();
        this.jSeparator1 = new JSeparator();
        rbMarket = new JRadioButton();
        this.panelApprovedSymbol = new JPanel();
        this.jScrollPane4 = new JScrollPane();
        this.tblApprovedScrip = new JTable();
        txtApprovedSymbol = new JTextField();
        this.jLabel3 = new JLabel();
        this.lblMsgApprovedSymbol = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.panelAllSymbol = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.tblAllScrip = new JTable();
        this.lblMsgAllSymbol = new JLabel();
        this.tbdPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ScripBrowse.this.tbdPaneStateChanged(evt);
            }
        });
        this.tblScripBrowse.setAutoCreateRowSorter(true);
        this.tblScripBrowse.setModel(new DefaultTableModel(new Object[0][], new String[]{"Scrip", "Detail"}));
        this.tblScripBrowse.setToolTipText("Drag and Drop Scrip to add in My Watches");
        this.tblScripBrowse.setSelectionForeground(new Color(0, 0, 0));
        this.tblScripBrowse.getTableHeader().setReorderingAllowed(false);
        this.tblScripBrowse.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                ScripBrowse.this.tblScripBrowseMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                ScripBrowse.this.tblScripBrowseMouseExited(evt);
            }
        });
        this.tblScripBrowse.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                ScripBrowse.this.tblScripBrowseMouseMoved(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.tblScripBrowse);
        txtSymbolDetail.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScripBrowse.this.txtSymbolDetailActionPerformed(evt);
            }
        });
        txtSymbolDetail.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                ScripBrowse.this.txtSymbolDetailFocusGained(evt);
            }
        });
        txtSymbolDetail.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ScripBrowse.this.txtSymbolDetailKeyReleased(evt);
            }
        });
        this.lblName.setFont(this.lblName.getFont().deriveFont(this.lblName.getFont().getStyle() | 1));
        this.lblName.setIcon(new ImageIcon(this.getClass().getResource("/Images/search16.png")));
        this.lblName.setText("Company");
        this.lblName.setHorizontalTextPosition(2);
        this.lblMsgBySymbol.setText(" ");
        this.lblMsgBySymbol.setVerticalAlignment(1);
        this.buttonGroup1.add(rbScrip);
        rbScrip.setSelected(true);
        rbScrip.setText("Scrip");
        rbScrip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScripBrowse.this.rbScripActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(rbCompany);
        rbCompany.setText("Company");
        rbCompany.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScripBrowse.this.rbCompanyActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(rbMarket);
        rbMarket.setText("Market");
        rbMarket.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScripBrowse.this.rbMarketActionPerformed(evt);
            }
        });
        GroupLayout panelBySymbolLayout = new GroupLayout(this.panelBySymbol);
        this.panelBySymbol.setLayout(panelBySymbolLayout);
        panelBySymbolLayout.setHorizontalGroup(panelBySymbolLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1, -1, 422, Short.MAX_VALUE).addGroup(panelBySymbolLayout.createSequentialGroup().addContainerGap().addGroup(panelBySymbolLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblMsgBySymbol, -2, 346, -2).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 402, Short.MAX_VALUE).addGroup(panelBySymbolLayout.createSequentialGroup().addComponent(this.lblName).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(txtSymbolDetail, -2, 105, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(rbMarket).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(rbScrip).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(rbCompany))).addContainerGap()));
        panelBySymbolLayout.setVerticalGroup(panelBySymbolLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelBySymbolLayout.createSequentialGroup().addContainerGap().addGroup(panelBySymbolLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblName, -2, 19, -2).addComponent(txtSymbolDetail, -2, -1, -2).addComponent(rbMarket).addComponent(rbScrip).addComponent(rbCompany)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 52, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, -1, -2).addGap(3, 3, 3).addComponent(this.lblMsgBySymbol, -2, 14, -2)));
        this.tbdPane.addTab("Scrip Search", this.panelBySymbol);
        this.tblApprovedScrip.setAutoCreateRowSorter(true);
        this.tblApprovedScrip.setModel(new DefaultTableModel(new Object[0][], new String[]{"Scrip", "Status"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false};
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.tblApprovedScrip.setToolTipText("Drag and Drop Scrip to add in My Watches");
        this.tblApprovedScrip.setSelectionForeground(new Color(0, 0, 0));
        this.tblApprovedScrip.getTableHeader().setReorderingAllowed(false);
        this.tblApprovedScrip.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                ScripBrowse.this.tblApprovedScripMouseExited(evt);
            }
        });
        this.tblApprovedScrip.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                ScripBrowse.this.tblApprovedScripMouseMoved(evt);
            }
        });
        this.jScrollPane4.setViewportView(this.tblApprovedScrip);
        txtApprovedSymbol.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScripBrowse.this.txtApprovedSymbolActionPerformed(evt);
            }
        });
        txtApprovedSymbol.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                ScripBrowse.this.txtApprovedSymbolFocusGained(evt);
            }
        });
        txtApprovedSymbol.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ScripBrowse.this.txtApprovedSymbolKeyReleased(evt);
            }
        });
        this.jLabel3.setFont(this.jLabel3.getFont().deriveFont(this.jLabel3.getFont().getStyle() | 1));
        this.jLabel3.setIcon(new ImageIcon(this.getClass().getResource("/Images/search16.png")));
        this.jLabel3.setText("Scrip");
        this.jLabel3.setHorizontalTextPosition(2);
        this.jLabel3.setMaximumSize(new Dimension(73, 19));
        this.jLabel3.setMinimumSize(new Dimension(73, 19));
        this.jLabel3.setPreferredSize(new Dimension(73, 19));
        this.lblMsgApprovedSymbol.setText(" ");
        this.lblMsgApprovedSymbol.setVerticalAlignment(1);
        GroupLayout panelApprovedSymbolLayout = new GroupLayout(this.panelApprovedSymbol);
        this.panelApprovedSymbol.setLayout(panelApprovedSymbolLayout);
        panelApprovedSymbolLayout.setHorizontalGroup(panelApprovedSymbolLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator2, -1, 422, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, panelApprovedSymbolLayout.createSequentialGroup().addContainerGap().addGroup(panelApprovedSymbolLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane4, GroupLayout.Alignment.LEADING, -1, 402, Short.MAX_VALUE).addComponent(this.lblMsgApprovedSymbol, GroupLayout.Alignment.LEADING, -1, 402, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, panelApprovedSymbolLayout.createSequentialGroup().addComponent(this.jLabel3, -2, 73, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(txtApprovedSymbol, -2, 105, -2))).addContainerGap()));
        panelApprovedSymbolLayout.setVerticalGroup(panelApprovedSymbolLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelApprovedSymbolLayout.createSequentialGroup().addContainerGap().addGroup(panelApprovedSymbolLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3, -2, 19, -2).addComponent(txtApprovedSymbol, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane4, -1, 52, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator2, -2, -1, -2).addGap(3, 3, 3).addComponent(this.lblMsgApprovedSymbol)));
        this.tbdPane.addTab("Approved Scrip", this.panelApprovedSymbol);
        this.tblAllScrip.setAutoCreateRowSorter(true);
        this.tblAllScrip.setModel(new DefaultTableModel(new Object[0][], new String[]{"Scrip", "Company Name"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false};
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.tblAllScrip.setToolTipText("Drag and Drop Scrip to add in My Watches");
        this.tblAllScrip.setSelectionForeground(new Color(0, 0, 0));
        this.tblAllScrip.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                ScripBrowse.this.tblAllScripMouseExited(evt);
            }
        });
        this.tblAllScrip.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                ScripBrowse.this.tblAllScripMouseMoved(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.tblAllScrip);
        this.lblMsgAllSymbol.setText(" ");
        this.lblMsgAllSymbol.setVerticalAlignment(1);
        GroupLayout panelAllSymbolLayout = new GroupLayout(this.panelAllSymbol);
        this.panelAllSymbol.setLayout(panelAllSymbolLayout);
        panelAllSymbolLayout.setHorizontalGroup(panelAllSymbolLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelAllSymbolLayout.createSequentialGroup().addContainerGap().addGroup(panelAllSymbolLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane3, GroupLayout.Alignment.LEADING, -1, 402, Short.MAX_VALUE).addComponent(this.lblMsgAllSymbol, GroupLayout.Alignment.LEADING, -1, 402, Short.MAX_VALUE)).addContainerGap()));
        panelAllSymbolLayout.setVerticalGroup(panelAllSymbolLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, panelAllSymbolLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane3, -1, 77, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblMsgAllSymbol, -2, 20, -2)));
        this.tbdPane.addTab("All Scrip", this.panelAllSymbol);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tbdPane));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tbdPane, GroupLayout.Alignment.TRAILING));
    }

    private void getApprovedSymbol() {
        if (LogsTC.ApprovedScrip.size() <= 0) {
            LoadLogs DailyRpt = new LoadLogs("ApprovedSymbol=", true);
            new ThreadWithName(DailyRpt, "ApprovedSymbol").start();
        } else {
            this.fillApprovedSymbolDetail();
        }
    }

    private void getSymbolDetailByName() {
        this.lblMsgBySymbol.setText(this.languageCentre.getValue(LanguageConstant.Loading));
        this.lblMsgBySymbol.setIcon(this.loaderIcon);
        this.scripBrowseModel = (DefaultTableModel)this.tblScripBrowse.getModel();
        this.removeSymbolDetailTable();
        Vector v = new Vector(LogCommon.SymbolAndSymbolName.keySet());
        Collections.sort(v);
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            String key = e.nextElement().toString();
            Vector<String> row = new Vector<String>();
            row.add(UtilKSE.GetMarketFromsymbol((String)key));
            row.add(key);
            row.add(((String)LogCommon.SymbolAndSymbolName.get(key)).toString());
            this.scripBrowseModel.addRow(row);
        }
        this.tblScripBrowse.setModel(this.scripBrowseModel);
        this.lblMsgBySymbol.setText(Util.format0digit((String)(this.tblScripBrowse.getRowCount() + "".trim().replaceAll("\\,", ""))) + " " + this.languageCentre.getValue(LanguageConstant.RecordsFound));
        this.lblMsgBySymbol.setIcon(null);
        this.repaint();
    }

    private void getSymbolDetailByMarket(String str) {
        str = str.toUpperCase();
        this.lblMsgBySymbol.setText(this.languageCentre.getValue(LanguageConstant.Loading));
        this.lblMsgBySymbol.setIcon(this.loaderIcon);
        this.scripBrowseModel = (DefaultTableModel)this.tblScripBrowse.getModel();
        this.removeSymbolDetailTable();
        Vector v = new Vector(LogCommon.SymbolAndSymbolName.keySet());
        Collections.sort(v);
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            String key = e.nextElement().toString();
            String market = UtilKSE.GetMarketFromsymbol((String)key);
            if (market.toUpperCase().indexOf(str) < 0) continue;
            Vector<String> row = new Vector<String>();
            row.add(market);
            row.add(key);
            row.add(((String)LogCommon.SymbolAndSymbolName.get(key)).toString());
            this.scripBrowseModel.addRow(row);
        }
        this.tblScripBrowse.setModel(this.scripBrowseModel);
        this.lblMsgBySymbol.setText(Util.format0digit((String)(this.tblScripBrowse.getRowCount() + "".trim().replaceAll("\\,", ""))) + " " + this.languageCentre.getValue(LanguageConstant.RecordsFound));
        this.lblMsgBySymbol.setIcon(null);
        this.repaint();
    }

    private void getSymbolDetailByName(String str) {
        str = str.toUpperCase();
        this.lblMsgBySymbol.setText(this.languageCentre.getValue(LanguageConstant.Loading));
        this.lblMsgBySymbol.setIcon(this.loaderIcon);
        this.scripBrowseModel = (DefaultTableModel)this.tblScripBrowse.getModel();
        this.removeSymbolDetailTable();
        Vector v = new Vector(LogCommon.SymbolAndSymbolName.keySet());
        Collections.sort(v);
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            String key = e.nextElement().toString();
            if (key.toUpperCase().indexOf(str) < 0) continue;
            Vector<String> row = new Vector<String>();
            row.add(UtilKSE.GetMarketFromsymbol((String)key));
            row.add(key);
            row.add(((String)LogCommon.SymbolAndSymbolName.get(key)).toString());
            this.scripBrowseModel.addRow(row);
        }
        this.tblScripBrowse.setModel(this.scripBrowseModel);
        this.lblMsgBySymbol.setText(Util.format0digit((String)(this.tblScripBrowse.getRowCount() + "".trim().replaceAll("\\,", ""))) + " " + this.languageCentre.getValue(LanguageConstant.RecordsFound));
        this.lblMsgBySymbol.setIcon(null);
        this.repaint();
    }

    private void getSymbolDetailByCompany(String str) {
        str = str.toUpperCase();
        this.lblMsgBySymbol.setText(this.languageCentre.getValue(LanguageConstant.Loading));
        this.lblMsgBySymbol.setIcon(this.loaderIcon);
        this.scripBrowseModel = (DefaultTableModel)this.tblScripBrowse.getModel();
        this.removeSymbolDetailTable();
        Vector v = new Vector(LogCommon.SymbolAndSymbolName.keySet());
        Collections.sort(v);
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            String key = e.nextElement().toString();
            String val = ((String)LogCommon.SymbolAndSymbolName.get(key)).toString();
            if ((val = val.toUpperCase()).indexOf(str) < 0) continue;
            Vector<String> row = new Vector<String>();
            row.add(UtilKSE.GetMarketFromsymbol((String)key));
            row.add(key);
            row.add(((String)LogCommon.SymbolAndSymbolName.get(key)).toString());
            this.scripBrowseModel.addRow(row);
        }
        this.tblScripBrowse.setModel(this.scripBrowseModel);
        this.lblMsgBySymbol.setText(Util.format0digit((String)(this.tblScripBrowse.getRowCount() + "".trim().replaceAll("\\,", ""))) + " " + this.languageCentre.getValue(LanguageConstant.RecordsFound));
        this.lblMsgBySymbol.setIcon(null);
        this.repaint();
    }

    private void tbdPaneStateChanged(ChangeEvent evt) {
        if (this.tbdPane.getTitleAt(this.tbdPane.getSelectedIndex()).equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.AllScrip))) {
            if (LogCommon.SymbolAndSymbolName.size() <= 0) {
                this.lblMsgAllSymbol.setText(this.languageCentre.getValue(LanguageConstant.Loading));
                LoadLogs DailyRpt = new LoadLogs("AllSymbol=", true);
                new ThreadWithName(DailyRpt, "AllSymbol").start();
            } else {
                this.fillAllScripBrowse();
            }
        }
    }

    private void txtSymbolDetailActionPerformed(ActionEvent evt) {
        this.callSearch();
    }

    private void txtApprovedSymbolActionPerformed(ActionEvent evt) {
        this.searchApprovedSymbol(txtApprovedSymbol.getText());
    }

    private void txtApprovedSymbolFocusGained(FocusEvent evt) {
        txtApprovedSymbol.selectAll();
    }

    private void txtSymbolDetailFocusGained(FocusEvent evt) {
        txtSymbolDetail.selectAll();
    }

    private void rbCompanyActionPerformed(ActionEvent evt) {
        if (rbCompany.isSelected()) {
            this.lblName.setText(this.languageCentre.getValue(LanguageConstant.Company));
        } else {
            this.lblName.setText(this.languageCentre.getValue(LanguageConstant.Scrip));
        }
        txtSymbolDetail.requestFocus();
        this.callSearch();
    }

    private void rbScripActionPerformed(ActionEvent evt) {
        if (rbScrip.isSelected()) {
            this.lblName.setText(this.languageCentre.getValue(LanguageConstant.Scrip));
        } else {
            this.lblName.setText(this.languageCentre.getValue(LanguageConstant.Company));
        }
        txtSymbolDetail.requestFocus();
        this.callSearch();
    }

    private void txtSymbolDetailKeyReleased(KeyEvent evt) {
        this.callSearch();
    }

    private void txtApprovedSymbolKeyReleased(KeyEvent evt) {
        this.searchApprovedSymbol(txtApprovedSymbol.getText());
    }

    private void tblScripBrowseMouseMoved(MouseEvent evt) {
        int row = this.tblScripBrowse.rowAtPoint(evt.getPoint());
        int col = this.tblScripBrowse.columnAtPoint(evt.getPoint());
        if (row == this.prevRow && col == this.prevCol) {
            return;
        }
        ToolTipManager.sharedInstance().mousePressed(evt);
        ToolTipManager.sharedInstance().mouseEntered(evt);
        this.prevRow = row;
        this.prevCol = col;
        if (row != this.renderScripBrowse.getRowNo()) {
            this.renderScripBrowse.setRowNo(row);
            this.repaint();
        }
    }

    private void tblScripBrowseMouseExited(MouseEvent evt) {
        this.tblScripBrowse.setToolTipText("");
        this.renderScripBrowse.setRowNo(-1);
    }

    private void tblScripBrowseMouseEntered(MouseEvent evt) {
        this.tblScripBrowse.setToolTipText(this.languageCentre.getValue(LanguageConstant.DragAndDropScripToAddInMyWatches));
    }

    private void tblApprovedScripMouseExited(MouseEvent evt) {
        this.renderApporved.setRowNo(-1);
    }

    private void tblApprovedScripMouseMoved(MouseEvent evt) {
        int row = this.tblApprovedScrip.rowAtPoint(evt.getPoint());
        if (row != this.renderApporved.getRowNo()) {
            this.renderApporved.setRowNo(row);
            this.repaint();
        }
    }

    private void tblAllScripMouseExited(MouseEvent evt) {
        this.renderAllScrip.setRowNo(-1);
    }

    private void tblAllScripMouseMoved(MouseEvent evt) {
        int row = this.tblAllScrip.rowAtPoint(evt.getPoint());
        if (row != this.renderAllScrip.getRowNo()) {
            this.renderAllScrip.setRowNo(row);
            this.repaint();
        }
    }

    private void rbMarketActionPerformed(ActionEvent evt) {
        if (rbMarket.isSelected()) {
            this.lblName.setText(this.languageCentre.getValue(LanguageConstant.Market));
        } else {
            this.lblName.setText(this.languageCentre.getValue(LanguageConstant.Company));
        }
        txtSymbolDetail.requestFocus();
        this.callSearch();
    }

    private int getTabIndex(JTabbedPane tab, String title) {
        int ind = 0;
        for (int i = 0; i < tab.getTabCount(); ++i) {
            if (!title.equalsIgnoreCase(tab.getTitleAt(i))) continue;
            ind = i;
            break;
        }
        return ind;
    }

    private void setLanguageValues() {
        this.tblScripBrowse.setToolTipText(this.languageCentre.getValue(LanguageConstant.DragAndDropScripToAddInMyWatches));
        this.lblName.setText(this.languageCentre.getValue(LanguageConstant.Scrip));
        rbScrip.setText(this.languageCentre.getValue(LanguageConstant.Scrip));
        rbCompany.setText(this.languageCentre.getValue(LanguageConstant.Company));
        rbMarket.setText(this.languageCentre.getValue(LanguageConstant.Market));
        this.tblApprovedScrip.setToolTipText(this.languageCentre.getValue(LanguageConstant.DragAndDropScripToAddInMyWatches));
        this.jLabel3.setText(this.languageCentre.getValue(LanguageConstant.Scrip));
        this.tblAllScrip.setToolTipText(this.languageCentre.getValue(LanguageConstant.DragAndDropScripToAddInMyWatches));
        this.tbdPane.setTitleAt(this.getTabIndex(this.tbdPane, "Scrip Search"), this.languageCentre.getValue(LanguageConstant.ScripSearch));
        this.tbdPane.setTitleAt(this.getTabIndex(this.tbdPane, "Approved Scrip"), this.languageCentre.getValue(LanguageConstant.ApprovedScrip));
        this.tbdPane.setTitleAt(this.getTabIndex(this.tbdPane, "All Scrip"), this.languageCentre.getValue(LanguageConstant.AllScrip));
    }
}

