/*
 * Decompiled with CFR 0.152.
 */
package windows;

import Control.JasperFileChooser;
import Control.ReportControl;
import Control.ReportControlEvent;
import Control.ReportControlListener;
import CustomComponent.MyTime;
import MyDocking.Mediator;
import Utilities.CompressManager;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import common.gui.util.LogCommon;
import common.gui.util.MessageType;
import common.gui.util.Util;
import common.services.WebService;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import kse.gui.bean.ScripWisePositionBean;
import kse.gui.model.ScripWisePositionModel;
import kse.gui.render.ScripWisePositionRender;
import languages.LanguageCentre;
import languages.LanguageConstant;
import org.jdesktop.swingx.JXTable;
import reports.Jasper_Report;
import reports.Report_ScripWisePosition;

public class ScripWisePosition
extends JPanel
implements ReportControlListener {
    private AutoCompleteSupport autoCompleteScrip;
    private AutoCompleteSupport autoCompleteMarket;
    private Mediator mediator = Mediator.getInstance();
    private LanguageCentre languageCentre = new LanguageCentre();
    private Vector<String> column = new Vector();
    private Vector<ScripWisePositionBean> rows = new Vector();
    private ScripWisePositionModel model = null;
    private ScripWisePositionRender render = null;
    private final String JRXMLFileName = "ScripWisePosition.jrxml";
    private JButton btnGet;
    private JComboBox cbScrip;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JLabel lblMessage;
    private JLabel lblScrip;
    private ReportControl reportControl1;
    private JXTable table;

    public ScripWisePosition() {
        this.initComponents();
        this.setScrip();
        this.setLanguageValues();
        this.initTable();
        this.reportControl1.addListener(this);
        this.reportControl1.ShowCustomExportButton();
        this.mediator.setScripWisePosition(this);
    }

    private void setScrip() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    if (ScripWisePosition.this.autoCompleteScrip != null && ScripWisePosition.this.autoCompleteScrip.isInstalled()) {
                        ScripWisePosition.this.autoCompleteScrip.uninstall();
                    }
                    Vector allScrip = new Vector(LogCommon.SymbolAndSymbolName.keySet());
                    Collections.sort(allScrip);
                    ScripWisePosition.this.cbScrip.setModel(new DefaultComboBoxModel(allScrip));
                    ScripWisePosition.this.autoCompleteScrip = AutoCompleteSupport.install((JComboBox)ScripWisePosition.this.cbScrip, (EventList)GlazedLists.eventListOf((Object[])allScrip.toArray()));
                    ScripWisePosition.this.cbScrip.setSelectedIndex(0);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    ScripWisePosition.this.mediator.WriteExceptionInClientMachine(ex);
                }
            }
        });
    }

    private void initTable() {
        this.column.add(this.languageCentre.getValue("Account"));
        this.column.add(this.languageCentre.getValue(LanguageConstant.TotalVolume));
        this.column.add(this.languageCentre.getValue(LanguageConstant.OpenVolume));
        this.column.add(this.languageCentre.getValue(LanguageConstant.OpenAveragePrice));
        this.column.add(this.languageCentre.getValue(LanguageConstant.OpenWorth));
        this.column.add(this.languageCentre.getValue(LanguageConstant.CollateralVolume));
        this.column.add(this.languageCentre.getValue(LanguageConstant.CollateralAveragePrice));
        this.column.add(this.languageCentre.getValue(LanguageConstant.CollateralWorth));
        this.model = new ScripWisePositionModel(this.rows, this.column);
        this.table.setModel((TableModel)this.model);
        this.table.setColumnControlVisible(true);
        this.table.setSelectionMode(0);
        this.table.setSortable(true);
        this.table.getTableHeader().setReorderingAllowed(true);
        ((JLabel)((Object)this.table.getTableHeader().getDefaultRenderer())).setHorizontalAlignment(0);
        this.tableDataChange();
        this.setRender();
    }

    private void setRender() {
        this.render = new ScripWisePositionRender();
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            this.table.getColumn(i).setCellRenderer((TableCellRenderer)this.render);
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.table = new JXTable();
        this.lblScrip = new JLabel();
        this.cbScrip = new JComboBox();
        this.btnGet = new JButton();
        this.jSeparator1 = new JSeparator();
        this.lblMessage = new JLabel();
        this.reportControl1 = new ReportControl();
        this.table.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView((Component)this.table);
        this.lblScrip.setText("Scrip");
        this.btnGet.setIcon(new ImageIcon(this.getClass().getResource("/Images/get.png")));
        this.btnGet.setText("Get");
        this.btnGet.setName("ScripWisePosition -> btnGet");
        this.btnGet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScripWisePosition.this.btnGetActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addComponent(this.lblMessage, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(140, 140, 140).addComponent(this.lblScrip, -2, 40, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbScrip, -2, 106, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnGet).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 60, Short.MAX_VALUE).addComponent(this.reportControl1, -2, 139, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(7, 7, 7).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblScrip, -2, 23, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbScrip, -2, 23, -2).addComponent(this.btnGet)))).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.reportControl1, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 180, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblMessage, -2, 24, -2)));
    }

    private void btnGetActionPerformed(ActionEvent evt) {
        this.loadData();
    }

    private void setLanguageValues() {
        this.lblScrip.setText(this.languageCentre.getValue(LanguageConstant.Scrip));
        this.btnGet.setText(this.languageCentre.getValue(LanguageConstant.Get));
    }

    private void loadData() {
        this.rows.clear();
        this.tableDataChange();
        Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Loading, (String)this.languageCentre.getValue(LanguageConstant.Loading));
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    byte[] da = WebService.getInstance().getPort().getCompressedData(LogCommon.UserID, "ScripWisePosition=", ScripWisePosition.this.getMarketAndScrip());
                    String data = CompressManager.unzipStringFromBytes(da);
                    ScripWisePosition.this.mediator.println("ScripWisePosition = " + data);
                    if (data.indexOf("|") > 0) {
                        String[] rows_data = data.split("\\|", -1);
                        for (int i = 0; i < rows_data.length - 1; ++i) {
                            String row_data = rows_data[i];
                            ScripWisePositionBean bean = ScripWisePositionBean.parse((String)row_data);
                            ScripWisePosition.this.rows.add(bean);
                        }
                        if (ScripWisePosition.this.rows.size() == 1) {
                            Util.setMessage((JLabel)ScripWisePosition.this.lblMessage, (MessageType)MessageType.Information, (String)("1 " + ScripWisePosition.this.languageCentre.getValue(LanguageConstant.RecordFound)));
                        } else if (ScripWisePosition.this.rows.size() > 1) {
                            Util.setMessage((JLabel)ScripWisePosition.this.lblMessage, (MessageType)MessageType.Information, (String)(Util.format0digit((String)(ScripWisePosition.this.rows.size() + "")) + " " + ScripWisePosition.this.languageCentre.getValue(LanguageConstant.RecordsFound)));
                        }
                    } else {
                        Util.setMessage((JLabel)ScripWisePosition.this.lblMessage, (MessageType)MessageType.Information, (String)ScripWisePosition.this.languageCentre.getValue(LanguageConstant.NoRecordsFound));
                    }
                    ScripWisePosition.this.tableDataChange();
                }
                catch (Exception ex) {
                    Util.setMessage((JLabel)ScripWisePosition.this.lblMessage, (MessageType)MessageType.Error, (String)ScripWisePosition.this.languageCentre.getValue(LanguageConstant.ErrorInLoading));
                    ScripWisePosition.this.mediator.WriteExceptionInClientMachine(ex);
                    ex.printStackTrace();
                }
            }
        }).start();
    }

    private void tableDataChange() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.model.fireTableDataChanged();
            this.table.addNotify();
            this.table.repaint();
            this.table.packAll();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ScripWisePosition.this.model.fireTableDataChanged();
                    ScripWisePosition.this.table.addNotify();
                    ScripWisePosition.this.table.repaint();
                    ScripWisePosition.this.table.packAll();
                }
            });
        }
    }

    private String getMarketAndScrip() {
        return "REG:" + this.getScrip();
    }

    private String getScrip() {
        String scrip = "";
        if (this.cbScrip.getSelectedItem() != null && !this.cbScrip.getSelectedItem().toString().trim().equalsIgnoreCase("")) {
            scrip = this.cbScrip.getSelectedItem().toString();
        }
        return scrip;
    }

    @Override
    public void ReportControl_Print(ReportControlEvent e) {
        Report_ScripWisePosition Report = new Report_ScripWisePosition("ScripWisePosition.jrxml", this.table.getModel());
        this.SetParameter((Jasper_Report)Report);
        if (!Report.isHasPage()) {
            return;
        }
        Report.PrintReport();
    }

    @Override
    public void ReportControl_Save(ReportControlEvent e) {
        String FileName;
        boolean result;
        Report_ScripWisePosition Report = new Report_ScripWisePosition("ScripWisePosition.jrxml", this.table.getModel());
        this.SetParameter((Jasper_Report)Report);
        if (!Report.isHasPage()) {
            return;
        }
        JasperFileChooser fc = new JasperFileChooser(new File(""));
        fc.setSelectedFile(new File(this.languageCentre.getValue(LanguageConstant.TradeLog) + "-" + MyTime.getInstance().getDate()));
        fc.addAllJasperChoosableFileFilter();
        fc.setAcceptAllFileFilterUsed(false);
        fc.showSaveDialog(this);
        if (fc.getSelectedFile() != null && !(result = Report.Export(FileName = fc.getSelectedFile().getAbsolutePath() + "." + fc.getExtenstion()))) {
            JOptionPane.showMessageDialog(null, this.languageCentre.getValue(LanguageConstant.ErrorInSavingFile));
        }
    }

    @Override
    public void ReportControl_Pdf(ReportControlEvent e) {
        Report_ScripWisePosition Report = new Report_ScripWisePosition("ScripWisePosition.jrxml", this.table.getModel());
        this.SetParameter((Jasper_Report)Report);
        if (!Report.isHasPage()) {
            return;
        }
        JasperFileChooser fc = new JasperFileChooser(new File(""));
        fc.setSelectedFile(new File(this.languageCentre.getValue(LanguageConstant.TradeLog) + "-" + MyTime.getInstance().getDate()));
        fc.addPdfFileFilter();
        fc.showSaveDialog(this);
        if (fc.getSelectedFile() != null) {
            String FileName = fc.getSelectedFile().getAbsolutePath().replaceAll("\"", "") + "." + fc.getExtenstion();
            boolean result = Report.ExportToPdf(FileName);
            if (result) {
                int Option = JOptionPane.showConfirmDialog(null, this.languageCentre.getValue(LanguageConstant.TradeLogReportCreatedDoYouWantToOpenIt), "PDF", 0);
                if (Option == 0) {
                    try {
                        Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + FileName);
                    }
                    catch (IOException iOException) {}
                }
            } else {
                JOptionPane.showMessageDialog(null, this.languageCentre.getValue(LanguageConstant.ErrorInCreatingPDFfile));
            }
        }
    }

    @Override
    public void ReportControl_View(ReportControlEvent e) {
        Report_ScripWisePosition Report = new Report_ScripWisePosition("ScripWisePosition.jrxml", this.table.getModel());
        this.SetParameter((Jasper_Report)Report);
        if (!Report.isHasPage()) {
            return;
        }
        Report.generateReport();
    }

    @Override
    public void ReportControl_CustomExport(ReportControlEvent e) {
        try {
            Report_ScripWisePosition Report = new Report_ScripWisePosition("ScripWisePosition.jrxml", this.table.getModel());
            if (!Report.isHasPage()) {
                return;
            }
            JasperFileChooser fc = new JasperFileChooser(new File(""));
            fc.setSelectedFile(new File(this.languageCentre.getValue(LanguageConstant.ScripWisePosition) + "-" + MyTime.getInstance().getDate()));
            fc.addCSVFileFilter();
            fc.showSaveDialog(this);
            String FileName = fc.getSelectedFile().getAbsolutePath().replaceAll("\"", "") + "." + fc.getExtenstion();
            try {
                Report.CustomExport(FileName, this.table.getModel());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void SetParameter(Jasper_Report Report) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("PrintDate", MyTime.getInstance().getTimeAndDateForReport());
        param.put("Scrip", this.cbScrip.getSelectedItem().toString());
        Report.SetParameter(param);
    }
}

