/*
 * Decompiled with CFR 0.152.
 */
package windows;

import MyDocking.Mediator;
import common.gui.util.AppConfig;
import common.gui.util.ImageUtil;
import common.gui.util.LogCommon;
import common.gui.util.MessageType;
import common.gui.util.Util;
import common.services.WebService;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;

public class SecondaryPasswordOT
extends JDialog {
    private JButton btnExit;
    private JButton btnValidate;
    private JSeparator jSeparator2;
    private JLabel lblBackground;
    private JLabel lblFetchNew;
    private JLabel lblImage;
    private JLabel lblMessage;
    private JLabel lblNote;
    private JLabel lblSecondaryPassword;
    private JLabel lblTitle;
    private JPasswordField txtSecondaryPassword;

    public SecondaryPasswordOT(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setDefaultCloseOperation(0);
        this.setBounds(0, 0, 495, 220);
        this.setLocationRelativeTo(null);
        this.setIconImage(null);
        try {
            if (AppConfig.houseIcon == null) {
                AppConfig.houseIcon = ImageUtil.downloadImage((String)(AppConfig.TradeCastURL + "/HouseImages/small.png"));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.setIconImage(AppConfig.houseIcon);
        this.lblFetchNew.setText("<html><b> Fetch New </b></html>");
        this.setTitle("Trade Cast v" + AppConfig.version.trim());
        this.setVisible(true);
        this.setAlwaysOnTop(true);
        this.requestFocus();
    }

    private void initComponents() {
        this.lblSecondaryPassword = new JLabel();
        this.lblNote = new JLabel();
        this.txtSecondaryPassword = new JPasswordField();
        this.btnValidate = new JButton();
        this.lblMessage = new JLabel();
        this.btnExit = new JButton();
        this.lblTitle = new JLabel();
        this.lblImage = new JLabel();
        this.lblBackground = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.lblFetchNew = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.getContentPane().setLayout(null);
        this.lblSecondaryPassword.setText("Secondary Password");
        this.getContentPane().add(this.lblSecondaryPassword);
        this.lblSecondaryPassword.setBounds(20, 90, 108, 25);
        this.lblNote.setText("Note: Secondary password has been sent to you on registered email address and mobile number ");
        this.getContentPane().add(this.lblNote);
        this.lblNote.setBounds(10, 150, 480, 26);
        this.getContentPane().add(this.txtSecondaryPassword);
        this.txtSecondaryPassword.setBounds(130, 90, 140, 25);
        this.btnValidate.setIcon(new ImageIcon(this.getClass().getResource("/Images/submit.png")));
        this.btnValidate.setText("Validate");
        this.btnValidate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SecondaryPasswordOT.this.btnValidateActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.btnValidate);
        this.btnValidate.setBounds(280, 90, 91, 25);
        this.lblMessage.setText(" ");
        this.getContentPane().add(this.lblMessage);
        this.lblMessage.setBounds(20, 120, 350, 26);
        this.btnExit.setIcon(new ImageIcon(this.getClass().getResource("/Images/close.png")));
        this.btnExit.setText("Exit");
        this.btnExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SecondaryPasswordOT.this.btnExitActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.btnExit);
        this.btnExit.setBounds(380, 90, 90, 25);
        this.lblTitle.setFont(new Font("Tahoma", 1, 11));
        this.lblTitle.setText("Secondary Password");
        this.getContentPane().add(this.lblTitle);
        this.lblTitle.setBounds(30, 20, 260, 40);
        this.lblImage.setIcon(new ImageIcon(this.getClass().getResource("/Images/secandryPassword48.png")));
        this.getContentPane().add(this.lblImage);
        this.lblImage.setBounds(370, 0, 60, 70);
        this.lblBackground.setBackground(new Color(255, 255, 255));
        this.lblBackground.setHorizontalAlignment(4);
        this.lblBackground.setIcon(new ImageIcon(this.getClass().getResource("/Images/HeaderBG.png")));
        this.lblBackground.setOpaque(true);
        this.getContentPane().add(this.lblBackground);
        this.lblBackground.setBounds(0, 0, 490, 72);
        this.getContentPane().add(this.jSeparator2);
        this.jSeparator2.setBounds(0, 73, 490, 3);
        this.lblFetchNew.setForeground(new Color(109, 164, 65));
        this.lblFetchNew.setHorizontalAlignment(0);
        this.lblFetchNew.setText("Fetch new");
        this.lblFetchNew.setToolTipText("Fetch new secondary password");
        this.lblFetchNew.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SecondaryPasswordOT.this.lblFetchNewMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SecondaryPasswordOT.this.lblFetchNewMouseExited(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                SecondaryPasswordOT.this.lblFetchNewMousePressed(evt);
            }
        });
        this.getContentPane().add(this.lblFetchNew);
        this.lblFetchNew.setBounds(380, 120, 90, 22);
        this.pack();
    }

    private void btnExitActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void btnValidateActionPerformed(ActionEvent evt) {
        String secondaryPassword = this.txtSecondaryPassword.getText();
        if (secondaryPassword.length() <= 0) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Please enter secondary password");
            this.txtSecondaryPassword.requestFocus();
        } else {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    Util.setMessage((JLabel)SecondaryPasswordOT.this.lblMessage, (MessageType)MessageType.Loading, (String)"Please wait while validating secondary password");
                    SecondaryPasswordOT.this.validatePassword();
                }
            }).start();
        }
    }

    private void lblFetchNewMouseEntered(MouseEvent evt) {
        this.lblFetchNew.setCursor(Cursor.getPredefinedCursor(12));
        this.lblFetchNew.setText("<html><b><u> Fetch New </u></b></html>");
    }

    private void lblFetchNewMouseExited(MouseEvent evt) {
        this.lblFetchNew.setCursor(Cursor.getPredefinedCursor(0));
        this.lblFetchNew.setText("<html><b> Fetch New </b></html>");
    }

    private void lblFetchNewMousePressed(MouseEvent evt) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Util.setMessage((JLabel)SecondaryPasswordOT.this.lblMessage, (MessageType)MessageType.Loading, (String)"Please wait while creating new secondary password");
                SecondaryPasswordOT.this.setNewSecondaryPassword();
            }
        }).start();
    }

    private void validatePassword() {
        try {
            String secondaryPassword = this.txtSecondaryPassword.getText();
            String result = WebService.getInstance().getPort().getInfo(LogCommon.UserID, "secondaryPassword=", secondaryPassword);
            if (result.equalsIgnoreCase("Error")) {
                Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Error, (String)"Some error occured, please contact to administrator");
            } else if (result.equalsIgnoreCase("Invalid")) {
                Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Error, (String)"Invalid secondary password");
                this.txtSecondaryPassword.requestFocus();
            } else if (result.equalsIgnoreCase("Valid")) {
                this.setVisible(false);
            } else {
                Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Error, (String)"Invalid request, please contact to administrator");
            }
        }
        catch (Exception ex) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Error, (String)"Please contact to administrator");
            Mediator.getInstance().WriteExceptionInClientMachine(ex);
        }
    }

    private void setNewSecondaryPassword() {
        try {
            String result = WebService.getInstance().getPort().getInfo(LogCommon.UserID, "newSecondaryPassword=", "");
            if (result.equalsIgnoreCase("Invalid")) {
                Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Error, (String)"Invalid request");
            } else if (result.equalsIgnoreCase("Success")) {
                Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Sussess, (String)"New secondary password sent to you");
            } else if (result.equalsIgnoreCase("Error")) {
                Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Error, (String)"Some error occured, please contact to administrator");
            }
        }
        catch (Exception ex) {
            Mediator.getInstance().WriteExceptionInClientMachine(ex);
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Error, (String)"Please contact to administrator");
        }
    }
}

