/*
 * Decompiled with CFR 0.152.
 */
package windows;

import MyDocking.Mediator;
import MyDocking.TradeCast;
import RendersNModels.SectorPerformanceCellRender;
import Utilities.LoadLogs;
import Utilities.MyDradAndDrop;
import Utilities.ThreadWithName;
import common.gui.util.AppConfig;
import common.gui.util.FormName;
import common.gui.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.text.DecimalFormat;
import java.util.Vector;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import kse.util.LogsKSE;
import kse.util.UtilKSE;
import languages.LanguageCentre;
import languages.LanguageConstant;

public class SectorPerformance
extends JPanel {
    private LanguageCentre languageCentre = new LanguageCentre();
    Mediator mediator = Mediator.getInstance();
    Class[] types = new Class[]{String.class, DecimalFormat.class, String.class, DecimalFormat.class};
    DefaultTableModel sectorPerformanceModel = new DefaultTableModel(new Object[0][], new String[]{this.languageCentre.getValue(LanguageConstant.SectorNames), this.languageCentre.getValue(LanguageConstant.TotalVolume), this.languageCentre.getValue(LanguageConstant.Leaders), this.languageCentre.getValue(LanguageConstant.LeadersVolume)}){

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public Class getColumnClass(int columnIndex) {
            return SectorPerformance.this.types[columnIndex];
        }
    };
    private ImageIcon loaderIcon = new ImageIcon(this.getClass().getResource(AppConfig.loaderIconPath));
    private SectorPerformanceCellRender render = new SectorPerformanceCellRender();
    private JButton btnRefresh;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JLabel lblMessage;
    private JTable table;

    public SectorPerformance() {
        this.initComponents();
        this.table.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.table.setModel(this.sectorPerformanceModel);
        this.mediator.setSectorPerformance(this);
        this.table.setDefaultRenderer(Object.class, this.render);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(180);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(55);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(55);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(85);
        this.table.setSelectionMode(0);
        this.table.setRowHeight(AppConfig.rowHeight);
        this.table.getTableHeader().setReorderingAllowed(false);
        JTableHeader header = this.table.getTableHeader();
        ((JLabel)((Object)header.getDefaultRenderer())).setHorizontalAlignment(0);
        MyDradAndDrop myDradAndDrop = new MyDradAndDrop(this.table, 2, FormName.MarketWatch);
        LogsKSE.SectorperformaceData = "";
        this.setLanguageValues();
        this.getLog();
    }

    public void getLog() {
        this.lblMessage.setText(" ");
        this.lblMessage.setIcon(null);
        if (LogsKSE.SectorperformaceData.length() <= 0) {
            this.lblMessage.setText(this.languageCentre.getValue(LanguageConstant.Loading));
            this.lblMessage.setIcon(this.loaderIcon);
            LoadLogs sectorPerformance = new LoadLogs("SectorPerformance=", true);
            new ThreadWithName(sectorPerformance, "SectorPerformance").start();
        } else {
            this.fillSectorPerDetail(LogsKSE.SectorperformaceData);
        }
    }

    public void setError() {
        this.lblMessage.setText(this.languageCentre.getValue(LanguageConstant.ErrorInLoading));
        this.lblMessage.setIcon(null);
        this.removeSectorPerTable();
    }

    public void fillSectorPerDetail(String result) {
        String[] str1;
        this.lblMessage.setText(" ");
        this.lblMessage.setIcon(null);
        if (result.equalsIgnoreCase("No Record(s) found")) {
            this.lblMessage.setText(" " + this.languageCentre.getValue(LanguageConstant.NoRecordsFound));
            return;
        }
        this.sectorPerformanceModel = (DefaultTableModel)this.table.getModel();
        this.removeSectorPerTable();
        if (!result.equalsIgnoreCase("No Record(s) found") && (str1 = result.split("="))[1].indexOf("|") > 0) {
            String[] str = str1[1].split("\\|", -1);
            for (int rows = 0; rows < str.length - 1; ++rows) {
                Vector<String> row = new Vector<String>();
                String[] str2 = str[rows].split(";");
                for (int col = 0; col < str2.length; ++col) {
                    row.addElement(Util.format2digit((String)str2[col].toString().trim().replaceAll("\\,", "")));
                }
                this.sectorPerformanceModel.addRow(row);
            }
        }
        this.table.setModel(this.sectorPerformanceModel);
        this.lblMessage.setText(Util.format0digit((String)(this.table.getRowCount() + "".trim().replaceAll("\\,", ""))) + " " + this.languageCentre.getValue(LanguageConstant.Sectors));
        this.lblMessage.setIcon(null);
        this.repaint();
    }

    private void removeSectorPerTable() {
        DefaultTableModel model = (DefaultTableModel)this.table.getModel();
        int numrows = model.getRowCount();
        for (int i = 0; i < numrows; ++i) {
            model.removeRow(0);
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.table = new JTable();
        this.btnRefresh = new JButton();
        this.lblMessage = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.table.setModel(new DefaultTableModel(new Object[0][], new String[]{"Sector Name(s)", "Total Volume", "Leader(s)", "Leader(s) Volume"}));
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SectorPerformance.this.tableMouseClicked(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SectorPerformance.this.tableMouseExited(evt);
            }
        });
        this.table.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                SectorPerformance.this.tableMouseMoved(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.table);
        this.btnRefresh.setIcon(new ImageIcon(this.getClass().getResource("/Images/refresh.png")));
        this.btnRefresh.setText("Refresh");
        this.btnRefresh.setName("SectorPerformance -> btnRefresh");
        this.btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SectorPerformance.this.btnRefreshActionPerformed(evt);
            }
        });
        this.lblMessage.setText(" ");
        this.lblMessage.setVerticalAlignment(1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -2, 0, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.lblMessage, -1, 200, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.btnRefresh))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 81, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, -1, -2).addGap(3, 3, 3).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnRefresh).addComponent(this.lblMessage, -2, 19, -2))));
    }

    private void btnRefreshActionPerformed(ActionEvent evt) {
        LogsKSE.SectorperformaceData = "";
        this.getLog();
    }

    private void tableMouseMoved(MouseEvent evt) {
        TableColumnModel colModel = this.table.getColumnModel();
        int vColIndex = colModel.getColumnIndexAtX(evt.getX());
        int mColIndex = this.table.convertColumnIndexToModel(vColIndex);
        if (this.languageCentre.getValue(LanguageConstant.Leaders).equalsIgnoreCase(this.table.getColumnName(mColIndex).toString()) || this.languageCentre.getValue(LanguageConstant.SectorNames).equalsIgnoreCase(this.table.getColumnName(mColIndex).toString())) {
            this.table.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.table.setCursor(Cursor.getPredefinedCursor(0));
        }
        int row = this.table.rowAtPoint(evt.getPoint());
        if (row != this.render.getRowNo()) {
            this.render.setRowNo(row);
            this.repaint();
        }
    }

    private void tableMouseClicked(MouseEvent evt) {
        TableColumnModel colModel = this.table.getColumnModel();
        int vColIndex = colModel.getColumnIndexAtX(evt.getX());
        int mColIndex = this.table.convertColumnIndexToModel(vColIndex);
        if (this.languageCentre.getValue(LanguageConstant.Leaders).equalsIgnoreCase(this.table.getColumnName(mColIndex).toString()) && !SwingUtilities.isRightMouseButton(evt)) {
            String sysmbol = this.table.getValueAt(this.table.getSelectedRow(), 2).toString();
            if (AppConfig.isHistoricalDataWatch) {
                this.mediator.openScripDetails(sysmbol);
            } else {
                TradeCast.getInstance().ShowDynamicForm(FormName.DetailedQuote, LanguageConstant.DetailedQuote);
                this.mediator.detailedQuote.AddSymbol(UtilKSE.GetMarketFromsymbol((String)sysmbol), sysmbol);
                this.mediator.detailedQuote.setTitle("");
            }
        }
        if (this.languageCentre.getValue(LanguageConstant.SectorNames).equalsIgnoreCase(this.table.getColumnName(mColIndex).toString()) && !SwingUtilities.isRightMouseButton(evt)) {
            this.mediator.MwPanel.setSecterTabDefault();
            if (AppConfig.isHistoricalDataWatch) {
                this.mediator.MwPanel.MySectorWatchHistorical.SetSectorComboSelected(this.table.getValueAt(this.table.getSelectedRow(), 0).toString());
            } else {
                this.mediator.MwPanel.MySectorWatch.SetSectorComboSelected(this.table.getValueAt(this.table.getSelectedRow(), 0).toString());
            }
        }
    }

    private void tableMouseExited(MouseEvent evt) {
        this.render.setRowNo(-1);
    }

    private void setLanguageValues() {
        this.btnRefresh.setText(this.languageCentre.getValue(LanguageConstant.Refresh));
    }

    class SectorPerformanceCellRenderer
    extends DefaultTableCellRenderer {
        SectorPerformanceCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object obj, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel cell = (JLabel)super.getTableCellRendererComponent(table, obj, isSelected, hasFocus, row, column);
            cell.setForeground(Color.WHITE);
            if (row % 2 == 0) {
                cell.setBackground(new Color(127, 167, 181));
            } else {
                cell.setBackground(new Color(67, 110, 134));
            }
            if (column == 0) {
                cell.setHorizontalAlignment(2);
            } else if (column == 1) {
                cell.setHorizontalAlignment(4);
            } else if (column == 2) {
                cell.setHorizontalAlignment(2);
            } else if (column == 3) {
                cell.setHorizontalAlignment(4);
            }
            return cell;
        }
    }
}

