/*
 * Decompiled with CFR 0.152.
 */
package windows;

import Beans.ExchangeHistory;
import MyDocking.Mediator;
import MyDocking.TradeCast;
import Utilities.LogsTC;
import common.gui.util.AppConfig;
import common.gui.util.FormName;
import common.gui.util.ImageUtil;
import common.gui.util.LoginMode;
import common.gui.util.Util;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import languages.LanguageCentre;
import languages.LanguageConstant;

public class StatusBar
extends JPanel {
    Mediator mediator = Mediator.getInstance();
    private BufferedImage image = null;
    private LanguageCentre languageCentre = new LanguageCentre();
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JLabel lblDisplay;
    private JLabel lblFeed;
    private JLabel lblFeedSession;
    private JTextField lblFeedSessionStatus;
    private JLabel lblHouseName;
    private JTextField lblMarketStatus;
    public JTextField lblPreviousVol;
    private JLabel lblStrength;
    private JLabel lblTradeSession1;
    private JTextField lblTradeSessionStatus;

    public StatusBar() {
        this.initComponents();
        this.mediator.setStatusBar(this);
        String strDateFormat = "HH:mm:ss";
        SimpleDateFormat sdf = new SimpleDateFormat(strDateFormat);
        if (AppConfig.loginMode == LoginMode.PMEX) {
            this.lblMarketStatus.setVisible(false);
            this.lblFeed.setVisible(false);
            this.lblPreviousVol.setVisible(false);
            this.lblDisplay.setVisible(false);
        } else {
            this.lblMarketStatus.setVisible(true);
            this.lblFeed.setVisible(true);
        }
        this.lblPreviousVol.setHorizontalAlignment(0);
        this.lblHouseName.setText("<html>" + AppConfig.companyName + "</html>");
        Dimension d = new Dimension((int)((double)this.lblHouseName.getText().length() * 3.5) + this.lblHouseName.getText().length(), this.lblHouseName.getPreferredSize().height);
        this.lblHouseName.setPreferredSize(d);
        this.lblHouseName.setMaximumSize(d);
        this.lblHouseName.setMinimumSize(d);
        this.lblStrength.setText("");
        this.lblHouseName.setForeground(Util.convertToColor((String)AppConfig.companyNameFG, (Color)Color.BLACK));
        this.lblPreviousVol.setDisabledTextColor(Color.BLACK);
        this.lblHouseName.setIcon(null);
        this.setImage();
        this.lblDisplay.setCursor(Cursor.getPredefinedCursor(12));
        this.lblMarketStatus.setCursor(Cursor.getPredefinedCursor(12));
        this.setLanguageValues();
    }

    public void UpdateStrengthBar(final long msec, final boolean ishttp) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.UpdateStrengthBar2(msec, ishttp);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StatusBar.this.UpdateStrengthBar2(msec, ishttp);
                }
            });
        }
    }

    public void UpdateStrengthBar2(long msec, boolean ishttp) {
        try {
            if (!ishttp) {
                if (msec > 12500L) {
                    this.lblStrength.setIcon(new ImageIcon(this.getClass().getResource("/Images/strength0.png")));
                } else if (msec > 10000L && msec <= 12500L) {
                    this.lblStrength.setIcon(new ImageIcon(this.getClass().getResource("/Images/strength1.png")));
                } else if (msec > 7500L && msec <= 10000L) {
                    this.lblStrength.setIcon(new ImageIcon(this.getClass().getResource("/Images/strength2.png")));
                } else if (msec > 5000L && msec <= 7500L) {
                    this.lblStrength.setIcon(new ImageIcon(this.getClass().getResource("/Images/strength3.png")));
                } else if (msec > 2500L && msec <= 5000L) {
                    this.lblStrength.setIcon(new ImageIcon(this.getClass().getResource("/Images/strength4.png")));
                } else if (msec > 0L && msec <= 2500L) {
                    this.lblStrength.setIcon(new ImageIcon(this.getClass().getResource("/Images/strength5.png")));
                }
            } else if (msec == 0L) {
                this.lblStrength.setIcon(new ImageIcon(this.getClass().getResource("/Images/httpstrength0.png")));
            } else if (msec == 1L) {
                this.lblStrength.setIcon(new ImageIcon(this.getClass().getResource("/Images/httpstrength1.png")));
            } else if (msec == 2L) {
                this.lblStrength.setIcon(new ImageIcon(this.getClass().getResource("/Images/httpstrength2.png")));
            } else if (msec == 3L) {
                this.lblStrength.setIcon(new ImageIcon(this.getClass().getResource("/Images/httpstrength3.png")));
            } else if (msec == 4L) {
                this.lblStrength.setIcon(new ImageIcon(this.getClass().getResource("/Images/httpstrength4.png")));
            } else if (msec == 5L) {
                this.lblStrength.setIcon(new ImageIcon(this.getClass().getResource("/Images/httpstrength5.png")));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setImage() {
        if (AppConfig.houseIcon == null) {
            AppConfig.houseIcon = ImageUtil.downloadImage((String)(AppConfig.TradeCastURL + "/HouseImages/small.png"));
        }
        if (AppConfig.houseIcon != null) {
            this.lblHouseName.setIcon(new ImageIcon(AppConfig.houseIcon));
        }
    }

    public void getURL(String str) {
        TradeCast.getInstance().showWebBrowserFrame();
        this.mediator.webBrowserFrame.openURL(str);
    }

    public void updatePreviousVol() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.updatePreviousVol2();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StatusBar.this.updatePreviousVol2();
                }
            });
        }
    }

    private void updatePreviousVol2() {
        long volume = 0L;
        Enumeration<ExchangeHistory> en = LogsTC.ExchangeHistory.elements();
        while (en.hasMoreElements()) {
            ExchangeHistory ex = new ExchangeHistory();
            ex = en.nextElement();
            if (!ex.index.equalsIgnoreCase("ALLSHR")) continue;
            volume = ex.volume;
            break;
        }
        try {
            long vol = volume;
            this.lblPreviousVol.setText(" " + Util.inMillion((long)vol) + " ");
            this.lblPreviousVol.setToolTipText(this.languageCentre.getValue(LanguageConstant.PreviousVolume) + " " + Util.format0digit((String)(volume + "")));
        }
        catch (NumberFormatException e) {
            this.lblPreviousVol.setText(" " + volume + " ");
            this.lblPreviousVol.setToolTipText(this.languageCentre.getValue(LanguageConstant.PreviousVolume) + " " + Util.format0digit((String)(volume + "")));
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.lblMarketStatus = new JTextField();
        this.lblTradeSessionStatus = new JTextField();
        this.lblFeedSessionStatus = new JTextField();
        this.lblFeedSession = new JLabel();
        this.lblTradeSession1 = new JLabel();
        this.lblFeed = new JLabel();
        this.lblDisplay = new JLabel();
        this.lblPreviousVol = new JTextField();
        this.lblHouseName = new JLabel();
        this.jLabel1 = new JLabel();
        this.jPanel3 = new JPanel();
        this.lblStrength = new JLabel();
        this.jPanel1.setName("jPanel1");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setName("Form");
        this.setPreferredSize(new Dimension(775, 24));
        this.jPanel2.setName("jPanel2");
        this.jPanel2.setPreferredSize(new Dimension(624, 24));
        this.lblMarketStatus.setEditable(false);
        this.lblMarketStatus.setFont(this.lblMarketStatus.getFont().deriveFont((float)this.lblMarketStatus.getFont().getSize() - 1.0f));
        this.lblMarketStatus.setForeground(new Color(255, 0, 0));
        this.lblMarketStatus.setHorizontalAlignment(0);
        this.lblMarketStatus.setText("Closed");
        this.lblMarketStatus.setBorder(BorderFactory.createBevelBorder(1));
        this.lblMarketStatus.setEnabled(false);
        this.lblMarketStatus.setName("lblMarketStatus");
        this.lblTradeSessionStatus.setEditable(false);
        this.lblTradeSessionStatus.setFont(this.lblTradeSessionStatus.getFont().deriveFont((float)this.lblTradeSessionStatus.getFont().getSize() - 1.0f));
        this.lblTradeSessionStatus.setForeground(new Color(255, 0, 0));
        this.lblTradeSessionStatus.setHorizontalAlignment(0);
        this.lblTradeSessionStatus.setText("Disconnected");
        this.lblTradeSessionStatus.setBorder(BorderFactory.createBevelBorder(1));
        this.lblTradeSessionStatus.setEnabled(false);
        this.lblTradeSessionStatus.setName("lblTradeSessionStatus");
        this.lblFeedSessionStatus.setEditable(false);
        this.lblFeedSessionStatus.setFont(this.lblFeedSessionStatus.getFont().deriveFont((float)this.lblFeedSessionStatus.getFont().getSize() - 1.0f));
        this.lblFeedSessionStatus.setForeground(new Color(255, 0, 0));
        this.lblFeedSessionStatus.setHorizontalAlignment(0);
        this.lblFeedSessionStatus.setText("Disconnected");
        this.lblFeedSessionStatus.setBorder(BorderFactory.createBevelBorder(1));
        this.lblFeedSessionStatus.setEnabled(false);
        this.lblFeedSessionStatus.setName("lblFeedSessionStatus");
        this.lblFeedSession.setHorizontalAlignment(4);
        this.lblFeedSession.setText("Feed Server");
        this.lblFeedSession.setName("lblFeedSession");
        this.lblFeedSession.setPreferredSize(new Dimension(65, 14));
        this.lblTradeSession1.setText("Trade Server");
        this.lblTradeSession1.setName("lblTradeSession1");
        this.lblFeed.setText("PSX Status");
        this.lblFeed.setName("lblFeed");
        this.lblDisplay.setText("<html>Previous Vol</html>");
        this.lblDisplay.setMaximumSize(new Dimension(56, 13));
        this.lblDisplay.setName("lblDisplay");
        this.lblDisplay.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                StatusBar.this.lblDisplayMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                StatusBar.this.lblDisplayMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                StatusBar.this.lblDisplayMouseExited(evt);
            }
        });
        this.lblPreviousVol.setEditable(false);
        this.lblPreviousVol.setFont(new Font("Tahoma 10", 1, 11));
        this.lblPreviousVol.setHorizontalAlignment(0);
        this.lblPreviousVol.setText("0");
        this.lblPreviousVol.setBorder(BorderFactory.createBevelBorder(1));
        this.lblPreviousVol.setName("lblPreviousVol");
        this.lblPreviousVol.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                StatusBar.this.lblPreviousVolMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                StatusBar.this.lblPreviousVolMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                StatusBar.this.lblPreviousVolMouseExited(evt);
            }
        });
        this.lblHouseName.setFont(this.lblHouseName.getFont().deriveFont(this.lblHouseName.getFont().getStyle() | 1));
        this.lblHouseName.setForeground(new Color(158, 173, 176));
        this.lblHouseName.setText("House Name");
        this.lblHouseName.setName("lblHouseName");
        this.lblHouseName.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                StatusBar.this.lblHouseNameMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                StatusBar.this.lblHouseNameMouseExited(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                StatusBar.this.lblHouseNameMousePressed(evt);
            }
        });
        this.jLabel1.setText("Connection Strength");
        this.jLabel1.setName("jLabel1");
        this.jPanel3.setAutoscrolls(true);
        this.jPanel3.setMaximumSize(new Dimension(Short.MAX_VALUE, 18));
        this.jPanel3.setMinimumSize(new Dimension(100, 18));
        this.jPanel3.setName("jPanel3");
        this.jPanel3.setLayout(new GridBagLayout());
        this.lblStrength.setHorizontalAlignment(0);
        this.lblStrength.setText("Strength");
        this.lblStrength.setVerticalAlignment(3);
        this.lblStrength.setBorder(BorderFactory.createBevelBorder(1));
        this.lblStrength.setMaximumSize(new Dimension(35, 20));
        this.lblStrength.setMinimumSize(new Dimension(35, 20));
        this.lblStrength.setName("lblStrength");
        this.lblStrength.setPreferredSize(new Dimension(35, 20));
        this.lblStrength.setVerticalTextPosition(3);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addComponent(this.lblHouseName, -2, 274, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblStrength, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblFeedSession, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblFeedSessionStatus, -2, 73, -2).addGap(14, 14, 14).addComponent(this.lblTradeSession1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblTradeSessionStatus, -2, 72, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblFeed).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblMarketStatus, -2, 61, -2).addGap(14, 14, 14).addComponent(this.lblDisplay, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblPreviousVol, -2, 73, -2)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.lblTradeSession1, -1, -1, Short.MAX_VALUE).addComponent(this.lblFeed, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblTradeSessionStatus, -2, -1, -2).addComponent(this.lblFeedSessionStatus, -2, -1, -2).addComponent(this.lblFeedSession, -2, 20, -2).addComponent(this.lblMarketStatus, -2, -1, -2).addComponent(this.lblStrength, -2, 19, -2).addComponent(this.jLabel1, -2, 17, -2).addComponent(this.lblHouseName))).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.lblPreviousVol).addComponent(this.lblDisplay, -2, 20, -2))).addContainerGap()));
        jPanel2Layout.linkSize(1, this.jLabel1, this.lblHouseName);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -1, 999, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -2, 20, -2));
    }

    private void lblHouseNameMousePressed(MouseEvent evt) {
        this.getURL(AppConfig.companyURL);
    }

    private void lblHouseNameMouseEntered(MouseEvent evt) {
        this.lblHouseName.setCursor(new Cursor(12));
        this.lblHouseName.setText("<html><u>" + AppConfig.companyName + "</u></html>");
    }

    private void lblHouseNameMouseExited(MouseEvent evt) {
        this.lblHouseName.setText("<html>" + AppConfig.companyName + "</html>");
        this.lblHouseName.setCursor(Cursor.getDefaultCursor());
    }

    private void lblPreviousVolMouseEntered(MouseEvent evt) {
        this.lblPreviousVol.setCursor(Cursor.getPredefinedCursor(12));
    }

    private void lblPreviousVolMouseExited(MouseEvent evt) {
    }

    private void lblDisplayMouseClicked(MouseEvent evt) {
        this.getExchStat();
    }

    private void lblPreviousVolMouseClicked(MouseEvent evt) {
        this.getExchStat();
    }

    private void lblDisplayMouseEntered(MouseEvent evt) {
        this.lblDisplay.setCursor(new Cursor(12));
        this.lblDisplay.setText("<html><u>" + this.languageCentre.getValue(LanguageConstant.PreviousVolume) + "</u></html>".trim());
    }

    private void lblDisplayMouseExited(MouseEvent evt) {
        this.lblDisplay.setText("<html>" + this.languageCentre.getValue(LanguageConstant.PreviousVolume) + "</html>".trim());
        this.lblDisplay.setCursor(Cursor.getDefaultCursor());
    }

    public void getExchStat() {
        TradeCast.getInstance().ShowDynamicForm(FormName.IndicesSummery, LanguageConstant.IndicesSummary);
    }

    private void setLanguageValues() {
        this.lblMarketStatus.setText(this.languageCentre.getValue(LanguageConstant.Closed));
        this.lblTradeSessionStatus.setText(this.languageCentre.getValue(LanguageConstant.Disconnected));
        this.lblFeedSessionStatus.setText(this.languageCentre.getValue(LanguageConstant.Disconnected));
        this.lblFeedSession.setText(this.languageCentre.getValue(LanguageConstant.FeedServer));
        this.lblTradeSession1.setText(this.languageCentre.getValue(LanguageConstant.TradeServer));
        this.lblFeed.setText(this.languageCentre.getValue(LanguageConstant.PSXStatus));
        this.lblDisplay.setText("<html>" + this.languageCentre.getValue(LanguageConstant.PreviousVolume) + "</html>");
        this.jLabel1.setText(this.languageCentre.getValue(LanguageConstant.ConnectionStrength));
    }

    public void setTradeSessionStatus(String status) {
        this.lblTradeSessionStatus.setText(this.languageCentre.getValue(status));
    }

    public void setTradeSessionStatusForeground(Color color) {
        this.lblTradeSessionStatus.setForeground(color);
        this.lblTradeSessionStatus.repaint();
    }

    public void setTradeSessionStatusDisabledTextColor(Color color) {
        this.lblTradeSessionStatus.setDisabledTextColor(color);
        this.lblTradeSessionStatus.repaint();
    }

    public void setFeedSessionStatus(String status) {
        this.lblFeedSessionStatus.setText(this.languageCentre.getValue(status));
    }

    public void setFeedSessionStatusForeground(Color color) {
        this.lblFeedSessionStatus.setForeground(color);
        this.lblFeedSessionStatus.repaint();
    }

    public void setFeedSessionStatusDisabledTextColor(Color color) {
        this.lblFeedSessionStatus.setDisabledTextColor(color);
        this.lblFeedSessionStatus.repaint();
    }

    public void setMarketStatus(String status) {
        this.lblMarketStatus.setText(this.languageCentre.getValue(status));
    }

    public void setMarketStatusDisabledTextColor(Color color) {
        this.lblMarketStatus.setDisabledTextColor(color);
        this.lblMarketStatus.repaint();
    }

    public void setMarketStatusForeground(Color color) {
        this.lblMarketStatus.setForeground(color);
        this.lblMarketStatus.repaint();
    }

    public String getMarketStatus() {
        return this.lblMarketStatus.getText();
    }
}

