/*
 * Decompiled with CFR 0.152.
 */
package windows;

import MyDocking.Mediator;
import RendersNModels.ThemeCellRenderer;
import Utilities.LoadLogs;
import Utilities.ThreadWithName;
import common.gui.util.AppConfig;
import common.gui.util.FormName;
import java.awt.Dimension;
import java.text.DecimalFormat;
import java.util.Vector;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableModel;
import languages.LanguageCentre;
import languages.LanguageConstant;
import windows.TopMoverTable;

public class TopMovers
extends JPanel {
    private Mediator mediator = Mediator.getInstance();
    private LanguageCentre languageCentre = new LanguageCentre();
    public static int MouseOverRowNo;
    private ImageIcon loaderIcon = new ImageIcon(this.getClass().getResource(AppConfig.loaderIconPath));
    private TopMoverTable tblLeader = null;
    private TopMoverTable tblGainer = null;
    private TopMoverTable tblLoser = null;
    private TopMoverTable tblIncrease = null;
    private TopMoverTable tblDecrease = null;
    private FormName formname = null;
    DefaultTableModel model = new DefaultTableModel(new Object[0][], new String[]{this.languageCentre.getValue(LanguageConstant.Scrip), this.languageCentre.getValue(LanguageConstant.Company), this.languageCentre.getValue(LanguageConstant.Last), this.languageCentre.getValue("Change"), this.languageCentre.getValue(LanguageConstant.PercentChange), this.languageCentre.getValue(LanguageConstant.Volume), this.languageCentre.getValue(LanguageConstant.Trades)}){
        Class[] types;
        {
            this.types = new Class[]{String.class, String.class, DecimalFormat.class, DecimalFormat.class, DecimalFormat.class, DecimalFormat.class, DecimalFormat.class, DecimalFormat.class};
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public Class getColumnClass(int columnIndex) {
            return this.types[columnIndex];
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (row < 0 || row >= this.getRowCount()) {
                return "";
            }
            Vector rowVector = (Vector)this.dataVector.elementAt(row);
            return rowVector.elementAt(column);
        }
    };
    private JButton btnRefresh;
    private JButton btnRefresh1;
    private JTabbedPane jTabbedPane1;
    private JPanel tbDecrease;
    private JPanel tbGainer;
    private JPanel tbIncrease;
    private JPanel tbLeaders;
    private JPanel tbLosers;
    private JSeparator leaderSeparator = new JSeparator();
    public JLabel lblLeaderMessage = new JLabel(" ");
    private JSeparator gainerSeparator = new JSeparator();
    public JLabel lblGainerMessage = new JLabel(" ");
    private JSeparator loserSeparator = new JSeparator();
    public JLabel lblLoserMessage = new JLabel(" ");
    private JSeparator increaseSeparator = new JSeparator();
    public JLabel lblIncreaseMessage = new JLabel(" ");
    private JSeparator decreaseSeparator = new JSeparator();
    public JLabel lblDecreaseMessage = new JLabel(" ");

    public TopMovers(FormName name) {
        this.formname = name;
        this.initComponents();
        if (name == FormName.TopMovers) {
            this.mediator.setTopMovers(this);
        } else if (name == FormName.PMEX_TopMovers) {
            this.mediator.setPMEX_TopMovers(this);
        }
        this.tblLeader = new TopMoverTable(name);
        this.tblGainer = new TopMoverTable(name);
        this.tblLoser = new TopMoverTable(name);
        this.tblIncrease = new TopMoverTable(name);
        this.tblDecrease = new TopMoverTable(name);
        GroupLayout tbLeadersLayout = new GroupLayout(this.tbLeaders);
        this.tbLeaders.setLayout(tbLeadersLayout);
        tbLeadersLayout.setHorizontalGroup(tbLeadersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.leaderSeparator, GroupLayout.Alignment.TRAILING, -1, 309, Short.MAX_VALUE).addComponent(this.tblLeader, -1, 309, Short.MAX_VALUE).addGroup(tbLeadersLayout.createSequentialGroup().addContainerGap().addComponent(this.lblLeaderMessage, -1, 289, Short.MAX_VALUE).addContainerGap()));
        tbLeadersLayout.setVerticalGroup(tbLeadersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(tbLeadersLayout.createSequentialGroup().addComponent(this.tblLeader, -1, 136, Short.MAX_VALUE).addGap(3, 3, 3).addComponent(this.leaderSeparator, -2, 2, -2).addGap(2, 2, 2).addComponent(this.lblLeaderMessage)));
        this.tblLeader.setModel(this.model);
        this.tblLeader.setRender(new ThemeCellRenderer("TopLeader"));
        GroupLayout tbGainersLayout = new GroupLayout(this.tbGainer);
        this.tbGainer.setLayout(tbGainersLayout);
        tbGainersLayout.setHorizontalGroup(tbGainersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.gainerSeparator, GroupLayout.Alignment.TRAILING, -1, 309, Short.MAX_VALUE).addComponent(this.tblGainer, -1, 309, Short.MAX_VALUE).addGroup(tbGainersLayout.createSequentialGroup().addContainerGap().addComponent(this.lblGainerMessage, -1, 289, Short.MAX_VALUE).addContainerGap()));
        tbGainersLayout.setVerticalGroup(tbGainersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(tbGainersLayout.createSequentialGroup().addComponent(this.tblGainer, -1, 136, Short.MAX_VALUE).addGap(3, 3, 3).addComponent(this.gainerSeparator, -2, 2, -2).addGap(2, 2, 2).addComponent(this.lblGainerMessage)));
        this.tblGainer.setModel(this.model);
        this.tblGainer.setRender(new ThemeCellRenderer("TopGainer"));
        GroupLayout tbLooserLayout = new GroupLayout(this.tbLosers);
        this.tbLosers.setLayout(tbLooserLayout);
        tbLooserLayout.setHorizontalGroup(tbLooserLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.loserSeparator, GroupLayout.Alignment.TRAILING, -1, 309, Short.MAX_VALUE).addComponent(this.tblLoser, -1, 309, Short.MAX_VALUE).addGroup(tbLooserLayout.createSequentialGroup().addContainerGap().addComponent(this.lblLoserMessage, -1, 289, Short.MAX_VALUE).addContainerGap()));
        tbLooserLayout.setVerticalGroup(tbLooserLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(tbLooserLayout.createSequentialGroup().addComponent(this.tblLoser, -1, 136, Short.MAX_VALUE).addGap(3, 3, 3).addComponent(this.loserSeparator, -2, 2, -2).addGap(2, 2, 2).addComponent(this.lblLoserMessage)));
        this.tblLoser.setModel(this.model);
        this.tblLoser.setRender(new ThemeCellRenderer("TopLoser"));
        GroupLayout tbIncreaseLayout = new GroupLayout(this.tbIncrease);
        this.tbIncrease.setLayout(tbIncreaseLayout);
        tbIncreaseLayout.setHorizontalGroup(tbIncreaseLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.increaseSeparator, GroupLayout.Alignment.TRAILING, -1, 309, Short.MAX_VALUE).addComponent(this.tblIncrease, -1, 309, Short.MAX_VALUE).addGroup(tbIncreaseLayout.createSequentialGroup().addContainerGap().addComponent(this.lblIncreaseMessage, -1, 289, Short.MAX_VALUE).addContainerGap()));
        tbIncreaseLayout.setVerticalGroup(tbIncreaseLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(tbIncreaseLayout.createSequentialGroup().addComponent(this.tblIncrease, -1, 136, Short.MAX_VALUE).addGap(3, 3, 3).addComponent(this.increaseSeparator, -2, 2, -2).addGap(2, 2, 2).addComponent(this.lblIncreaseMessage)));
        this.tblIncrease.setModel(this.model);
        this.tblIncrease.setRender(new ThemeCellRenderer("MktPercentIncrease"));
        GroupLayout tbDecreaseLayout = new GroupLayout(this.tbDecrease);
        this.tbDecrease.setLayout(tbDecreaseLayout);
        tbDecreaseLayout.setHorizontalGroup(tbDecreaseLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.decreaseSeparator, GroupLayout.Alignment.TRAILING, -1, 309, Short.MAX_VALUE).addComponent(this.tblDecrease, -1, 309, Short.MAX_VALUE).addGroup(tbDecreaseLayout.createSequentialGroup().addContainerGap().addComponent(this.lblDecreaseMessage, -1, 289, Short.MAX_VALUE).addContainerGap()));
        tbDecreaseLayout.setVerticalGroup(tbDecreaseLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(tbDecreaseLayout.createSequentialGroup().addComponent(this.tblDecrease, -1, 136, Short.MAX_VALUE).addGap(3, 3, 3).addComponent(this.decreaseSeparator, -2, 2, -2).addGap(2, 2, 2).addComponent(this.lblDecreaseMessage)));
        this.tblDecrease.setModel(this.model);
        this.tblDecrease.setRender(new ThemeCellRenderer("MktPercentDecrease"));
        this.tblLeader.setTableColumnWidth();
        this.tblGainer.setTableColumnWidth();
        this.tblLoser.setTableColumnWidth();
        this.tblIncrease.setTableColumnWidth();
        this.tblDecrease.setTableColumnWidth();
        this.setLanguageValues();
    }

    public void fillTopDecrease(String result) {
        if (result.indexOf("=") >= 0) {
            this.tblDecrease.fillTableWithPercentFromDB(result);
            this.lblDecreaseMessage.setText(" ");
            this.lblDecreaseMessage.setIcon(null);
        } else {
            this.lblDecreaseMessage.setText("0 " + this.languageCentre.getValue(LanguageConstant.RecordsFound));
            this.lblDecreaseMessage.setIcon(null);
        }
    }

    public void fillTopGainers(String result) {
        if (result.indexOf("=") >= 0) {
            this.tblGainer.fillTableWithPercentCalculate(result);
            this.lblGainerMessage.setText("  ");
            this.lblGainerMessage.setIcon(null);
        } else {
            this.lblGainerMessage.setText("0 " + this.languageCentre.getValue(LanguageConstant.RecordsFound));
            this.lblGainerMessage.setIcon(null);
        }
    }

    public void fillTopIncrease(String result) {
        if (result.indexOf("=") >= 0) {
            this.tblIncrease.fillTableWithPercentFromDB(result);
            this.lblIncreaseMessage.setText("  ");
            this.lblIncreaseMessage.setIcon(null);
        } else {
            this.lblIncreaseMessage.setText("0 " + this.languageCentre.getValue(LanguageConstant.RecordsFound));
            this.lblIncreaseMessage.setIcon(null);
        }
    }

    public void fillTopLeaders(String result) {
        if (result.indexOf("=") >= 0) {
            this.tblLeader.fillTableWithPercentCalculate(result);
            this.lblLeaderMessage.setText("  ");
            this.lblLeaderMessage.setIcon(null);
        } else {
            this.lblLeaderMessage.setText("0 " + this.languageCentre.getValue(LanguageConstant.RecordsFound));
            this.lblLeaderMessage.setIcon(null);
        }
    }

    public void fillTopLosers(String result) {
        if (result.indexOf("=") >= 0) {
            this.tblLoser.fillTableWithPercentCalculate(result);
            this.lblLoserMessage.setText(" ");
            this.lblLoserMessage.setIcon(null);
        } else {
            this.lblLoserMessage.setText("0 " + this.languageCentre.getValue(LanguageConstant.RecordsFound));
            this.lblLoserMessage.setIcon(null);
        }
    }

    public void PMEX_fillTopLeader(String result) {
        if (result.indexOf("=") >= 0) {
            this.tblLeader.PMEX_fillTableWithPercentFromDB(result);
            this.lblLeaderMessage.setText("  ");
            this.lblLeaderMessage.setIcon(null);
        } else {
            this.lblLeaderMessage.setText("0 " + this.languageCentre.getValue(LanguageConstant.RecordsFound));
            this.lblLeaderMessage.setIcon(null);
        }
    }

    public void PMEX_fillTopGainers(String result) {
        if (result.indexOf("=") >= 0) {
            this.tblGainer.PMEX_fillTableWithPercentFromDB(result);
            this.lblGainerMessage.setText("  ");
            this.lblGainerMessage.setIcon(null);
        } else {
            this.lblGainerMessage.setText("0 " + this.languageCentre.getValue(LanguageConstant.RecordsFound));
            this.lblGainerMessage.setIcon(null);
        }
    }

    public void PMEX_fillToplosers(String result) {
        if (result.indexOf("=") >= 0) {
            this.tblLoser.PMEX_fillTableWithPercentFromDB(result);
            this.lblLoserMessage.setText(" ");
            this.lblLoserMessage.setIcon(null);
        } else {
            this.lblLoserMessage.setText("0 " + this.languageCentre.getValue(LanguageConstant.RecordsFound));
            this.lblLoserMessage.setIcon(null);
        }
    }

    public void PMEX_fillTopDecrease(String result) {
        if (result.indexOf("=") >= 0) {
            this.tblDecrease.PMEX_fillTableWithPercentFromDB(result);
            this.lblDecreaseMessage.setText(" ");
            this.lblDecreaseMessage.setIcon(null);
        } else {
            this.lblDecreaseMessage.setText("0 " + this.languageCentre.getValue(LanguageConstant.RecordsFound));
            this.lblDecreaseMessage.setIcon(null);
        }
    }

    public void PMEX_fillTopIncrease(String result) {
        if (result.indexOf("=") >= 0) {
            this.tblIncrease.PMEX_fillTableWithPercentFromDB(result);
            this.lblIncreaseMessage.setText("  ");
            this.lblIncreaseMessage.setIcon(null);
        } else {
            this.lblIncreaseMessage.setText("0 " + this.languageCentre.getValue(LanguageConstant.RecordsFound));
            this.lblIncreaseMessage.setIcon(null);
        }
    }

    public void removeTable() {
        if (this.tblLeader != null) {
            this.tblLeader.removeTable();
        }
        if (this.tblLoser != null) {
            this.tblLoser.removeTable();
        }
        if (this.tblGainer != null) {
            this.tblGainer.removeTable();
        }
        if (this.tblIncrease != null) {
            this.tblIncrease.removeTable();
        }
        if (this.tblDecrease != null) {
            this.tblDecrease.removeTable();
        }
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.tbLeaders = new JPanel();
        this.tbGainer = new JPanel();
        this.tbIncrease = new JPanel();
        this.tbLosers = new JPanel();
        this.tbDecrease = new JPanel();
        this.setPreferredSize(new Dimension(315, 315));
        this.jTabbedPane1.setMaximumSize(new Dimension(310, 271));
        this.jTabbedPane1.setName("jTabbedPane1");
        this.jTabbedPane1.setPreferredSize(new Dimension(310, 271));
        this.jTabbedPane1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TopMovers.this.jTabbedPane1StateChanged(evt);
            }
        });
        this.tbLeaders.setName("tbLeaders");
        this.tbLeaders.setPreferredSize(new Dimension(300, 315));
        GroupLayout tbLeadersLayout = new GroupLayout(this.tbLeaders);
        this.tbLeaders.setLayout(tbLeadersLayout);
        tbLeadersLayout.setHorizontalGroup(tbLeadersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 310, Short.MAX_VALUE));
        tbLeadersLayout.setVerticalGroup(tbLeadersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 271, Short.MAX_VALUE));
        this.jTabbedPane1.addTab("By Volume", this.tbLeaders);
        this.tbGainer.setName("tbGainer");
        GroupLayout tbGainerLayout = new GroupLayout(this.tbGainer);
        this.tbGainer.setLayout(tbGainerLayout);
        tbGainerLayout.setHorizontalGroup(tbGainerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 310, Short.MAX_VALUE));
        tbGainerLayout.setVerticalGroup(tbGainerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 271, Short.MAX_VALUE));
        this.jTabbedPane1.addTab("By Price Increase", this.tbGainer);
        this.tbIncrease.setMaximumSize(new Dimension(310, 271));
        this.tbIncrease.setName("tbIncrease");
        this.tbIncrease.setRequestFocusEnabled(false);
        GroupLayout tbIncreaseLayout = new GroupLayout(this.tbIncrease);
        this.tbIncrease.setLayout(tbIncreaseLayout);
        tbIncreaseLayout.setHorizontalGroup(tbIncreaseLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 310, Short.MAX_VALUE));
        tbIncreaseLayout.setVerticalGroup(tbIncreaseLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 271, Short.MAX_VALUE));
        this.jTabbedPane1.addTab("By % Increase", this.tbIncrease);
        this.tbLosers.setMaximumSize(new Dimension(310, 271));
        this.tbLosers.setName("tbLosers");
        GroupLayout tbLosersLayout = new GroupLayout(this.tbLosers);
        this.tbLosers.setLayout(tbLosersLayout);
        tbLosersLayout.setHorizontalGroup(tbLosersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 310, Short.MAX_VALUE));
        tbLosersLayout.setVerticalGroup(tbLosersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 271, Short.MAX_VALUE));
        this.jTabbedPane1.addTab("By Price Decrease", this.tbLosers);
        this.tbDecrease.setMaximumSize(new Dimension(310, 271));
        this.tbDecrease.setName("tbDecrease");
        GroupLayout tbDecreaseLayout = new GroupLayout(this.tbDecrease);
        this.tbDecrease.setLayout(tbDecreaseLayout);
        tbDecreaseLayout.setHorizontalGroup(tbDecreaseLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 310, Short.MAX_VALUE));
        tbDecreaseLayout.setVerticalGroup(tbDecreaseLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 271, Short.MAX_VALUE));
        this.jTabbedPane1.addTab("By % Decrease", this.tbDecrease);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1, -1, 315, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1, -1, 315, Short.MAX_VALUE));
    }

    private void jTabbedPane1StateChanged(ChangeEvent evt) {
        this.removeTable();
        String title = this.jTabbedPane1.getTitleAt(this.jTabbedPane1.getSelectedIndex());
        if (this.formname == FormName.TopMovers) {
            if (title.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.ByVolume))) {
                this.lblLeaderMessage.setText(this.languageCentre.getValue(LanguageConstant.Loading));
                this.lblLeaderMessage.setIcon(this.loaderIcon);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(100L);
                            LoadLogs loadLogs = new LoadLogs("TopLeaders=", true);
                            new ThreadWithName(loadLogs, "TopLeaders").start();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }).start();
            } else if (title.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.ByPriceIncrease))) {
                this.lblGainerMessage.setText(this.languageCentre.getValue(LanguageConstant.Loading));
                this.lblGainerMessage.setIcon(this.loaderIcon);
                LoadLogs loadLogs = new LoadLogs("TopGainers=", true);
                new ThreadWithName(loadLogs, "TopGainers").start();
            } else if (title.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.ByPriceDecrease))) {
                this.lblLoserMessage.setText(this.languageCentre.getValue(LanguageConstant.Loading));
                this.lblLoserMessage.setIcon(this.loaderIcon);
                LoadLogs loadLogs = new LoadLogs("TopLosers=", true);
                new ThreadWithName(loadLogs, "TopLosers").start();
            } else if (title.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.ByPercentIncrease))) {
                this.lblIncreaseMessage.setText(this.languageCentre.getValue(LanguageConstant.Loading));
                this.lblIncreaseMessage.setIcon(this.loaderIcon);
                LoadLogs loadLogs = new LoadLogs("MarketPercentIncrease=", true);
                new ThreadWithName(loadLogs, "MarketPercentIncrease").start();
            } else if (title.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.ByPercentDecrease))) {
                this.lblDecreaseMessage.setText(this.languageCentre.getValue(LanguageConstant.Loading));
                this.lblDecreaseMessage.setIcon(this.loaderIcon);
                LoadLogs loadLogs = new LoadLogs("MarketPercentDecrease=", true);
                new ThreadWithName(loadLogs, "MarketPercentDecrease").start();
            }
        } else if (this.formname == FormName.PMEX_TopMovers) {
            if (title.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.ByVolume))) {
                this.lblLeaderMessage.setText(this.languageCentre.getValue(LanguageConstant.Loading));
                this.lblLeaderMessage.setIcon(this.loaderIcon);
                LoadLogs loadLogs = new LoadLogs("PMEX_GetTopLeaders=", true);
                new ThreadWithName(loadLogs, "PMEX_GetTopLeaders").start();
            } else if (title.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.ByPriceIncrease))) {
                this.lblGainerMessage.setText(this.languageCentre.getValue(LanguageConstant.Loading));
                this.lblGainerMessage.setIcon(this.loaderIcon);
                LoadLogs loadLogs = new LoadLogs("PMEX_GetTopGainers=", true);
                new ThreadWithName(loadLogs, "PMEX_GetTopGainers").start();
            } else if (title.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.ByPercentIncrease))) {
                this.lblIncreaseMessage.setText(this.languageCentre.getValue(LanguageConstant.Loading));
                this.lblIncreaseMessage.setIcon(this.loaderIcon);
                LoadLogs loadLogs = new LoadLogs("PMEX_GetMarketPercentIncrease=", true);
                new ThreadWithName(loadLogs, "PMEX_GetMarketPercentIncrease").start();
            } else if (title.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.ByPriceDecrease))) {
                this.lblLoserMessage.setText(this.languageCentre.getValue(LanguageConstant.Loading));
                this.lblLoserMessage.setIcon(this.loaderIcon);
                LoadLogs loadLogs = new LoadLogs("PMEX_GetTopLosers=", true);
                new ThreadWithName(loadLogs, "PMEX_GetTopLosers").start();
            } else if (title.equalsIgnoreCase(this.languageCentre.getValue(LanguageConstant.ByPercentDecrease))) {
                this.lblDecreaseMessage.setText(this.languageCentre.getValue(LanguageConstant.Loading));
                this.lblDecreaseMessage.setIcon(this.loaderIcon);
                LoadLogs loadLogs = new LoadLogs("PMEX_GetMarketPercentDecrease=", true);
                new ThreadWithName(loadLogs, "PMEX_GetMarketPercentDecrease").start();
            }
        }
    }

    private int getTabIndex(JTabbedPane tab, String title) {
        int ind = 0;
        for (int i = 0; i < tab.getTabCount(); ++i) {
            if (!title.equalsIgnoreCase(tab.getTitleAt(i))) continue;
            ind = i;
            break;
        }
        return ind;
    }

    private void setLanguageValues() {
        this.jTabbedPane1.setTitleAt(this.getTabIndex(this.jTabbedPane1, "By Volume"), this.languageCentre.getValue(LanguageConstant.ByVolume));
        this.jTabbedPane1.setTitleAt(this.getTabIndex(this.jTabbedPane1, "By Price Increase"), this.languageCentre.getValue(LanguageConstant.ByPriceIncrease));
        this.jTabbedPane1.setTitleAt(this.getTabIndex(this.jTabbedPane1, "By % Increase"), this.languageCentre.getValue(LanguageConstant.ByPercentIncrease));
        this.jTabbedPane1.setTitleAt(this.getTabIndex(this.jTabbedPane1, "By Price Decrease"), this.languageCentre.getValue(LanguageConstant.ByPriceDecrease));
        this.jTabbedPane1.setTitleAt(this.getTabIndex(this.jTabbedPane1, "By % Decrease"), this.languageCentre.getValue(LanguageConstant.ByPercentDecrease));
    }

    public void reload() {
        this.jTabbedPane1StateChanged(null);
    }
}

