/*
 * Decompiled with CFR 0.152.
 */
package windows;

import MyDocking.Mediator;
import MyDocking.TradeCast;
import chrriis.common.UIUtils;
import chrriis.dj.nativeswing.NSOption;
import chrriis.dj.nativeswing.swtimpl.NativeInterface;
import chrriis.dj.nativeswing.swtimpl.components.JWebBrowser;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserAdapter;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserEvent;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserListener;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserNavigationEvent;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserWindowOpeningEvent;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserWindowWillOpenEvent;
import common.gui.component.CloseListener;
import common.gui.component.CloseTabbedPane;
import common.gui.util.AppConfig;
import common.gui.util.FormName;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import languages.LanguageCentre;
import languages.LanguageConstant;
import windows.CheckBrowserJar;

public class WebBrowserFrame
extends JFrame {
    CheckBrowserJar cj;
    final CloseTabbedPane tabbedPane = new CloseTabbedPane();
    ImageIcon icon;
    Image temp;
    String jarName = "";
    private static boolean disposed = false;
    public static boolean LoadingInProgress = false;
    public static boolean FirstTimeCheck = true;
    private LanguageCentre languageCentre = new LanguageCentre();

    public WebBrowserFrame() {
        this.initComponents();
        try {
            this.LoadAfterDownload();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void checkJarFile() {
        if (LoadingInProgress) {
            Mediator.getInstance().println("Jar Laoding in Progress!");
            return;
        }
        if (!FirstTimeCheck) {
            this.LoadAfterDownload();
        }
    }

    public void LoadAfterDownload() {
        LoadingInProgress = false;
        this.icon = new ImageIcon(this.getClass().getResource("/Images/Browser.png"));
        this.temp = this.icon.getImage();
        this.setIconImage(this.temp);
        try {
            NativeInterface.open();
            UIUtils.setPreferredLookAndFeel();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.setTitle(this.languageCentre.getValue(LanguageConstant.TradeCastBrowser));
        Mediator.getInstance().setWebBrowser(this);
        KeyStroke stroke = KeyStroke.getKeyStroke("ESCAPE");
        InputMap inputMap = this.getRootPane().getInputMap(2);
        inputMap.put(stroke, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WebBrowserFrame.this.dispose();
            }
        });
        this.tabbedPane.addCloseListener(new CloseListener(){

            public void closeOperation(MouseEvent e, int overTabIndex) {
                if (WebBrowserFrame.this.tabbedPane.getTabCount() == 1) {
                    WebBrowserFrame.this.dispose();
                } else {
                    WebBrowserFrame.this.tabbedPane.removeTabAt(overTabIndex);
                }
            }
        });
        this.tabbedPane.setTabLayoutPolicy(1);
        this.add((Component)this.tabbedPane, "Center");
        this.setSize(new Dimension(800, 600));
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int w = this.getSize().width;
        int h = this.getSize().height;
        int x = (dim.width - w) / 2;
        int y = (dim.height - h) / 2;
        this.setLocation(x, y);
    }

    public void openURL(String url) {
        JWebBrowser newWebBrowser = new JWebBrowser(new NSOption[0]);
        newWebBrowser.setMenuBarVisible(false);
        WebBrowserFrame.addWebBrowserListener((JTabbedPane)this.tabbedPane, newWebBrowser);
        this.tabbedPane.addTab(url, (Component)newWebBrowser);
        newWebBrowser.navigate(url);
        this.toFront();
        this.setExtendedState(0);
    }

    private static void addWebBrowserListener(final JTabbedPane tabbedPane, final JWebBrowser webBrowser) {
        webBrowser.addWebBrowserListener((WebBrowserListener)new WebBrowserAdapter(){

            public void titleChanged(WebBrowserEvent e) {
                for (int i = 0; i < tabbedPane.getTabCount(); ++i) {
                    if (tabbedPane.getComponentAt(i) != webBrowser) continue;
                    if (i == 0) {
                        return;
                    }
                    tabbedPane.setTitleAt(i, webBrowser.getPageTitle());
                    break;
                }
            }

            public void windowWillOpen(WebBrowserWindowWillOpenEvent e) {
                JWebBrowser newWebBrowser = new JWebBrowser(new NSOption[0]);
                WebBrowserFrame.addWebBrowserListener(tabbedPane, newWebBrowser);
                tabbedPane.addTab("New Tab", (Component)newWebBrowser);
                e.setNewWebBrowser(newWebBrowser);
            }

            public void windowOpening(WebBrowserWindowOpeningEvent e) {
                e.getWebBrowser().setMenuBarVisible(false);
            }

            public void locationChanging(WebBrowserNavigationEvent e) {
                String[] sp;
                if (e.getNewResourceLocation().indexOf(AppConfig.SnapShotWindowLink) >= 0 && e.getNewResourceLocation().indexOf("#") >= 0 && (sp = e.getNewResourceLocation().split("#", -1)).length >= 2) {
                    Mediator.getInstance().openScripDetails(sp[1]);
                }
            }
        });
    }

    private void initComponents() {
        this.setDefaultCloseOperation(2);
        this.pack();
    }

    @Override
    public void dispose() {
        TradeCast.getInstance().DisposePanel(FormName.WebBrowser);
        super.dispose();
    }
}

