/*
 * Decompiled with CFR 0.152.
 */
package windows.bipl;

import MyDocking.Mediator;
import Utilities.LogsTC;
import common.gui.util.CompressManager;
import common.gui.util.LogCommon;
import common.gui.util.MessageType;
import common.gui.util.Util;
import common.services.WebService;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import languages.LanguageCentre;

public class CustomerVerificationBIPL
extends JPanel {
    private LanguageCentre languageCentre = new LanguageCentre();
    DefaultTableModel model = new DefaultTableModel();
    Map<String, String> CNICMap = new HashMap<String, String>();
    private JButton btnGet;
    private ButtonGroup buttonGroup1;
    public JComboBox cbAccountNo;
    private JRadioButton isAccountNo;
    private JRadioButton isCNIC;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel2;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JLabel lblMessage;
    private JLabel lblOrderHeader;
    private JLabel lblType;
    private JTextField txtAccountNo;
    private JTextField txtAccountTitle;
    private JTextField txtAddress;
    private JTextField txtBirthPlace;
    private JTextField txtCNICNo;
    private JTextField txtContactNo;
    private JTextField txtDateOfBirth;
    private JTextField txtEmail;
    private JTextField txtMotherName;
    private JTextField txtNTNNo;
    private JTextField txtUIN;

    public CustomerVerificationBIPL() {
        this.initComponents();
        this.lblOrderHeader.setText("<html> <b> Customer Verification </b> <html>");
        this.setAccounts();
        this.getAcountCNIC();
    }

    private void setAccounts() {
        this.cbAccountNo.setModel(new DefaultComboBoxModel<Object>(LogsTC.accountAll.keySet().toArray()));
    }

    private void setCNIC() {
        this.cbAccountNo.setModel(new DefaultComboBoxModel<Object>(this.CNICMap.keySet().toArray()));
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.lblMessage = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jPanel2 = new JPanel();
        this.jLabel8 = new JLabel();
        this.txtAccountTitle = new JTextField();
        this.jLabel9 = new JLabel();
        this.txtAccountNo = new JTextField();
        this.jLabel10 = new JLabel();
        this.txtCNICNo = new JTextField();
        this.jLabel11 = new JLabel();
        this.txtNTNNo = new JTextField();
        this.jLabel12 = new JLabel();
        this.txtEmail = new JTextField();
        this.jLabel13 = new JLabel();
        this.txtContactNo = new JTextField();
        this.jLabel14 = new JLabel();
        this.txtDateOfBirth = new JTextField();
        this.jLabel15 = new JLabel();
        this.txtMotherName = new JTextField();
        this.jLabel16 = new JLabel();
        this.txtAddress = new JTextField();
        this.jLabel17 = new JLabel();
        this.txtUIN = new JTextField();
        this.jLabel18 = new JLabel();
        this.txtBirthPlace = new JTextField();
        this.lblOrderHeader = new JLabel();
        this.jLabel1 = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.lblType = new JLabel();
        this.cbAccountNo = new JComboBox();
        this.btnGet = new JButton();
        this.isAccountNo = new JRadioButton();
        this.isCNIC = new JRadioButton();
        this.setLayout(null);
        this.lblMessage.setText(" ");
        this.add(this.lblMessage);
        this.lblMessage.setBounds(20, 325, 510, 20);
        this.add(this.jSeparator1);
        this.jSeparator1.setBounds(0, 315, 550, 3);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(" Account Information "));
        this.jLabel8.setText("Account Title");
        this.txtAccountTitle.setEditable(false);
        this.jLabel9.setText("Account No");
        this.txtAccountNo.setEditable(false);
        this.jLabel10.setText("CNIC No");
        this.txtCNICNo.setEditable(false);
        this.jLabel11.setText("NTN No");
        this.txtNTNNo.setEditable(false);
        this.jLabel12.setText("Email");
        this.txtEmail.setEditable(false);
        this.jLabel13.setText("Contact No");
        this.txtContactNo.setEditable(false);
        this.jLabel14.setText("Date Of Birth");
        this.txtDateOfBirth.setEditable(false);
        this.jLabel15.setText("Mother Name");
        this.txtMotherName.setEditable(false);
        this.jLabel16.setText("Address");
        this.txtAddress.setEditable(false);
        this.jLabel17.setText("UIN");
        this.txtUIN.setEditable(false);
        this.jLabel18.setText("Birth Place");
        this.txtBirthPlace.setEditable(false);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel16, -2, 80, -2).addGap(10, 10, 10).addComponent(this.txtAddress)).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel8, -2, 80, -2).addGap(10, 10, 10).addComponent(this.txtAccountTitle, -2, 150, -2)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel15, -2, 80, -2).addGap(10, 10, 10).addComponent(this.txtMotherName, -2, 150, -2)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel14, -2, 80, -2).addGap(10, 10, 10).addComponent(this.txtDateOfBirth, -2, 150, -2)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel10, -2, 80, -2).addGap(10, 10, 10).addComponent(this.txtCNICNo, -2, 150, -2)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel12, -2, 80, -2).addGap(10, 10, 10).addComponent(this.txtEmail, -2, 150, -2))).addGap(18, 18, 18).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel9, -2, 80, -2).addComponent(this.jLabel11, -2, 80, -2).addComponent(this.jLabel13, -2, 80, -2).addComponent(this.jLabel18, -2, 80, -2).addComponent(this.jLabel17, -2, 80, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtAccountNo, -2, 150, -2).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtNTNNo, GroupLayout.Alignment.TRAILING, -2, 150, -2).addComponent(this.txtContactNo, GroupLayout.Alignment.TRAILING, -2, 150, -2).addComponent(this.txtBirthPlace, GroupLayout.Alignment.TRAILING, -2, 150, -2).addComponent(this.txtUIN, GroupLayout.Alignment.TRAILING, -2, 150, -2))))).addContainerGap(16, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel8, -2, 22, -2).addComponent(this.txtAccountTitle, -2, 22, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel10, -2, 22, -2).addComponent(this.txtCNICNo, -2, 22, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel12, -2, 22, -2).addComponent(this.txtEmail, -2, 22, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel14, -2, 22, -2).addComponent(this.txtDateOfBirth, -2, 22, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel15, -2, 22, -2).addComponent(this.txtMotherName, -2, 22, -2))).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel9, -2, 22, -2).addComponent(this.txtAccountNo, -2, 22, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel11, -2, 22, -2).addComponent(this.txtNTNNo, -2, 22, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel13, -2, 22, -2).addComponent(this.txtContactNo, -2, 22, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel18, -2, 22, -2).addComponent(this.txtBirthPlace, -2, 22, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel17, -2, 22, -2).addComponent(this.txtUIN, -2, 22, -2)))).addGap(11, 11, 11).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel16, -2, 22, -2).addComponent(this.txtAddress, -2, 22, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.add(this.jPanel2);
        this.jPanel2.setBounds(10, 110, 530, 200);
        this.lblOrderHeader.setIcon(new ImageIcon(this.getClass().getResource("/Images/customerVerification48.png")));
        this.lblOrderHeader.setText("-------");
        this.add(this.lblOrderHeader);
        this.lblOrderHeader.setBounds(28, 0, 360, 60);
        this.jLabel1.setBackground(new Color(255, 255, 255));
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/Images/HeaderBG.png")));
        this.jLabel1.setOpaque(true);
        this.add(this.jLabel1);
        this.jLabel1.setBounds(0, 0, 550, 60);
        this.add(this.jSeparator2);
        this.jSeparator2.setBounds(0, 60, 550, 3);
        this.lblType.setText("Account No");
        this.add(this.lblType);
        this.lblType.setBounds(20, 80, 70, 23);
        this.cbAccountNo.setEditable(true);
        this.cbAccountNo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                CustomerVerificationBIPL.this.cbAccountNoItemStateChanged(evt);
            }
        });
        this.add(this.cbAccountNo);
        this.cbAccountNo.setBounds(90, 80, 160, 23);
        this.btnGet.setIcon(new ImageIcon(this.getClass().getResource("/Images/get.png")));
        this.btnGet.setText("Get");
        this.btnGet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomerVerificationBIPL.this.btnGetActionPerformed(evt);
            }
        });
        this.add(this.btnGet);
        this.btnGet.setBounds(430, 80, 100, 23);
        this.buttonGroup1.add(this.isAccountNo);
        this.isAccountNo.setSelected(true);
        this.isAccountNo.setText("Account No");
        this.isAccountNo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomerVerificationBIPL.this.isAccountNoActionPerformed(evt);
            }
        });
        this.add(this.isAccountNo);
        this.isAccountNo.setBounds(260, 80, 90, 23);
        this.buttonGroup1.add(this.isCNIC);
        this.isCNIC.setText("CNIC");
        this.isCNIC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomerVerificationBIPL.this.isCNICActionPerformed(evt);
            }
        });
        this.add(this.isCNIC);
        this.isCNIC.setBounds(360, 80, 70, 23);
    }

    private void cbAccountNoItemStateChanged(ItemEvent evt) {
    }

    private void btnGetActionPerformed(ActionEvent evt) {
        if (this.cbAccountNo.getSelectedItem() == null) {
            if (this.isAccountNo.isSelected()) {
                Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Error, (String)"Please select Account No");
            } else {
                Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Error, (String)"Please select CNIC");
            }
            this.cbAccountNo.requestFocus();
        } else if (this.cbAccountNo.getSelectedItem().toString().trim().length() <= 0) {
            if (this.isAccountNo.isSelected()) {
                Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Error, (String)"Please select Account No");
            } else {
                Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Error, (String)"Please select CNIC");
            }
            this.cbAccountNo.requestFocus();
            this.cbAccountNo.requestFocus();
        } else {
            this.reset();
            this.getCustomerInfo();
        }
    }

    private void isAccountNoActionPerformed(ActionEvent evt) {
        this.lblType.setText("Account No");
        this.setAccounts();
    }

    private void isCNICActionPerformed(ActionEvent evt) {
        this.lblType.setText("CNIC");
        this.setCNIC();
    }

    private void getAcountCNIC() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Util.setMessage((JLabel)CustomerVerificationBIPL.this.lblMessage, (MessageType)MessageType.Loading, (String)"Loading information");
                try {
                    String result = CompressManager.unzipStringFromBytes((byte[])WebService.getInstance().getPort().getCompressedData(LogCommon.UserID, "AccountCNIC=", ""));
                    Mediator.getInstance().println("GetAcountCNIC = " + result);
                    System.out.println("GetAcountCNIC = " + result);
                    if (result.contains("|")) {
                        String[] data;
                        for (String rowData : data = result.split("\\|", -1)) {
                            if (!rowData.contains(";")) continue;
                            String[] row = rowData.split("\\;", -1);
                            CustomerVerificationBIPL.this.CNICMap.put(row[1], row[0]);
                        }
                    } else {
                        Util.setMessage((JLabel)CustomerVerificationBIPL.this.lblMessage, (MessageType)MessageType.Information, (String)"No record found");
                    }
                }
                catch (Exception ex) {
                    Util.setMessage((JLabel)CustomerVerificationBIPL.this.lblMessage, (MessageType)MessageType.Error, (String)"Error in loading");
                    ex.printStackTrace();
                    Mediator.getInstance().WriteExceptionInClientMachine(ex);
                }
                Util.setMessage((JLabel)CustomerVerificationBIPL.this.lblMessage, (MessageType)MessageType.EMPTY, (String)"");
            }
        }).start();
    }

    private void getCustomerInfo() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Util.setMessage((JLabel)CustomerVerificationBIPL.this.lblMessage, (MessageType)MessageType.Loading, (String)"Loading information");
                try {
                    String accountNo = "";
                    if (CustomerVerificationBIPL.this.isAccountNo.isSelected()) {
                        accountNo = CustomerVerificationBIPL.this.cbAccountNo.getSelectedItem().toString();
                    } else {
                        String cnic = CustomerVerificationBIPL.this.cbAccountNo.getSelectedItem().toString();
                        if (CustomerVerificationBIPL.this.CNICMap.containsKey(cnic)) {
                            accountNo = CustomerVerificationBIPL.this.CNICMap.get(cnic);
                        }
                    }
                    String result = WebService.getInstance().getPort().getInfo(LogCommon.UserID, "GetCustomerInfo=", accountNo);
                    Mediator.getInstance().println("GetCustomerInfo = " + result);
                    System.out.println("GetCustomerInfo = " + result);
                    if (result.contains(";")) {
                        String[] data = result.split("\\;", -1);
                        for (int i = 1; i < data.length; ++i) {
                            String rowData = data[i];
                            if (!rowData.contains(",")) continue;
                            String[] row = rowData.split("\\,", -1);
                            CustomerVerificationBIPL.this.txtAccountTitle.setText(row[0]);
                            CustomerVerificationBIPL.this.txtAccountNo.setText(row[1]);
                            CustomerVerificationBIPL.this.txtCNICNo.setText(row[2]);
                            CustomerVerificationBIPL.this.txtNTNNo.setText(row[3]);
                            CustomerVerificationBIPL.this.txtEmail.setText(row[4]);
                            CustomerVerificationBIPL.this.txtContactNo.setText(row[5]);
                            CustomerVerificationBIPL.this.txtDateOfBirth.setText(row[6]);
                            CustomerVerificationBIPL.this.txtMotherName.setText(row[7]);
                            CustomerVerificationBIPL.this.txtAddress.setText(row[8]);
                            CustomerVerificationBIPL.this.txtUIN.setText(row[9]);
                            CustomerVerificationBIPL.this.txtBirthPlace.setText(row[10]);
                        }
                    } else {
                        Util.setMessage((JLabel)CustomerVerificationBIPL.this.lblMessage, (MessageType)MessageType.Information, (String)"No record found");
                    }
                }
                catch (Exception ex) {
                    Util.setMessage((JLabel)CustomerVerificationBIPL.this.lblMessage, (MessageType)MessageType.Error, (String)"Error in loading");
                    ex.printStackTrace();
                    Mediator.getInstance().WriteExceptionInClientMachine(ex);
                }
                Util.setMessage((JLabel)CustomerVerificationBIPL.this.lblMessage, (MessageType)MessageType.EMPTY, (String)"");
            }
        }).start();
    }

    private void reset() {
        Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.EMPTY, (String)"");
        this.txtAccountTitle.setText("");
        this.txtAccountNo.setText("");
        this.txtCNICNo.setText("");
        this.txtNTNNo.setText("");
        this.txtEmail.setText("");
        this.txtContactNo.setText("");
        this.txtDateOfBirth.setText("");
        this.txtMotherName.setText("");
        this.txtAddress.setText("");
        this.txtUIN.setText("");
        this.txtBirthPlace.setText("");
    }
}

