/*
 * Decompiled with CFR 0.152.
 */
package windows.js;

import Control.JasperFileChooser;
import Control.ReportControl;
import Control.ReportControlEvent;
import Control.ReportControlListener;
import CustomComponent.MyTime;
import MyDocking.Mediator;
import RendersNModels.CustodyNetSharesRender;
import Utilities.CompressManager;
import Utilities.LogsTC;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import common.gui.component.NxGTable;
import common.gui.util.AppConfig;
import common.gui.util.LogCommon;
import common.gui.util.MessageType;
import common.gui.util.Util;
import common.services.WebService;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import languages.LanguageCentre;
import languages.LanguageConstant;
import reports.Jasper_Report;
import reports.Report_CustodyNetShares;

public class CustodyNetShares
extends JPanel
implements ReportControlListener {
    private AutoCompleteSupport autoCom;
    private AutoCompleteSupport autoCompleteScrip;
    Vector<String> column = new Vector();
    Vector rows = new Vector();
    DefaultTableModel model = null;
    CustodyNetSharesRender render = null;
    JTextComponent editorScrip;
    String log = "";
    private LanguageCentre languageCentre = new LanguageCentre();
    private JButton btnGet;
    public JComboBox cbAccountNo;
    public JComboBox cbScrip;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JLabel lblMsg;
    private ReportControl reportControl1;
    private NxGTable table;
    public String JRXMLFileName = "CustodyNetShares.jrxml";

    public CustodyNetShares() {
        this.initComponents();
        this.setAccount();
        this.setAllScrip();
        this.initTable();
        this.editorScrip = (JTextComponent)this.cbScrip.getEditor().getEditorComponent();
        this.editorScrip.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                CustodyNetShares.this.setData(CustodyNetShares.this.log);
            }
        });
        this.reportControl1.addListener(this);
    }

    public void setAllScrip() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    if (CustodyNetShares.this.autoCompleteScrip != null && CustodyNetShares.this.autoCompleteScrip.isInstalled()) {
                        CustodyNetShares.this.autoCompleteScrip.uninstall();
                    }
                    Vector allScrip = new Vector(LogCommon.SymbolAndSymbolName.keySet());
                    allScrip.addElement("ALL");
                    Collections.sort(allScrip);
                    CustodyNetShares.this.cbScrip.setModel(new DefaultComboBoxModel(allScrip));
                    CustodyNetShares.this.autoCompleteScrip = AutoCompleteSupport.install((JComboBox)CustodyNetShares.this.cbScrip, (EventList)GlazedLists.eventListOf((Object[])allScrip.toArray()));
                    CustodyNetShares.this.cbScrip.setSelectedItem("ALL");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    private void initTable() {
        this.column.add("Account");
        this.column.add("Security Name");
        this.column.add("Scrip");
        this.column.add("Custody Balance");
        this.column.add("Phy.Tradable");
        this.column.add("CDC Tradable");
        this.column.add("Registered");
        this.column.add("Unregistered");
        this.column.add("Corp.Act");
        this.column.add("Regular");
        this.column.add("Spot");
        this.column.add("Forward");
        this.column.add("Net");
        this.column.add("Closing Rate");
        this.column.add("Amount");
        this.model = new DefaultTableModel(this.rows, this.column){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.setRender();
        this.table.setModel((TableModel)this.model);
        this.table.setColumnControlVisible(false);
        this.table.setSelectionMode(0);
        this.table.setAutoResizeMode(0);
        this.table.setSortable(false);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.getColumn(0).setPreferredWidth(150);
    }

    void setRender() {
        this.render = new CustodyNetSharesRender();
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            this.table.getColumn(i).setCellRenderer(this.render);
        }
    }

    private void tableDataChange() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.model.fireTableDataChanged();
            this.table.addNotify();
            this.table.repaint();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CustodyNetShares.this.model.fireTableDataChanged();
                    CustodyNetShares.this.table.addNotify();
                    CustodyNetShares.this.table.repaint();
                }
            });
        }
    }

    private void setAccount() {
        ArrayList<String> allAccount = new ArrayList<String>();
        for (String s : LogsTC.accountAll.keySet()) {
            allAccount.add(s);
        }
        Collections.sort(allAccount);
        allAccount.add(0, "ALL");
        this.cbAccountNo.setModel(new DefaultComboBoxModel<Object>(allAccount.toArray()));
        this.autoCom = AutoCompleteSupport.install((JComboBox)this.cbAccountNo, (EventList)GlazedLists.eventListOf((Object[])allAccount.toArray()));
        this.cbAccountNo.setSelectedItem("ALL");
    }

    private boolean checkValidate() {
        if (this.cbAccountNo.getSelectedItem() == null) {
            Util.setMessage((JLabel)this.lblMsg, (MessageType)MessageType.Information, (String)"Please select account");
            this.cbAccountNo.requestFocus();
            return false;
        }
        if (this.cbAccountNo.getSelectedItem().toString().length() <= 0) {
            Util.setMessage((JLabel)this.lblMsg, (MessageType)MessageType.Information, (String)"Please select account");
            this.cbAccountNo.requestFocus();
            return false;
        }
        return true;
    }

    private Vector getRowParse(String row) {
        try {
            String scrip = this.editorScrip.getText();
            if (row.indexOf("|") > 0) {
                int i;
                String[] pipeSeparate = row.split("\\|", -1);
                Vector<Object> rowSum = new Vector<Object>();
                for (i = 0; i < pipeSeparate.length - 1; ++i) {
                    String[] semiColonSeparator = pipeSeparate[i].toString().split("\\;", -1);
                    Vector<String> v = new Vector<String>();
                    for (int j = 0; j < semiColonSeparator.length; ++j) {
                        v.addElement(semiColonSeparator[j]);
                    }
                    if (scrip.equalsIgnoreCase("") || scrip.equalsIgnoreCase("ALL")) {
                        this.rows.addElement(v);
                        continue;
                    }
                    if (v.get(2).toString().indexOf(scrip) != 0) continue;
                    this.rows.addElement(v);
                }
                for (int k = 0; k < this.column.size(); ++k) {
                    if (k == 0) {
                        rowSum.addElement("Grand Total");
                        continue;
                    }
                    if (k == 1 || k == 2) {
                        rowSum.addElement("");
                        continue;
                    }
                    rowSum.addElement(0);
                }
                for (i = 0; i < this.rows.size(); ++i) {
                    Vector vector = (Vector)this.rows.elementAt(i);
                    for (int j = 0; j < vector.size(); ++j) {
                        String string = (String)vector.elementAt(j);
                        if (j <= 2 || string.length() <= 1) continue;
                        try {
                            rowSum.setElementAt(Double.parseDouble(rowSum.get(j).toString()) + Double.parseDouble(string), j);
                            continue;
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
                if (rowSum.size() > 0) {
                    this.rows.addElement(rowSum);
                }
            } else {
                Util.setMessage((JLabel)this.lblMsg, (MessageType)MessageType.Information, (String)"No record found");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Mediator.getInstance().PrintLog(ex, row);
        }
        return this.rows;
    }

    private Vector<String> getColumnParse(String colName) {
        try {
            String[] pipeSeparate = colName.split("\\$", -1);
            String[] semiColonSeparator = pipeSeparate[0].toString().split("\\;", -1);
            this.column.clear();
            for (int i = 0; i < semiColonSeparator.length - 1; ++i) {
                if (semiColonSeparator[i].trim().length() <= 0) continue;
                this.column.add(semiColonSeparator[i]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return this.column;
    }

    private synchronized void setData(String result) {
        this.rows.clear();
        if (result.indexOf("$") > 0) {
            String[] colSep = result.split("\\$", -1);
            this.model.setDataVector(this.getRowParse(colSep[1]), this.getColumnParse(colSep[0]));
            this.table.setModel((TableModel)this.model);
            this.setRender();
            this.table.packAll();
        } else {
            Util.setMessage((JLabel)this.lblMsg, (MessageType)MessageType.Information, (String)"No record found");
        }
        this.tableDataChange();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.table = new NxGTable();
        this.jSeparator1 = new JSeparator();
        this.lblMsg = new JLabel();
        this.cbAccountNo = new JComboBox();
        this.jLabel1 = new JLabel();
        this.btnGet = new JButton();
        this.reportControl1 = new ReportControl();
        this.jLabel2 = new JLabel();
        this.cbScrip = new JComboBox();
        this.table.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView((Component)this.table);
        this.cbAccountNo.setEditable(true);
        this.jLabel1.setText("Account");
        this.btnGet.setIcon(new ImageIcon(this.getClass().getResource("/Images/get.png")));
        this.btnGet.setText("Get");
        this.btnGet.setMaximumSize(new Dimension(49, 22));
        this.btnGet.setMinimumSize(new Dimension(49, 22));
        this.btnGet.setName("CustodyNetShares -> btnGet");
        this.btnGet.setPreferredSize(new Dimension(49, 22));
        this.btnGet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustodyNetShares.this.btnGetActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Scrip");
        this.cbScrip.setEditable(true);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblMsg, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1, -1, 540, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel2, -2, 53, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.cbAccountNo, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnGet, -2, 75, -2)).addComponent(this.cbScrip, -2, 100, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.reportControl1, -2, -1, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbAccountNo, -2, -1, -2).addComponent(this.btnGet, -2, -1, -2)).addComponent(this.reportControl1, -1, 24, Short.MAX_VALUE).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2, -2, 23, -2).addComponent(this.cbScrip, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 80, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, -1, -2).addGap(5, 5, 5).addComponent(this.lblMsg, -2, 18, -2)));
    }

    private void btnGetActionPerformed(ActionEvent evt) {
        this.getData();
    }

    @Override
    public void ReportControl_Print(ReportControlEvent e) {
        Report_CustodyNetShares Report = new Report_CustodyNetShares(this.JRXMLFileName, this.table.getModel());
        this.SetParameter((Jasper_Report)Report);
        if (!Report.isHasPage()) {
            return;
        }
        Report.PrintReport();
    }

    @Override
    public void ReportControl_Save(ReportControlEvent e) {
        String FileName;
        boolean result;
        Report_CustodyNetShares Report = new Report_CustodyNetShares(this.JRXMLFileName, this.table.getModel());
        this.SetParameter((Jasper_Report)Report);
        if (!Report.isHasPage()) {
            return;
        }
        JasperFileChooser fc = new JasperFileChooser(new File(""));
        fc.setSelectedFile(new File("Custody Net Shares-" + MyTime.getInstance().getDate()));
        fc.addAllJasperChoosableFileFilter();
        fc.setAcceptAllFileFilterUsed(false);
        fc.showSaveDialog(this);
        if (fc.getSelectedFile() != null && !(result = Report.Export(FileName = fc.getSelectedFile().getAbsolutePath() + "." + fc.getExtenstion()))) {
            JOptionPane.showMessageDialog(null, "Error in saving file.");
        }
    }

    @Override
    public void ReportControl_Pdf(ReportControlEvent e) {
        int Option;
        String FileName;
        boolean result;
        Report_CustodyNetShares Report = new Report_CustodyNetShares(this.JRXMLFileName, this.table.getModel());
        this.SetParameter((Jasper_Report)Report);
        if (!Report.isHasPage()) {
            return;
        }
        JasperFileChooser fc = new JasperFileChooser(new File(""));
        fc.setSelectedFile(new File("Custody Net Shares-" + MyTime.getInstance().getDate()));
        fc.addPdfFileFilter();
        fc.showSaveDialog(this);
        if (fc.getSelectedFile() != null && (result = Report.ExportToPdf(FileName = fc.getSelectedFile().getAbsolutePath().replaceAll("\"", "") + "." + fc.getExtenstion())) && (Option = JOptionPane.showConfirmDialog(null, "Custody Net Shares report created. Do you want to open it?", "PDF", 0)) == 0) {
            try {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + FileName);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void ReportControl_View(ReportControlEvent e) {
        Report_CustodyNetShares Report = new Report_CustodyNetShares(this.JRXMLFileName, this.table.getModel());
        this.SetParameter((Jasper_Report)Report);
        if (!Report.isHasPage()) {
            return;
        }
        Report.generateReport();
    }

    @Override
    public void ReportControl_CustomExport(ReportControlEvent e) {
    }

    private void SetParameter(Jasper_Report Report) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("Title", AppConfig.companyName);
        param.put("Time", MyTime.getInstance().getTime());
        param.put("PrintDate", MyTime.getInstance().getTimeAndDateForReport());
        param.put("FromDate", MyTime.getInstance().getDate());
        param.put("AccountNo", this.cbAccountNo.getSelectedItem().toString());
        param.put("Scrip", this.cbScrip.getSelectedItem().toString());
        param.put("UserID", LogCommon.UserID);
        Report.SetParameter(param);
    }

    private void getData() {
        if (this.checkValidate()) {
            new Thread("CustodyNetShares"){

                @Override
                public void run() {
                    try {
                        Util.setMessage((JLabel)CustodyNetShares.this.lblMsg, (MessageType)MessageType.Loading, (String)CustodyNetShares.this.languageCentre.getValue(LanguageConstant.Loading));
                        CustodyNetShares.this.log = "";
                        CustodyNetShares.this.rows.clear();
                        CustodyNetShares.this.tableDataChange();
                        byte[] data = WebService.getInstance().getPort().getOrderHistory(LogCommon.UserID, CustodyNetShares.this.cbAccountNo.getSelectedItem().toString(), "", "", "", "", "", "CustodyNetShares");
                        String result = CompressManager.unzipStringFromBytes(data);
                        Util.setMessage((JLabel)CustodyNetShares.this.lblMsg, (MessageType)MessageType.EMPTY, (String)"");
                        CustodyNetShares.this.log = result;
                        CustodyNetShares.this.setData(result);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        Util.setMessage((JLabel)CustodyNetShares.this.lblMsg, (MessageType)MessageType.Error, (String)"Error in loading data");
                    }
                }
            }.start();
        }
    }
}

