/*
 * Decompiled with CFR 0.152.
 */
package windows.js;

import MyDocking.Mediator;
import common.gui.util.LogCommon;
import common.gui.util.MessageType;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import windows.js.JSAccount;
import windows.js.JSFooter;
import windows.js.JSOpenPositionDetail;
import windows.js.JSPortfolioDetail;
import windows.js.JSSummary;

public class JSExposure
extends JPanel {
    JSAccount account = null;
    JSFooter footer = new JSFooter();
    JSPortfolioDetail porfolio;
    JSOpenPositionDetail openPosition;
    String temp;
    private JPanel pnlAccount;
    private JPanel pnlFooter;
    public JPanel pnlHolder;

    public JSExposure() {
        this.porfolio = new JSPortfolioDetail(this.footer.lblMessage);
        this.openPosition = new JSOpenPositionDetail(this.footer.lblMessage);
        this.temp = "";
        this.initComponents();
        this.account = new JSAccount(this, this.footer.lblMessage);
        LogCommon.isExposureOpen = true;
        this.pnlAccount.add(this.account);
        this.pnlFooter.add(this.footer);
        this.setData(this.temp);
        Mediator.getInstance().setExposure(this);
    }

    public void reset() {
        this.porfolio.reset();
        this.openPosition.reset();
        this.pnlHolder.removeAll();
    }

    public void setData(String result) {
        this.reset();
        Mediator.getInstance().println("JS Exposure = " + result);
        if (result.equalsIgnoreCase("Invalid Account")) {
            this.account.setMessage(this.footer.lblMessage, MessageType.Error, "Invalid Account");
        } else if (result.indexOf("^") > 0) {
            String[] val = result.split("\\^", -1);
            this.setSummary(val[0]);
            this.porfolio.setPortfolio(val[1]);
            this.porfolio.IsModelExist = false;
            this.pnlHolder.add(this.porfolio);
            if (val.length == 3) {
                this.openPosition.setPortfolio(val[2]);
                this.openPosition.IsModelExist = false;
                this.pnlHolder.add(this.openPosition);
            }
        } else {
            this.account.setMessage(this.footer.lblMessage, MessageType.Error, "Error in loading Exposure Watch");
        }
        this.tableDataChange();
    }

    private void tableDataChange() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.pnlHolder.revalidate();
            this.pnlHolder.repaint();
            this.revalidate();
            this.repaint();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JSExposure.this.pnlHolder.revalidate();
                    JSExposure.this.pnlHolder.repaint();
                    JSExposure.this.revalidate();
                    JSExposure.this.repaint();
                }
            });
        }
    }

    private void initComponents() {
        this.pnlAccount = new JPanel();
        this.pnlHolder = new JPanel();
        this.pnlFooter = new JPanel();
        this.pnlAccount.setLayout(new BoxLayout(this.pnlAccount, 2));
        this.pnlHolder.setLayout(new BoxLayout(this.pnlHolder, 1));
        this.pnlFooter.setLayout(new BoxLayout(this.pnlFooter, 2));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlAccount, -1, 164, Short.MAX_VALUE).addComponent(this.pnlHolder, -1, -1, Short.MAX_VALUE).addComponent(this.pnlFooter, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.pnlAccount, -2, 42, -2).addGap(1, 1, 1).addComponent(this.pnlHolder, -1, 96, Short.MAX_VALUE).addGap(1, 1, 1).addComponent(this.pnlFooter, -2, 24, -2)));
    }

    private void setSummary(String result) {
        if (result.indexOf("*") >= 0) {
            String[] summaries = result.split("\\*", -1);
            for (int i = 0; i < summaries.length; ++i) {
                String summary = summaries[i];
                if (summary.indexOf("%") <= 0) continue;
                String[] values = summary.split("%", -1);
                JSSummary sum = new JSSummary();
                sum.setSummary(values[0], values[1]);
                this.pnlHolder.add(sum);
            }
        }
    }

    public void getFocus() {
        this.account.getFocus();
    }
}

