/*
 * Decompiled with CFR 0.152.
 */
package windows.js;

import CustomComponent.NxGLabelGradeint;
import CustomComponent.NxGTableCellRender;
import RendersNModels.OpenPositionModel;
import common.gui.util.AppConfig;
import common.gui.util.MyColors;
import common.gui.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;

public class JSPortfolioDetail
extends JPanel {
    Position openPosition = new Position();
    public DefaultTableModel model = null;
    Vector openColumns = new Vector();
    public Vector openRow = new Vector();
    ImageIcon loaderIcon = new ImageIcon(this.getClass().getResource(AppConfig.loaderIconPath));
    public boolean IsModelExist = false;
    ArrayList DataType = new ArrayList();
    public double[] Total;
    private PositionTableCellRenderer render = new PositionTableCellRenderer();
    private JLabel lblMessage = null;
    private JScrollPane jScrollPane2;
    private JTable table;

    public JSPortfolioDetail(JLabel lbl) {
        this.initComponents();
        this.lblMessage = lbl;
    }

    public synchronized void setPortfolio(String msg) {
        this.openPosition.fillPosition(msg);
    }

    private void initComponents() {
        this.jScrollPane2 = new JScrollPane();
        this.table = new JTable();
        this.setBorder(BorderFactory.createTitledBorder(null, " Portfolio Details", 0, 0, new Font("Tahoma", 1, 10)));
        this.table.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.table.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane2.setViewportView(this.table);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(2, 2, 2).addComponent(this.jScrollPane2, -1, 80, Short.MAX_VALUE).addGap(2, 2, 2)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(2, 2, 2).addComponent(this.jScrollPane2, -1, 87, Short.MAX_VALUE)));
    }

    public void reset() {
        this.openPosition.removeOpenTable();
    }

    public JTable getTable() {
        return this.table;
    }

    private class Position {
        public synchronized void fillPosition(String msg) {
            JSPortfolioDetail.this.lblMessage.setText("");
            JSPortfolioDetail.this.lblMessage.setIcon(null);
            this.removeOpenTable();
            if (msg.indexOf("|") < 0) {
                JSPortfolioDetail.this.lblMessage.setForeground(MyColors.successMessageFG);
                JSPortfolioDetail.this.lblMessage.setText("No record found");
                JSPortfolioDetail.this.lblMessage.setIcon(null);
                return;
            }
            boolean Added = false;
            String[] str = msg.trim().split("\\|", -1);
            JSPortfolioDetail.this.openColumns.clear();
            String[] Header = str[0].split("\\;", -1);
            for (int i = 0; i < Header.length; ++i) {
                JSPortfolioDetail.this.openColumns.add(Header[i]);
            }
            JSPortfolioDetail.this.DataType.clear();
            if (str.length < 2) {
                JSPortfolioDetail.this.lblMessage.setForeground(MyColors.successMessageFG);
                JSPortfolioDetail.this.lblMessage.setText("No record found");
                JSPortfolioDetail.this.lblMessage.setIcon(null);
                return;
            }
            for (int rowS = 1; rowS < str.length; ++rowS) {
                Vector<String> row = new Vector<String>();
                if (str[rowS].length() <= 0) continue;
                String[] str2 = str[rowS].split("\\;", -1);
                if (str2.length <= 0) {
                    JSPortfolioDetail.this.lblMessage.setForeground(MyColors.successMessageFG);
                    JSPortfolioDetail.this.lblMessage.setText("No record found");
                    JSPortfolioDetail.this.lblMessage.setIcon(null);
                    return;
                }
                for (int col = 0; col < str2.length; ++col) {
                    String s = str2[col].replaceAll("\\,", "");
                    row.addElement(String.valueOf(s));
                    if (rowS != 1) continue;
                    this.SetDataType(s);
                }
                Added = true;
                JSPortfolioDetail.this.openRow.addElement(row);
            }
            if (Added && JSPortfolioDetail.this.IsModelExist) {
                JSPortfolioDetail.this.table.addNotify();
            }
            if (!JSPortfolioDetail.this.IsModelExist) {
                JSPortfolioDetail.this.IsModelExist = true;
                JSPortfolioDetail.this.model = new OpenPositionModel(JSPortfolioDetail.this.openRow, JSPortfolioDetail.this.openColumns);
                JSPortfolioDetail.this.table.setModel(JSPortfolioDetail.this.model);
                JSPortfolioDetail.this.table.setRowHeight(AppConfig.rowHeight);
                JSPortfolioDetail.this.table.setSelectionMode(0);
                for (int k = 0; k < JSPortfolioDetail.this.openColumns.size(); ++k) {
                    JSPortfolioDetail.this.table.getColumn(JSPortfolioDetail.this.openColumns.elementAt(k)).setCellRenderer(JSPortfolioDetail.this.render);
                }
                JSPortfolioDetail.this.table.setAutoCreateRowSorter(false);
                JTableHeader header = JSPortfolioDetail.this.table.getTableHeader();
                ((JLabel)((Object)header.getDefaultRenderer())).setHorizontalAlignment(0);
            }
            if (JSPortfolioDetail.this.table.getRowCount() > 1) {
                JSPortfolioDetail.this.lblMessage.setText(Util.format0digit((String)(JSPortfolioDetail.this.table.getRowCount() + "".trim().replaceAll("\\,", ""))) + " records found.");
            } else {
                JSPortfolioDetail.this.lblMessage.setText(Util.format0digit((String)(JSPortfolioDetail.this.table.getRowCount() + "".trim().replaceAll("\\,", ""))) + " record found.");
            }
            JSPortfolioDetail.this.lblMessage.setIcon(null);
            this.tableDataChange();
            JSPortfolioDetail.this.repaint();
        }

        private void tableDataChange() {
            if (SwingUtilities.isEventDispatchThread()) {
                if (JSPortfolioDetail.this.model != null) {
                    JSPortfolioDetail.this.model.fireTableDataChanged();
                }
                JSPortfolioDetail.this.table.addNotify();
                JSPortfolioDetail.this.table.repaint();
                JSPortfolioDetail.this.repaint();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (JSPortfolioDetail.this.model != null) {
                            JSPortfolioDetail.this.model.fireTableDataChanged();
                        }
                        JSPortfolioDetail.this.table.addNotify();
                        JSPortfolioDetail.this.table.repaint();
                        JSPortfolioDetail.this.repaint();
                    }
                });
            }
        }

        public void removeOpenTable() {
            JSPortfolioDetail.this.openRow.clear();
            this.tableDataChange();
        }

        public void SetDataType(String Val) {
            try {
                if (Val.indexOf(".") > -1) {
                    Double.parseDouble(Val.replaceAll("\\,", ""));
                    JSPortfolioDetail.this.DataType.add("Double");
                } else {
                    Integer.parseInt(Val.replaceAll("\\,", ""));
                    JSPortfolioDetail.this.DataType.add("Integer");
                }
            }
            catch (Exception e) {
                JSPortfolioDetail.this.DataType.add("String");
            }
        }

        public void MakeTotal() {
            try {
                int i;
                JSPortfolioDetail.this.Total = new double[JSPortfolioDetail.this.DataType.size()];
                for (i = 0; i < JSPortfolioDetail.this.DataType.size(); ++i) {
                    JSPortfolioDetail.this.Total[i] = 0.0;
                }
                for (i = 0; i < JSPortfolioDetail.this.openRow.size(); ++i) {
                    Vector Col = (Vector)JSPortfolioDetail.this.openRow.get(i);
                    for (int j = 0; j < JSPortfolioDetail.this.DataType.size(); ++j) {
                        JSPortfolioDetail.this.Total[j] = JSPortfolioDetail.this.Total[j] + this.CheckISDouble(Col.get(j).toString());
                    }
                }
                Vector<String> NewRow = new Vector<String>();
                NewRow.addElement("Total");
                DecimalFormat twoPlacesWithComma = new DecimalFormat("###.##");
                twoPlacesWithComma.setMinimumFractionDigits(2);
                twoPlacesWithComma.setMaximumFractionDigits(2);
                for (int i2 = 1; i2 < JSPortfolioDetail.this.Total.length; ++i2) {
                    NewRow.addElement(twoPlacesWithComma.format(JSPortfolioDetail.this.Total[i2]));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public double CheckISDouble(String str) {
            double RetVal = 0.0;
            try {
                RetVal = Double.parseDouble(str.replaceAll("\\,", ""));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return RetVal;
        }
    }

    private class PositionTableCellRenderer
    extends NxGTableCellRender {
        private PositionTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object obj, boolean isSelected, boolean hasFocus, int row, int column) {
            NxGLabelGradeint cell = new NxGLabelGradeint();
            cell.setForeground(MyColors.cellRenderFG);
            cell.setVerticalAlignment(0);
            if (obj == null) {
                obj = "";
            }
            boolean isTotalRow = false;
            if (row == JSPortfolioDetail.this.model.getRowCount() - 1 && JSPortfolioDetail.this.model.getValueAt(row, 0).toString().equalsIgnoreCase("Total")) {
                isTotalRow = true;
            }
            if (JSPortfolioDetail.this.DataType.size() >= column) {
                if (JSPortfolioDetail.this.DataType.get(column).toString().equalsIgnoreCase("Double")) {
                    cell.setHorizontalAlignment(4);
                    cell.setText(" " + Util.format2digit((String)obj.toString().trim().replaceAll("\\,", "")) + " ");
                } else if (JSPortfolioDetail.this.DataType.get(column).toString().equalsIgnoreCase("Integer")) {
                    cell.setHorizontalAlignment(4);
                    cell.setText(" " + Util.format0digit((String)obj.toString().trim().replaceAll("\\,", "")) + " ");
                } else if (JSPortfolioDetail.this.DataType.get(column).toString().equalsIgnoreCase("String")) {
                    cell.setHorizontalAlignment(2);
                    cell.setText(" " + obj.toString() + " ");
                }
            }
            if (row % 2 == 0) {
                cell.setGradient(this.getOddColorStart(), this.getOddColorEnd());
            } else {
                cell.setGradient(this.getEvenColorStart(), this.getEvenColorEnd());
            }
            if (isSelected) {
                cell.setGradient(this.getSelectColorStart(), this.getSelectColorEnd());
                cell.setForeground(Color.WHITE);
            }
            if ((this.getRowNo() != -1 || this.getRowNo() <= row) && this.getRowNo() == row) {
                cell.setGradient(this.getRoleOverColorStart(), this.getRoleOverColorEnd());
                cell.setForeground(Color.WHITE);
            }
            if (isTotalRow) {
                cell.setFont(new Font(cell.getFont().getFontName(), 1, cell.getFont().getSize()));
            }
            return cell;
        }
    }
}

