/*
 * Decompiled with CFR 0.152.
 */
package windows.js;

import Beans.MarketDeliveryBean;
import CATALYST.Socket.EncryptDecrypt;
import MyDocking.Mediator;
import MyDocking.TradeCast;
import RendersNModels.CheckBoxEditor;
import RendersNModels.ComboBoxToolTipRender;
import RendersNModels.MarkDeliveryCellRender;
import RendersNModels.MarketDeliveryModel;
import Utilities.LogsTC;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import common.gui.component.JTextFieldFilter;
import common.gui.component.NxGTable;
import common.gui.util.AppConfig;
import common.gui.util.LogCommon;
import common.gui.util.MessageType;
import common.gui.util.MyColors;
import common.gui.util.Util;
import common.services.WebService;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import javax.swing.text.Document;
import languages.LanguageCentre;
import languages.LanguageConstant;

public class MarkDelivery
extends JPanel {
    MarketDeliveryModel model = null;
    Vector<String> column = new Vector();
    Vector<MarketDeliveryBean> row = new Vector();
    MarkDeliveryCellRender render = new MarkDeliveryCellRender();
    private LanguageCentre languageCentre = new LanguageCentre();
    Timer timer = new Timer(10, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            MarkDelivery.this.cbAccount.requestFocus();
            MarkDelivery.this.timer.stop();
        }
    });
    private JButton btnGet;
    private JButton btnSubmit;
    private JComboBox cbAccount;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JLabel lblAccount;
    private JLabel lblMessage;
    private NxGTable table;
    private JPasswordField txtPinCode;

    public MarkDelivery() {
        try {
            this.initComponents();
            this.setAccounts();
            this.initTable();
            this.txtPinCode.setDocument((Document)new JTextFieldFilter("0123456789", 4));
            if (LogCommon.isMarkDeleviryHelp) {
                TradeCast.getInstance().setTrayMessage("Mark Delivery: ", "Change Mark Quantity by double clicking the Mark Quantity cell.", TrayIcon.MessageType.INFO);
                LogCommon.isMarkDeleviryHelp = false;
            }
            this.timer.start();
            this.txtPinCode.setText(LogCommon.pinCode);
            if (LogCommon.preferredAccount.trim().length() > 0) {
                this.cbAccount.setSelectedItem(LogCommon.preferredAccount);
            } else {
                try {
                    this.cbAccount.setSelectedIndex(0);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void initComponents() {
        this.lblAccount = new JLabel();
        this.cbAccount = new JComboBox();
        this.jLabel2 = new JLabel();
        this.txtPinCode = new JPasswordField();
        this.btnGet = new JButton();
        this.lblMessage = new JLabel();
        this.btnSubmit = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.table = new NxGTable();
        this.jSeparator1 = new JSeparator();
        this.setPreferredSize(new Dimension(758, 270));
        this.lblAccount.setText("Account");
        this.cbAccount.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbAccount.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MarkDelivery.this.cbAccountActionPerformed(evt);
            }
        });
        this.jLabel2.setText("PIN");
        this.txtPinCode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MarkDelivery.this.txtPinCodeActionPerformed(evt);
            }
        });
        this.btnGet.setText("Get");
        this.btnGet.setName("MarkDelivery -> btnGet");
        this.btnGet.setPreferredSize(new Dimension(51, 20));
        this.btnGet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MarkDelivery.this.btnGetActionPerformed(evt);
            }
        });
        this.btnSubmit.setIcon(new ImageIcon(this.getClass().getResource("/Images/submit.png")));
        this.btnSubmit.setText("Submit");
        this.btnSubmit.setName("MarkDelivery -> btnSubmit");
        this.btnSubmit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MarkDelivery.this.btnSubmitActionPerformed(evt);
            }
        });
        this.table.setModel((TableModel)new DefaultTableModel(new Object[0][], new String[]{"1", "2", "3", "4", "5"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, Long.class, Object.class, Object.class, Object.class};
                this.canEdit = new boolean[]{true, false, true, true, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jScrollPane1.setViewportView((Component)this.table);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jSeparator1).addGap(1, 1, 1)).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lblMessage, -2, 450, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 203, Short.MAX_VALUE).addComponent(this.btnSubmit)).addComponent(this.jScrollPane1).addGroup(layout.createSequentialGroup().addComponent(this.lblAccount).addGap(10, 10, 10).addComponent(this.cbAccount, -2, 119, -2).addGap(12, 12, 12).addComponent(this.jLabel2).addGap(10, 10, 10).addComponent(this.txtPinCode, -2, 40, -2).addGap(6, 6, 6).addComponent(this.btnGet, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblAccount, -2, 23, -2).addComponent(this.cbAccount, -2, 23, -2).addComponent(this.jLabel2, -2, 23, -2).addComponent(this.txtPinCode, -2, 23, -2).addComponent(this.btnGet, -2, 23, -2)).addGap(7, 7, 7).addComponent(this.jScrollPane1, -1, 190, Short.MAX_VALUE).addGap(5, 5, 5).addComponent(this.jSeparator1, -2, 3, -2).addGap(2, 2, 2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblMessage, -2, 23, -2).addComponent(this.btnSubmit)).addGap(5, 5, 5)));
    }

    private void btnGetActionPerformed(ActionEvent evt) {
        this.getData();
    }

    private void btnSubmitActionPerformed(ActionEvent evt) {
        this.postTableData();
    }

    private void txtPinCodeActionPerformed(ActionEvent evt) {
        if (this.txtPinCode.getText().trim().length() <= 0) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Please enter PIN");
            this.txtPinCode.requestFocus();
        } else if (this.txtPinCode.getText().trim().length() < 4) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"PIN length should be four digits");
            this.txtPinCode.requestFocus();
        } else {
            this.getData();
        }
    }

    private void cbAccountActionPerformed(ActionEvent evt) {
        if (evt.getModifiers() == 16 || evt.getActionCommand().equalsIgnoreCase("comboBoxEdited")) {
            if (this.cbAccount.getSelectedItem() == null) {
                Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Please select account");
                this.cbAccount.requestFocus();
            } else if (this.cbAccount.getSelectedItem().toString().trim().length() <= 0) {
                Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Please select account");
                this.cbAccount.requestFocus();
            } else {
                this.txtPinCode.requestFocus();
            }
        }
    }

    private void postTableData() {
        if (this.row.size() <= 0) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"No record found");
            return;
        }
        final String pin = EncryptDecrypt.getInstance().EncryptText(String.valueOf(this.txtPinCode.getPassword()));
        Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.EMPTY, (String)"");
        int status = -1;
        for (int i = 0; i < this.row.size(); ++i) {
            MarketDeliveryBean bean = this.row.get(i);
            String market = bean.getMarket();
            String scrip = bean.getSymbol();
            boolean isCheck = Boolean.parseBoolean(this.table.getValueAt(i, 4).toString());
            long mrkQty = -1L;
            long Qty = -1L;
            try {
                mrkQty = Long.parseLong(this.table.getValueAt(i, 3).toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Qty = Long.parseLong(this.table.getValueAt(i, 2).toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (isCheck) {
                if (mrkQty <= 0L) {
                    Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)("Entered Mark Quantity of " + market + " - " + scrip + " should be greater than zero"));
                    status = 0;
                    break;
                }
                if (mrkQty <= Qty) continue;
                Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)("Entered Mark Quantity of " + market + " - " + scrip + " should be less than Quatity"));
                status = 0;
                break;
            }
            if (mrkQty == 0L) continue;
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)("Entered Mark Quantity of " + market + " - " + scrip + " should be zero"));
            status = 0;
            break;
        }
        if (status == 0) {
            return;
        }
        new Thread("MarkDeleviry PostData"){

            @Override
            public void run() {
                String result = "";
                try {
                    Util.setMessage((JLabel)MarkDelivery.this.lblMessage, (MessageType)MessageType.Loading, (String)"Please wait");
                    MarkDelivery.this.btnSubmit.setEnabled(false);
                    String sb = "";
                    for (int i = 0; i < MarkDelivery.this.row.size(); ++i) {
                        MarketDeliveryBean bean = MarkDelivery.this.row.get(i);
                        Integer id = bean.getId();
                        sb = sb + LogCommon.UserID + ";" + MarkDelivery.this.cbAccount.getSelectedItem().toString() + ";" + MarkDelivery.this.table.getValueAt(i, 0).toString() + ";" + MarkDelivery.this.table.getValueAt(i, 1).toString() + ";" + MarkDelivery.this.table.getValueAt(i, 3).toString() + ";" + id + "|";
                    }
                    String packet = sb;
                    WebService.getInstance();
                    result = WebService.getInstance().getPort().getInfo(pin, "MarkDelivery", packet);
                    if (result.indexOf("Success") >= 0) {
                        Util.setMessage((JLabel)MarkDelivery.this.lblMessage, (MessageType)MessageType.EMPTY, (String)"");
                        JOptionPane.showMessageDialog(TradeCast.getInstance().frame, "Your request has been submitted.", LanguageConstant.MarkDelivery, 1);
                        MarkDelivery.this.getData();
                    } else if (result.indexOf("Invalid Pincode") >= 0) {
                        Util.setMessage((JLabel)MarkDelivery.this.lblMessage, (MessageType)MessageType.Error, (String)"Invalid PIN");
                    }
                }
                catch (Exception ex) {
                    Util.setMessage((JLabel)MarkDelivery.this.lblMessage, (MessageType)MessageType.Error, (String)"Error in submit");
                    Mediator.getInstance().PrintLog(ex, result);
                    ex.printStackTrace();
                }
                MarkDelivery.this.btnSubmit.setEnabled(true);
            }
        }.start();
    }

    private void setAccounts() {
        this.cbAccount.setModel(new DefaultComboBoxModel<Object>(LogsTC.accountAll.keySet().toArray()));
        AutoCompleteSupport support = AutoCompleteSupport.install((JComboBox)this.cbAccount, (EventList)GlazedLists.eventListOf((Object[])LogsTC.accountAll.keySet().toArray()));
        this.cbAccount.setRenderer(new ComboBoxToolTipRender(LogsTC.accountAll, ""));
        support.setStrict(true);
    }

    private void initTable() {
        this.column.add("ID");
        this.column.add("Market");
        this.column.add("Symbol");
        this.column.add("Quantity");
        this.column.add("Marked Quantity");
        this.column.add("Mark");
        this.model = new MarketDeliveryModel((Vector)this.row, (Vector)this.column);
        this.table.setModel((TableModel)this.model);
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            this.table.getColumn((Object)this.model.getColumnName(i)).setCellRenderer(this.render);
        }
        JTableHeader header = this.table.getTableHeader();
        ((JLabel)((Object)header.getDefaultRenderer())).setHorizontalAlignment(0);
        this.table.setRowHeight(AppConfig.rowHeight);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setSelectionMode(0);
        this.table.getColumn((Object)"Mark").setCellEditor(new CheckBoxEditor(new JCheckBox(), (JTable)this.table));
        this.table.removeColumn(this.table.getColumnModel().getColumn(0));
        this.table.repaint();
    }

    private void removeRowes() {
        this.row.clear();
        this.model.fireTableDataChanged();
        this.tableDataChange();
    }

    private void tableDataChange() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.table.addNotify();
            this.table.repaint();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MarkDelivery.this.table.addNotify();
                    MarkDelivery.this.table.repaint();
                }
            });
        }
    }

    private void getData() {
        if (this.isValidInput()) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    String result = "";
                    try {
                        MarkDelivery.this.removeRowes();
                        Util.setMessage((JLabel)MarkDelivery.this.lblMessage, (MessageType)MessageType.Loading, (String)MarkDelivery.this.languageCentre.getValue(LanguageConstant.Loading));
                        String pinCode = EncryptDecrypt.getInstance().EncryptText(String.valueOf(MarkDelivery.this.txtPinCode.getPassword()));
                        result = WebService.getInstance().getPort().getWithdrawalStatement(LogCommon.UserID, pinCode, MarkDelivery.this.cbAccount.getSelectedItem().toString(), "", "", "MarkDelivery");
                        if (result.equalsIgnoreCase("Invalid Pincode")) {
                            Util.setMessage((JLabel)MarkDelivery.this.lblMessage, (MessageType)MessageType.Error, (String)"Invalid Pincode");
                            MarkDelivery.this.txtPinCode.requestFocus();
                        } else {
                            MarkDelivery.this.fillPosition(result);
                        }
                    }
                    catch (Exception ex) {
                        Util.setMessage((JLabel)MarkDelivery.this.lblMessage, (MessageType)MessageType.Error, (String)"Error in loading data");
                        Mediator.getInstance().PrintLog(ex, result);
                    }
                }
            }, "Mark Delivery getdata").start();
        }
    }

    private synchronized void fillPosition(String msg) {
        Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.EMPTY, (String)"");
        if (msg.indexOf(";") < 0) {
            this.lblMessage.setForeground(MyColors.successMessageFG);
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"No record found");
            return;
        }
        if (msg.indexOf("|") > 0) {
            String[] values = msg.split("\\|", -1);
            for (int i = 0; i < values.length - 1; ++i) {
                String string = values[i];
                MarketDeliveryBean b = MarketDeliveryBean.parse(string);
                this.row.add(b);
            }
        }
        this.model.fireTableDataChanged();
        this.table.packAll();
        this.tableDataChange();
        if (this.row.size() <= 1) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Normal, (String)(Util.format0digit((String)(this.row.size() + "")) + " record found."));
        } else {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Normal, (String)(Util.format0digit((String)(this.row.size() + "")) + " records found."));
        }
    }

    private boolean isValidInput() {
        if (this.cbAccount.getSelectedItem() == null) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Please select account");
            this.cbAccount.requestFocus();
            return false;
        }
        if (this.cbAccount.getSelectedItem().toString().trim().length() <= 0) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Please select account");
            this.cbAccount.requestFocus();
            return false;
        }
        if (this.txtPinCode.getText().trim().length() <= 3) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Please enter PIN");
            this.txtPinCode.requestFocus();
            return false;
        }
        String acc = this.cbAccount.getSelectedItem().toString().trim();
        if (!LogsTC.accountAll.containsKey(acc)) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Error, (String)"Invalid account");
            this.cbAccount.requestFocus();
        }
        return true;
    }
}

