/*
 * Decompiled with CFR 0.152.
 */
package windows.pmex;

import Beans.MBPFeed;
import CustomComponent.MyTime;
import MyDocking.Mediator;
import MyDocking.TradeCast;
import Utilities.FormsProperties;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import common.bean.ContractBrowseBean;
import common.bean.MBO_MBP_Bean;
import common.gui.component.NxGDialogBox;
import common.gui.component.NxGPanel;
import common.gui.component.NxGTable;
import common.gui.util.AppConfig;
import common.gui.util.CompressManager;
import common.gui.util.FormName;
import common.gui.util.LogCommon;
import common.gui.util.LoginMode;
import common.gui.util.MessageType;
import common.gui.util.Title;
import common.gui.util.Util;
import common.interfaces.AddContract;
import common.services.WebService;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import languages.LanguageCentre;
import languages.LanguageConstant;
import org.jdesktop.swingx.JXButton;
import org.jdesktop.swingx.JXCollapsiblePane;
import pmex.gui.bean.ContractPIPBean;
import pmex.gui.bean.LeaderBean;
import pmex.gui.bean.LeaderTickLocksBean;
import pmex.gui.bean.PMEXMarketFeedBean;
import pmex.gui.model.LeaderModel;
import pmex.gui.render.LeaderRender;
import pmex.gui.util.DataLoader;
import pmex.gui.util.LogsPMEX;
import pmex.gui.util.UtilPMEX;
import windows.pmex.PMEX_ContractBrowseDialog;
import windows.pmex.order.PMEX_OrderOneClick;

public class PMEX_Ladder
extends NxGPanel
implements MouseListener,
AddContract {
    private Mediator mediator = Mediator.getInstance();
    private TradeCast tradeCast = TradeCast.getInstance();
    private String LastContract = "";
    private boolean isContractChange = false;
    private Vector<LeaderBean> rows = new Vector();
    private Vector<String> columns = new Vector();
    private Hashtable<String, LeaderTickLocksBean> tickInfo = new Hashtable();
    private HashMap<String, Long> VAP = new HashMap(30);
    private static Set<String> set = new LinkedHashSet<String>(6);
    private LeaderModel model = null;
    private LeaderRender render = null;
    private JTableHeader header = null;
    private TableColumnModel columnModel = null;
    private AutoCompleteSupport autoCom;
    private String contract = "";
    private String lastTime = " ";
    private NxGDialogBox dialogBox;
    public static final String contractPrompt = "Please Select a Contract";
    private PMEX_OrderOneClick PMEX_Order_Template = null;
    private PMEXMarketFeedBean pmexMarketFeedBean = null;
    private LanguageCentre languageCentre = new LanguageCentre();
    private JToggleButton btnSeeMore;
    private JComboBox cbContract;
    private JXCollapsiblePane collPaneOrder;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JToolBar jToolBar1;
    private JXButton jXButton1;
    private JLabel lblLastUpdate;
    private JLabel lblMarket;
    private JLabel lblMessage;
    private NxGTable table;
    Runnable loadSectorPIP = new Runnable(){

        @Override
        public void run() {
            while (LogsPMEX.PMEX_SECTOR_PIP.size() <= 0) {
            }
            Util.setMessage((JLabel)PMEX_Ladder.this.lblMessage, (MessageType)MessageType.EMPTY, (String)"");
        }
    };

    public PMEX_Ladder(NxGDialogBox dialogBox, String contract) {
        this.initComponents();
        this.dialogBox = dialogBox;
        this.contract = contract;
        this.tradeCast.PMEX_LaderWindowHolder.add(this);
        this.PMEX_Order_Template = new PMEX_OrderOneClick((JPanel)((Object)this));
        this.PMEX_Order_Template.setVisible(false);
        if (LogsPMEX.PMEX_SECTOR_PIP.size() <= 0 && AppConfig.loginMode != LoginMode.KSE) {
            new DataLoader().getData("PMEX_GetSectorPIP");
            new Thread(this.loadSectorPIP, "PMEX_GetSectorPIP").start();
        }
        this.lblLastUpdate.setText("  ");
        this.lblLastUpdate.setFont(AppConfig.defaultPlanFont);
        this.lblLastUpdate.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                PMEX_Ladder.this.lblLastUpdate.setText(PMEX_Ladder.this.lastTime);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                PMEX_Ladder.this.lblLastUpdate.setText("  ");
            }
        });
        this.initTable();
        this.setupOrderPanel();
        this.addEventListiner();
        this.addContract();
        this.setOrderOptions(LogCommon.PMEX_OrderOption);
        LogsPMEX.CONTRACT_HOLDER.add(this);
        if (contract != null && contract.trim().length() > 1) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Loading, (String)this.languageCentre.getValue(LanguageConstant.Loading));
            this.SendMBPMessage(contract, UtilPMEX.GetMarketFromContract((String)contract));
            this.cbContract.setSelectedItem(contract);
        }
        this.cbContract.setMaximumRowCount(29);
        if (Util.isMacOSX()) {
            this.btnSeeMore.setMaximumSize(new Dimension(90, 23));
            this.btnSeeMore.setMinimumSize(new Dimension(90, 23));
            this.btnSeeMore.setPreferredSize(new Dimension(90, 23));
            this.btnSeeMore.setSize(new Dimension(90, 23));
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(200L);
                    PMEX_Ladder.this.PMEX_Order_Template.setVisible(true);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    private void initTable() {
        this.columns.add("VAP");
        this.columns.add("Orders");
        this.columns.add("Buy");
        this.columns.add("Price");
        this.columns.add("Sell");
        this.columns.add("Size");
        this.columns.add("Total");
        this.model = new LeaderModel(this.rows, this.columns);
        this.table.setModel((TableModel)this.model);
        this.render = new LeaderRender((JTable)this.table, this.model);
        this.header = this.table.getTableHeader();
        this.columnModel = this.table.getColumnModel();
        for (int k = 0; k < this.columns.size(); ++k) {
            this.table.getColumn((Object)this.columns.elementAt(k)).setCellRenderer((TableCellRenderer)this.render);
        }
        this.setColumnVisible();
        this.table.setRowSorter(null);
        this.table.repaint();
    }

    private void addEventListiner() {
        this.table.addMouseListener((MouseListener)this);
        this.header.addMouseListener(this);
    }

    private LeaderBean getMaximum() {
        LeaderBean lb = new LeaderBean();
        for (LeaderBean temp : this.rows) {
            if (lb.getTotal() < temp.getTotal()) {
                lb.setTotal(temp.getTotal());
            }
            if (lb.getSize() < temp.getSize()) {
                lb.setSize(temp.getSize());
            }
            if (lb.getVAP() >= temp.getVAP()) continue;
            lb.setVAP(temp.getVAP());
        }
        return lb;
    }

    private void setPercentage() {
        LeaderBean lb = this.getMaximum();
        double total = new Double(1.0) / (double)lb.getTotal();
        double size = new Double(1.0) / (double)lb.getSize();
        double VAP = new Double(1.0) / (double)lb.getVAP();
        for (LeaderBean temp : this.rows) {
            temp.setTotalPercent((int)((double)temp.getTotal() * total * 100.0));
            temp.setSizePercent((int)((double)temp.getSize() * size * 100.0));
            temp.setVAPPercent((int)((double)temp.getVAP() * VAP * 100.0));
        }
    }

    private void setTickInfo() {
        LeaderTickLocksBean lb = new LeaderTickLocksBean();
        lb.setTick(0.1);
        lb.setLowerLock(100.0);
        lb.setUpperCap(110.0);
        this.tickInfo.put("Test", lb);
    }

    private void SendMBPMessage(String contract, String market) {
        if (!this.LastContract.equalsIgnoreCase(contract + ":" + market)) {
            if (LogsPMEX.PMEX_CONTRACT_ALL.size() > 0 && !LogsPMEX.PMEX_CONTRACT_ALL.containsKey(contract.trim())) {
                Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Error, (String)"Invalid Contract");
                this.LastContract = contract + ":" + market;
            } else {
                this.getVolumneAtPrice(contract, market);
                this.contract = contract;
                this.LastContract = contract + ":" + market;
                this.isContractChange = true;
                this.mediator.SubcribePMEXMBP("PMEX_Ladder : SendMBPMessage");
                this.PMEX_Order_Template.setContract(contract);
                this.PMEX_Order_Template.setMarket(market);
                this.PMEX_Order_Template.setLastTradePrice(LeaderBean.DEFAULT_VALUE);
            }
        }
        if (contract.equalsIgnoreCase("")) {
            this.mediator.SubcribePMEXMBP("PMEX_Ladder (Contract Empty): SendMBPMessage ");
        }
    }

    public void MessageSent(boolean b) {
        if (b) {
            this.PMEX_Order_Template.sendOrderToServer();
        } else {
            this.PMEX_Order_Template.setFocusResquest();
        }
    }

    public void updateFeedThread(final String feedRecived) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PMEX_Ladder.this.setName("updateFeedThread");
                PMEX_Ladder.this.mediator.println("Ladded FeedRecived = " + feedRecived);
                PMEX_Ladder.this.updateFeed(feedRecived);
                Util.setMessage((JLabel)PMEX_Ladder.this.lblMessage, (MessageType)MessageType.Normal, (String)PMEX_Ladder.this.contract);
            }
        });
    }

    private void updateFeed(String feedRecived) {
        String selectedContract;
        double lastTradePrice = 0.0;
        double change = 0.0;
        if (this.cbContract.getSelectedItem() != null && !(selectedContract = this.cbContract.getSelectedItem().toString()).trim().equalsIgnoreCase("")) {
            this.PMEX_Order_Template.setMBPBean(null);
            if (feedRecived.indexOf("|") > 0) {
                int buyRowNo = 0;
                String[] feeds = feedRecived.split("\\|", -1);
                for (int i = 0; i < feeds.length; ++i) {
                    String singlFeed = feeds[i];
                    if (singlFeed.trim().length() <= 0 || singlFeed.indexOf(";") < 0) continue;
                    String[] feed = feeds[i].split("\\;", -1);
                    MBPFeed mbpfeed = new MBPFeed();
                    mbpfeed.feedString = feeds[i];
                    mbpfeed.symbol = feed[0];
                    mbpfeed.market = feed[1];
                    mbpfeed.buy = feed[3];
                    mbpfeed.sell = feed[4];
                    mbpfeed.lastPrice = feed[2];
                    if (!selectedContract.equalsIgnoreCase(mbpfeed.symbol)) continue;
                    this.rows.clear();
                    if (mbpfeed.lastPrice.indexOf("$") > 0) {
                        String[] val = mbpfeed.lastPrice.split("\\$", -1);
                        try {
                            lastTradePrice = Double.parseDouble(val[0]);
                            this.render.setLastTradePrice(lastTradePrice);
                            this.PMEX_Order_Template.setLastTradePrice(lastTradePrice);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            this.render.setLastTradePrice((double)LeaderBean.DEFAULT_VALUE);
                            this.PMEX_Order_Template.setLastTradePrice(LeaderBean.DEFAULT_VALUE);
                        }
                        try {
                            change = Double.parseDouble(val[1]);
                            if (change > 0.0) {
                                this.render.setChangeUp(true);
                            } else {
                                this.render.setChangeUp(false);
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    this.setPMEX_Order_MBPBean(feedRecived);
                    String contract = "";
                    if (mbpfeed.symbol.indexOf("-") > 0) {
                        contract = mbpfeed.symbol.split("\\-", -1)[0];
                    }
                    if (LogsPMEX.PMEX_SECTOR_PIP.containsKey(contract)) {
                        String key;
                        LeaderBean lb;
                        LeaderBean lb2;
                        int j;
                        ContractPIPBean cPIP = (ContractPIPBean)LogsPMEX.PMEX_SECTOR_PIP.get(contract);
                        String[] BuyValues = mbpfeed.buy.split("\\$", -1);
                        String[] SellValues = mbpfeed.sell.split("\\$", -1);
                        String[] sellVal3 = SellValues[SellValues.length - 2].split("\\,", -1);
                        double sellPriceFirst = Double.valueOf(sellVal3[1]);
                        double buyPriceLast = 0.0;
                        double totalPIPSell = (double)cPIP.getExtraRow() * cPIP.getPIP() + sellPriceFirst;
                        for (j = cPIP.getExtraRow(); j > 0; --j) {
                            lb2 = new LeaderBean();
                            double val = totalPIPSell - cPIP.getPIP();
                            lb2.setSell(val);
                            lb2.setPrice(val);
                            lb2.setContractPipDigit(cPIP.getRoundDigit());
                            String key2 = Util.format4digit((String)(val + ""));
                            if (this.VAP.containsKey(key2)) {
                                lb2.setVAP(this.VAP.get(key2).longValue());
                            }
                            totalPIPSell = val;
                            this.setOrderQuantity(lb2);
                            this.rows.add(lb2);
                        }
                        for (j = SellValues.length - 1; j > 0; --j) {
                            String[] sellVal = SellValues[j - 1].split("\\,", -1);
                            long sellVol = Long.parseLong(sellVal[0]);
                            double sellPrice = Double.parseDouble(sellVal[1]);
                            lb = new LeaderBean();
                            lb.setRowIndex(j);
                            lb.setSell(sellPrice);
                            lb.setPrice(sellPrice);
                            lb.setSize(sellVol);
                            lb.setContractPipDigit(cPIP.getRoundDigit());
                            key = Util.format4digit((String)(sellPrice + ""));
                            if (this.VAP.containsKey(key)) {
                                lb.setVAP(this.VAP.get(key).longValue());
                            }
                            this.setOrderQuantity(lb);
                            this.rows.add(lb);
                        }
                        buyRowNo = this.rows.size();
                        for (j = 0; j < BuyValues.length - 1; ++j) {
                            String[] buyVal = BuyValues[j].split("\\,", -1);
                            long buyVol = Long.parseLong(buyVal[0]);
                            double buyPrice = Double.parseDouble(buyVal[1]);
                            lb = new LeaderBean();
                            lb.setRowIndex(j);
                            lb.setBuy(buyPrice);
                            lb.setPrice(buyPrice);
                            lb.setSize(buyVol);
                            lb.setContractPipDigit(cPIP.getRoundDigit());
                            key = Util.format4digit((String)(buyPrice + ""));
                            if (this.VAP.containsKey(key)) {
                                lb.setVAP(this.VAP.get(key).longValue());
                            }
                            buyPriceLast = buyPrice;
                            this.setOrderQuantity(lb);
                            this.rows.add(lb);
                        }
                        for (j = 0; j < cPIP.getExtraRow(); ++j) {
                            lb2 = new LeaderBean();
                            double val = buyPriceLast -= cPIP.getPIP();
                            lb2.setBuy(val);
                            lb2.setPrice(val);
                            lb2.setContractPipDigit(cPIP.getRoundDigit());
                            String key3 = Util.format4digit((String)(val + ""));
                            if (this.VAP.containsKey(key3)) {
                                lb2.setVAP(this.VAP.get(key3).longValue());
                            }
                            buyPriceLast = val;
                            this.setOrderQuantity(lb2);
                            this.rows.add(lb2);
                        }
                    }
                    this.setTotalValue(buyRowNo);
                    this.setPercentage();
                }
            }
            if (this.isContractChange) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException ex) {
                            ex.printStackTrace();
                        }
                        Util.setScrollbarHeightInCenter((JScrollPane)PMEX_Ladder.this.jScrollPane1);
                    }
                });
                this.isContractChange = false;
            }
            this.model.fireTableDataChanged();
            this.table.addNotify();
            this.packColumns((JTable)this.table, 15);
            this.table.repaint();
            this.lastTime = MyTime.getInstance().getTime();
            this.lblLastUpdate.setToolTipText("Last Update Time " + this.lastTime);
        }
    }

    private void setTotalValue(int rowNo) {
        try {
            LeaderBean lb;
            int i;
            long size = 0L;
            for (i = rowNo; i < this.rows.size(); ++i) {
                lb = this.rows.elementAt(i);
                if (lb.getSize() <= 0L) continue;
                lb.setTotal(size += lb.getSize());
            }
            size = 0L;
            for (i = rowNo - 1; i > 0; --i) {
                lb = this.rows.elementAt(i);
                if (lb.getSize() <= 0L) continue;
                lb.setTotal(size += lb.getSize());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void getVolumneAtPrice(final String contract, final String market) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    PMEX_Ladder.this.VAP.clear();
                    byte[] result = WebService.getInstance().getPort().getCompressedData(contract, "PMEX_GetVolumneAtPrice", market);
                    PMEX_Ladder.this.fillVolumeAtPrice(CompressManager.unzipStringFromBytes((byte[])result));
                }
                catch (Exception ex) {
                    Logger.getLogger(PMEX_Ladder.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }, "getVolumneAtPrice").start();
    }

    private void fillVolumeAtPrice(String data) {
        String values;
        if (data.indexOf("=") > 0 && (values = data.split("\\=", -1)[1]).indexOf("|") > 0) {
            String[] allRows = values.split("\\|", -1);
            for (int i = 0; i < allRows.length; ++i) {
                String singleRow = allRows[i];
                if (singleRow.indexOf(";") <= 0) continue;
                String[] val = singleRow.split("\\;", -1);
                Double price = Double.parseDouble(val[0]);
                Long vol = Long.parseLong(val[1]);
                this.VAP.put(Util.format4digit((String)(price + "")), vol);
            }
        }
    }

    private void setupOrderPanel() {
        this.collPaneOrder.add((Component)((Object)this.PMEX_Order_Template));
        this.collPaneOrder.setCollapsed(false);
    }

    private void setCollaspe() {
        boolean state = this.collPaneOrder.isCollapsed();
        this.collPaneOrder.setCollapsed(!state);
        if (state) {
            this.PMEX_Order_Template.setFocusResquest();
            this.btnSeeMore.setIcon(new ImageIcon(this.getClass().getResource("/Images/uparrowgray.png")));
            this.btnSeeMore.setText("See Less");
        } else {
            this.btnSeeMore.setIcon(new ImageIcon(this.getClass().getResource("/Images/downarrowgray.png")));
            this.btnSeeMore.setText("See More");
        }
    }

    private void setOrderQuantity(LeaderBean lb) {
        lb.setOrders(this.mediator.pmex_WorkingOrder.getContractOrderQuantity(this.contract, lb.getPrice()));
    }

    private void setPMEX_Order_MBPBean(String feedRecived) {
        String[] feeds = feedRecived.split("\\|", -1);
        if (feeds[0].trim().length() > 0 && feeds[0].indexOf(";") >= 0) {
            String[] feed = feeds[0].split("\\;", -1);
            MBPFeed mbpfeed = new MBPFeed();
            mbpfeed.feedString = feeds[0];
            mbpfeed.symbol = feed[0];
            mbpfeed.market = feed[1];
            mbpfeed.buy = feed[3];
            mbpfeed.sell = feed[4];
            mbpfeed.lastPrice = feed[2];
            if (mbpfeed.lastPrice.indexOf("$") > 0) {
                String[] val = mbpfeed.lastPrice.split("\\$", -1);
                try {
                    double lastTradePrice = Double.parseDouble(val[0]);
                    this.PMEX_Order_Template.setLastTradePrice(lastTradePrice);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    this.PMEX_Order_Template.setLastTradePrice(LeaderBean.DEFAULT_VALUE);
                }
                String[] BuyValues = mbpfeed.buy.split("\\$", -1);
                String[] SellValues = mbpfeed.sell.split("\\$", -1);
                String[] BuyVal = new String[]{"", ""};
                String[] SellVal = new String[]{"", ""};
                MBO_MBP_Bean bean = new MBO_MBP_Bean();
                SellVal[1] = "";
                SellVal[0] = "";
                BuyVal[1] = "";
                BuyVal[0] = "";
                if (0 < BuyValues.length - 1) {
                    BuyVal = BuyValues[0].split("\\,", -1);
                }
                if (0 < SellValues.length - 1) {
                    SellVal = SellValues[0].split("\\,", -1);
                }
                try {
                    long vol = Long.parseLong(BuyVal[0]);
                    bean.setVolumeBuy(vol);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                try {
                    double price = Double.parseDouble(BuyVal[1]);
                    bean.setPriceBuy(price);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                try {
                    double price = Double.parseDouble(SellVal[1]);
                    bean.setPriceSell(price);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                try {
                    int vol = Integer.parseInt(SellVal[0]);
                    bean.setVolumeSell((long)vol);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                this.PMEX_Order_Template.setMBPBean(bean);
            }
        }
    }

    public void saveStatus() {
        set.clear();
        LogCommon.PMEX_LadderColumn = "";
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            String col = this.table.getColumnExt(i).getTitle();
            set.add(col);
            LogCommon.PMEX_LadderColumn = LogCommon.PMEX_LadderColumn + "|" + col;
        }
    }

    private void setColumnVisible() {
        this.table.getColumnExt((Object)"VAP").setVisible(false);
        this.table.getColumnExt((Object)"Orders").setVisible(false);
        this.table.getColumnExt((Object)"Buy").setVisible(false);
        this.table.getColumnExt((Object)"Price").setVisible(false);
        this.table.getColumnExt((Object)"Sell").setVisible(false);
        this.table.getColumnExt((Object)"Size").setVisible(false);
        this.table.getColumnExt((Object)"Total").setVisible(false);
        for (String s : set) {
            try {
                this.table.getColumnExt((Object)s).setVisible(true);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void setOrderOptions(String PMEX_OrderOption) {
        if (this.PMEX_Order_Template != null) {
            this.PMEX_Order_Template.setOrderOptions(PMEX_OrderOption);
        }
    }

    public String getContract() {
        return this.cbContract.getSelectedItem().toString();
    }

    public String getContractWithMarket() {
        if (this.LastContract.equalsIgnoreCase("") && !this.getContract().equalsIgnoreCase(contractPrompt)) {
            return this.getContract() + ":" + UtilPMEX.GetMarketFromContract((String)this.getContract());
        }
        return this.LastContract;
    }

    public void packColumns(JTable table, int margin) {
        this.table.packAll();
    }

    private void emptyDetail() {
        this.rows.clear();
        this.PMEX_Order_Template.setMBPBean(null);
        this.model.fireTableDataChanged();
        this.table.addNotify();
        this.table.repaint();
    }

    public void dispose() {
        if (this.dialogBox != null) {
            this.dialogBox.dispose();
        }
    }

    public void setPIN() {
        this.PMEX_Order_Template.setPIN();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.table = new NxGTable();
        this.lblMarket = new JLabel();
        this.cbContract = new JComboBox();
        this.jXButton1 = new JXButton();
        this.jSeparator1 = new JSeparator();
        this.lblMessage = new JLabel();
        this.lblLastUpdate = new JLabel();
        this.jToolBar1 = new JToolBar();
        this.btnSeeMore = new JToggleButton();
        this.collPaneOrder = new JXCollapsiblePane();
        this.table.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PMEX_Ladder.this.tableMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView((Component)this.table);
        this.lblMarket.setText("Contract ");
        this.cbContract.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbContract.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PMEX_Ladder.this.cbContractActionPerformed(evt);
            }
        });
        this.jXButton1.setText("...");
        this.jXButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PMEX_Ladder.this.jXButton1ActionPerformed(evt);
            }
        });
        this.jSeparator1.setPreferredSize(new Dimension(50, 3));
        this.lblLastUpdate.setHorizontalAlignment(4);
        this.lblLastUpdate.setIcon(new ImageIcon(this.getClass().getResource("/Images/lastUpdateTime16.png")));
        this.lblLastUpdate.setText("PKT 88:88:88");
        this.lblLastUpdate.setToolTipText("Yet not updated");
        this.lblLastUpdate.setHorizontalTextPosition(2);
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.btnSeeMore.setIcon(new ImageIcon(this.getClass().getResource("/Images/downarrowgray.png")));
        this.btnSeeMore.setSelected(true);
        this.btnSeeMore.setText("See Less");
        this.btnSeeMore.setFocusable(false);
        this.btnSeeMore.setHorizontalTextPosition(2);
        this.btnSeeMore.setMaximumSize(new Dimension(80, 23));
        this.btnSeeMore.setMinimumSize(new Dimension(80, 23));
        this.btnSeeMore.setVerticalTextPosition(3);
        this.btnSeeMore.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PMEX_Ladder.this.btnSeeMoreItemStateChanged(evt);
            }
        });
        this.jToolBar1.add(this.btnSeeMore);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lblMessage, -2, 228, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.lblLastUpdate)).addComponent(this.jScrollPane1).addComponent(this.jToolBar1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.lblMarket, -2, 54, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbContract, -2, 165, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.jXButton1, -2, 18, -2).addGap(0, 0, Short.MAX_VALUE)).addComponent((Component)this.collPaneOrder, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(5, 5, 5).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbContract, -2, -1, -2).addComponent((Component)this.jXButton1, -2, -1, -2).addComponent(this.lblMarket, -2, 18, -2)).addGap(5, 5, 5).addComponent(this.jScrollPane1, -1, 88, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jToolBar1, -2, 25, -2).addGap(0, 0, 0).addComponent((Component)this.collPaneOrder, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 3, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblMessage, -2, 21, -2).addComponent(this.lblLastUpdate, -2, 16, -2))));
        layout.linkSize(1, new Component[]{this.cbContract, this.jXButton1, this.lblMarket});
    }

    private void jXButton1ActionPerformed(ActionEvent evt) {
        if (this.tradeCast.htFormsProperties.containsKey(FormName.ContractBrowse)) {
            FormsProperties fp = this.tradeCast.htFormsProperties.get(FormName.ContractBrowse);
            ContractBrowseBean cb = PMEX_ContractBrowseDialog.getSelectedContract(this.tradeCast.frame, true, fp.getSize());
            if (cb != null) {
                this.cbContract.setSelectedItem(cb.getContract());
            }
        } else {
            ContractBrowseBean cb = PMEX_ContractBrowseDialog.getSelectedContract(this.tradeCast.frame, true, new Dimension(600, 400));
            if (cb != null) {
                this.cbContract.setSelectedItem(cb.getContract());
            }
        }
    }

    private void cbContractActionPerformed(ActionEvent evt) {
        if (evt.getModifiers() == 16 || evt.getModifiers() == 0 || evt.getActionCommand().equalsIgnoreCase("comboBoxEdited")) {
            String sym = "";
            if (this.cbContract.getSelectedItem() != null) {
                sym = this.cbContract.getSelectedItem().toString();
            }
            this.setContract(sym);
        }
    }

    private void btnSeeMoreItemStateChanged(ItemEvent evt) {
        this.setCollaspe();
    }

    private void tableMouseClicked(MouseEvent evt) {
        if (this.table.getRowCount() > 0) {
            double sell = this.rows.get(this.table.getSelectedRow()).getSell();
            double buy = this.rows.get(this.table.getSelectedRow()).getBuy();
            if (this.table.getColumnName(this.table.getSelectedColumn()).equalsIgnoreCase("Buy")) {
                if (buy != (double)LeaderBean.DEFAULT_VALUE) {
                    String temp = LogsPMEX.SelectedSymbol;
                    LogsPMEX.SelectedSymbol = this.contract;
                    this.tradeCast.ShowDynamicForm(FormName.PMEX_Buy, Title.PMEX_Buy);
                    if (this.mediator.pmex_orderBase != null) {
                        this.mediator.pmex_orderBase.setPrefredPrice(buy);
                    }
                    LogsPMEX.SelectedSymbol = temp;
                }
            } else if (this.table.getColumnName(this.table.getSelectedColumn()).equalsIgnoreCase("Sell") && sell != (double)LeaderBean.DEFAULT_VALUE) {
                String temp = LogsPMEX.SelectedSymbol;
                LogsPMEX.SelectedSymbol = this.contract;
                this.tradeCast.ShowDynamicForm(FormName.PMEX_Sell, Title.PMEX_Sell);
                if (this.mediator.pmex_orderBase != null) {
                    this.mediator.pmex_orderBase.setPrefredPrice(sell);
                }
                LogsPMEX.SelectedSymbol = temp;
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        try {
            Object obj = e.getSource();
            if (obj != this.table && obj == this.header) {
                int vci = this.columnModel.getColumnIndexAtX(e.getX());
                int clickedColumn = this.table.convertColumnIndexToModel(vci);
                if (clickedColumn == 0) {
                    this.model.isVAP = !this.model.isVAP;
                } else if (clickedColumn == 1) {
                    this.model.isOrders = !this.model.isOrders;
                } else if (clickedColumn == 4) {
                    this.model.isSell = !this.model.isSell;
                } else if (clickedColumn == 2) {
                    this.model.isBuy = !this.model.isBuy;
                } else if (clickedColumn == 5) {
                    this.model.isSize = !this.model.isSize;
                } else if (clickedColumn == 3) {
                    this.model.isPrice = !this.model.isPrice;
                } else if (clickedColumn == 6) {
                    this.model.isTotal = !this.model.isTotal;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.header.repaint();
        this.table.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public void addContract() {
        if (this.autoCom != null && this.autoCom.isInstalled()) {
            this.autoCom.uninstall();
        }
        ArrayList v = new ArrayList(LogsPMEX.PMEX_CONTRACT_ALL.keySet());
        Collections.sort(v);
        v.add(0, contractPrompt);
        this.autoCom = AutoCompleteSupport.install((JComboBox)this.cbContract, (EventList)GlazedLists.eventListOf((Object[])v.toArray()));
        this.autoCom.setStrict(false);
        this.cbContract.setSelectedItem(this.contract);
        this.cbContract.setSelectedItem(contractPrompt);
    }

    public void requestFocus() {
        super.requestFocus();
        this.cbContract.requestFocus();
    }

    public void addContract(String string) {
        if (string.length() < 1) {
            this.cbContract.setSelectedItem(contractPrompt);
        } else {
            this.cbContract.setSelectedItem(string);
        }
        this.cbContract.requestFocus();
    }

    private void setContract(String sym) {
        if (sym.length() < 1 || sym.equalsIgnoreCase(contractPrompt)) {
            this.emptyDetail();
            this.SendMBPMessage("", "");
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"Please enter Contract");
        } else if (!this.LastContract.equalsIgnoreCase(sym + ":" + UtilPMEX.GetMarketFromContract((String)sym))) {
            this.emptyDetail();
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Loading, (String)this.languageCentre.getValue(LanguageConstant.Loading));
            this.SendMBPMessage(sym, UtilPMEX.GetMarketFromContract((String)sym));
        }
        this.setPriceFromFeedAndSubcribe(true);
    }

    private void setPriceFromFeedAndSubcribe(boolean isSendFeedRequest) {
        if (isSendFeedRequest) {
            this.mediator.sendFeedContract("", "PMEX_Ladder : setPriceFromFeedAndSubcribe = " + isSendFeedRequest);
        }
    }

    public void feedReceived(PMEXMarketFeedBean pmexMktFeedBean) {
        if (this.pmexMarketFeedBean != null) {
            if (pmexMktFeedBean.getTotalVolume() > this.pmexMarketFeedBean.getTotalVolume()) {
                this.updateVolumeAtPrice(pmexMktFeedBean);
            }
            this.pmexMarketFeedBean = pmexMktFeedBean;
        } else {
            this.pmexMarketFeedBean = pmexMktFeedBean;
        }
    }

    private void updateVolumeAtPrice(PMEXMarketFeedBean pmexMktFeedBean) {
        String key = Util.format4digit((String)(pmexMktFeedBean.getLastTradePrice() + ""));
        if (this.VAP.containsKey(key)) {
            this.VAP.put(key, this.VAP.get(key) + pmexMktFeedBean.getLastTradeVolume());
        } else {
            this.VAP.put(key, pmexMktFeedBean.getLastTradeVolume());
        }
        for (LeaderBean lb : this.rows) {
            if (lb.getPrice() != pmexMktFeedBean.getLastTradePrice() || !this.VAP.containsKey(key)) continue;
            lb.setVAP(this.VAP.get(key).longValue());
        }
        this.model.fireTableDataChanged();
        this.table.addNotify();
        this.table.packAll();
        this.table.repaint();
        this.lastTime = MyTime.getInstance().getTime();
        this.lblLastUpdate.setToolTipText("Last Update Time " + this.lastTime);
    }

    static {
        if (LogCommon.PMEX_LadderColumn.indexOf("|") >= 0) {
            String[] cols;
            for (String col : cols = LogCommon.PMEX_LadderColumn.split("\\|", -1)) {
                if (col.trim().length() <= 0) continue;
                set.add(col);
            }
        } else {
            set.add("VAP");
            set.add("Buy");
            set.add("Sell");
            set.add("Size");
            set.add("Total");
        }
    }
}

