/*
 * Decompiled with CFR 0.152.
 */
package windows.pmex;

import common.bean.MBO_MBP_Bean;
import common.gui.util.MyColors;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JPanel;

public class PMEX_MBP_ContractBars
extends JPanel {
    private List<MBO_MBP_Bean> allRows;
    private long maxCumulativeVol;
    RenderingHints qualityHints;

    public PMEX_MBP_ContractBars() {
        this.initComponents();
        this.qualityHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.qualityHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
    }

    public void setValues(List<MBO_MBP_Bean> allRows, long maxCumulativeVol) {
        this.allRows = allRows;
        this.maxCumulativeVol = maxCumulativeVol;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.allRows != null) {
            int wid = (this.getSize().width - 10) / 2;
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHints(this.qualityHints);
            double slice = new Double(wid) / new Double(this.maxCumulativeVol);
            int height = 3;
            int space = 1;
            for (int i = 0; i < this.allRows.size(); ++i) {
                MBO_MBP_Bean bean = this.allRows.get(i);
                Color bgColor = Color.white;
                if (bean.getVolumeBuy() < bean.getVolumeSell()) {
                    bgColor = MyColors.MBPSellColor[0];
                } else if (bean.getVolumeBuy() > bean.getVolumeSell()) {
                    bgColor = MyColors.MBPBuyColor[0];
                }
                double val = (double)bean.getCumulativeBuy() * slice;
                int x = (int)((double)wid - val);
                int y = 0 + i * (height + space);
                int width = (int)val;
                if (bean.getCumulativeSell() == 0L && bean.getCumulativeBuy() == 0L) continue;
                g2.setColor(bgColor);
                g2.fillRect(x, y, width, height);
                Rectangle2D.Double rect = new Rectangle2D.Double(x, y, width, height);
                g2.setColor(Color.black);
                g2.draw(rect);
                double val2 = (double)bean.getCumulativeSell() * slice;
                x = wid;
                y = 0 + i * (height + space);
                width = (int)val2;
                g2.setColor(bgColor);
                g2.fillRect(x, y, width, height);
                rect = new Rectangle2D.Double(x, y, width, height);
                g2.setColor(Color.black);
                g2.draw(rect);
            }
        }
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 205, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 43, Short.MAX_VALUE));
    }
}

