/*
 * Decompiled with CFR 0.152.
 */
package windows.pmex;

import Control.JasperFileChooser;
import Control.ReportControl;
import Control.ReportControlEvent;
import Control.ReportControlListener;
import CustomComponent.MyTime;
import MyDocking.Mediator;
import RendersNModels.ComboBoxToolTipRender;
import Utilities.LogsTC;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import common.bean.AccountBean;
import common.gui.component.NxGTable;
import common.gui.util.AppConfig;
import common.gui.util.CompressManager;
import common.gui.util.LogCommon;
import common.gui.util.MessageType;
import common.gui.util.Util;
import common.services.WebService;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.text.AbstractDocument;
import javax.swing.text.JTextComponent;
import languages.LanguageCentre;
import languages.LanguageConstant;
import org.jdesktop.swingx.JXDatePicker;
import pmex.gui.bean.PMEXPeriodicTradeDetailBean;
import pmex.gui.model.PMEXPeriodicTradeDetailModel;
import pmex.gui.render.PMEXPeriodicDetailRender;
import pmex.gui.util.LogsPMEX;
import reports.Jasper_Report;
import reports.Report_PeriodicDetail;
import windows.pmex.buyingpower.DocumentSizeAndUppercaseFilter;

public class PMEX_PeriodicTradeDetail
extends JPanel
implements ReportControlListener {
    private String JRXMLFileName = "PMEX_PeriodicTradeDetail.jrxml";
    private Vector<String> column = new Vector();
    private Vector<PMEXPeriodicTradeDetailBean> rowsAll = new Vector();
    private Vector<PMEXPeriodicTradeDetailBean> rows = new Vector();
    private PMEXPeriodicTradeDetailModel model = null;
    private PMEXPeriodicDetailRender render = null;
    private JTextComponent editorScrip;
    private AutoCompleteSupport autoComplete;
    private LanguageCentre languageCentre = new LanguageCentre();
    private JButton btnGet;
    public JComboBox cbAccountNo;
    public JComboBox cbContract;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JLabel lblAccount;
    private JLabel lblFromTradeDate;
    private JLabel lblMsg;
    private JLabel lblPrefix;
    private JLabel lblToTradeDate;
    private ReportControl reportControl1;
    private NxGTable table;
    private JXDatePicker txtFromDate;
    private JXDatePicker txtToTradeDate;

    public PMEX_PeriodicTradeDetail() {
        this.initComponents();
        this.reportControl1.setVisible(false);
        this.txtFromDate.setFormats(new DateFormat[]{LogsTC.dateFormatAcc});
        this.txtToTradeDate.setFormats(new DateFormat[]{LogsTC.dateFormatAcc});
        this.txtFromDate.setDate(new Date(System.currentTimeMillis()));
        this.txtToTradeDate.setDate(new Date(System.currentTimeMillis()));
        this.setAccount();
        this.addContract();
        this.initTable();
        this.editorScrip = (JTextComponent)this.cbContract.getEditor().getEditorComponent();
        this.editorScrip.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                PMEX_PeriodicTradeDetail.this.filterData();
                PMEX_PeriodicTradeDetail.this.addTotalRows();
            }
        });
        this.cbAccountNo.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                PMEX_PeriodicTradeDetail.this.editorScrip.selectAll();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.reportControl1.addListener(this);
    }

    private void setAccount() {
        if (LogsPMEX.accountPrefix.length() > 0) {
            this.lblPrefix.setText(LogsPMEX.accountPrefix);
        } else {
            this.lblPrefix.setText("Account");
        }
        Iterator en = LogsPMEX.ALL_ACCOUNTS.keySet().iterator();
        ArrayList<String> list = new ArrayList<String>();
        while (en.hasNext()) {
            String key = en.next().toString();
            AccountBean ac = (AccountBean)LogsPMEX.ALL_ACCOUNTS.get(key);
            if (ac.getAccountNo().indexOf(LogsPMEX.accountPrefix) == 0) {
                list.add(ac.getAccountNo().replaceFirst(LogsPMEX.accountPrefix, ""));
                continue;
            }
            list.add(ac.getAccountNo());
        }
        this.cbAccountNo.setRenderer(new ComboBoxToolTipRender(LogsPMEX.ALL_ACCOUNTS, LogsPMEX.accountPrefix));
        this.cbAccountNo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    PMEX_PeriodicTradeDetail.this.cbAccountNo.setToolTipText(((AccountBean)LogsPMEX.ALL_ACCOUNTS.get(LogsPMEX.accountPrefix + PMEX_PeriodicTradeDetail.this.cbAccountNo.getSelectedItem().toString().trim())).toString());
                }
                catch (Exception ex) {
                    PMEX_PeriodicTradeDetail.this.cbAccountNo.setToolTipText(null);
                }
            }
        });
        Collections.sort(list);
        this.cbAccountNo.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
        this.autoComplete = AutoCompleteSupport.install((JComboBox)this.cbAccountNo, (EventList)GlazedLists.eventListOf((Object[])list.toArray()));
        this.cbAccountNo.setEditable(true);
        AbstractDocument d = (AbstractDocument)((JTextField)this.cbAccountNo.getEditor().getEditorComponent()).getDocument();
        d.setDocumentFilter(new DocumentSizeAndUppercaseFilter(4));
    }

    private boolean checkValidate() {
        if (this.cbAccountNo.getSelectedItem() == null) {
            Util.setMessage((JLabel)this.lblMsg, (MessageType)MessageType.Information, (String)"Please select account");
            this.cbAccountNo.requestFocus();
            return false;
        }
        if (this.cbAccountNo.getSelectedItem().toString().length() <= 0) {
            Util.setMessage((JLabel)this.lblMsg, (MessageType)MessageType.Information, (String)"Please select account");
            this.cbAccountNo.requestFocus();
            return false;
        }
        if (this.txtFromDate.getDate() == null) {
            Util.setMessage((JLabel)this.lblMsg, (MessageType)MessageType.Information, (String)"Please select from date");
            this.txtFromDate.requestFocus();
            return false;
        }
        if (this.txtToTradeDate == null) {
            Util.setMessage((JLabel)this.lblMsg, (MessageType)MessageType.Information, (String)"Please select to date");
            this.txtToTradeDate.requestFocus();
            return false;
        }
        if (this.txtToTradeDate.getDate().compareTo(this.txtFromDate.getDate()) < 0) {
            Util.setMessage((JLabel)this.lblMsg, (MessageType)MessageType.Information, (String)"From date should be greater then or equal to To date.");
            this.txtFromDate.requestFocus();
            return false;
        }
        return true;
    }

    private void initTable() {
        this.column.add("Account");
        this.column.add("Client Name");
        this.column.add("Execution Date");
        this.column.add("Scrip");
        this.column.add("Buy Quantity");
        this.column.add("Buy Amount");
        this.column.add("Sell Quantity");
        this.column.add("Sell Amount");
        this.column.add("Quantity");
        this.column.add("Item Unit");
        this.column.add("Seesion ID");
        this.column.add("Currency");
        this.column.add("Gross Rate");
        this.column.add("Brokerage Amount");
        this.column.add("Trade Fee");
        this.column.add("IPF Charges");
        this.column.add("SST Charges");
        this.column.add("SECP Charges");
        this.model = new PMEXPeriodicTradeDetailModel(this.rows, this.column);
        this.table.setModel((TableModel)this.model);
        this.table.setColumnControlVisible(false);
        this.table.setSelectionMode(0);
        this.table.setAutoResizeMode(0);
        this.table.setSortable(false);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.getColumn(0).setPreferredWidth(150);
        this.setRender();
    }

    public void addContract() {
        if (this.autoComplete != null && this.autoComplete.isInstalled()) {
            this.autoComplete.uninstall();
        }
        ArrayList v = new ArrayList(LogsPMEX.PMEX_CONTRACT_ALL.keySet());
        Collections.sort(v);
        v.add(0, "");
        this.autoComplete = AutoCompleteSupport.install((JComboBox)this.cbContract, (EventList)GlazedLists.eventListOf((Object[])v.toArray()));
        this.autoComplete.setStrict(false);
        this.cbContract.setSelectedItem("");
    }

    void setRender() {
        this.render = new PMEXPeriodicDetailRender();
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            this.table.getColumn(i).setCellRenderer((TableCellRenderer)this.render);
        }
    }

    private Vector<PMEXPeriodicTradeDetailBean> parseRows(String row) {
        Vector<PMEXPeriodicTradeDetailBean> rows = new Vector<PMEXPeriodicTradeDetailBean>();
        try {
            this.rowsAll.clear();
            if (row.indexOf("|") > 0) {
                String[] pipeSeparate = row.split("\\|", -1);
                for (int i = 0; i < pipeSeparate.length - 1; ++i) {
                    String[] semiColonSeparator = pipeSeparate[i].toString().split("\\;", -1);
                    PMEXPeriodicTradeDetailBean v = PMEXPeriodicTradeDetailBean.parse((String[])semiColonSeparator);
                    Mediator.getInstance().println("PMEXPeriodicTradeDetailBean  = " + v);
                    this.rowsAll.add(v);
                }
            } else {
                Util.setMessage((JLabel)this.lblMsg, (MessageType)MessageType.Information, (String)"No record found");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Mediator.getInstance().PrintLog(ex, row);
        }
        return rows;
    }

    private void filterData() {
        String scrip = this.editorScrip.getText();
        this.rows.clear();
        for (int i = 0; i < this.rowsAll.size(); ++i) {
            PMEXPeriodicTradeDetailBean v = this.rowsAll.get(i);
            if (scrip.equalsIgnoreCase("") || scrip.equalsIgnoreCase("ALL")) {
                this.rows.addElement(v);
                continue;
            }
            if (v.getScrip().indexOf(scrip) != 0) continue;
            this.rows.addElement(v);
        }
        this.tableDataChange(false);
    }

    private void addTotalRows() {
        String oldScrip = "";
        Vector<PMEXPeriodicTradeDetailBean> row = new Vector<PMEXPeriodicTradeDetailBean>();
        long buyQty = 0L;
        long sellQty = 0L;
        long buyQtyGT = 0L;
        long sellQtyGT = 0L;
        long QuantityGT = 0L;
        long Quantity = 0L;
        double buyAmt = 0.0;
        double sellAmt = 0.0;
        double brokAmt = 0.0;
        double netAmt = 0.0;
        double tradeFee = 0.0;
        double tradeFeeGT = 0.0;
        double IPFCharges = 0.0;
        double IPFChargesGT = 0.0;
        double SSTCharges = 0.0;
        double SSTChargesGT = 0.0;
        double SECPCharges = 0.0;
        double SECPChargesGT = 0.0;
        double buyAmtGT = 0.0;
        double sellAmtGT = 0.0;
        double brokAmtGT = 0.0;
        double netAmtGT = 0.0;
        for (int i = 0; i < this.rows.size(); ++i) {
            PMEXPeriodicTradeDetailBean beanTotal;
            PMEXPeriodicTradeDetailBean bean = this.rows.get(i);
            if (i == 0) {
                oldScrip = bean.getScrip();
            }
            if (oldScrip.equalsIgnoreCase(bean.getScrip())) {
                buyQty += bean.getBuyQuantity();
                sellQty += bean.getSellQuantity();
                buyAmt += bean.getBuyAmount();
                sellAmt += bean.getSellAmount();
                brokAmt += bean.getBrokerageAmount();
                Quantity += bean.getQuantity();
                tradeFee += bean.getTradeFee();
                IPFCharges += bean.getIPFCharges();
                SSTCharges += bean.getSSTCharges();
                SECPCharges += bean.getSECPCharges();
                buyQtyGT += bean.getBuyQuantity();
                sellQtyGT += bean.getSellQuantity();
                buyAmtGT += bean.getBuyAmount();
                sellAmtGT += bean.getSellAmount();
                brokAmtGT += bean.getBrokerageAmount();
                QuantityGT += bean.getQuantity();
                tradeFeeGT += bean.getTradeFee();
                IPFChargesGT += bean.getIPFCharges();
                SSTChargesGT += bean.getSSTCharges();
                SECPChargesGT += bean.getSECPCharges();
                row.add(bean);
            } else {
                beanTotal = new PMEXPeriodicTradeDetailBean();
                beanTotal.setScrip("Total");
                beanTotal.setBuyQuantity(buyQty);
                beanTotal.setSellQuantity(sellQty);
                beanTotal.setBuyAmount(buyAmt);
                beanTotal.setSellAmount(sellAmt);
                beanTotal.setBrokerageAmount(brokAmt);
                beanTotal.setQuantity(Quantity);
                beanTotal.setTradeFee(tradeFee);
                beanTotal.setIPFCharges(IPFCharges);
                beanTotal.setSSTCharges(SSTCharges);
                beanTotal.setSECPCharges(SECPCharges);
                row.add(beanTotal);
                row.add(bean);
                buyQty = bean.getBuyQuantity();
                sellQty = bean.getSellQuantity();
                buyAmt = bean.getBuyAmount();
                sellAmt = bean.getSellAmount();
                brokAmt = bean.getBrokerageAmount();
                Quantity = bean.getQuantity();
                tradeFee = bean.getTradeFee();
                IPFCharges = bean.getIPFCharges();
                SSTCharges = bean.getSSTCharges();
                SECPCharges = bean.getSECPCharges();
                buyQtyGT += bean.getBuyQuantity();
                sellQtyGT += bean.getSellQuantity();
                buyAmtGT += bean.getBuyAmount();
                sellAmtGT += bean.getSellAmount();
                brokAmtGT += bean.getBrokerageAmount();
                QuantityGT += bean.getQuantity();
                tradeFeeGT += bean.getTradeFee();
                IPFChargesGT += bean.getIPFCharges();
                SSTChargesGT = bean.getSSTCharges();
                SECPChargesGT = bean.getSECPCharges();
                oldScrip = bean.getScrip();
            }
            if (i != this.rows.size() - 1) continue;
            beanTotal = new PMEXPeriodicTradeDetailBean();
            PMEXPeriodicTradeDetailBean beanGTotal = new PMEXPeriodicTradeDetailBean();
            beanTotal.setScrip("Total");
            beanTotal.setBuyQuantity(buyQty);
            beanTotal.setSellQuantity(sellQty);
            beanTotal.setBuyAmount(buyAmt);
            beanTotal.setSellAmount(sellAmt);
            beanTotal.setBrokerageAmount(brokAmt);
            beanTotal.setQuantity(Quantity);
            beanTotal.setTradeFee(tradeFee);
            beanTotal.setIPFCharges(IPFCharges);
            beanTotal.setSSTCharges(SSTCharges);
            beanTotal.setSECPCharges(SECPCharges);
            beanGTotal.setScrip("Grand Total");
            beanGTotal.setBuyQuantity(buyQtyGT);
            beanGTotal.setSellQuantity(sellQtyGT);
            beanGTotal.setBuyAmount(buyAmtGT);
            beanGTotal.setSellAmount(sellAmtGT);
            beanGTotal.setBrokerageAmount(brokAmtGT);
            beanGTotal.setQuantity(QuantityGT);
            beanGTotal.setTradeFee(tradeFeeGT);
            beanGTotal.setIPFCharges(IPFChargesGT);
            beanGTotal.setSSTCharges(SSTChargesGT);
            beanGTotal.setSECPCharges(SECPChargesGT);
            row.add(beanTotal);
            row.add(beanGTotal);
        }
        this.rows.clear();
        this.rows.addAll(row);
        this.tableDataChange(true);
    }

    private Vector<String> getColumnParse(String colName) {
        try {
            String[] pipeSeparate = colName.split("\\$", -1);
            String[] semiColonSeparator = pipeSeparate[0].toString().split("\\;", -1);
            this.column.clear();
            for (int i = 0; i < semiColonSeparator.length - 1; ++i) {
                if (semiColonSeparator[i].trim().length() <= 0) continue;
                this.column.add(semiColonSeparator[i]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return this.column;
    }

    private void tableDataChange(final boolean isPack) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.model.fireTableDataChanged();
            if (isPack) {
                this.table.packAll();
            }
            this.table.addNotify();
            this.table.repaint();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PMEX_PeriodicTradeDetail.this.model.fireTableDataChanged();
                    if (isPack) {
                        PMEX_PeriodicTradeDetail.this.table.packAll();
                    }
                    PMEX_PeriodicTradeDetail.this.table.addNotify();
                    PMEX_PeriodicTradeDetail.this.table.repaint();
                }
            });
        }
    }

    private synchronized void setData(String result) {
        Util.setMessage((JLabel)this.lblMsg, (MessageType)MessageType.EMPTY, (String)"");
        this.rows.clear();
        if (result.indexOf("$") > 0) {
            int index = result.indexOf("$");
            String colSep = result.substring(++index);
            this.parseRows(colSep);
            this.filterData();
            this.addTotalRows();
        } else {
            Util.setMessage((JLabel)this.lblMsg, (MessageType)MessageType.Information, (String)"No record found");
        }
        this.tableDataChange(true);
    }

    private void initComponents() {
        this.lblFromTradeDate = new JLabel();
        this.txtFromDate = new JXDatePicker();
        this.lblToTradeDate = new JLabel();
        this.txtToTradeDate = new JXDatePicker();
        this.lblAccount = new JLabel();
        this.cbAccountNo = new JComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.table = new NxGTable();
        this.reportControl1 = new ReportControl();
        this.btnGet = new JButton();
        this.jSeparator1 = new JSeparator();
        this.lblMsg = new JLabel();
        this.cbContract = new JComboBox();
        this.lblPrefix = new JLabel();
        this.lblFromTradeDate.setText("From Date");
        this.lblToTradeDate.setText("To Date");
        this.lblAccount.setHorizontalAlignment(2);
        this.lblAccount.setText("Contract ");
        this.cbAccountNo.setEditable(true);
        this.table.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.table.setAutoResizeMode(0);
        this.jScrollPane1.setViewportView((Component)this.table);
        this.btnGet.setIcon(new ImageIcon(this.getClass().getResource("/Images/get.png")));
        this.btnGet.setText("Get");
        this.btnGet.setMaximumSize(new Dimension(49, 22));
        this.btnGet.setMinimumSize(new Dimension(49, 22));
        this.btnGet.setName("PMEX_PeriodicTradeDetail -> btnGet");
        this.btnGet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PMEX_PeriodicTradeDetail.this.btnGetActionPerformed(evt);
            }
        });
        this.cbContract.setEditable(true);
        this.lblPrefix.setHorizontalAlignment(2);
        this.lblPrefix.setText("Account");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.lblAccount, -2, 50, -2).addGap(0, 0, 0).addComponent(this.cbContract, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.reportControl1, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jScrollPane1))).addContainerGap()).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.lblPrefix, -2, 50, -2).addGap(2, 2, 2).addComponent(this.cbAccountNo, -2, 100, -2).addGap(10, 10, 10).addComponent(this.lblFromTradeDate, -2, 60, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.txtFromDate, -2, 107, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.lblToTradeDate, -2, 50, -2).addGap(0, 0, 0).addComponent((Component)this.txtToTradeDate, -2, 100, -2).addGap(10, 10, 10).addComponent(this.btnGet, -2, 70, -2)).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.lblMsg, -2, 525, -2))).addGap(0, 109, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblPrefix, -2, 22, -2).addComponent(this.cbAccountNo, -2, 22, -2).addComponent(this.lblFromTradeDate, -2, 22, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblToTradeDate, -2, 22, -2).addComponent((Component)this.txtFromDate, -2, -1, -2)).addComponent((Component)this.txtToTradeDate, -2, -1, -2).addComponent(this.btnGet, -2, 22, -2)).addGap(8, 8, 8).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblAccount, -2, 22, -2).addComponent(this.cbContract, -2, 22, -2).addComponent(this.reportControl1, -2, -1, -2)).addGap(10, 10, 10).addComponent(this.jScrollPane1, -1, 117, Short.MAX_VALUE).addGap(6, 6, 6).addComponent(this.jSeparator1, -2, -1, -2).addGap(6, 6, 6).addComponent(this.lblMsg, -2, 16, -2)));
    }

    private void btnGetActionPerformed(ActionEvent evt) {
        this.getData();
    }

    @Override
    public void ReportControl_Print(ReportControlEvent e) {
        Report_PeriodicDetail Report = new Report_PeriodicDetail(this.JRXMLFileName, this.table.getModel());
        this.SetParameter((Jasper_Report)Report);
        if (!Report.isHasPage()) {
            return;
        }
        Report.PrintReport();
    }

    @Override
    public void ReportControl_Save(ReportControlEvent e) {
        String FileName;
        boolean result;
        Report_PeriodicDetail Report = new Report_PeriodicDetail(this.JRXMLFileName, this.table.getModel());
        this.SetParameter((Jasper_Report)Report);
        if (!Report.isHasPage()) {
            return;
        }
        JasperFileChooser fc = new JasperFileChooser(new File(""));
        fc.setSelectedFile(new File("Periodic Trade Detail-" + MyTime.getInstance().getDate()));
        fc.addAllJasperChoosableFileFilter();
        fc.setAcceptAllFileFilterUsed(false);
        fc.showSaveDialog(this);
        if (fc.getSelectedFile() != null && !(result = Report.Export(FileName = fc.getSelectedFile().getAbsolutePath() + "." + fc.getExtenstion()))) {
            JOptionPane.showMessageDialog(null, "Error in saving file.");
        }
    }

    @Override
    public void ReportControl_Pdf(ReportControlEvent e) {
        int Option;
        String FileName;
        boolean result;
        Report_PeriodicDetail Report = new Report_PeriodicDetail(this.JRXMLFileName, this.table.getModel());
        this.SetParameter((Jasper_Report)Report);
        if (!Report.isHasPage()) {
            return;
        }
        JasperFileChooser fc = new JasperFileChooser(new File(""));
        fc.setSelectedFile(new File("Periodic Trade Detail-" + MyTime.getInstance().getDate()));
        fc.addPdfFileFilter();
        fc.showSaveDialog(this);
        if (fc.getSelectedFile() != null && (result = Report.ExportToPdf(FileName = fc.getSelectedFile().getAbsolutePath().replaceAll("\"", "") + "." + fc.getExtenstion())) && (Option = JOptionPane.showConfirmDialog(null, "Periodic Trade Detail report created. Do you want to open it?", "PDF", 0)) == 0) {
            try {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + FileName);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void ReportControl_View(ReportControlEvent e) {
        Report_PeriodicDetail Report = new Report_PeriodicDetail(this.JRXMLFileName, this.table.getModel());
        this.SetParameter((Jasper_Report)Report);
        if (!Report.isHasPage()) {
            return;
        }
        Report.generateReport();
    }

    @Override
    public void ReportControl_CustomExport(ReportControlEvent e) {
    }

    private void SetParameter(Jasper_Report Report) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("Title", AppConfig.companyName);
        param.put("Time", MyTime.getInstance().getTime());
        param.put("PrintDate", MyTime.getInstance().getTimeAndDateForReport());
        param.put("FromDate", LogsTC.dateFormatAcc.format(this.txtFromDate.getDate()));
        param.put("ToDate", LogsTC.dateFormatAcc.format(this.txtToTradeDate.getDate()));
        param.put("AccountNo", this.cbAccountNo.getSelectedItem().toString());
        param.put("UserID", LogCommon.UserID);
        Report.SetParameter(param);
    }

    private String getSelectedAccount() {
        if (this.cbAccountNo.getSelectedItem() == null) {
            return "";
        }
        if (this.cbAccountNo.getSelectedItem().toString().trim().equalsIgnoreCase("")) {
            return "";
        }
        return LogsPMEX.accountPrefix + this.cbAccountNo.getSelectedItem().toString().trim();
    }

    private void getData() {
        if (this.checkValidate()) {
            new Thread("PMEX_PeriodicTradeDetail"){

                @Override
                public void run() {
                    try {
                        PMEX_PeriodicTradeDetail.this.rowsAll.clear();
                        PMEX_PeriodicTradeDetail.this.rows.clear();
                        PMEX_PeriodicTradeDetail.this.tableDataChange(false);
                        Util.setMessage((JLabel)PMEX_PeriodicTradeDetail.this.lblMsg, (MessageType)MessageType.Loading, (String)PMEX_PeriodicTradeDetail.this.languageCentre.getValue(LanguageConstant.Loading));
                        byte[] data = WebService.getInstance().getPort().getOrderHistory(LogCommon.UserID, PMEX_PeriodicTradeDetail.this.getSelectedAccount(), "", "", "", LogsTC.dateFormatAcc.format(PMEX_PeriodicTradeDetail.this.txtFromDate.getDate()), LogsTC.dateFormatAcc.format(PMEX_PeriodicTradeDetail.this.txtToTradeDate.getDate()), "PMEX_PeriodicTradeDetail");
                        String result = CompressManager.unzipStringFromBytes((byte[])data);
                        Mediator.getInstance().println("PMEX_PeriodicTradeDetail = " + result);
                        PMEX_PeriodicTradeDetail.this.setData(result);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        Util.setMessage((JLabel)PMEX_PeriodicTradeDetail.this.lblMsg, (MessageType)MessageType.Error, (String)"Error in loading data");
                    }
                }
            }.start();
        }
    }
}

