/*
 * Decompiled with CFR 0.152.
 */
package windows.pmex;

import CustomComponent.MyTime;
import MyDocking.Mediator;
import common.gui.component.NxGTable;
import common.gui.util.AppConfig;
import common.gui.util.MessageType;
import common.gui.util.Util;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import languages.LanguageCentre;
import languages.LanguageConstant;
import pmex.gui.bean.RiskWatchBean;
import pmex.gui.model.RiskWatchModel;
import pmex.gui.render.RiskWatchRender;
import pmex.gui.util.LogsPMEX;
import windows.pmex.buyingpower.PMEX_BuyingPower_Dock_Panel;

public class PMEX_RiskWatch
extends JPanel {
    private Vector<String> column = new Vector();
    private Vector<RiskWatchBean> rows = new Vector();
    private RiskWatchModel model = null;
    private RiskWatchRender render;
    int LastSortCol = -1;
    String LastSortOrd = "ASC";
    protected boolean isSortAsc;
    private String lastTime = " ";
    private LanguageCentre languageCentre = new LanguageCentre();
    private JScrollPane jScrollPane2;
    private JLabel lblLastUpdate;
    private JLabel lblMessage;
    private NxGTable table;
    private JSeparator tableSeperator;

    public PMEX_RiskWatch() {
        try {
            this.initComponents();
            Mediator.getInstance().setPMEX_RiskWatch(this);
            this.column.add("Traders");
            this.column.add("Net Liqudity");
            this.column.add("Margin Requirement");
            this.column.add("Realized P/L");
            this.column.add("Unrealized P/L");
            this.column.add("Buying Power");
            this.column.add("% Buying Power Used");
            this.column.add("Threshold");
            this.model = new RiskWatchModel(this.rows, this.column, (JTable)this.table);
            this.table.setModel((TableModel)this.model);
            this.table.setAutoCreateRowSorter(false);
            this.tableDataChange();
            this.table.getColumnExt(0).setComparator((Comparator)new RiskWatchComparator(0, this.isSortAsc));
            JTableHeader header = this.table.getTableHeader();
            header.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    PMEX_RiskWatch.this.ClickForSort(evt);
                }
            });
            this.setColumnWidth();
            this.setRender();
            Mediator.getInstance().ResetTimerBuyingPower();
            this.lblLastUpdate.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    PMEX_RiskWatch.this.lblLastUpdate.setText(PMEX_RiskWatch.this.lastTime);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    PMEX_RiskWatch.this.lblLastUpdate.setText("  ");
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void ParseBuyingPower(String result) {
        if (result.indexOf("$") >= 0) {
            String[] allRows = result.split("\\$", -1);
            for (int i = 0; i < allRows.length; ++i) {
                String singleRow = allRows[i];
                if (singleRow.indexOf(";") < 0) continue;
                boolean isFound = false;
                RiskWatchBean bean = RiskWatchBean.parse((String)singleRow);
                for (RiskWatchBean rowObj : this.rows) {
                    if (rowObj.getAccount().equalsIgnoreCase(bean.getAccount())) {
                        isFound = true;
                        int index = this.rows.indexOf(rowObj);
                        this.rows.remove(rowObj);
                        this.rows.add(index, bean);
                        break;
                    }
                    isFound = false;
                }
                if (isFound) continue;
                this.rows.add(bean);
            }
        }
        if (this.rows.size() <= 0) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Normal, (String)"No record found.");
        } else if (this.rows.size() == 1) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)(Util.format0digit((String)(this.rows.size() + "")) + " record found."));
        } else {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)(Util.format0digit((String)(this.rows.size() + "")) + " records found."));
        }
        this.model.fireTableDataChanged();
        this.table.packAll();
        this.tableDataChange();
        this.lastTime = MyTime.getInstance().getTime();
        this.lblLastUpdate.setToolTipText("Last Update Time " + this.lastTime);
    }

    private void emptyTable() {
        Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.EMPTY, (String)"");
        this.rows.clear();
        this.model.fireTableDataChanged();
        this.tableDataChange();
    }

    private void initPanel(String title, PMEX_BuyingPower_Dock_Panel panel) {
        panel.setTitle(title);
        panel.setFont(AppConfig.defaultBoldFontExStats2);
        panel.setBorder(UIManager.getBorder("PopupMenu.border"));
        if (title.equalsIgnoreCase("Net Liquidity")) {
            panel.setIcon(new ImageIcon(this.getClass().getResource("/pmex/gui/images/netPosition24x24.png")));
        } else if (title.equalsIgnoreCase("Margin Required")) {
            panel.setIcon(new ImageIcon(this.getClass().getResource("/pmex/gui/images/marginRequired24x24.png")));
        } else if (title.equalsIgnoreCase("Buying Power")) {
            panel.setIcon(new ImageIcon(this.getClass().getResource("/pmex/gui/images/buyingPower24x24.png")));
        } else if (title.equalsIgnoreCase("Realized P/L")) {
            panel.setIcon(new ImageIcon(this.getClass().getResource("/pmex/gui/images/realisedPL24x24.png")));
        } else if (title.equalsIgnoreCase("Unrealized P/L")) {
            panel.setIcon(new ImageIcon(this.getClass().getResource("/pmex/gui/images/unrealisedPL24x24.png")));
        } else if (title.equalsIgnoreCase("% Buying Power Used")) {
            panel.setIcon(new ImageIcon(this.getClass().getResource("/pmex/gui/images/buyingPwerPercent24x24.png")));
        }
    }

    private void tableDataChange() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.table.addNotify();
            this.table.repaint();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PMEX_RiskWatch.this.table.addNotify();
                    PMEX_RiskWatch.this.table.repaint();
                }
            });
        }
    }

    public void ClickForSort(MouseEvent evt) {
        JTable table_ = ((JTableHeader)evt.getSource()).getTable();
        TableColumnModel colModel = table_.getColumnModel();
        int vColIndex = colModel.getColumnIndexAtX(evt.getX());
        int mColIndex = this.table.convertColumnIndexToModel(vColIndex);
        if (vColIndex != -1) {
            if (this.LastSortCol == mColIndex) {
                this.isSortAsc = !this.isSortAsc;
            } else {
                this.LastSortCol = mColIndex;
            }
            Collections.sort(this.rows, new RiskWatchComparator(mColIndex, this.isSortAsc));
            this.tableDataChange();
            this.model.fireTableDataChanged();
            this.table.packAll();
            this.tableDataChange();
        }
    }

    private void initComponents() {
        this.jScrollPane2 = new JScrollPane();
        this.table = new NxGTable();
        this.tableSeperator = new JSeparator();
        this.lblMessage = new JLabel();
        this.lblLastUpdate = new JLabel();
        this.table.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.table.setSortable(false);
        this.jScrollPane2.setViewportView((Component)this.table);
        this.lblLastUpdate.setHorizontalAlignment(4);
        this.lblLastUpdate.setIcon(new ImageIcon(this.getClass().getResource("/Images/lastUpdateTime16.png")));
        this.lblLastUpdate.setHorizontalTextPosition(2);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tableSeperator).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2).addGroup(layout.createSequentialGroup().addComponent(this.lblMessage, -2, 431, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 139, Short.MAX_VALUE).addComponent(this.lblLastUpdate, -2, 210, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2, -1, 231, Short.MAX_VALUE).addGap(5, 5, 5).addComponent(this.tableSeperator, -2, 3, -2).addGap(2, 2, 2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblMessage, -2, 20, -2).addComponent(this.lblLastUpdate, -2, 20, -2)).addGap(5, 5, 5)));
    }

    private void setRender() {
        this.render = new RiskWatchRender((JTable)this.table);
        for (int k = 0; k < this.column.size(); ++k) {
            this.table.getColumn((Object)this.column.elementAt(k)).setCellRenderer((TableCellRenderer)this.render);
        }
    }

    private void setColumnWidth() {
    }

    public void setLoading() {
        Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Loading, (String)this.languageCentre.getValue(LanguageConstant.Loading));
    }

    private class RiskWatchComparator
    implements Comparator<RiskWatchBean> {
        private final int columnIndex;
        protected boolean isSortAscA;

        public RiskWatchComparator(int columnIndex, boolean sortAsc) {
            this.columnIndex = columnIndex;
            this.isSortAscA = sortAsc;
        }

        @Override
        public int compare(RiskWatchBean o1, RiskWatchBean o2) {
            int result = 0;
            if (this.columnIndex == 0) {
                try {
                    long account1 = Long.parseLong(o1.getAccount().replaceFirst(LogsPMEX.accountPrefix, ""));
                    long account2 = Long.parseLong(o2.getAccount().replaceFirst(LogsPMEX.accountPrefix, ""));
                    result = account1 < account2 ? -1 : (account1 > account2 ? 1 : 0);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else if (this.columnIndex == 1) {
                long d2;
                long d1 = o1.getNetLiqudity();
                result = d1 < (d2 = o2.getNetLiqudity()) ? -1 : (d1 > d2 ? 1 : 0);
            } else if (this.columnIndex == 2) {
                double d2;
                double d1 = o1.getMarginRequirement();
                result = d1 < (d2 = o2.getMarginRequirement()) ? -1 : (d1 > d2 ? 1 : 0);
            } else if (this.columnIndex == 3) {
                double d2;
                double d1 = o1.getRealized();
                result = d1 < (d2 = o2.getRealized()) ? -1 : (d1 > d2 ? 1 : 0);
            } else if (this.columnIndex == 4) {
                double d2;
                double d1 = o1.getUnrealized();
                result = d1 < (d2 = o2.getUnrealized()) ? -1 : (d1 > d2 ? 1 : 0);
            } else if (this.columnIndex == 5) {
                double d2;
                double d1 = o1.getBuyingPower();
                result = d1 < (d2 = o2.getBuyingPower()) ? -1 : (d1 > d2 ? 1 : 0);
            } else if (this.columnIndex == 6) {
                double d2;
                double d1 = o1.getBuyingPowerPercentUsed();
                result = d1 < (d2 = o2.getBuyingPowerPercentUsed()) ? -1 : (d1 > d2 ? 1 : 0);
            } else if (this.columnIndex == 7) {
                double d2;
                double d1 = o1.getThreshold();
                int n = d1 < (d2 = o2.getThreshold()) ? -1 : (result = d1 > d2 ? 1 : 0);
            }
            if (!this.isSortAscA) {
                result = -result;
            }
            return result;
        }
    }
}

