/*
 * Decompiled with CFR 0.152.
 */
package windows.pmex.buyingpower;

import javax.swing.JOptionPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public class DocumentSizeAndUppercaseFilter
extends DocumentFilter {
    private final int max;

    public DocumentSizeAndUppercaseFilter(int max) {
        this.max = max;
    }

    @Override
    public void insertString(DocumentFilter.FilterBypass fb, int offset, String text, AttributeSet attr) throws BadLocationException {
        if (fb.getDocument().getLength() + text.length() <= this.max) {
            super.insertString(fb, offset, text.toUpperCase(), attr);
        }
    }

    @Override
    public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
        int documentLength = fb.getDocument().getLength();
        if (documentLength - length + text.length() <= this.max) {
            super.replace(fb, offset, length, text.toUpperCase(), attrs);
        }
    }

    private void showError() {
        JOptionPane.showMessageDialog(null, "Too many characters entered");
    }
}

