/*
 * Decompiled with CFR 0.152.
 */
package windows.pmex.buyingpower;

import CustomComponent.MyTime;
import MyDocking.Mediator;
import RendersNModels.ComboBoxToolTipRender;
import Utilities.CompressManager;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import common.bean.AccountBean;
import common.gui.component.NxGScrollBarUI;
import common.gui.component.NxGTable;
import common.gui.layout.NxGWrapLayout;
import common.gui.util.AppConfig;
import common.gui.util.LogCommon;
import common.gui.util.MessageType;
import common.gui.util.Util;
import common.services.WebServiceTraderPosition;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.text.AbstractDocument;
import languages.LanguageCentre;
import languages.LanguageConstant;
import pmex.gui.bean.TraderPositionBeans;
import pmex.gui.model.TraderPositionModel;
import pmex.gui.render.TraderPositionRender;
import pmex.gui.util.LogsPMEX;
import windows.pmex.buyingpower.DocumentSizeAndUppercaseFilter;
import windows.pmex.buyingpower.PMEX_BuyingPower_Dock_Panel;

public class PMEX_BuyingPower
extends JPanel {
    Vector<String> column = new Vector();
    Vector<TraderPositionBeans> rows = new Vector();
    TraderPositionModel model = null;
    private TraderPositionRender render;
    private String previousResut = "";
    private boolean showMessage = true;
    private Timer timer2 = null;
    private final int CALL_DELAY = 15000;
    private String lastTime = " ";
    private LanguageCentre languageCentre = new LanguageCentre();
    private JButton btnRefresh;
    private JComboBox cbAccountNo;
    private JPanel jPanel1;
    private JScrollPane jScrollPane2;
    private JLabel lblLastUpdate;
    private JLabel lblMessage;
    private JLabel lblPrefix;
    private JLabel lbltraders;
    private PMEX_BuyingPower_Dock_Panel pnlBuyPowerPercentUsed;
    private PMEX_BuyingPower_Dock_Panel pnlBuyingPower;
    private PMEX_BuyingPower_Dock_Panel pnlMarginRequired;
    private PMEX_BuyingPower_Dock_Panel pnlNetLiquidity;
    private PMEX_BuyingPower_Dock_Panel pnlRealizedPL;
    private PMEX_BuyingPower_Dock_Panel pnlThreshold;
    private PMEX_BuyingPower_Dock_Panel pnlUnrealizedPL;
    private JScrollPane scrollPane;
    private NxGTable table;
    private JSeparator tableSeperator;

    public PMEX_BuyingPower() {
        try {
            this.initComponents();
            Mediator.getInstance().setPMEX_BuyingPower(this);
            this.column.add("Traders");
            this.column.add("Contract");
            this.column.add("Position");
            this.column.add("Realized P/L");
            this.column.add("Unrealized P/L");
            this.column.add("Intl-Unrealized P/L");
            this.column.add("Intl-Price");
            this.model = new TraderPositionModel(this.rows, this.column, (JTable)this.table);
            this.table.setModel((TableModel)this.model);
            this.table.setAutoCreateRowSorter(true);
            this.table.addNotify();
            this.table.repaint();
            this.cbAccountNo.setMaximumRowCount(7);
            this.setColumnWidth();
            this.setAccounts();
            this.setRender();
            this.initPanel("Net Liquidity", this.pnlNetLiquidity);
            this.initPanel("Margin Required", this.pnlMarginRequired);
            this.initPanel("Buying Power", this.pnlBuyingPower);
            this.initPanel("Threshold", this.pnlThreshold);
            this.initPanel("Realized P/L", this.pnlRealizedPL);
            this.initPanel("Unrealized P/L", this.pnlUnrealizedPL);
            this.initPanel("% Buying Power Used", this.pnlBuyPowerPercentUsed);
            this.pnlNetLiquidity.setPreferredSize(new Dimension(200, 40));
            this.pnlMarginRequired.setPreferredSize(new Dimension(200, 40));
            this.pnlBuyingPower.setPreferredSize(new Dimension(200, 40));
            this.pnlThreshold.setPreferredSize(new Dimension(125, 40));
            this.pnlRealizedPL.setPreferredSize(new Dimension(200, 40));
            this.pnlUnrealizedPL.setPreferredSize(new Dimension(200, 40));
            this.pnlBuyPowerPercentUsed.setPreferredSize(new Dimension(200, 40));
            this.jPanel1.setLayout((LayoutManager)new NxGWrapLayout());
            this.jPanel1.add(this.pnlNetLiquidity);
            this.jPanel1.add(this.pnlMarginRequired);
            this.jPanel1.add(this.pnlBuyingPower);
            this.jPanel1.add(this.pnlThreshold);
            this.jPanel1.add(this.pnlRealizedPL);
            this.jPanel1.add(this.pnlUnrealizedPL);
            this.jPanel1.add(this.pnlBuyPowerPercentUsed);
            this.scrollPane.setHorizontalScrollBarPolicy(30);
            this.scrollPane.setVerticalScrollBarPolicy(20);
            UIManager.put("ScrollBar.background", 1);
            JScrollBar vbar = this.scrollPane.getVerticalScrollBar();
            NxGScrollBarUI ui2 = new NxGScrollBarUI();
            ui2.setMyScrollBarUI(vbar);
            vbar.setPreferredSize(new Dimension(7, 0));
            this.scrollPane.setHorizontalScrollBarPolicy(30);
            this.sendRequestBuyingPower();
            this.lblLastUpdate.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    PMEX_BuyingPower.this.lblLastUpdate.setText(PMEX_BuyingPower.this.lastTime);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    PMEX_BuyingPower.this.lblLastUpdate.setText("  ");
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void initPanel(String title, PMEX_BuyingPower_Dock_Panel panel) {
        panel.setTitle(title);
        panel.setFont(AppConfig.defaultBoldFontExStats2);
        panel.setBorder(UIManager.getBorder("PopupMenu.border"));
        if (title.equalsIgnoreCase("Net Liquidity")) {
            panel.setIcon(new ImageIcon(this.getClass().getResource("/pmex/gui/images/netPosition24x24.png")));
        } else if (title.equalsIgnoreCase("Margin Required")) {
            panel.setIcon(new ImageIcon(this.getClass().getResource("/pmex/gui/images/marginRequired24x24.png")));
        } else if (title.equalsIgnoreCase("Buying Power")) {
            panel.setIcon(new ImageIcon(this.getClass().getResource("/pmex/gui/images/buyingPower24x24.png")));
        } else if (title.equalsIgnoreCase("Realized P/L")) {
            panel.setIcon(new ImageIcon(this.getClass().getResource("/pmex/gui/images/realisedPL24x24.png")));
        } else if (title.equalsIgnoreCase("Unrealized P/L")) {
            panel.setIcon(new ImageIcon(this.getClass().getResource("/pmex/gui/images/unrealisedPL24x24.png")));
        } else if (title.equalsIgnoreCase("% Buying Power Used")) {
            panel.setIcon(new ImageIcon(this.getClass().getResource("/pmex/gui/images/buyingPwerPercent24x24.png")));
        } else if (title.equalsIgnoreCase("Threshold")) {
            panel.setIcon(new ImageIcon(this.getClass().getResource("/pmex/gui/images/threshold24x24.png")));
        }
    }

    private void setAccounts() {
        if (LogsPMEX.accountPrefix.length() > 0) {
            this.lblPrefix.setText(LogsPMEX.accountPrefix);
        } else {
            this.lblPrefix.setVisible(false);
            this.lblPrefix.setText(" ");
        }
        Iterator en = LogsPMEX.ALL_ACCOUNTS.keySet().iterator();
        ArrayList<String> list = new ArrayList<String>();
        list.add("ALL");
        while (en.hasNext()) {
            String key = en.next().toString();
            AccountBean ac = (AccountBean)LogsPMEX.ALL_ACCOUNTS.get(key);
            if (ac.getAccountNo().indexOf(LogsPMEX.accountPrefix) == 0) {
                list.add(ac.getAccountNo().replaceFirst(LogsPMEX.accountPrefix, ""));
                continue;
            }
            list.add(ac.getAccountNo());
        }
        this.cbAccountNo.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
        AutoCompleteSupport support = AutoCompleteSupport.install((JComboBox)this.cbAccountNo, (EventList)GlazedLists.eventListOf((Object[])list.toArray()));
        support.setStrict(false);
        this.cbAccountNo.setRenderer(new ComboBoxToolTipRender(LogsPMEX.ALL_ACCOUNTS, LogsPMEX.accountPrefix));
        this.cbAccountNo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    PMEX_BuyingPower.this.cbAccountNo.setToolTipText(((AccountBean)LogsPMEX.ALL_ACCOUNTS.get(LogsPMEX.accountPrefix + PMEX_BuyingPower.this.cbAccountNo.getSelectedItem().toString().trim())).toString());
                }
                catch (Exception ex) {
                    PMEX_BuyingPower.this.cbAccountNo.setToolTipText(null);
                }
            }
        });
        try {
            if (this.cbAccountNo.getItemCount() > 0) {
                if (LogCommon.preferredAccountPMEX.trim().length() > 0) {
                    this.cbAccountNo.setSelectedItem(LogCommon.preferredAccountPMEX.replaceFirst(LogsPMEX.accountPrefix, ""));
                } else {
                    this.cbAccountNo.setSelectedItem("");
                }
            } else {
                this.cbAccountNo.setSelectedItem("");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        AbstractDocument d = (AbstractDocument)((JTextField)this.cbAccountNo.getEditor().getEditorComponent()).getDocument();
        d.setDocumentFilter(new DocumentSizeAndUppercaseFilter(4));
    }

    private void setValues(String title, PMEX_BuyingPower_Dock_Panel panel, String value, boolean isForeColor, boolean isPercent, int columnIndex, boolean isShowPKR, boolean isDecimal, boolean isShowPercent) {
        if (this.cbAccountNo.getSelectedItem().toString().trim().length() > 0) {
            panel.setValue(value + "", isForeColor, isShowPKR, isDecimal, isShowPercent);
            if (isPercent) {
                if (columnIndex == 5) {
                    try {
                        panel.setPercent((int)Double.parseDouble(value.toString()), true);
                    }
                    catch (Exception ex) {
                        panel.setPercent(0, true);
                        ex.printStackTrace();
                    }
                } else {
                    try {
                        double d = Double.parseDouble(this.pnlBuyPowerPercentUsed.getValue() + "");
                        int per = (int)(100.0 - d);
                        panel.setPercent(per, false);
                    }
                    catch (Exception ex) {
                        panel.setPercent(0, false);
                        ex.printStackTrace();
                    }
                }
            }
            panel.setToolTipText(title + " : " + Util.format2digit((String)(value + "")));
        }
    }

    private void setRender() {
        this.render = new TraderPositionRender((JTable)this.table);
        for (int k = 0; k < this.column.size(); ++k) {
            this.table.getColumn((Object)this.column.elementAt(k)).setCellRenderer((TableCellRenderer)this.render);
        }
    }

    private void setColumnWidth() {
        this.table.getColumnModel().getColumn(0).setPreferredWidth(175);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(190);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(100);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(117);
        this.table.getColumnModel().getColumn(4).setPreferredWidth(136);
        this.table.getColumnModel().getColumn(5).setPreferredWidth(177);
        this.table.getColumnModel().getColumn(6).setPreferredWidth(100);
    }

    private void StartTimer() {
        this.timer2 = new Timer();
        this.timer2.schedule((TimerTask)new TraderPositionTask(), 0L, 15000L);
    }

    public void StopTimer() {
        if (this.timer2 != null) {
            this.timer2.cancel();
        }
    }

    public String getSelectedAccount() {
        if (this.cbAccountNo.getSelectedItem() == null) {
            return "";
        }
        if (this.cbAccountNo.getSelectedItem().toString().trim().equalsIgnoreCase("")) {
            return "";
        }
        if (this.cbAccountNo.getSelectedItem().toString().trim().equalsIgnoreCase("ALL")) {
            return "";
        }
        return LogsPMEX.accountPrefix + this.cbAccountNo.getSelectedItem().toString().trim();
    }

    private String getSelectedAccount2() {
        if (AppConfig.isPMEX) {
            if (this.cbAccountNo.getSelectedItem() == null) {
                return LogsPMEX.accountPrefix;
            }
            if (this.cbAccountNo.getSelectedItem().toString().trim().equalsIgnoreCase("")) {
                return LogsPMEX.accountPrefix;
            }
            return LogsPMEX.accountPrefix + this.cbAccountNo.getSelectedItem().toString().trim();
        }
        if (this.cbAccountNo.getSelectedItem() == null) {
            return this.getAllAccount();
        }
        if (this.cbAccountNo.getSelectedItem().toString().trim().equalsIgnoreCase("")) {
            return this.getAllAccount();
        }
        if (this.cbAccountNo.getSelectedItem().toString().trim().equalsIgnoreCase("ALL")) {
            return this.getAllAccount();
        }
        return this.getFilterAccount();
    }

    private String getAllAccount() {
        Iterator en = LogsPMEX.ALL_ACCOUNTS.keySet().iterator();
        StringBuilder sb = new StringBuilder();
        while (en.hasNext()) {
            String key = en.next().toString();
            sb.append(key).append("~");
        }
        return sb.toString();
    }

    private String getFilterAccount() {
        StringBuilder sb = new StringBuilder();
        String acc = this.getSelectedAccount();
        Iterator en = LogsPMEX.ALL_ACCOUNTS.keySet().iterator();
        while (en.hasNext()) {
            String key = en.next().toString();
            AccountBean ac = (AccountBean)LogsPMEX.ALL_ACCOUNTS.get(key);
            if (ac.getAccountNo().indexOf(acc) != 0) continue;
            sb.append(key).append("~");
        }
        return sb.toString();
    }

    public synchronized void getTraderPositionWebService() {
        new Thread((Runnable)new ThreadTraderPosition(), "PMEX_BuyiungPower getTraderPositionWebService").start();
    }

    private void getBuyingPowerFromServer() {
        Mediator.getInstance().ResetTimerBuyingPower();
    }

    private void stopDataFromServer() {
    }

    private void emptyOtherInfo() {
        this.pnlRealizedPL.setToolTipText(null);
        this.pnlUnrealizedPL.setToolTipText(null);
        this.pnlNetLiquidity.setToolTipText(null);
        this.pnlBuyingPower.setToolTipText(null);
        this.pnlThreshold.setToolTipText(null);
        this.pnlMarginRequired.setToolTipText(null);
        this.pnlBuyPowerPercentUsed.setToolTipText(null);
        this.pnlBuyingPower.setPercent(0, true);
        this.pnlBuyPowerPercentUsed.setPercent(0, false);
        this.pnlRealizedPL.setValue("", false, false, false, false);
        this.pnlUnrealizedPL.setValue("", false, false, false, false);
        this.pnlNetLiquidity.setValue("", false, false, false, false);
        this.pnlBuyingPower.setValue("", false, false, false, false);
        this.pnlThreshold.setValue("", false, false, false, false);
        this.pnlMarginRequired.setValue("", false, false, false, false);
        this.pnlBuyPowerPercentUsed.setValue("", false, true, false, false);
    }

    private void emptyTable() {
        Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.EMPTY, (String)"");
        this.rows.clear();
        this.model.fireTableDataChanged();
        this.table.addNotify();
        this.table.repaint();
    }

    private synchronized void ParseTraderPosition(String result) {
        boolean isFound = false;
        if (result.indexOf("$") >= 0) {
            String[] rowsAll = result.split("\\$", -1);
            for (int row = 0; row < rowsAll.length - 1; ++row) {
                int index;
                TraderPositionBeans tpBean = TraderPositionBeans.parse((String)rowsAll[row]);
                if (this.getSelectedAccount().equalsIgnoreCase("")) {
                    for (TraderPositionBeans np : this.rows) {
                        if (np.getTraders().equalsIgnoreCase(tpBean.getTraders()) && np.getContract().equalsIgnoreCase(tpBean.getContract())) {
                            isFound = true;
                            index = this.rows.indexOf(np);
                            this.rows.remove(np);
                            this.rows.add(index, tpBean);
                            break;
                        }
                        isFound = false;
                    }
                    if (isFound) continue;
                    this.rows.add(tpBean);
                    continue;
                }
                if (tpBean.getTraders().indexOf(this.getSelectedAccount2()) == 0) {
                    for (TraderPositionBeans np : this.rows) {
                        if (np.getTraders().equalsIgnoreCase(tpBean.getTraders()) && np.getContract().equalsIgnoreCase(tpBean.getContract())) {
                            isFound = true;
                            index = this.rows.indexOf(np);
                            this.rows.remove(np);
                            this.rows.add(index, tpBean);
                            break;
                        }
                        isFound = false;
                    }
                    if (isFound) continue;
                    this.rows.add(tpBean);
                    continue;
                }
                if (!tpBean.getTraders().equalsIgnoreCase(this.getSelectedAccount())) continue;
                for (TraderPositionBeans np : this.rows) {
                    if (np.getContract().equalsIgnoreCase(tpBean.getContract())) {
                        isFound = true;
                        index = this.rows.indexOf(np);
                        this.rows.remove(np);
                        this.rows.add(index, tpBean);
                        break;
                    }
                    isFound = false;
                }
                if (isFound) continue;
                this.rows.add(tpBean);
            }
        }
        if (this.rows.size() <= 0) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Normal, (String)"No record found.");
        } else if (this.rows.size() == 1) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)(Util.format0digit((String)(this.rows.size() + "")) + " record found."));
        } else {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)(Util.format0digit((String)(this.rows.size() + "")) + " records found."));
        }
        this.lastTime = MyTime.getInstance().getTime();
        this.lblLastUpdate.setToolTipText("Last Update Time " + this.lastTime);
        this.model.fireTableDataChanged();
        this.table.repaint();
    }

    public void ParseBuyingPower(String result) {
        if (result.indexOf("$") >= 0 && !result.equalsIgnoreCase(this.previousResut)) {
            String[] allRows = result.split("\\$", -1);
            for (int i = 0; i < allRows.length; ++i) {
                String[] singleRow;
                String sngRow = allRows[i];
                if (sngRow.indexOf(";") <= 0 || !(singleRow = sngRow.split("\\;", -1))[1].equalsIgnoreCase(this.getSelectedAccount())) continue;
                this.setValues("% Buying Power Used", this.pnlBuyPowerPercentUsed, singleRow[7], false, true, 5, false, true, true);
                this.setValues("Buying Power", this.pnlBuyingPower, singleRow[5], false, true, 3, true, false, false);
                this.setValues("Threshold", this.pnlThreshold, singleRow[8], false, false, 8, false, false, false);
                this.setValues("Realized P/L", this.pnlRealizedPL, singleRow[2], true, false, 0, true, false, false);
                this.setValues("Unrealized P/L", this.pnlUnrealizedPL, singleRow[3], true, false, 1, true, false, false);
                this.setValues("Net Liquidity", this.pnlNetLiquidity, singleRow[4], false, false, 2, true, false, false);
                this.setValues("Margin Required", this.pnlMarginRequired, singleRow[6], false, false, 4, true, false, false);
                this.previousResut = result;
            }
        }
    }

    private void getTraderPosition() {
        this.getTraderPositionWebService();
    }

    private void initComponents() {
        this.btnRefresh = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.table = new NxGTable();
        this.lbltraders = new JLabel();
        this.cbAccountNo = new JComboBox();
        this.tableSeperator = new JSeparator();
        this.lblMessage = new JLabel();
        this.lblPrefix = new JLabel();
        this.lblLastUpdate = new JLabel();
        this.scrollPane = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.pnlNetLiquidity = new PMEX_BuyingPower_Dock_Panel();
        this.pnlRealizedPL = new PMEX_BuyingPower_Dock_Panel();
        this.pnlMarginRequired = new PMEX_BuyingPower_Dock_Panel();
        this.pnlUnrealizedPL = new PMEX_BuyingPower_Dock_Panel();
        this.pnlBuyingPower = new PMEX_BuyingPower_Dock_Panel();
        this.pnlBuyPowerPercentUsed = new PMEX_BuyingPower_Dock_Panel();
        this.pnlThreshold = new PMEX_BuyingPower_Dock_Panel();
        this.btnRefresh.setIcon(new ImageIcon(this.getClass().getResource("/Images/refresh.png")));
        this.btnRefresh.setText("Refresh");
        this.btnRefresh.setFocusable(false);
        this.btnRefresh.setHorizontalTextPosition(4);
        this.btnRefresh.setMaximumSize(new Dimension(75, 23));
        this.btnRefresh.setMinimumSize(new Dimension(75, 23));
        this.btnRefresh.setName("PMEX_BuyingPower -> btnRefersh");
        this.btnRefresh.setPreferredSize(new Dimension(75, 20));
        this.btnRefresh.setVerticalTextPosition(3);
        this.btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PMEX_BuyingPower.this.btnRefreshActionPerformed(evt);
            }
        });
        this.table.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane2.setViewportView((Component)this.table);
        this.lbltraders.setText(" Account");
        this.lbltraders.setMaximumSize(new Dimension(0, 0));
        this.lbltraders.setMinimumSize(new Dimension(0, 0));
        this.lbltraders.setPreferredSize(new Dimension(39, 6));
        this.cbAccountNo.setPreferredSize(new Dimension(22, 20));
        this.cbAccountNo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PMEX_BuyingPower.this.cbAccountNoActionPerformed(evt);
            }
        });
        this.lblMessage.setBackground(new Color(153, 153, 255));
        this.lblPrefix.setHorizontalAlignment(4);
        this.lblPrefix.setText("88888");
        this.lblPrefix.setMaximumSize(new Dimension(0, 0));
        this.lblPrefix.setMinimumSize(new Dimension(0, 0));
        this.lblPrefix.setPreferredSize(new Dimension(39, 6));
        this.lblLastUpdate.setBackground(new Color(255, 0, 0));
        this.lblLastUpdate.setHorizontalAlignment(4);
        this.lblLastUpdate.setIcon(new ImageIcon(this.getClass().getResource("/Images/lastUpdateTime16.png")));
        this.lblLastUpdate.setHorizontalTextPosition(2);
        this.lblLastUpdate.setMaximumSize(new Dimension(16, 20));
        this.lblLastUpdate.setMinimumSize(new Dimension(16, 20));
        this.lblLastUpdate.setPreferredSize(new Dimension(16, 20));
        this.jPanel1.setBorder(BorderFactory.createLineBorder(new Color(204, 204, 204), 0));
        this.pnlNetLiquidity.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jPanel1.add(this.pnlNetLiquidity);
        this.pnlRealizedPL.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jPanel1.add(this.pnlRealizedPL);
        this.pnlMarginRequired.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jPanel1.add(this.pnlMarginRequired);
        this.pnlUnrealizedPL.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jPanel1.add(this.pnlUnrealizedPL);
        this.pnlBuyingPower.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jPanel1.add(this.pnlBuyingPower);
        this.pnlBuyPowerPercentUsed.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jPanel1.add(this.pnlBuyPowerPercentUsed);
        this.pnlThreshold.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jPanel1.add(this.pnlThreshold);
        this.scrollPane.setViewportView(this.jPanel1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.lbltraders, -2, 50, -2).addGap(10, 10, 10).addComponent(this.lblPrefix, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbAccountNo, -2, 113, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnRefresh, -2, 98, -2)).addComponent(this.tableSeperator, -1, 500, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lblMessage, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblLastUpdate, -2, 162, -2)).addComponent(this.jScrollPane2, GroupLayout.Alignment.TRAILING).addComponent(this.scrollPane, GroupLayout.Alignment.TRAILING, -2, 0, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lbltraders, -2, 20, -2).addComponent(this.lblPrefix, -2, 20, -2).addComponent(this.cbAccountNo, -2, -1, -2).addComponent(this.btnRefresh, -2, 21, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scrollPane, -2, 98, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane2, -1, 27, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tableSeperator, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.lblLastUpdate, -1, -1, Short.MAX_VALUE).addComponent(this.lblMessage, -1, -1, Short.MAX_VALUE))));
    }

    private void cbAccountNoActionPerformed(ActionEvent evt) {
        try {
            if (evt.getModifiers() == 16 || evt.getActionCommand().equalsIgnoreCase("comboBoxEdited")) {
                this.getData();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void btnRefreshActionPerformed(ActionEvent evt) {
        this.getData();
    }

    private void sendRequestBuyingPower() {
        this.StopTimer();
        this.emptyTable();
        this.emptyOtherInfo();
        this.previousResut = "";
        if (!this.getSelectedAccount().equalsIgnoreCase("")) {
            String acc = this.getSelectedAccount();
            if (LogsPMEX.ALL_ACCOUNTS.containsKey(acc)) {
                this.getBuyingPowerFromServer();
                this.StartTimer();
            } else if (this.showMessage) {
                this.stopDataFromServer();
                this.StartTimer();
            }
        } else {
            this.stopDataFromServer();
            this.StartTimer();
        }
    }

    private void getData() {
        try {
            this.sendRequestBuyingPower();
            this.getTraderPositionWebService();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private abstract class SwingTimerTask
    extends TimerTask {
        private SwingTimerTask() {
        }

        public abstract void doRun();

        @Override
        public void run() {
            if (!EventQueue.isDispatchThread()) {
                EventQueue.invokeLater(this);
            } else {
                this.doRun();
            }
        }
    }

    private class ThreadTraderPosition
    implements Runnable {
        private ThreadTraderPosition() {
        }

        @Override
        public void run() {
            try {
                if (PMEX_BuyingPower.this.getSelectedAccount2().trim().length() > 0) {
                    Util.setMessage((JLabel)PMEX_BuyingPower.this.lblMessage, (MessageType)MessageType.Loading, (String)PMEX_BuyingPower.this.languageCentre.getValue(LanguageConstant.Loading));
                    byte[] _byte = WebServiceTraderPosition.getInstance().getPort().getCompressedData(LogCommon.UserID, "PMEX_GetTraderPosition", PMEX_BuyingPower.this.getSelectedAccount2());
                    String data = CompressManager.unzipStringFromBytes(_byte);
                    Mediator.getInstance().println("TRADERPOSITION = " + data);
                    Util.setMessage((JLabel)PMEX_BuyingPower.this.lblMessage, (MessageType)MessageType.EMPTY, (String)"");
                    if (data.equalsIgnoreCase("No record(s) found") || data.equalsIgnoreCase("TRADERPOSITION*%BUYINGPOWER*")) {
                        Util.setMessage((JLabel)PMEX_BuyingPower.this.lblMessage, (MessageType)MessageType.Information, (String)"No record found");
                    } else {
                        PMEX_BuyingPower.this.ParseTraderPosition(data);
                    }
                } else {
                    Util.setMessage((JLabel)PMEX_BuyingPower.this.lblMessage, (MessageType)MessageType.Information, (String)"Please select account");
                }
            }
            catch (Exception ex) {
                Util.setMessage((JLabel)PMEX_BuyingPower.this.lblMessage, (MessageType)MessageType.Error, (String)"Error in loading Commodity Buying Power Details");
                ex.printStackTrace();
            }
        }
    }

    private class TraderPositionTask
    extends SwingTimerTask {
        private TraderPositionTask() {
        }

        @Override
        public void doRun() {
            PMEX_BuyingPower.this.getTraderPosition();
        }
    }
}

