/*
 * Decompiled with CFR 0.152.
 */
package windows.pmex.buyingpower;

import common.gui.component.NxGLabelDoubleColor;
import common.gui.util.AppConfig;
import common.gui.util.MyColors;
import common.gui.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;

public class PMEX_BuyingPower_Dock_Panel
extends JPanel {
    private Double value = new Double(0.0);
    private JLabel lblIcon;
    private JLabel lblTitle;
    private NxGLabelDoubleColor lblValue;

    public PMEX_BuyingPower_Dock_Panel() {
        this.initComponents();
        this.lblIcon.setIcon(new ImageIcon(this.getClass().getResource("/pmex/gui/images/netPosition24x24.png")));
        this.lblTitle.setText("");
        this.lblValue.setText("");
        this.lblValue.setOpaque(false);
        this.lblValue.setFont(this.lblValue.getFont().deriveFont(1));
        this.lblTitle.setFont(AppConfig.defaultPlanFont);
    }

    private void initComponents() {
        this.lblIcon = new JLabel();
        this.lblTitle = new JLabel();
        this.lblValue = new NxGLabelDoubleColor();
        this.lblIcon.setIcon(new ImageIcon(this.getClass().getResource("/Images/info32.png")));
        this.lblTitle.setFont(new Font("Tahoma", 1, 11));
        this.lblTitle.setHorizontalAlignment(0);
        this.lblTitle.setText("jLabel2");
        this.lblTitle.setMinimumSize(new Dimension(34, 16));
        this.lblTitle.setPreferredSize(new Dimension(34, 16));
        this.lblValue.setHorizontalAlignment(0);
        this.lblValue.setText("jLabel2");
        this.lblValue.setOpaque(true);
        this.lblValue.setPreferredSize(new Dimension(34, 16));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.lblIcon).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblTitle, -1, -1, Short.MAX_VALUE).addComponent((Component)this.lblValue, -1, -1, Short.MAX_VALUE)).addGap(4, 4, 4)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblIcon, -2, 36, -2).addGroup(layout.createSequentialGroup().addComponent(this.lblTitle, -2, -1, -2).addGap(2, 2, 2).addComponent((Component)this.lblValue, -2, -1, -2)));
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(String value, boolean isForecolor, boolean isShowPKR, boolean isDecimail, boolean isShowPercent) {
        try {
            Double d;
            this.value = d = Double.valueOf(Double.parseDouble(value));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (isForecolor) {
            if (this.value == 0.0) {
                this.lblValue.setForeground(Color.BLUE);
            } else if (this.value > 0.0) {
                this.lblValue.setForeground(Color.GREEN.darker());
            } else {
                this.lblValue.setForeground(Color.RED.darker());
            }
        }
        if (value.trim().length() <= 0) {
            this.lblValue.setText("");
        } else if (isShowPKR) {
            if (isDecimail) {
                this.lblValue.setText("PKR " + Util.format2digit((String)value));
            } else {
                this.lblValue.setText("PKR " + Util.format0digit((String)value));
            }
        } else if (isShowPercent) {
            if (isDecimail) {
                this.lblValue.setText(Util.format2digit((String)value) + " %");
            } else {
                this.lblValue.setText(Util.format0digit((String)value) + " %");
            }
        } else if (isDecimail) {
            this.lblValue.setText(Util.format2digit((String)value));
        } else {
            this.lblValue.setText(Util.format0digit((String)value));
        }
    }

    public void setTitle(String title) {
        this.lblTitle.setText(title);
    }

    public void setPercent(int percent, boolean isBuyingPower) {
        this.lblValue.setPaintWidthPercent(percent);
        if (!isBuyingPower) {
            if (percent <= 25) {
                this.lblValue.setEndPercentColor(MyColors.red.brighter());
                this.lblValue.setStartPercentColor(MyColors.red);
            } else if (percent <= 50) {
                this.lblValue.setEndPercentColor(MyColors.orange.brighter());
                this.lblValue.setStartPercentColor(MyColors.orange);
            } else if (percent <= 75) {
                this.lblValue.setEndPercentColor(MyColors.yellow.brighter().brighter().brighter().brighter());
                this.lblValue.setStartPercentColor(MyColors.yellow);
            } else {
                this.lblValue.setEndPercentColor(MyColors.green.brighter());
                this.lblValue.setStartPercentColor(MyColors.green);
            }
        } else {
            if (percent <= 25) {
                this.lblValue.setEndPercentColor(MyColors.green.brighter());
                this.lblValue.setStartPercentColor(MyColors.green);
            } else if (percent <= 50) {
                this.lblValue.setEndPercentColor(MyColors.yellow.brighter().brighter().brighter().brighter());
                this.lblValue.setStartPercentColor(MyColors.yellow);
            }
            if (percent <= 75) {
                this.lblValue.setEndPercentColor(MyColors.orange.brighter());
                this.lblValue.setStartPercentColor(MyColors.orange);
            } else {
                this.lblValue.setEndPercentColor(MyColors.red.brighter());
                this.lblValue.setStartPercentColor(MyColors.red);
            }
        }
    }

    public void setIcon(ImageIcon imageIcon) {
        this.lblIcon.setIcon(imageIcon);
    }
}

