/*
 * Decompiled with CFR 0.152.
 */
package windows.pmex.logs;

import Control.JasperFileChooser;
import Control.ReportControl;
import Control.ReportControlEvent;
import Control.ReportControlListener;
import CustomComponent.MyTime;
import MyDocking.Mediator;
import RendersNModels.ComboBoxToolTipRender;
import Utilities.LoadLogs;
import Utilities.ThreadWithName;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import common.bean.AccountBean;
import common.gui.component.NxGTable;
import common.gui.util.AppConfig;
import common.gui.util.LogCommon;
import common.gui.util.MyColors;
import common.gui.util.Util;
import common.interfaces.AddContract;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.AbstractDocument;
import javax.swing.text.JTextComponent;
import languages.LanguageCentre;
import languages.LanguageConstant;
import pmex.gui.bean.OrderActivityBean;
import pmex.gui.model.OrderActivityModel;
import pmex.gui.render.OrderActivityRender;
import pmex.gui.util.LogsPMEX;
import reports.Jasper_Report;
import reports.Report_PMEX_OrderActivity;
import windows.pmex.buyingpower.DocumentSizeAndUppercaseFilter;

public class PMEX_OrderActivity
extends JPanel
implements ActionListener,
ItemListener,
ReportControlListener,
AddContract {
    private Mediator mediator = Mediator.getInstance();
    private Vector<OrderActivityBean> rows = new Vector();
    private ArrayList<OrderActivityBean> rowReport = new ArrayList();
    private Vector<String> columns = new Vector();
    private OrderActivityModel model = null;
    private OrderActivityRender render = null;
    private ImageIcon loaderIcon = new ImageIcon(this.getClass().getResource(AppConfig.loaderIconPath));
    private AutoCompleteSupport autoCom;
    private AutoCompleteSupport autoComplete;
    private JTextComponent editorContract;
    private JTextComponent editorTrader;
    private JTextComponent editorStatus;
    private int BuyCount;
    private int SellCount;
    private String LogString;
    private int isIterator = 1;
    private boolean IsFlag = true;
    private LanguageCentre languageCentre = new LanguageCentre();
    private JButton btnRefresh;
    private JComboBox cbAccountNo;
    private JCheckBox cbBuy;
    private JComboBox cbContract;
    private JCheckBox cbSell;
    private JComboBox cbStatus;
    private JComboBox cbTrader;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JLabel lblMessage;
    private JLabel lblPrefix;
    private JLabel lblSymbol;
    private JLabel lblSymbol1;
    private JLabel lblTrader;
    private ReportControl reportControl1;
    private NxGTable table;
    public String JRXMLFileName = "PMEX_OrderActivity.jrxml";

    public PMEX_OrderActivity() {
        try {
            this.initComponents();
            this.setThis();
            this.setTreader();
            this.setAccount();
            this.setStatus();
            this.addContract();
            this.cbContract.setMaximumRowCount(30);
            this.cbStatus.setMaximumRowCount(30);
            LogsPMEX.CONTRACT_HOLDER.add(this);
            this.cbSell.setForeground(MyColors.SellBG);
            this.cbBuy.setForeground(MyColors.BuyBG);
            this.initTable();
            this.reportControl1.setVisible(true);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, ex);
            ex.printStackTrace();
        }
    }

    private void setThis() {
        this.mediator.setPMEX_OrderActivity(this);
        this.btnRefresh.addActionListener(this);
        this.cbContract.addActionListener(this);
        this.cbBuy.addItemListener(this);
        this.cbSell.addItemListener(this);
    }

    private void initTable() {
        this.columns.add("User");
        this.columns.add("Time");
        this.columns.add("Order ID");
        this.columns.add("Account");
        this.columns.add("Contract");
        this.columns.add("Order Type");
        this.columns.add("Transaction Type");
        this.columns.add("Status");
        this.columns.add("Volume");
        this.columns.add("Filled Volume");
        this.columns.add("Total Filled");
        this.columns.add("Remaining Volume");
        this.columns.add("Price");
        this.columns.add("Fill Price");
        this.columns.add("Distance");
        this.columns.add("Trailing Step");
        this.columns.add("Remarks");
        this.model = new OrderActivityModel(this.rows, this.columns);
        this.table.setModel((TableModel)this.model);
        this.render = new OrderActivityRender();
        for (int k = 0; k < this.model.getColumnCount(); ++k) {
            this.table.getColumn((Object)this.model.getColumnName(k)).setCellRenderer((TableCellRenderer)this.render);
        }
        FontMetrics metrics = this.getFontMetrics(LogCommon.LogFont);
        int fontHeight = metrics.getHeight();
        this.table.setRowHeight(fontHeight);
        this.table.repaint();
        this.reportControl1.addListener(this);
    }

    public void GetLog() {
        this.lblMessage.setText(this.languageCentre.getValue(LanguageConstant.Loading));
        this.lblMessage.setIcon(this.loaderIcon);
        LoadLogs loadLogs = new LoadLogs("PMEX_GetOrderActivity=", true, false);
        new ThreadWithName(loadLogs, "PMEX_GetOrderActivity").start();
    }

    public void LogRecieved(String Str) {
        this.lblMessage.setIcon(null);
        if (Str.equalsIgnoreCase("No Record found") || Str.equalsIgnoreCase("")) {
            this.lblMessage.setText("No record found.");
        } else if (Str.equalsIgnoreCase("Exception")) {
            this.lblMessage.setText("Error in loading Order Activity Log.");
        } else {
            this.LogString = Str;
            this.UpdateTable(Str);
        }
    }

    private synchronized void UpdateTable2(String Logstr) {
        this.UpdateTable(Logstr);
    }

    private void UpdateTable(String Logstr) {
        this.emptyTable();
        this.lblMessage.setText(" ");
        this.lblMessage.setIcon(null);
        this.BuyCount = 0;
        this.SellCount = 0;
        if (Logstr.indexOf(";") < 1) {
            this.lblMessage.setText("No record found.");
            return;
        }
        String Trader = "";
        Trader = this.cbTrader.getSelectedItem() == null ? this.editorTrader.getText() : this.cbTrader.getSelectedItem().toString();
        String Account = this.getSelectedAccount();
        String Contract = "";
        Contract = this.cbContract.getSelectedItem() == null ? this.editorContract.getText() : this.cbContract.getSelectedItem().toString().trim();
        String Status2 = "";
        Status2 = this.cbStatus.getSelectedItem() == null ? this.editorStatus.getText() : this.cbStatus.getSelectedItem().toString();
        if (Contract.equalsIgnoreCase("ALL")) {
            Contract = "";
        }
        if (Account.equalsIgnoreCase("ALL")) {
            Account = "";
        }
        if (Trader.equalsIgnoreCase("ALL")) {
            Trader = "";
        }
        if (Status2.equalsIgnoreCase("ALL")) {
            Status2 = "";
        }
        String Type2 = "";
        if (this.cbSell.isSelected()) {
            Type2 = "SELL";
        }
        if (this.cbBuy.isSelected()) {
            Type2 = "BUY";
        }
        if (this.cbBuy.isSelected() && this.cbSell.isSelected()) {
            Type2 = "";
        }
        if (Logstr.indexOf("|") > 0) {
            String[] data = Logstr.split("\\|", -1);
            for (int i = 0; i < data.length; ++i) {
                OrderActivityBean b;
                String string = data[i];
                if (string.trim().equalsIgnoreCase("") || !(b = OrderActivityBean.parse((String)string)).getTrader().equalsIgnoreCase(Trader) && Trader.length() > 0 || !b.getContract().trim().equalsIgnoreCase(Contract) && Contract.length() > 0 || b.getAccount().trim().indexOf(Account) == -1 && Account.length() > 0 || !b.getTransactionType().equalsIgnoreCase(Type2) && Type2.length() > 0 || !b.getStatus().equalsIgnoreCase(Status2) && Status2.length() > 0) continue;
                if (b.getTransactionType().equalsIgnoreCase("Buy")) {
                    ++this.BuyCount;
                }
                if (b.getTransactionType().equalsIgnoreCase("Sell")) {
                    ++this.SellCount;
                }
                this.rows.add(b);
            }
        }
        if (this.model.getRowCount() > 1) {
            this.lblMessage.setText(Util.format0digit((String)(this.model.getRowCount() + "".trim().replaceAll("\\,", ""))) + " records found.     Buy (" + Util.format0digit((String)(this.BuyCount + "")) + ")     Sell (" + Util.format0digit((String)(this.SellCount + "")) + ")");
        } else {
            this.lblMessage.setText(Util.format0digit((String)(this.model.getRowCount() + "".trim().replaceAll("\\,", ""))) + " record found.     Buy (" + Util.format0digit((String)(this.BuyCount + "")) + ")     Sell (" + Util.format0digit((String)(this.SellCount + "")) + ")");
        }
        this.lblMessage.setIcon(null);
        this.tableDataChange();
    }

    private void tableDataChange() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.model.fireTableDataChanged();
            this.table.packAll();
            this.table.addNotify();
            this.table.repaint();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PMEX_OrderActivity.this.model.fireTableDataChanged();
                    PMEX_OrderActivity.this.table.packAll();
                    PMEX_OrderActivity.this.table.addNotify();
                    PMEX_OrderActivity.this.table.repaint();
                }
            });
        }
    }

    private void emptyTable() {
        this.lblMessage.setText("No record found.");
        this.lblMessage.setIcon(null);
        this.rows.clear();
        this.tableDataChange();
    }

    private void setTreader() {
        Vector<String> allTrader = new Vector<String>();
        allTrader.addElement("ALL");
        allTrader.addElement(LogCommon.UserID);
        Collections.sort(allTrader);
        this.cbTrader.setModel(new DefaultComboBoxModel(allTrader));
        AutoCompleteSupport support = AutoCompleteSupport.install((JComboBox)this.cbTrader, (EventList)GlazedLists.eventListOf((Object[])allTrader.toArray()));
        this.cbTrader.setSelectedItem("ALL");
        this.editorTrader = (JTextComponent)this.cbTrader.getEditor().getEditorComponent();
        this.editorTrader.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                PMEX_OrderActivity.this.UpdateTable2(PMEX_OrderActivity.this.LogString);
            }
        });
    }

    private void setStatus() {
        Collections.sort(LogsPMEX.OrderActivityStautsTypes);
        this.cbStatus.setModel(new DefaultComboBoxModel(LogsPMEX.OrderActivityStautsTypes));
        AutoCompleteSupport support = AutoCompleteSupport.install((JComboBox)this.cbStatus, (EventList)GlazedLists.eventListOf((Object[])LogsPMEX.OrderActivityStautsTypes.toArray()));
        this.cbStatus.setSelectedItem("ALL");
        this.editorStatus = (JTextComponent)this.cbStatus.getEditor().getEditorComponent();
        this.editorStatus.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                PMEX_OrderActivity.this.UpdateTable2(PMEX_OrderActivity.this.LogString);
            }
        });
    }

    private void setAccount() {
        if (LogsPMEX.accountPrefix.length() > 0) {
            this.lblPrefix.setText(LogsPMEX.accountPrefix);
        } else {
            this.lblPrefix.setText("Account");
        }
        Iterator en = LogsPMEX.ALL_ACCOUNTS.keySet().iterator();
        ArrayList<String> list = new ArrayList<String>();
        while (en.hasNext()) {
            String key = en.next().toString();
            AccountBean ac = (AccountBean)LogsPMEX.ALL_ACCOUNTS.get(key);
            if (ac.getAccountNo().indexOf(LogsPMEX.accountPrefix) == 0) {
                list.add(ac.getAccountNo().replaceFirst(LogsPMEX.accountPrefix, ""));
                continue;
            }
            list.add(ac.getAccountNo());
        }
        this.cbAccountNo.setRenderer(new ComboBoxToolTipRender(LogsPMEX.ALL_ACCOUNTS, LogsPMEX.accountPrefix));
        this.cbAccountNo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    PMEX_OrderActivity.this.cbAccountNo.setToolTipText(((AccountBean)LogsPMEX.ALL_ACCOUNTS.get(LogsPMEX.accountPrefix + PMEX_OrderActivity.this.cbAccountNo.getSelectedItem().toString().trim())).toString());
                }
                catch (Exception ex) {
                    PMEX_OrderActivity.this.cbAccountNo.setToolTipText(null);
                }
            }
        });
        Collections.sort(list);
        list.add(0, "ALL");
        this.cbAccountNo.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
        this.autoComplete = AutoCompleteSupport.install((JComboBox)this.cbAccountNo, (EventList)GlazedLists.eventListOf((Object[])list.toArray()));
        this.cbAccountNo.setSelectedItem("ALL");
        this.cbAccountNo.setEditable(true);
        this.cbAccountNo.addActionListener(this);
        this.cbAccountNo.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                PMEX_OrderActivity.this.UpdateTable2(PMEX_OrderActivity.this.LogString);
            }
        });
        AbstractDocument d = (AbstractDocument)((JTextField)this.cbAccountNo.getEditor().getEditorComponent()).getDocument();
        d.setDocumentFilter(new DocumentSizeAndUppercaseFilter(4));
    }

    private String getSelectedAccount() {
        if (this.cbAccountNo.getSelectedItem() == null) {
            return "";
        }
        if (this.cbAccountNo.getSelectedItem().toString().trim().equalsIgnoreCase("")) {
            return "";
        }
        if (this.cbAccountNo.getSelectedItem().toString().trim().equalsIgnoreCase("ALL")) {
            return "ALL";
        }
        return LogsPMEX.accountPrefix + this.cbAccountNo.getSelectedItem().toString().trim();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.table = new NxGTable();
        this.reportControl1 = new ReportControl();
        this.cbSell = new JCheckBox();
        this.btnRefresh = new JButton();
        this.cbBuy = new JCheckBox();
        this.cbAccountNo = new JComboBox();
        this.lblSymbol = new JLabel();
        this.lblTrader = new JLabel();
        this.cbTrader = new JComboBox();
        this.lblPrefix = new JLabel();
        this.cbContract = new JComboBox();
        this.lblMessage = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.cbStatus = new JComboBox();
        this.lblSymbol1 = new JLabel();
        this.table.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.table.setAutoResizeMode(0);
        this.jScrollPane1.setViewportView((Component)this.table);
        this.cbSell.setText("Sell");
        this.cbSell.setPreferredSize(new Dimension(41, 20));
        this.btnRefresh.setIcon(new ImageIcon(this.getClass().getResource("/Images/refresh.png")));
        this.btnRefresh.setText("Refresh");
        this.btnRefresh.setToolTipText("Reload from server");
        this.btnRefresh.setName("PMEX_OrderActivity -> btnRefresh");
        this.cbBuy.setText("Buy");
        this.cbBuy.setMaximumSize(new Dimension(43, 20));
        this.cbBuy.setMinimumSize(new Dimension(43, 20));
        this.cbBuy.setPreferredSize(new Dimension(43, 20));
        this.lblSymbol.setText("Contract");
        this.lblTrader.setText("User");
        this.lblPrefix.setHorizontalAlignment(4);
        this.lblPrefix.setText("Account");
        this.lblSymbol1.setHorizontalAlignment(4);
        this.lblSymbol1.setText("Status");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addGroup(layout.createSequentialGroup().addGap(11, 11, 11).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lblTrader, -2, 40, -2).addGap(9, 9, 9).addComponent(this.cbTrader, -2, 110, -2).addGap(10, 10, 10).addComponent(this.lblPrefix, -2, 40, -2).addGap(10, 10, 10).addComponent(this.cbAccountNo, -2, 110, -2).addGap(10, 10, 10).addComponent(this.cbBuy, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.lblSymbol, -2, 44, -2).addGap(5, 5, 5).addComponent(this.cbContract, -2, 110, -2).addGap(10, 10, 10).addComponent(this.lblSymbol1, -2, 40, -2).addGap(10, 10, 10).addComponent(this.cbStatus, -2, 110, -2).addGap(10, 10, 10).addComponent(this.cbSell, -2, -1, -2).addGap(19, 19, 19).addComponent(this.btnRefresh, -2, 165, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.reportControl1, -2, -1, -2)).addComponent(this.jScrollPane1).addComponent(this.lblMessage, -2, 460, -2)).addGap(9, 9, 9)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(5, 5, 5).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblPrefix, -2, 20, -2).addComponent(this.cbAccountNo, -2, -1, -2).addComponent(this.cbBuy, -2, -1, -2).addGroup(layout.createSequentialGroup().addGap(1, 1, 1).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblTrader, -2, 20, -2).addComponent(this.cbTrader, -2, -1, -2)))).addGap(2, 2, 2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnRefresh, -2, 23, -2).addGroup(layout.createSequentialGroup().addGap(3, 3, 3).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblSymbol, -2, 20, -2).addComponent(this.cbContract, -2, -1, -2).addComponent(this.lblSymbol1, -2, 20, -2).addComponent(this.cbStatus, -2, -1, -2).addComponent(this.cbSell, -2, -1, -2).addComponent(this.reportControl1, -2, 20, -2)))).addGap(5, 5, 5).addComponent(this.jScrollPane1, -1, 163, Short.MAX_VALUE).addGap(6, 6, 6).addComponent(this.jSeparator1, -2, -1, -2).addGap(3, 3, 3).addComponent(this.lblMessage, -2, 20, -2).addGap(1, 1, 1)));
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.btnRefresh) {
            this.GetLog();
        } else if (evt.getSource() == this.cbAccountNo) {
            this.UpdateTable2(this.LogString);
        } else if (evt.getSource() == this.cbTrader) {
            this.UpdateTable2(this.LogString);
        } else if (evt.getSource() == this.cbContract && (evt.getModifiers() == 16 || evt.getActionCommand().equalsIgnoreCase("comboBoxEdited"))) {
            this.UpdateTable2(this.LogString);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        ItemSelectable source = e.getItemSelectable();
        if (source == this.cbBuy || source == this.cbSell) {
            this.UpdateTable2(this.LogString);
        }
    }

    public void addContract() {
        if (this.autoCom != null && this.autoCom.isInstalled()) {
            this.autoCom.uninstall();
        }
        ArrayList v = new ArrayList(LogsPMEX.PMEX_CONTRACT_ALL.keySet());
        Collections.sort(v);
        v.add(0, "ALL");
        this.autoCom = AutoCompleteSupport.install((JComboBox)this.cbContract, (EventList)GlazedLists.eventListOf((Object[])v.toArray()));
        this.autoCom.setStrict(false);
        this.cbContract.setSelectedItem("ALL");
        this.editorContract = (JTextComponent)this.cbContract.getEditor().getEditorComponent();
        this.editorContract.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                PMEX_OrderActivity.this.UpdateTable2(PMEX_OrderActivity.this.LogString);
            }
        });
    }

    @Override
    public void ReportControl_Print(ReportControlEvent e) {
        Report_PMEX_OrderActivity Report = new Report_PMEX_OrderActivity(this.JRXMLFileName, this.getTableRows());
        this.SetParameters((Jasper_Report)Report);
        if (!Report.isHasPage()) {
            return;
        }
        Report.PrintReport();
    }

    @Override
    public void ReportControl_Save(ReportControlEvent e) {
        String FileName;
        boolean result;
        Report_PMEX_OrderActivity Report = new Report_PMEX_OrderActivity(this.JRXMLFileName, this.getTableRows());
        this.SetParameters((Jasper_Report)Report);
        if (!Report.isHasPage()) {
            return;
        }
        JasperFileChooser fc = new JasperFileChooser(new File(""));
        fc.setSelectedFile(new File("Order Activity-" + MyTime.getInstance().getDate()));
        fc.addAllJasperChoosableFileFilter();
        fc.setAcceptAllFileFilterUsed(false);
        fc.showSaveDialog(this);
        if (fc.getSelectedFile() != null && !(result = Report.Export(FileName = fc.getSelectedFile().getAbsolutePath() + "." + fc.getExtenstion()))) {
            JOptionPane.showMessageDialog(null, "Error in saving file.");
        }
    }

    @Override
    public void ReportControl_Pdf(ReportControlEvent e) {
        try {
            int Option;
            String FileName;
            boolean result;
            Report_PMEX_OrderActivity Report = new Report_PMEX_OrderActivity(this.JRXMLFileName, this.getTableRows());
            this.SetParameters((Jasper_Report)Report);
            if (!Report.isHasPage()) {
                return;
            }
            JasperFileChooser fc = new JasperFileChooser(new File(""));
            fc.setSelectedFile(new File("Order Activity-" + MyTime.getInstance().getDate()));
            fc.addPdfFileFilter();
            fc.showSaveDialog(this);
            if (fc.getSelectedFile() != null && (result = Report.ExportToPdf(FileName = fc.getSelectedFile().getAbsolutePath().replaceAll("\"", "") + "." + fc.getExtenstion())) && (Option = JOptionPane.showConfirmDialog(null, "Order Activity report created. Do you want to open it?", "PDF", 0)) == 0) {
                try {
                    Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + FileName);
                }
                catch (IOException iOException) {}
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void ReportControl_View(ReportControlEvent e) {
        Report_PMEX_OrderActivity Report = new Report_PMEX_OrderActivity(this.JRXMLFileName, this.getTableRows());
        this.SetParameters((Jasper_Report)Report);
        if (!Report.isHasPage()) {
            return;
        }
        Report.generateReport();
    }

    @Override
    public void ReportControl_CustomExport(ReportControlEvent e) {
    }

    private String[][] getTableRows() {
        if (this.IsFlag) {
            this.rowReport.addAll(this.rows);
            this.IsFlag = false;
        }
        String[][] obj = new String[this.table.getModel().getRowCount()][this.table.getModel().getColumnCount()];
        for (int i = 0; i < this.table.getModel().getRowCount(); ++i) {
            OrderActivityBean value = this.rowReport.get(i);
            for (int j = 0; j < this.table.getModel().getColumnCount(); ++j) {
                obj[i][0] = value.getTrader();
                obj[i][1] = value.getTime();
                obj[i][2] = value.getOrderID();
                obj[i][3] = value.getAccount();
                obj[i][4] = value.getContract();
                obj[i][5] = value.getOrderType();
                obj[i][6] = value.getTransactionType();
                obj[i][7] = value.getStatus().replaceAll("_", " ");
                obj[i][8] = String.valueOf(value.getVolume());
                obj[i][9] = String.valueOf(value.getFilledVolume());
                obj[i][10] = String.valueOf(value.getTotalFilled());
                obj[i][11] = String.valueOf(value.getRemainingVolume());
                obj[i][12] = String.valueOf(value.getPrice());
                obj[i][13] = String.valueOf(value.getFillPrice());
                obj[i][14] = String.valueOf(value.getDistance());
                obj[i][15] = String.valueOf(value.getTrailingStep());
            }
        }
        return obj;
    }

    private void SetParameters(Jasper_Report Report) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("PrintDate", MyTime.getInstance().getTimeAndDateForReport());
        Report.SetParameter(param);
    }

    private class ColumnListner
    extends MouseAdapter {
        private final NxGTable table;
        protected int sortCol = 0;
        protected boolean isSortAsc = true;
        private TableColumnModel colModel;

        public ColumnListner(NxGTable table) {
            this.table = table;
            this.colModel = table.getColumnModel();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int columnModelIndex = this.colModel.getColumnIndexAtX(e.getX());
            int modelIndex = this.colModel.getColumn(columnModelIndex).getModelIndex();
            if (modelIndex < 0) {
                return;
            }
            if (this.sortCol == modelIndex) {
                this.isSortAsc = !this.isSortAsc;
            } else {
                this.sortCol = modelIndex;
            }
            if (PMEX_OrderActivity.this.isIterator == 1) {
                PMEX_OrderActivity.this.rowReport.clear();
                PMEX_OrderActivity.this.rowReport.addAll(PMEX_OrderActivity.this.rows);
                Collections.sort(PMEX_OrderActivity.this.rowReport, new OrderActivityComparator(this.sortCol, this.isSortAsc));
                PMEX_OrderActivity.this.isIterator = 2;
            } else if (PMEX_OrderActivity.this.isIterator == 2) {
                PMEX_OrderActivity.this.rowReport.clear();
                PMEX_OrderActivity.this.rowReport.addAll(PMEX_OrderActivity.this.rows);
                Collections.sort(PMEX_OrderActivity.this.rowReport, new OrderActivityComparator(this.sortCol, this.isSortAsc));
                PMEX_OrderActivity.this.isIterator = 3;
            } else {
                PMEX_OrderActivity.this.rowReport.clear();
                PMEX_OrderActivity.this.rowReport.addAll(PMEX_OrderActivity.this.rows);
                PMEX_OrderActivity.this.isIterator = 1;
            }
        }
    }

    private class OrderActivityComparator
    implements Comparator<OrderActivityBean> {
        int colIndex = 0;
        boolean isAsc = true;

        public OrderActivityComparator(int colIndex, boolean isAsc) {
            this.colIndex = colIndex;
            this.isAsc = isAsc;
        }

        @Override
        public int compare(OrderActivityBean b1, OrderActivityBean b2) {
            int result = 0;
            switch (this.colIndex) {
                case 0: {
                    result = b1.getTrader().compareTo(b2.getTrader());
                    break;
                }
                case 3: {
                    result = b1.getAccount().compareTo(b2.getAccount());
                    break;
                }
                case 4: {
                    result = b1.getContract().compareTo(b2.getContract());
                    break;
                }
                case 2: {
                    result = b1.getOrderID().compareTo(b2.getOrderID());
                    break;
                }
                case 5: {
                    result = b1.getOrderType().compareTo(b2.getOrderType());
                    break;
                }
                case 6: {
                    result = b1.getTransactionType().compareTo(b2.getTransactionType());
                    break;
                }
                case 12: {
                    result = b1.getPrice() < b2.getPrice() ? -1 : (b1.getPrice() > b2.getPrice() ? 1 : 0);
                    break;
                }
                case 9: {
                    result = b1.getFilledVolume() < b2.getFilledVolume() ? -1 : (b1.getFilledVolume() > b2.getFilledVolume() ? 1 : 0);
                    break;
                }
                case 10: {
                    result = b1.getTotalFilled() < b2.getTotalFilled() ? -1 : (b1.getTotalFilled() > b2.getTotalFilled() ? 1 : 0);
                    break;
                }
                case 11: {
                    result = b1.getRemainingVolume() < b2.getRemainingVolume() ? -1 : (b1.getRemainingVolume() > b2.getRemainingVolume() ? 1 : 0);
                    break;
                }
                case 7: {
                    result = b1.getStatus().compareTo(b2.getStatus());
                    break;
                }
                case 1: {
                    result = b1.getTime().compareTo(b2.getTime());
                }
            }
            if (!this.isAsc) {
                result = -result;
            }
            return result;
        }
    }
}

