/*
 * Decompiled with CFR 0.152.
 */
package windows.pmex.order;

import CustomComponent.DocumentType;
import CustomComponent.NxGPassword;
import MyDocking.Mediator;
import common.gui.component.NxGScrollBarUI;
import common.gui.util.LogCommon;
import common.gui.util.MessageType;
import common.gui.util.Util;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import windows.pmex.order.PMEX_FastOrderPanel;

public class PMEX_FastOrder
extends JPanel
implements Runnable {
    private static int panelID = 0;
    private JButton btnAdd;
    private JButton btnClearAll;
    private JCheckBox isSavePIN;
    private JLabel jLabel1;
    private JLabel jLabel8;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JLabel lblHeader;
    private JLabel lblIcon;
    private JLabel lblMessage;
    private JPanel pnlHeader;
    private JPanel pnlOrderHolder;
    private JScrollPane scrollPane;
    private JTable tblHeader;
    private NxGPassword txtPinCode;

    public PMEX_FastOrder() {
        try {
            this.initComponents();
            this.setThis();
            this.setColumnWidth();
            this.setForDocument();
            JTableHeader header = this.tblHeader.getTableHeader();
            ((JLabel)((Object)header.getDefaultRenderer())).setHorizontalAlignment(0);
            this.addDefaultOrderPanel();
            this.txtPinCode.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Button.shadow")));
            this.lblIcon.setIcon(new ImageIcon(this.getClass().getResource("/pmex/gui/images/fastOrder48x48.png")));
            this.scrollPane.setHorizontalScrollBarPolicy(31);
            this.scrollPane.setVerticalScrollBarPolicy(20);
            UIManager.put("ScrollBar.background", 1);
            JScrollBar vbar = this.scrollPane.getVerticalScrollBar();
            NxGScrollBarUI ui2 = new NxGScrollBarUI();
            ui2.setMyScrollBarUI(vbar);
            vbar.setPreferredSize(new Dimension(7, 0));
            this.setPIN();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setPIN() {
        if (LogCommon.pinCode.length() > 0) {
            this.txtPinCode.setText(LogCommon.pinCode);
            this.isSavePIN.setSelected(true);
        } else {
            this.txtPinCode.setText("");
            this.isSavePIN.setSelected(false);
        }
    }

    private void setThis() {
        Mediator.getInstance().setPMEX_FastOrder(this);
    }

    private void setForDocument() {
        this.txtPinCode.setDocument(DocumentType.NUMERIC, 4);
    }

    private void setColumnWidth() {
        this.tblHeader.getColumnModel().getColumn(0).setPreferredWidth(152);
        this.tblHeader.getColumnModel().getColumn(1).setPreferredWidth(55);
        this.tblHeader.getColumnModel().getColumn(2).setPreferredWidth(116);
        this.tblHeader.getColumnModel().getColumn(3).setPreferredWidth(116);
        this.tblHeader.getColumnModel().getColumn(4).setPreferredWidth(38);
        this.tblHeader.getColumnModel().getColumn(5).setPreferredWidth(71);
        this.tblHeader.getColumnModel().getColumn(6).setPreferredWidth(71);
        this.tblHeader.getColumnModel().getColumn(7).setPreferredWidth(71);
        this.tblHeader.getColumnModel().getColumn(8).setPreferredWidth(71);
    }

    public void setOrderOptions(String PMEX_OrderOption) {
    }

    public String getContractWithMarket() {
        StringBuilder sb = new StringBuilder();
        for (Component component : this.pnlOrderHolder.getComponents()) {
            if (!(component instanceof PMEX_FastOrderPanel)) continue;
            sb.append(((PMEX_FastOrderPanel)component).getContractWithMarket()).append(";");
        }
        return sb.toString();
    }

    private void addDefaultOrderPanel() {
        SwingUtilities.invokeLater(this);
    }

    public void removeOrdePanel(int id) {
        for (Component component : this.pnlOrderHolder.getComponents()) {
            if (!(component instanceof PMEX_FastOrderPanel) || ((PMEX_FastOrderPanel)component).getID() != id) continue;
            this.pnlOrderHolder.remove(component);
            break;
        }
        this.pnlOrderHolder.updateUI();
        this.setRowCount();
    }

    private void initComponents() {
        this.pnlHeader = new JPanel();
        this.lblHeader = new JLabel();
        this.lblIcon = new JLabel();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.tblHeader = new JTable();
        this.jSeparator1 = new JSeparator();
        this.scrollPane = new JScrollPane();
        this.pnlOrderHolder = new JPanel();
        this.jSeparator2 = new JSeparator();
        this.btnAdd = new JButton();
        this.lblMessage = new JLabel();
        this.txtPinCode = new NxGPassword();
        this.isSavePIN = new JCheckBox();
        this.btnClearAll = new JButton();
        this.jLabel8 = new JLabel();
        this.setLayout(null);
        this.pnlHeader.setBackground(new Color(255, 255, 255));
        this.pnlHeader.setLayout(null);
        this.lblHeader.setFont(new Font("Tahoma", 1, 14));
        this.lblHeader.setText("Commodity Fast Orders");
        this.pnlHeader.add(this.lblHeader);
        this.lblHeader.setBounds(30, 0, 280, 70);
        this.lblIcon.setIcon(new ImageIcon(this.getClass().getResource("/Images/error32.png")));
        this.pnlHeader.add(this.lblIcon);
        this.lblIcon.setBounds(680, 10, 60, 50);
        this.jLabel1.setBackground(new Color(255, 255, 255));
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/Images/HeaderBG.png")));
        this.jLabel1.setOpaque(true);
        this.pnlHeader.add(this.jLabel1);
        this.jLabel1.setBounds(0, 0, 770, 72);
        this.add(this.pnlHeader);
        this.pnlHeader.setBounds(0, 0, 790, 72);
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.jScrollPane1.setVerticalScrollBarPolicy(21);
        this.tblHeader.setModel(new DefaultTableModel(new Object[0][], new String[]{"Contract", "Order", "Type", "Account", "GTC", "Quantity", "Limit Price", "Trigger Price", "Action"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{true, true, true, true, false, true, true, true, true};
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.tblHeader.setAutoResizeMode(0);
        this.tblHeader.setEnabled(false);
        this.tblHeader.getTableHeader().setResizingAllowed(false);
        this.tblHeader.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane1.setViewportView(this.tblHeader);
        this.add(this.jScrollPane1);
        this.jScrollPane1.setBounds(10, 81, 760, 26);
        this.add(this.jSeparator1);
        this.jSeparator1.setBounds(0, 72, 785, 3);
        this.pnlOrderHolder.setAutoscrolls(true);
        this.pnlOrderHolder.setLayout(new BoxLayout(this.pnlOrderHolder, 1));
        this.scrollPane.setViewportView(this.pnlOrderHolder);
        this.add(this.scrollPane);
        this.scrollPane.setBounds(10, 107, 760, 222);
        this.add(this.jSeparator2);
        this.jSeparator2.setBounds(0, 335, 785, 2);
        this.btnAdd.setIcon(new ImageIcon(this.getClass().getResource("/Images/RSSSubscribe.png")));
        this.btnAdd.setText("Add");
        this.btnAdd.setName("PMEX_FastOrder -> btnAdd");
        this.btnAdd.setOpaque(false);
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PMEX_FastOrder.this.btnAddActionPerformed(evt);
            }
        });
        this.add(this.btnAdd);
        this.btnAdd.setBounds(690, 341, 80, 25);
        this.lblMessage.setHorizontalAlignment(2);
        this.lblMessage.setText("PIN :");
        this.add(this.lblMessage);
        this.lblMessage.setBounds(180, 341, 380, 25);
        this.txtPinCode.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Button.shadow")));
        this.add(this.txtPinCode);
        this.txtPinCode.setBounds(50, 341, 40, 25);
        this.isSavePIN.setText("Save PIN");
        this.isSavePIN.setOpaque(false);
        this.isSavePIN.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PMEX_FastOrder.this.isSavePINItemStateChanged(evt);
            }
        });
        this.add(this.isSavePIN);
        this.isSavePIN.setBounds(100, 341, 90, 25);
        this.btnClearAll.setIcon(new ImageIcon(this.getClass().getResource("/Images/refresh.png")));
        this.btnClearAll.setText("Reset All");
        this.btnClearAll.setName("PMEX_FastOrder -> btnClearAll");
        this.btnClearAll.setOpaque(false);
        this.btnClearAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PMEX_FastOrder.this.btnClearAllActionPerformed(evt);
            }
        });
        this.add(this.btnClearAll);
        this.btnClearAll.setBounds(580, 341, 100, 25);
        this.jLabel8.setHorizontalAlignment(4);
        this.jLabel8.setText("PIN :");
        this.add(this.jLabel8);
        this.jLabel8.setBounds(10, 341, 30, 25);
    }

    private void btnAddActionPerformed(ActionEvent evt) {
        PMEX_FastOrderPanel order = new PMEX_FastOrderPanel(this, this.txtPinCode, ++panelID);
        this.pnlOrderHolder.add(order);
        this.pnlOrderHolder.addNotify();
        this.pnlOrderHolder.repaint();
        this.pnlOrderHolder.updateUI();
        this.scrollPane.repaint();
        Util.ScrollToFirstOrLastRow((boolean)false, (JPanel)this.pnlOrderHolder, (JScrollPane)this.scrollPane);
        this.setRowCount();
        order.setFocus();
    }

    private void isSavePINItemStateChanged(ItemEvent evt) {
        LogCommon.pinCode = evt.getStateChange() == 2 ? "" : this.txtPinCode.getText();
        Mediator.getInstance().setUniversalPIN();
    }

    private void btnClearAllActionPerformed(ActionEvent evt) {
        for (Component component : this.pnlOrderHolder.getComponents()) {
            if (!(component instanceof PMEX_FastOrderPanel)) continue;
            ((PMEX_FastOrderPanel)component).resetValues();
        }
    }

    @Override
    public void run() {
        for (int i = 0; i < 10; ++i) {
            PMEX_FastOrderPanel order = new PMEX_FastOrderPanel(this, this.txtPinCode, ++panelID);
            this.pnlOrderHolder.add(order);
            this.pnlOrderHolder.addNotify();
            this.pnlOrderHolder.repaint();
            this.pnlOrderHolder.updateUI();
            this.scrollPane.repaint();
        }
        this.setRowCount();
    }

    private void setRowCount() {
        int cnt = this.pnlOrderHolder.getComponentCount();
        if (cnt == 0) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)"No order added");
        } else if (cnt == 1) {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)(this.pnlOrderHolder.getComponentCount() + " order added"));
        } else {
            Util.setMessage((JLabel)this.lblMessage, (MessageType)MessageType.Information, (String)(this.pnlOrderHolder.getComponentCount() + " orders added"));
        }
    }
}

