/*
 * Decompiled with CFR 0.152.
 */
package windows.pmex.order;

import CustomComponent.DocumentType;
import CustomComponent.MyOptionPane;
import CustomComponent.NxGComboBox;
import CustomComponent.NxGPassword;
import CustomComponent.NxGSpinner;
import MyDocking.Mediator;
import MyDocking.TradeCast;
import RendersNModels.ComboBoxToolTipRender;
import Utilities.LogsTC;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import common.bean.AccountBean;
import common.bean.MBO_MBP_Bean;
import common.gui.component.NxGDialogBox;
import common.gui.component.NxGRoundedPanel;
import common.gui.util.AppConfig;
import common.gui.util.ImageUtil;
import common.gui.util.LogCommon;
import common.gui.util.MessageType;
import common.gui.util.Util;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.AbstractDocument;
import pmex.gui.bean.LeaderBean;
import pmex.gui.bean.PMEXOrderBean;
import pmex.gui.util.LogsPMEX;
import windows.pmex.buyingpower.DocumentSizeAndUppercaseFilter;
import windows.pmex.order.PMEX_OrderConfirmation;

public class PMEX_OrderOneClick
extends NxGRoundedPanel
implements ActionListener,
FocusListener {
    private String contract = "";
    private String market = "";
    private double lastTradePrice = LeaderBean.DEFAULT_VALUE;
    private final SpinnerNumberModel quantityModel = new SpinnerNumberModel(0, 0, 1000000, 10);
    private Mediator mediator = Mediator.getInstance();
    private Object scr = null;
    private String type = "";
    private MBO_MBP_Bean MBPBean = null;
    private final JPanel owner;
    private boolean isOpening = false;
    private JButton btnBuy;
    private JButton btnBuyMarket;
    private JButton btnSell;
    private JButton btnSellMarket;
    private NxGComboBox cbAccountNo;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel lblPrefix;
    private JPanel pnlQty;
    private NxGSpinner spQuantity;
    private NxGPassword txtPinCode;

    public PMEX_OrderOneClick(JPanel owner) {
        this.initComponents();
        this.owner = owner;
        this.setOpaque(false);
        this.setShady(false);
        ((NxGRoundedPanel)this.pnlQty).setShady(false);
        this.cbAccountNo.setRenderer(new ComboBoxToolTipRender(LogsTC.accountAll, LogsPMEX.accountPrefix));
        this.cbAccountNo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    PMEX_OrderOneClick.this.cbAccountNo.setToolTipText(LogsTC.accountAll.get(PMEX_OrderOneClick.this.cbAccountNo.getSelectedItem().toString().trim()).toString());
                }
                catch (Exception ex) {
                    PMEX_OrderOneClick.this.cbAccountNo.setToolTipText(null);
                }
            }
        });
        this.spQuantity.setModel(this.quantityModel);
        this.setListener();
        this.setForDocument();
        this.setAccounts();
        this.setPIN();
        this.isOpening = true;
    }

    private void setListener() {
        this.cbAccountNo.addActionListener(this);
        this.txtPinCode.addActionListener(this);
        this.spQuantity.getEditor().addFocusListener(this);
        ((JSpinner.DefaultEditor)this.spQuantity.getEditor()).getTextField().addFocusListener(this);
        ((JSpinner.DefaultEditor)this.spQuantity.getEditor()).addFocusListener(this);
        ((JSpinner.DefaultEditor)this.spQuantity.getEditor()).getTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                super.keyReleased(evt);
                if (evt.getKeyCode() == 10) {
                    if (PMEX_OrderOneClick.this.spQuantity.getValue().toString().trim().length() <= 0 || PMEX_OrderOneClick.this.spQuantity.getValue().toString().equalsIgnoreCase("0") || PMEX_OrderOneClick.this.spQuantity.getValue().toString().equalsIgnoreCase("0.0")) {
                        PMEX_OrderOneClick.this.spQuantity.setError(true);
                    } else {
                        PMEX_OrderOneClick.this.spQuantity.setError(false);
                        PMEX_OrderOneClick.this.txtPinCode.requestFocus();
                    }
                }
            }
        });
        this.btnSell.addActionListener(this);
        this.btnSellMarket.addActionListener(this);
        this.btnBuy.addActionListener(this);
        this.btnBuyMarket.addActionListener(this);
    }

    private String getSelectedAccount() {
        if (this.cbAccountNo.getSelectedItem() == null) {
            return "";
        }
        if (this.cbAccountNo.getSelectedItem().toString().trim().equalsIgnoreCase("")) {
            return "";
        }
        return LogsPMEX.accountPrefix + this.cbAccountNo.getSelectedItem().toString().trim();
    }

    private void setForDocument() {
        this.txtPinCode.setDocument(DocumentType.NUMERIC, 4);
    }

    private void setAccounts() {
        if (LogsPMEX.accountPrefix.length() > 0) {
            this.lblPrefix.setText(LogsPMEX.accountPrefix);
        } else {
            this.lblPrefix.setText("Account");
        }
        Iterator en = LogsPMEX.ALL_ACCOUNTS.keySet().iterator();
        ArrayList<String> list = new ArrayList<String>();
        while (en.hasNext()) {
            String key = en.next().toString();
            AccountBean ac = (AccountBean)LogsPMEX.ALL_ACCOUNTS.get(key);
            if (ac.getAccountNo().indexOf(LogsPMEX.accountPrefix) == 0) {
                list.add(ac.getAccountNo().replaceFirst(LogsPMEX.accountPrefix, ""));
                continue;
            }
            list.add(ac.getAccountNo());
        }
        this.cbAccountNo.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
        AutoCompleteSupport support = AutoCompleteSupport.install((JComboBox)this.cbAccountNo, (EventList)GlazedLists.eventListOf((Object[])list.toArray()));
        support.setStrict(false);
        this.cbAccountNo.setRenderer(new ComboBoxToolTipRender(LogsPMEX.ALL_ACCOUNTS, LogsPMEX.accountPrefix));
        this.cbAccountNo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    PMEX_OrderOneClick.this.cbAccountNo.setToolTipText(((AccountBean)LogsPMEX.ALL_ACCOUNTS.get(LogsPMEX.accountPrefix + PMEX_OrderOneClick.this.cbAccountNo.getSelectedItem().toString().trim())).toString());
                }
                catch (Exception ex) {
                    PMEX_OrderOneClick.this.cbAccountNo.setToolTipText(null);
                }
            }
        });
        try {
            if (this.cbAccountNo.getItemCount() > 0) {
                if (LogCommon.preferredAccountPMEX.trim().length() > 0) {
                    this.cbAccountNo.setSelectedItem(LogCommon.preferredAccountPMEX.replaceFirst(LogsPMEX.accountPrefix, ""));
                } else {
                    this.cbAccountNo.setSelectedIndex(0);
                }
            } else {
                this.cbAccountNo.setSelectedItem("");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        AbstractDocument d = (AbstractDocument)((JTextField)this.cbAccountNo.getEditor().getEditorComponent()).getDocument();
        d.setDocumentFilter(new DocumentSizeAndUppercaseFilter(4));
    }

    public void setOrderOptions(String result) {
        try {
            if (result.indexOf(";") > 0) {
                LogCommon.PMEX_OrderOption = result;
            }
            if (LogCommon.PMEX_OrderOption.indexOf(";") > 0) {
                String[] val = LogCommon.PMEX_OrderOption.split("\\;", -1);
                Integer value = new Integer(Integer.parseInt(val[0]));
                Integer min = new Integer(1);
                Integer max = new Integer(999999);
                Integer step = new Integer(Integer.parseInt(val[1]));
                this.quantityModel.setMinimum(min);
                this.quantityModel.setMaximum(max);
                this.quantityModel.setStepSize(step);
                this.quantityModel.setValue(value);
            } else {
                Integer value = new Integer(100);
                Integer min = new Integer(1);
                Integer max = new Integer(999999);
                Integer step = new Integer(1);
                this.quantityModel.setMinimum(min);
                this.quantityModel.setMaximum(max);
                this.quantityModel.setStepSize(step);
                this.quantityModel.setValue(value);
            }
        }
        catch (Exception ex) {
            Mediator.getInstance().PrintLog(ex, result);
        }
    }

    private void openOrderConfirmation(String orderType, boolean isBuy) {
        PMEXOrderBean bean = this.getBean(isBuy);
        PMEX_OrderConfirmation OC = new PMEX_OrderConfirmation(bean, orderType, this.owner);
        NxGDialogBox jd = new NxGDialogBox((Frame)TradeCast.getInstance().frame, true);
        try {
            if (AppConfig.houseIcon == null) {
                AppConfig.houseIcon = ImageUtil.downloadImage((String)(AppConfig.TradeCastURL + "/HouseImages/small.png"));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        jd.setIconImage(AppConfig.houseIcon);
        jd.getContentPane().add(OC);
        if (bean.getTransactionType().equalsIgnoreCase("Sel")) {
            jd.setTitle("Sell Order Confirmation");
        } else if (bean.getTransactionType().equalsIgnoreCase("Buy")) {
            jd.setTitle("Buy Order Confirmation");
        } else {
            jd.setTitle(bean.getTransactionType() + " Order Confirmation");
        }
        if (Util.isWindow7()) {
            jd.setSize(330, 225);
        } else {
            jd.setSize(330, 220);
        }
        jd.setLocationRelativeTo(null);
        jd.setVisible(true);
    }

    private void initComponents() {
        this.btnBuyMarket = new JButton();
        this.btnBuy = new JButton();
        this.btnSellMarket = new JButton();
        this.btnSell = new JButton();
        this.pnlQty = new NxGRoundedPanel();
        this.jLabel1 = new JLabel();
        this.lblPrefix = new JLabel();
        this.jLabel3 = new JLabel();
        this.txtPinCode = new NxGPassword();
        this.cbAccountNo = new NxGComboBox();
        this.spQuantity = new NxGSpinner();
        this.btnBuyMarket.setOpaque(false);
        this.btnBuyMarket.setText("Buy");
        this.btnBuyMarket.setToolTipText("Buy at market price");
        this.btnBuyMarket.setName("PMEX_OrderOneClick -> btnBuyMarket");
        this.btnBuy.setOpaque(false);
        this.btnBuy.setText("Bid");
        this.btnBuy.setToolTipText("Buy at last trade price");
        this.btnBuy.setName("PMEX_OrderOneClick -> btnbuy");
        this.btnBuy.setNextFocusableComponent(this.cbAccountNo);
        this.btnSellMarket.setOpaque(false);
        this.btnSellMarket.setText("Sell");
        this.btnSellMarket.setToolTipText("Sell at market price");
        this.btnSellMarket.setName("PMEX_OrderOneClick -> btnSellMarket");
        this.btnSell.setOpaque(false);
        this.btnSell.setText("Ask");
        this.btnSell.setToolTipText("Sell at last trade price");
        this.btnSell.setName("PMEX_OrderOneClick -> btnSell");
        this.pnlQty.setBackground(new Color(255, 255, 102));
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText("Quantity");
        this.lblPrefix.setHorizontalAlignment(0);
        this.lblPrefix.setText("Account");
        this.jLabel3.setHorizontalAlignment(0);
        this.jLabel3.setText("PIN");
        this.cbAccountNo.setPreferredSize(new Dimension(56, 20));
        this.spQuantity.setMinimumSize(new Dimension(10, 16));
        this.spQuantity.setPreferredSize(new Dimension(15, 16));
        GroupLayout pnlQtyLayout = new GroupLayout(this.pnlQty);
        this.pnlQty.setLayout(pnlQtyLayout);
        pnlQtyLayout.setHorizontalGroup(pnlQtyLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlQtyLayout.createSequentialGroup().addGroup(pnlQtyLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlQtyLayout.createSequentialGroup().addGap(4, 4, 4).addComponent(this.lblPrefix, -1, 41, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, pnlQtyLayout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.cbAccountNo, -2, 1, Short.MAX_VALUE))).addGap(2, 2, 2).addGroup(pnlQtyLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -1, 44, Short.MAX_VALUE).addComponent(this.spQuantity, -1, -1, Short.MAX_VALUE)).addGap(2, 2, 2).addGroup(pnlQtyLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.txtPinCode, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel3, -1, 40, Short.MAX_VALUE)).addGap(5, 5, 5)));
        pnlQtyLayout.setVerticalGroup(pnlQtyLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlQtyLayout.createSequentialGroup().addGap(5, 5, 5).addGroup(pnlQtyLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.lblPrefix).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlQtyLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtPinCode, -2, 22, -2).addComponent(this.cbAccountNo, -2, 22, -2).addComponent(this.spQuantity, -2, 22, -2)).addContainerGap()));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(5, 5, 5).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.btnBuyMarket, -1, -1, Short.MAX_VALUE).addComponent(this.btnBuy, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlQty, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.btnSellMarket, -1, -1, Short.MAX_VALUE).addComponent(this.btnSell)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlQty, -2, 52, -2).addGroup(layout.createSequentialGroup().addComponent(this.btnBuyMarket).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnBuy)).addGroup(layout.createSequentialGroup().addComponent(this.btnSellMarket).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnSell))).addContainerGap(-1, Short.MAX_VALUE)));
    }

    @Override
    public void focusGained(FocusEvent evt) {
        Object source = evt.getSource();
        if (source == ((JSpinner.DefaultEditor)this.spQuantity.getEditor()).getTextField()) {
            JFormattedTextField textField = (JFormattedTextField)evt.getComponent();
            textField.setText(textField.getText());
            textField.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent fe) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.scr = e.getSource();
        if (this.scr == this.cbAccountNo) {
            if ((e.getModifiers() == 16 || e.getActionCommand().equalsIgnoreCase("comboBoxEdited")) && this.isOpening && this.isBasicValide()) {
                ((JSpinner.DefaultEditor)this.spQuantity.getEditor()).getTextField().requestFocus();
            }
        } else if (this.scr == this.txtPinCode) {
            if (this.isBasicValide()) {
                this.sendOrder();
            }
        } else {
            this.sendOrder();
        }
    }

    private void sendOrder() {
        if (this.scr == this.btnSell) {
            if (this.isValide(false)) {
                this.type = "SEL";
                if (LogCommon.isConfirmation) {
                    this.openOrderConfirmation("Limit", false);
                } else {
                    this.sendSellOrder();
                }
            }
        } else if (this.scr == this.btnSellMarket) {
            if (this.isBasicValide()) {
                this.type = "SEL";
                if (LogCommon.isConfirmation) {
                    this.openOrderConfirmation("Market", false);
                } else {
                    this.sendSellMarketOrder();
                }
            }
        } else if (this.scr == this.btnBuy) {
            if (this.isValide(true)) {
                this.type = "BUY";
                if (LogCommon.isConfirmation) {
                    this.openOrderConfirmation("Limit", true);
                } else {
                    this.sendBuyOrder();
                }
            }
        } else if (this.scr == this.btnBuyMarket) {
            if (this.isBasicValide()) {
                this.type = "BUY";
                if (LogCommon.isConfirmation) {
                    this.openOrderConfirmation("Market", true);
                } else {
                    this.sendBuyMarketOrder();
                }
            }
        } else {
            this.btnBuyMarket.requestFocus();
        }
    }

    public void sendOrderToServer() {
        if (this.scr == this.btnSell) {
            if (this.isValide(false)) {
                this.type = "SEL";
                this.sendSellOrder();
            }
        } else if (this.scr == this.btnSellMarket) {
            if (this.isBasicValide()) {
                this.type = "SEL";
                this.sendSellMarketOrder();
            }
        } else if (this.scr == this.btnBuy) {
            if (this.isValide(true)) {
                this.type = "BUY";
                this.sendBuyOrder();
            }
        } else if (this.scr == this.btnBuyMarket && this.isBasicValide()) {
            this.type = "BUY";
            this.sendBuyMarketOrder();
        }
        this.setFocusResquest();
    }

    private boolean isBasicValide() {
        boolean status = false;
        if (this.contract.trim().equalsIgnoreCase("") || this.contract.trim().equalsIgnoreCase("Please Select a Contract")) {
            MyOptionPane.showMessage(MessageType.Error, "Please select a contract", true);
        } else if (this.cbAccountNo.getSelectedItem().toString().trim().length() <= 0) {
            this.cbAccountNo.setError(true);
            this.cbAccountNo.requestFocus();
        } else if (this.spQuantity.getValue().toString().trim().length() <= 0 || this.spQuantity.getValue().toString().equalsIgnoreCase("0")) {
            this.spQuantity.setError(true);
            ((JSpinner.DefaultEditor)this.spQuantity.getEditor()).getTextField().requestFocus();
        } else if (this.txtPinCode.getText().trim().length() <= 0) {
            this.txtPinCode.setError(true);
            this.txtPinCode.requestFocus();
        } else {
            status = true;
            this.resetError();
        }
        return status;
    }

    private boolean isValide(boolean isBuy) {
        boolean status = false;
        if (this.isBasicValide()) {
            if (this.getOrderPrice(isBuy) <= 0.0) {
                MyOptionPane.showMessage(MessageType.Error, "Price is not set", true);
            } else {
                this.btnBuyMarket.requestFocus();
                status = true;
                this.resetError();
            }
        }
        return status;
    }

    private PMEXOrderBean getBean(boolean isBuy) {
        PMEXOrderBean bean = new PMEXOrderBean();
        bean.setContract(this.getContract());
        bean.setMarket(this.getMarket());
        bean.setAccount(this.getSelectedAccount());
        bean.setVolume(Long.parseLong(this.spQuantity.getValue().toString()));
        bean.setLimitPrice(this.getOrderPrice(isBuy));
        bean.setPIN(this.txtPinCode.getText());
        bean.setUserName(LogCommon.UserID);
        bean.setUserCode(LogCommon.UserCode);
        bean.setIP(LogCommon.localip);
        bean.setOrderNumber(LogsPMEX.orderNumber++ + "");
        bean.setDateTime(Mediator.getDateTime());
        bean.setTransactionType(this.type);
        return bean;
    }

    private void resetValues() {
        this.resetError();
    }

    private void resetError() {
        this.cbAccountNo.setError(false);
        this.spQuantity.setError(false);
        this.txtPinCode.setError(false);
    }

    private void sendSellOrder() {
        PMEXOrderBean bean = this.getBean(false);
        String orderString = bean.getLimitOrderString();
        this.mediator.SendMsgToTradeServer_PMEX_NewOrder(orderString);
        this.resetValues();
    }

    private void sendSellMarketOrder() {
        PMEXOrderBean bean = this.getBean(false);
        String orderString = bean.getMarketOrderString();
        this.mediator.SendMsgToTradeServer_PMEX_NewOrder(orderString);
        this.resetValues();
    }

    private void sendBuyOrder() {
        PMEXOrderBean bean = this.getBean(true);
        String orderString = bean.getLimitOrderString();
        this.mediator.SendMsgToTradeServer_PMEX_NewOrder(orderString);
        this.resetValues();
    }

    private void sendBuyMarketOrder() {
        PMEXOrderBean bean = this.getBean(true);
        String orderString = bean.getMarketOrderString();
        this.mediator.SendMsgToTradeServer_PMEX_NewOrder(orderString);
        this.resetValues();
    }

    public String getContract() {
        return this.contract;
    }

    public void setContract(String contract) {
        this.contract = contract;
    }

    public String getMarket() {
        return this.market;
    }

    public void setMarket(String market) {
        this.market = market;
    }

    public double getLastTradePrice() {
        return this.lastTradePrice;
    }

    public void setLastTradePrice(double lastTradePrice) {
        this.lastTradePrice = lastTradePrice;
    }

    private double getOrderPrice(boolean isBuy) {
        double val = 0.0;
        val = this.getLastTradePrice() <= 0.0 ? (this.MBPBean != null ? (isBuy ? this.MBPBean.getPriceSell() : this.MBPBean.getPriceBuy()) : 0.0) : this.getLastTradePrice();
        return val;
    }

    public MBO_MBP_Bean getMBPBean() {
        return this.MBPBean;
    }

    public void setMBPBean(MBO_MBP_Bean MBPBean) {
        this.MBPBean = MBPBean;
    }

    public void setFocusResquest() {
        this.isBasicValide();
    }

    public void setPIN() {
        this.txtPinCode.setText(LogCommon.pinCode);
    }
}

