/*
 * Decompiled with CFR 0.152.
 */
package windows.pmex.watches;

import CATALYST.Control.MarketFeed;
import CustomComponent.MyOptionPane;
import CustomComponent.MyTime;
import MyDocking.Mediator;
import MyDocking.TradeCast;
import Utilities.FormsProperties;
import Utilities.LoadLogs;
import Utilities.ThreadWithName;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import common.bean.ContractBrowseBean;
import common.dragndrop.GhostGlassPane;
import common.gui.component.NxGLink;
import common.gui.layout.NxGWrapLayout;
import common.gui.util.FormName;
import common.gui.util.MessageType;
import common.gui.util.Title;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import org.jdesktop.swingx.JXButton;
import org.jdesktop.swingx.JXPanel;
import pmex.gui.Tile;
import pmex.gui.TileScrollPane;
import pmex.gui.bean.PMEXMarketFeedBean;
import pmex.gui.dragdrop.TileDropDestination;
import pmex.gui.event.PMEXTileEvent;
import pmex.gui.event.PMEXTileEventListener;
import pmex.gui.util.LogsPMEX;
import pmex.gui.util.UtilPMEX;
import pmex.interfaces.ContractBarInterface;
import windows.pmex.PMEX_ContractBrowseDialog;
import windows.pmex.watches.PMEX_ContractBar;

public class PMEX_Matrix
extends JXPanel
implements PMEXTileEventListener,
ContractBarInterface {
    private TileDropDestination pnlTile = null;
    private List _listeners = new ArrayList();
    public Map<String, PMEXMarketFeedBean> allFeed = new HashMap<String, PMEXMarketFeedBean>(20);
    private Mediator mediator = Mediator.getInstance();
    private boolean isShowUnit;
    private AutoCompleteSupport autoCom;
    private PMEX_ContractBar PMEX_ContractBar = null;
    private Date date = null;
    private JComboBox cbContract;
    private JToggleButton jToggleButton1;
    private JToolBar jToolBar1;
    private JXButton jXButton1;
    private JLabel lblMarket;
    private TileScrollPane nxGScrollPane1;
    private JPanel pnlContract;

    public PMEX_Matrix(JFrame frame) {
        this.initComponents();
        this.mediator.setPMEX_MatrixPanel(this);
        this.pnlTile = new TileDropDestination((ContractBarInterface)this);
        this.pnlTile.setLayout((LayoutManager)new NxGWrapLayout());
        this.nxGScrollPane1.addComponent((JComponent)this.pnlTile);
        this.nxGScrollPane1.addComponentDropListiner((ContractBarInterface)this, this.pnlTile);
        this.nxGScrollPane1.setComponentParent((Component)((Object)this));
        this.nxGScrollPane1.setIsHorizontal(false);
        this.nxGScrollPane1.setScrollerCollapsed(false);
        this.nxGScrollPane1.setIsMouseWheelListner(true);
        this.nxGScrollPane1.setBorders(false);
        this.nxGScrollPane1.setBars();
        this.cbContract.setMaximumRowCount(30);
        this.PMEX_ContractBar = new PMEX_ContractBar(null, this, FormName.PMEX_Matrix);
        this.PMEX_ContractBar.showQuantityButton(false);
        TradeCast.getInstance().MatrixWindowHolder.add(this);
        frame.setGlassPane((Component)new GhostGlassPane());
        this.setContractBar();
        this.setDate(MyTime.getInstance().getDate2());
    }

    private void SendMessageToFeedServer() {
        Mediator.getInstance().sendFeedContract(this.getContractAdded(), "PMEX Matrix : SendMessageToFeedServer");
    }

    public String getContractAdded() {
        return this.pnlTile.getContractAdded();
    }

    public void AddContractInWatch(String text) {
        this.addContractToWatch(text, false);
        this.setScrollToTopBottom(true);
    }

    private void setScrollToTopBottom(boolean isTop) {
        this.nxGScrollPane1.getScrollPane().validate();
        this.nxGScrollPane1.setScrollPaneTopBottom(isTop);
        this.nxGScrollPane1.getScrollPane().validate();
        this.pnlTile.repaint();
    }

    private void setScrollToTile(Tile tp) {
        this.nxGScrollPane1.getScrollPane().validate();
        this.nxGScrollPane1.setScrollToTile(tp);
        this.nxGScrollPane1.getScrollPane().validate();
        this.pnlTile.repaint();
    }

    public synchronized void feedReceived(String feed) {
        if (feed.indexOf("|") > 0) {
            String[] allFeeds = feed.split("\\|", -1);
            for (int i = 0; i < allFeeds.length; ++i) {
                String singleFeed = allFeeds[i];
                if (singleFeed.trim().length() <= 0) continue;
                PMEXMarketFeedBean bean = PMEXMarketFeedBean.parse((String)singleFeed);
                this.allFeed.put(bean.getContract() + ":" + bean.getMarket(), bean);
                for (Component com : this.pnlTile.getComponents()) {
                    Tile t;
                    if (!(com instanceof Tile) || !(t = (Tile)com).getContract().equalsIgnoreCase(bean.getContract())) continue;
                    if (t.isExpire()) {
                        t.setContractExpire(false);
                    }
                    if (bean.getSellVolume() <= 0L && bean.getBuyVolume() <= 0L && !(bean.getSell() > 0.0) && !(bean.getBuy() > 0.0)) continue;
                    t.updateFeed(bean);
                }
            }
        }
    }

    private void setFeedFromMarketWatch(String contract, String market) {
        MarketFeed feed = this.mediator.PMEX_MarketWatchPanel.GetSingleFeed(contract, market);
        if (feed != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(contract).append(";");
            sb.append(market).append(";");
            sb.append(feed.bvol).append(";");
            sb.append(feed.buy).append(";");
            sb.append(feed.sell).append(";");
            sb.append(feed.svol).append(";");
            sb.append(feed.state).append(";");
            sb.append(feed.lTrdPrice).append(";");
            sb.append(feed.high).append(";");
            sb.append(feed.low).append(";");
            sb.append(feed.change).append(";");
            sb.append(feed.perChange).append(";");
            sb.append(feed.totVolume).append(";");
            sb.append(feed.ltrdVolume).append(";");
            sb.append(feed.lTrdTime).append(";");
            sb.append("0").append(";");
            sb.append("0").append(";");
            sb.append(feed.closePrice).append("|");
            this.feedReceived(sb.toString());
        }
    }

    private void initComponents() {
        this.pnlContract = new JPanel();
        this.jToolBar1 = new JToolBar();
        this.jToggleButton1 = new JToggleButton();
        this.lblMarket = new NxGLink("Contract Browse");
        this.cbContract = new JComboBox();
        this.jXButton1 = new JXButton();
        this.nxGScrollPane1 = new TileScrollPane();
        this.pnlContract.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("Button.shadow")));
        this.pnlContract.setOpaque(false);
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.jToggleButton1.setText("Quantity");
        this.jToggleButton1.setFocusable(false);
        this.jToggleButton1.setHorizontalTextPosition(0);
        this.jToggleButton1.setMaximumSize(new Dimension(49, 26));
        this.jToggleButton1.setMinimumSize(new Dimension(49, 26));
        this.jToggleButton1.setPreferredSize(new Dimension(49, 26));
        this.jToggleButton1.setVerticalTextPosition(3);
        this.jToggleButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PMEX_Matrix.this.jToggleButton1ActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jToggleButton1);
        this.lblMarket.setFont(new Font("Tahoma", 1, 11));
        this.lblMarket.setHorizontalAlignment(0);
        this.lblMarket.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/Images/TC.png")));
        this.lblMarket.setText("Contract Browse");
        this.lblMarket.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                PMEX_Matrix.this.lblMarketMousePressed(evt);
            }
        });
        this.cbContract.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbContract.setOpaque(false);
        this.cbContract.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PMEX_Matrix.this.cbContractActionPerformed(evt);
            }
        });
        this.jXButton1.setText("...");
        this.jXButton1.setOpaque(false);
        this.jXButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PMEX_Matrix.this.jXButton1ActionPerformed(evt);
            }
        });
        GroupLayout pnlContractLayout = new GroupLayout(this.pnlContract);
        this.pnlContract.setLayout(pnlContractLayout);
        pnlContractLayout.setHorizontalGroup(pnlContractLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pnlContractLayout.createSequentialGroup().addContainerGap().addComponent(this.lblMarket, -2, 120, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cbContract, -2, 165, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.jXButton1, -2, 18, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jToolBar1, -2, -1, -2)));
        pnlContractLayout.setVerticalGroup(pnlContractLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pnlContractLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(pnlContractLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbContract, -2, -1, -2).addComponent((Component)this.jXButton1, -2, -1, -2)).addGap(2, 2, 2)).addComponent(this.lblMarket, -2, 28, -2).addComponent(this.jToolBar1, -1, -1, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlContract, -1, -1, Short.MAX_VALUE).addComponent((Component)this.nxGScrollPane1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.pnlContract, -2, -1, -2).addGap(1, 1, 1).addComponent((Component)this.nxGScrollPane1, -1, 117, Short.MAX_VALUE)));
    }

    private void jToggleButton1ActionPerformed(ActionEvent evt) {
    }

    private void cbContractActionPerformed(ActionEvent evt) {
        if (evt.getModifiers() == 16 || evt.getActionCommand().equalsIgnoreCase("comboBoxEdited")) {
            String sym = this.cbContract.getSelectedItem().toString();
            this.addContractToWatch(sym, false);
        }
    }

    private void jXButton1ActionPerformed(ActionEvent evt) {
        TradeCast tradeCast = TradeCast.getInstance();
        if (tradeCast.htFormsProperties.containsKey(FormName.ContractBrowse)) {
            FormsProperties fp = tradeCast.htFormsProperties.get(FormName.ContractBrowse);
            ContractBrowseBean cb = PMEX_ContractBrowseDialog.getSelectedContract(tradeCast.frame, true, fp.getSize());
            if (cb != null) {
                this.cbContract.setSelectedItem(cb.getContract());
            }
        } else {
            ContractBrowseBean cb = PMEX_ContractBrowseDialog.getSelectedContract(tradeCast.frame, true, new Dimension(600, 400));
            if (cb != null) {
                this.cbContract.setSelectedItem(cb.getContract());
            }
        }
    }

    private void lblMarketMousePressed(MouseEvent evt) {
    }

    public synchronized void addEventListener(PMEXTileEventListener listener) {
        this._listeners.add(listener);
    }

    public synchronized void removeEventListener(PMEXTileEventListener listener) {
        this._listeners.remove(listener);
    }

    private synchronized void fireEventShowUnit(boolean showUnit) {
        PMEXTileEvent event = new PMEXTileEvent((Object)this);
        Iterator i = this._listeners.iterator();
        while (i.hasNext()) {
            ((PMEXTileEventListener)i.next()).showUnit(event, showUnit);
        }
    }

    public void showUnit(PMEXTileEvent e, boolean showUnit) {
    }

    public void showWindow(PMEXTileEvent e, FormName formName, String contract) {
        if (formName == FormName.PMEX_MBP) {
            TradeCast.getInstance().ShowPMEX_MBPWindow(formName, Title.PMEX_MarketDepthByPrice, contract);
        } else if (formName == FormName.PMEX_Ladder) {
            TradeCast.getInstance().ShowLadderWindow(formName, Title.PMEX_Ladder, contract);
        } else if (formName == FormName.PMEX_Ladder_Dock) {
            TradeCast.getInstance().showStaticWindow(Title.PMEX_Ladder_Dock, true);
            TradeCast.getInstance().Panel_PMEX_Leader.addContract(contract);
        } else if (formName == FormName.PMEX_Sell) {
            LogsPMEX.SelectedSymbol = contract;
            TradeCast.getInstance().ShowDynamicForm(formName, Title.PMEX_Sell);
        } else if (formName == FormName.PMEX_Buy) {
            LogsPMEX.SelectedSymbol = contract;
            TradeCast.getInstance().ShowDynamicForm(formName, Title.PMEX_Buy);
        } else if (formName == FormName.PMEX_AddContract) {
            this.mediator.PMEX_MarketWatchPanel.AddContractInWatch(contract + ";" + UtilPMEX.GetMarketFromContract((String)contract));
        }
    }

    public void removeTile(PMEXTileEvent e, Tile tile, String contract, String market) {
        this.SendMessageToFeedServer();
    }

    private void setContractBar() {
        this.pnlContract.removeAll();
        this.pnlContract.revalidate();
        this.pnlContract.setLayout(new GridLayout(1, 1));
        this.pnlContract.add(this.PMEX_ContractBar);
    }

    public void addAllContractsToWatch(String contract, boolean isAtLoginTime) {
        String market = UtilPMEX.GetMarketFromContract((String)contract);
        Tile tp = null;
        if (contract.indexOf("|") > 0) {
            String[] cont;
            for (String contr : cont = contract.split("\\|", -1)) {
                if (contr.trim().length() <= 1) continue;
                if (this.pnlTile.getAllTiles().size() >= 100) {
                    if (isAtLoginTime) break;
                    MyOptionPane.showMessage(MessageType.Information, "You cannot add more than 100 contract", false);
                    break;
                }
                tp = this.addAllContactTile(contr, market);
            }
            this.SendMessageToFeedServer();
            if (tp != null) {
                this.setScrollToTile(tp);
            }
            this.setFeedFromMarketWatch(contract, UtilPMEX.GetMarketFromContract((String)contract));
        } else {
            this.addAllContactTile(contract, market);
        }
    }

    public void addContractToWatch(String contract, boolean isAtLoginTime) {
        String market = UtilPMEX.GetMarketFromContract((String)contract);
        if (contract.indexOf("|") > 0) {
            String[] cont;
            for (String contr : cont = contract.split("\\|", -1)) {
                if (contr.trim().length() <= 1) continue;
                if (this.pnlTile.getAllTiles().size() >= 100) {
                    if (!isAtLoginTime) {
                        MyOptionPane.showMessage(MessageType.Information, "You cannot add more than 100 contract", false);
                    }
                    break;
                }
                this.addContactTile(contr, market, isAtLoginTime);
            }
        } else {
            this.addContactTile(contract, market, isAtLoginTime);
        }
    }

    private Tile addAllContactTile(String contract, String market) {
        if (contract.trim().length() <= 0) {
            return null;
        }
        Tile tp = new Tile();
        this.addEventListener((PMEXTileEventListener)tp);
        tp.setContract(contract);
        if (UtilPMEX.isContractExpire((String)tp.getContract())) {
            return null;
        }
        tp.addEventListener((PMEXTileEventListener)this);
        this.allFeed.put(contract + ":" + market, new PMEXMarketFeedBean());
        this.pnlTile.add((Component)tp);
        this.pnlTile.repaint();
        return tp;
    }

    private void addContactTile(String contract, String market, boolean isAtLoginTime) {
        if (contract.trim().length() <= 0) {
            return;
        }
        if (this.pnlTile.getAllTiles().size() >= 100) {
            if (!isAtLoginTime) {
                MyOptionPane.showMessage(MessageType.Information, "You cannot add more than 100 contract", false);
            }
            return;
        }
        Tile tp = new Tile();
        this.addEventListener((PMEXTileEventListener)tp);
        tp.setContract(contract);
        if (UtilPMEX.isContractExpire((String)tp.getContract())) {
            return;
        }
        tp.addEventListener((PMEXTileEventListener)this);
        this.allFeed.put(contract + ":" + market, new PMEXMarketFeedBean());
        this.pnlTile.add((Component)tp);
        this.pnlTile.repaint();
        this.checkExpireContractToday(tp);
        this.SendMessageToFeedServer();
        this.setScrollToTile(tp);
        this.setFeedFromMarketWatch(contract, UtilPMEX.GetMarketFromContract((String)contract));
    }

    public PMEXMarketFeedBean GetSingleFeed(String contract, String market) {
        PMEXMarketFeedBean feed = null;
        String key = "";
        key = contract.indexOf(";") >= 0 ? contract.replace(";", ":") : contract + ":" + market;
        if (this.allFeed.containsKey(key)) {
            return this.allFeed.get(key);
        }
        return feed;
    }

    public void saveProfile() {
        if (this.mediator != null) {
            new Thread("Matrix saveProfile"){

                @Override
                public void run() {
                    PMEX_Matrix.this.mediator.SaveProfilePMEX_Matrix(false);
                }
            }.start();
        }
    }

    public void reloadProfile() {
        LoadLogs PREFERENCES = new LoadLogs("PMEX_GetUserContract_MATRIX_Reload=", true);
        new ThreadWithName(PREFERENCES, "PMEX_GetUserContract_MATRIX_Reload").start();
    }

    public void showQuantity() {
        if (this.isShowUnit) {
            this.fireEventShowUnit(false);
            this.isShowUnit = false;
        } else {
            this.fireEventShowUnit(true);
            this.isShowUnit = true;
        }
    }

    public void checkExpireContract() {
        List lst = this.pnlTile.getAllTiles();
        for (Tile tile : lst) {
            if (!UtilPMEX.isContractExpire((String)tile.getContract())) continue;
            tile.setContractExpire(true);
        }
    }

    private void checkExpireContractToday(Tile tile) {
        String symbol = tile.getContract();
        if (LogsPMEX.PMEX_CONTRACT_ALL.containsKey(symbol)) {
            ContractBrowseBean cb = (ContractBrowseBean)LogsPMEX.PMEX_CONTRACT_ALL.get(symbol);
            if (this.getDate() != null && this.getDate().compareTo(cb.getDate()) == 0) {
                tile.setExpireContractToday();
            }
        }
    }

    private Date getDate() {
        if (this.date != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(this.date);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            this.date = cal.getTime();
        }
        return this.date;
    }

    private void setDate(Date date) {
        this.date = date;
    }
}

