/*
 * Decompiled with CFR 0.152.
 */
package windows.pmex.watches;

import CATALYST.Control.ColumnData;
import CATALYST.Control.JTABLE;
import CATALYST.Control.MarketWatch;
import CATALYST.Control.MarketWatchEvent;
import CATALYST.Control.MarketWatchListner;
import CustomComponent.MyTime;
import MyDocking.Mediator;
import Utilities.LoadLogs;
import Utilities.ThreadWithName;
import common.gui.util.AppConfig;
import common.gui.util.FormName;
import common.gui.util.LogCommon;
import common.gui.util.MyColors;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import languages.LanguageCentre;
import languages.LanguageConstant;
import pmex.gui.bean.PMEXMarketFeedBean;
import pmex.gui.util.LogsPMEX;
import pmex.gui.util.UtilPMEX;
import pmex.interfaces.ContractBarInterface;
import windows.pmex.watches.PMEX_ContractBar;
import windows.pmex.watches.PMEX_MarketWatchPanel;

public class PMEX_MyMarketWatch
extends JPanel
implements MarketWatchListner,
ContractBarInterface {
    public MarketWatch Mwh;
    public JPopupMenu popup = new JPopupMenu();
    public static String ltPrice = "";
    public static String sys = "";
    private Mediator mediator = Mediator.getInstance();
    private final PMEX_MarketWatchPanel pmex_marketWatchPanel;
    private PMEX_ContractBar PMEX_ContractBar = null;
    private static HashMap<String, Integer> columnIndex = new HashMap();
    private LanguageCentre languageCentre = new LanguageCentre();

    public PMEX_MyMarketWatch(PMEX_MarketWatchPanel marketWatchPanel, String name) {
        this.initComponents();
        this.pmex_marketWatchPanel = marketWatchPanel;
        this.Mwh = new MarketWatch(name, columnIndex);
        this.Mwh.setIsKSEWatch(false);
        this.PMEX_ContractBar = new PMEX_ContractBar(this.Mwh, this, FormName.PMEX_MarketWatch);
        this.PMEX_ContractBar.showQuantityButton(false);
        boolean index = false;
        ColumnData[] m_columns = new ColumnData[]{new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Market), 50, 2), new ColumnData(this.Mwh, this.languageCentre.getValue("Contract"), 150, 2), new ColumnData(this.Mwh, this.languageCentre.getValue("BuyVol"), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Buy), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Sell), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("SellVol"), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.LastPrice), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("Change"), 70, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("Dir"), 40, 0), new ColumnData(this.Mwh, this.languageCentre.getValue("LTrdTime"), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.TotalVolume), 100, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Low), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Average), 70, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.High), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("TotalTrd"), 70, 4), new ColumnData(this.Mwh, this.languageCentre.getValue("LTrdVolume"), 100, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.ClosePrice), 80, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.State), 100, 2), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Flag), 50, 2), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.Trade), 80, 0), new ColumnData(this.Mwh, this.languageCentre.getValue("Spread"), 100, 4), new ColumnData(this.Mwh, this.languageCentre.getValue(LanguageConstant.PercentChange), 70, 4)};
        this.Mwh.NON_VisibleColumn.add(this.languageCentre.getValue(LanguageConstant.Dir));
        this.Mwh.NON_VisibleColumn.add(this.languageCentre.getValue(LanguageConstant.Average));
        this.Mwh.NON_VisibleColumn.add(this.languageCentre.getValue("TotalTrd"));
        this.Mwh.NON_VisibleColumn.add(this.languageCentre.getValue(LanguageConstant.ClosePrice));
        this.Mwh.NON_VisibleColumn.add(this.languageCentre.getValue(LanguageConstant.Flag));
        this.Mwh.NON_VisibleColumn.add(this.languageCentre.getValue(LanguageConstant.Trade));
        this.Mwh.NON_VisibleColumn.add(this.languageCentre.getValue("Spread"));
        this.Mwh.isHistoricalDataWatch = false;
        this.Mwh.ChangeAllColorAndFonts(MyColors.MarketWatchRowColor, MyColors.MarketWatchSelectedRowColor, MyColors.MarketWatchIncreaseColor, MyColors.MarketWatchDecreaseColor, LogCommon.MarketWatchFont);
        this.Mwh.SetHeight = new JFrame().getToolkit().getScreenSize().height - 500;
        this.Mwh.SetWidth = new JFrame().getToolkit().getScreenSize().width + 130;
        this.Mwh.setVisible(true);
        this.Mwh.setMarket(new String[]{"FUT"});
        this.Mwh.Debug = true;
        this.Mwh.addListener((MarketWatchListner)this);
        this.Mwh.isUserAddScrip = true;
        this.Mwh.allowedScripLimit = 100;
        this.Mwh.ShowTradeButton = false;
        this.Mwh.ShowCompanySnapButton = false;
        this.Mwh.isStandardCapital = false;
        this.Mwh.ShowPopupMenuTable = true;
        this.Mwh.init(m_columns);
        this.Mwh.comboBox.setModel(new DefaultComboBoxModel<String>(LogsPMEX.PMEX_MARKETS));
        this.Mwh.comboBox.removeItem("");
        this.Mwh.createPMEX_PopupMenu();
        this.Mwh.setDate(MyTime.getInstance().getDate2());
        JTABLE table = this.Mwh.GetTable();
        for (String col : this.Mwh.NON_VisibleColumn) {
            table.RemoveColumn(col);
        }
        if (table.isColumnExist(this.languageCentre.getValue(LanguageConstant.PercentChange))) {
            table.moveColumn(this.Mwh.GetTable().getColumnModel().getColumnIndex(this.languageCentre.getValue(LanguageConstant.PercentChange)), 8);
        }
        JPanel pnlWatch = new JPanel(false);
        pnlWatch.setLayout(new GridLayout(1, 1));
        pnlWatch.add((Component)this.Mwh, "Center");
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.PMEX_ContractBar);
        this.add(pnlWatch);
    }

    public synchronized void MarketWatchMessageReceived(MarketWatchEvent event) {
        this.mediator.PMEX_MarketWatchMessageReceived(event);
    }

    private void MarketWatchKeyEvent(KeyEvent e) {
    }

    public void SetSymbol(String symbol) {
        this.PMEX_ContractBar.setContract(symbol);
    }

    public void SymbolRemove(String Symbol, String Market) {
        this.Mwh.RemoveSymbolFromWatch(Symbol + ";" + Market);
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    public void addContractToWatch(String contract, boolean isAtLoginTime) {
        String market = UtilPMEX.GetMarketFromContract((String)contract);
        String key = "";
        key = contract.indexOf(";") >= 0 ? contract : contract + ";" + market;
        this.Mwh.AddSymbolInMarketWatch(key, false, isAtLoginTime);
        PMEXMarketFeedBean feed = this.mediator.PMEX_Matrix.GetSingleFeed(contract, market);
        if (feed != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(key).append(";");
            sb.append(feed.getBuyVolume()).append(";");
            sb.append(feed.getBuy()).append(";");
            sb.append(feed.getSell()).append(";");
            sb.append(feed.getSellVolume()).append(";");
            sb.append(feed.getState()).append(";");
            sb.append(feed.getLastTradePrice()).append(";");
            sb.append(feed.getHigh()).append(";");
            sb.append(feed.getLow()).append(";");
            sb.append(feed.getChange()).append(";");
            sb.append(feed.getPercentChange()).append(";");
            sb.append(feed.getTotalVolume()).append(";");
            sb.append(feed.getLastTradeVolume()).append(";");
            sb.append(feed.getLastTradeTime()).append(";");
            sb.append(feed.getOpenPrice()).append(";");
            sb.append(feed.getSettlementPrice()).append(";");
            sb.append(feed.getClosePrice()).append("|");
            this.pmex_marketWatchPanel.feedReceived(sb.toString());
        }
        this.pmex_marketWatchPanel.sendSymbolForFeed();
    }

    public void saveProfile() {
        if (this.mediator != null) {
            new Thread("saveProfile"){

                @Override
                public void run() {
                    PMEX_MyMarketWatch.this.mediator.SaveProfilePMEX(false);
                    PMEX_MyMarketWatch.this.pmex_marketWatchPanel.SetColumnToSave();
                    AppConfig.setAllValues();
                }
            }.start();
        }
    }

    public void reloadProfile() {
        LoadLogs PREFERENCES = new LoadLogs("PMEX_GetUserContract_Reload=", true);
        new ThreadWithName(PREFERENCES, "PMEX_GetUserContract_Reload").start();
    }

    public void showQuantity() {
    }

    public void checkExpireContract() {
    }

    public void addAllContractsToWatch(String contract, boolean isAtLoginTime) {
    }

    static {
        int index = 0;
        columnIndex.put(LanguageConstant.Market, index++);
        columnIndex.put("Contract", index++);
        columnIndex.put("BuyVol", index++);
        columnIndex.put(LanguageConstant.Buy, index++);
        columnIndex.put(LanguageConstant.Sell, index++);
        columnIndex.put("SellVol", index++);
        columnIndex.put(LanguageConstant.LastPrice, index++);
        columnIndex.put("Change", index++);
        columnIndex.put("Dir", index++);
        columnIndex.put("LTrdTime", index++);
        columnIndex.put(LanguageConstant.TotalVolume, index++);
        columnIndex.put(LanguageConstant.Low, index++);
        columnIndex.put(LanguageConstant.Average, index++);
        columnIndex.put(LanguageConstant.High, index++);
        columnIndex.put("TotalTrd", index++);
        columnIndex.put("LTrdVolume", index++);
        columnIndex.put(LanguageConstant.ClosePrice, index++);
        columnIndex.put(LanguageConstant.State, index++);
        columnIndex.put(LanguageConstant.Flag, index++);
        columnIndex.put("Spread", index++);
        columnIndex.put(LanguageConstant.PercentChange, index++);
    }
}

