/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.runtime.metaclass;

import groovy.lang.ExpandoMetaClass;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassRegistry;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import org.codehaus.groovy.reflection.CachedClass;
import org.codehaus.groovy.reflection.CachedMethod;
import org.codehaus.groovy.reflection.FastArray;
import org.codehaus.groovy.reflection.ReflectionCache;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.DefaultGroovyStaticMethods;
import org.codehaus.groovy.runtime.metaclass.ConcurrentReaderHashMap;
import org.codehaus.groovy.runtime.metaclass.MemoryAwareConcurrentReadMap;
import org.codehaus.groovy.runtime.metaclass.NewInstanceMetaMethod;
import org.codehaus.groovy.runtime.metaclass.NewMetaMethod;
import org.codehaus.groovy.runtime.metaclass.NewStaticMetaMethod;
import org.codehaus.groovy.vmplugin.VMPluginFactory;

public class MetaClassRegistryImpl
implements MetaClassRegistry {
    private volatile int constantMetaClassCount = 0;
    private ConcurrentReaderHashMap constantMetaClasses = new ConcurrentReaderHashMap();
    private MemoryAwareConcurrentReadMap weakMetaClasses = new MemoryAwareConcurrentReadMap();
    private MemoryAwareConcurrentReadMap loaderMap = new MemoryAwareConcurrentReadMap();
    private boolean useAccessible;
    private FastArray instanceMethods = new FastArray();
    private FastArray staticMethods = new FastArray();
    private volatile Integer version = new Integer(0);
    private MyThreadLocal locallyKnown = new MyThreadLocal();
    public static final int LOAD_DEFAULT = 0;
    public static final int DONT_LOAD_DEFAULT = 1;
    private static MetaClassRegistry instanceInclude;
    private static MetaClassRegistry instanceExclude;
    private MetaClassRegistry.MetaClassCreationHandle metaClassCreationHandle = new MetaClassRegistry.MetaClassCreationHandle();

    public MetaClassRegistryImpl() {
        this(0, true);
    }

    public MetaClassRegistryImpl(int loadDefault) {
        this(loadDefault, true);
    }

    public MetaClassRegistryImpl(boolean useAccessible) {
        this(0, useAccessible);
    }

    public MetaClassRegistryImpl(int loadDefault, boolean useAccessible) {
        this.useAccessible = useAccessible;
        if (loadDefault == 0) {
            HashMap map = new HashMap();
            this.registerMethods(DefaultGroovyMethods.class, true, map);
            Class[] pluginDGMs = VMPluginFactory.getPlugin().getPluginDefaultGroovyMethods();
            for (int i = 0; i < pluginDGMs.length; ++i) {
                this.registerMethods(pluginDGMs[i], true, map);
            }
            this.registerMethods(DefaultGroovyStaticMethods.class, false, map);
            Iterator it = map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = it.next();
                CachedClass cls = (CachedClass)e.getKey();
                ArrayList list = (ArrayList)e.getValue();
                cls.setNewMopMethods(list);
            }
        }
        this.installMetaClassCreationHandle();
        MetaClass emcMetaClass = this.metaClassCreationHandle.create(ExpandoMetaClass.class, this);
        emcMetaClass.initialize();
        this.constantMetaClasses.put(ExpandoMetaClass.class, emcMetaClass);
        this.constantMetaClassCount = 1;
    }

    private void installMetaClassCreationHandle() {
        try {
            Class<?> customMetaClassHandle = Class.forName("groovy.runtime.metaclass.CustomMetaClassCreationHandle");
            Constructor<?> customMetaClassHandleConstructor = customMetaClassHandle.getConstructor(new Class[0]);
            this.metaClassCreationHandle = (MetaClassRegistry.MetaClassCreationHandle)customMetaClassHandleConstructor.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            this.metaClassCreationHandle = new MetaClassRegistry.MetaClassCreationHandle();
        }
        catch (Exception e) {
            throw new GroovyRuntimeException("Could not instantiate custom Metaclass creation handle: " + e, e);
        }
    }

    private void registerMethods(Class theClass, boolean useInstanceMethods, Map map) {
        CachedMethod[] methods = ReflectionCache.getCachedClass(theClass).getMethods();
        for (int i = 0; i < methods.length; ++i) {
            NewMetaMethod metaMethod;
            CachedClass[] paramTypes;
            CachedMethod method = methods[i];
            int mod = method.getModifiers();
            if (!Modifier.isStatic(mod) || !Modifier.isPublic(mod) || (paramTypes = method.getParameterTypes()).length <= 0) continue;
            ArrayList<NewInstanceMetaMethod> arr = (ArrayList<NewInstanceMetaMethod>)map.get(paramTypes[0]);
            if (arr == null) {
                arr = new ArrayList<NewInstanceMetaMethod>(4);
                map.put(paramTypes[0], arr);
            }
            if (useInstanceMethods) {
                metaMethod = new NewInstanceMetaMethod(method);
                arr.add((NewInstanceMetaMethod)metaMethod);
                this.instanceMethods.add(metaMethod);
                continue;
            }
            metaMethod = new NewStaticMetaMethod(method);
            arr.add((NewInstanceMetaMethod)metaMethod);
            this.staticMethods.add(metaMethod);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MetaClass getGlobalMetaClass(Class theClass) {
        MetaClass answer = null;
        if (this.constantMetaClassCount != 0) {
            answer = (MetaClass)this.constantMetaClasses.get(theClass);
        }
        if (answer != null) {
            return answer;
        }
        answer = (MetaClass)this.weakMetaClasses.get(theClass);
        if (answer != null) {
            return answer;
        }
        Class clazz = theClass;
        synchronized (clazz) {
            answer = (MetaClass)this.weakMetaClasses.get(theClass);
            if (answer != null) {
                return answer;
            }
            CachedClass forEffect = ReflectionCache.getCachedClass(theClass);
            answer = this.metaClassCreationHandle.create(theClass, this);
            answer.initialize();
            if (GroovySystem.isKeepJavaMetaClasses()) {
                ++this.constantMetaClassCount;
                this.constantMetaClasses.put(theClass, answer);
            } else {
                this.weakMetaClasses.put(theClass, answer);
            }
        }
        return answer;
    }

    public MetaClass getMetaClass(Class theClass) {
        return this.locallyKnown.getMetaClass(theClass);
    }

    public synchronized void removeMetaClass(Class theClass) {
        this.version = new Integer(this.version + 1);
        Object answer = null;
        if (this.constantMetaClassCount != 0) {
            answer = this.constantMetaClasses.remove(theClass);
        }
        if (answer == null) {
            this.weakMetaClasses.remove(theClass);
        } else {
            --this.constantMetaClassCount;
        }
        ReflectionCache.getCachedClass(theClass).setStaticMetaClassField(null);
    }

    public synchronized void setMetaClass(Class theClass, MetaClass theMetaClass) {
        this.version = new Integer(this.version + 1);
        ++this.constantMetaClassCount;
        this.constantMetaClasses.put(theClass, theMetaClass);
        ReflectionCache.getCachedClass(theClass).setStaticMetaClassField(theMetaClass);
    }

    public boolean useAccessible() {
        return this.useAccessible;
    }

    public MetaClassRegistry.MetaClassCreationHandle getMetaClassCreationHandler() {
        return this.metaClassCreationHandle;
    }

    public void setMetaClassCreationHandle(MetaClassRegistry.MetaClassCreationHandle handle) {
        if (handle == null) {
            throw new IllegalArgumentException("Cannot set MetaClassCreationHandle to null value!");
        }
        this.metaClassCreationHandle = handle;
    }

    public static MetaClassRegistry getInstance(int includeExtension) {
        if (includeExtension != 1) {
            if (instanceInclude == null) {
                instanceInclude = new MetaClassRegistryImpl();
            }
            return instanceInclude;
        }
        if (instanceExclude == null) {
            instanceExclude = new MetaClassRegistryImpl(1);
        }
        return instanceExclude;
    }

    public FastArray getInstanceMethods() {
        return this.instanceMethods;
    }

    public FastArray getStaticMethods() {
        return this.staticMethods;
    }

    private class LocallyKnownClasses
    extends WeakHashMap {
        int version;
        public static final int CACHE_SIZE = 5;
        final MetaClass[] cache = new MetaClass[5];
        int nextCacheEntry;

        private LocallyKnownClasses() {
        }

        public MetaClass getMetaClass(Class theClass) {
            int regv = MetaClassRegistryImpl.this.version;
            if (this.version != regv) {
                this.clear();
            } else {
                MetaClass mc = this.checkCache(theClass);
                if (mc != null) {
                    return mc;
                }
                mc = this.checkMap(theClass);
                if (mc != null) {
                    return mc;
                }
            }
            return this.getFromGlobal(theClass);
        }

        private MetaClass checkCache(Class theClass) {
            for (int i = 0; i != 5; ++i) {
                MetaClass metaClass = this.cache[i];
                if (metaClass == null || metaClass.getTheClass() != theClass) continue;
                return metaClass;
            }
            return null;
        }

        private MetaClass checkMap(Class theClass) {
            MetaClass mc;
            SoftReference ref = (SoftReference)this.get(theClass);
            if (ref != null && (mc = (MetaClass)ref.get()) != null) {
                this.putToCache(mc);
                return mc;
            }
            return null;
        }

        private MetaClass getFromGlobal(Class theClass) {
            MetaClass answer = MetaClassRegistryImpl.this.getGlobalMetaClass(theClass);
            this.put(theClass, answer);
            this.version = MetaClassRegistryImpl.this.version;
            return answer;
        }

        public Object put(Object key, Object value) {
            this.putToCache((MetaClass)value);
            return super.put(key, new SoftReference<Object>(value));
        }

        private void putToCache(MetaClass value) {
            this.cache[this.nextCacheEntry++] = value;
            if (this.nextCacheEntry == 5) {
                this.nextCacheEntry = 0;
            }
        }

        public void clear() {
            for (int i = 0; i < this.cache.length; ++i) {
                this.cache[i] = null;
            }
            super.clear();
        }
    }

    private class MyThreadLocal
    extends ThreadLocal {
        private volatile LocallyKnownClasses myClasses;
        private Thread myThread;

        private MyThreadLocal() {
            this.myClasses = new LocallyKnownClasses();
            this.myThread = Thread.currentThread();
        }

        protected Object initialValue() {
            return new LocallyKnownClasses();
        }

        public MetaClass getMetaClass(Class theClass) {
            return ((LocallyKnownClasses)this.get()).getMetaClass(theClass);
        }

        public Object get() {
            if (Thread.currentThread() != this.myThread) {
                return super.get();
            }
            return this.myClasses;
        }
    }
}

