/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.tools.shell.util;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import jline.ANSIBuffer;
import jline.Terminal;
import org.codehaus.groovy.tools.shell.util.MessageSource;

public class ANSI {
    private static Boolean enabled;
    static /* synthetic */ Class class$org$codehaus$groovy$tools$shell$util$ANSI$Code;

    private static boolean detect() {
        boolean enabled = Terminal.getTerminal().isANSISupported();
        if (!enabled) {
            String force = System.getProperty(ANSI.class.getName() + ".force", "false");
            enabled = Boolean.valueOf(force);
        }
        return enabled;
    }

    public static boolean isDetected() {
        return ANSI.detect();
    }

    public static void setEnabled(boolean flag) {
        enabled = flag;
    }

    public static boolean isEnabled() {
        if (enabled == null) {
            enabled = ANSI.isDetected();
        }
        return enabled;
    }

    public static class Buffer {
        private final StringBuffer buff = new StringBuffer();
        public final boolean autoClear = true;
        static final /* synthetic */ boolean $assertionsDisabled;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            try {
                String string = this.buff.toString();
                return string;
            }
            finally {
                this.clear();
            }
        }

        public void clear() {
            this.buff.setLength(0);
        }

        public int size() {
            return this.buff.length();
        }

        public Buffer append(String text) {
            this.buff.append(text);
            return this;
        }

        public Buffer append(Object obj) {
            return this.append(String.valueOf(obj));
        }

        public Buffer attrib(int code) {
            if (ANSI.isEnabled()) {
                this.buff.append(ANSIBuffer.ANSICodes.attrib((int)code));
            }
            return this;
        }

        public Buffer attrib(String text, int code) {
            if (!$assertionsDisabled && text == null) {
                throw new AssertionError();
            }
            if (ANSI.isEnabled()) {
                this.buff.append(ANSIBuffer.ANSICodes.attrib((int)code)).append(text).append(ANSIBuffer.ANSICodes.attrib((int)0));
            } else {
                this.buff.append(text);
            }
            return this;
        }

        public Buffer attrib(String text, String codeName) {
            return this.attrib(text, Code.forName(codeName));
        }

        static {
            $assertionsDisabled = !(class$org$codehaus$groovy$tools$shell$util$ANSI == null ? (class$org$codehaus$groovy$tools$shell$util$ANSI = ANSI.class$("org.codehaus.groovy.tools.shell.util.ANSI")) : class$org$codehaus$groovy$tools$shell$util$ANSI).desiredAssertionStatus();
        }
    }

    public static class Code {
        public static final int OFF = 0;
        public static final int BOLD = 1;
        public static final int UNDERSCORE = 4;
        public static final int BLINK = 5;
        public static final int REVERSE = 7;
        public static final int CONCEALED = 8;
        public static final int FG_BLACK = 30;
        public static final int FG_RED = 31;
        public static final int FG_GREEN = 32;
        public static final int FG_YELLOW = 33;
        public static final int FG_BLUE = 34;
        public static final int FG_MAGENTA = 35;
        public static final int FG_CYAN = 36;
        public static final int FG_WHITE = 37;
        public static final int BLACK = 30;
        public static final int RED = 31;
        public static final int GREEN = 32;
        public static final int YELLOW = 33;
        public static final int BLUE = 34;
        public static final int MAGENTA = 35;
        public static final int CYAN = 36;
        public static final int WHITE = 37;
        public static final int BG_BLACK = 40;
        public static final int BG_RED = 41;
        public static final int BG_GREEN = 42;
        public static final int BG_YELLOW = 43;
        public static final int BG_BLUE = 44;
        public static final int BG_MAGENTA = 45;
        public static final int BG_CYAN = 46;
        public static final int BG_WHITE = 47;
        private static final Map NAMES_TO_CODES;
        private static final Map CODES_TO_NAMES;
        static final /* synthetic */ boolean $assertionsDisabled;

        public static int forName(String name) throws IllegalArgumentException {
            if (!$assertionsDisabled && name == null) {
                throw new AssertionError();
            }
            String tmp = name.toUpperCase();
            Number code = (Number)NAMES_TO_CODES.get(tmp);
            if (code == null) {
                throw new IllegalArgumentException("Invalid ANSI code name: " + name);
            }
            return code.intValue();
        }

        public static String name(int code) throws IllegalArgumentException {
            String name = (String)CODES_TO_NAMES.get(new Integer(code));
            if (name == null) {
                throw new IllegalArgumentException("Invalid ANSI code: " + code);
            }
            return name;
        }

        static {
            $assertionsDisabled = !(class$org$codehaus$groovy$tools$shell$util$ANSI == null ? (class$org$codehaus$groovy$tools$shell$util$ANSI = ANSI.class$("org.codehaus.groovy.tools.shell.util.ANSI")) : class$org$codehaus$groovy$tools$shell$util$ANSI).desiredAssertionStatus();
            Field[] fields = (class$org$codehaus$groovy$tools$shell$util$ANSI$Code == null ? (class$org$codehaus$groovy$tools$shell$util$ANSI$Code = ANSI.class$("org.codehaus.groovy.tools.shell.util.ANSI$Code")) : class$org$codehaus$groovy$tools$shell$util$ANSI$Code).getDeclaredFields();
            HashMap<String, Number> names = new HashMap<String, Number>(fields.length);
            HashMap<Number, String> codes = new HashMap<Number, String>(fields.length);
            try {
                for (int i = 0; i < fields.length; ++i) {
                    int mods = fields[i].getModifiers();
                    if (!Modifier.isPublic(mods)) continue;
                    String name = fields[i].getName();
                    Number code = (Number)fields[i].get(class$org$codehaus$groovy$tools$shell$util$ANSI$Code == null ? ANSI.class$("org.codehaus.groovy.tools.shell.util.ANSI$Code") : class$org$codehaus$groovy$tools$shell$util$ANSI$Code);
                    names.put(name, code);
                    codes.put(code, name);
                }
            }
            catch (IllegalAccessException e) {
                throw new Error(e);
            }
            NAMES_TO_CODES = names;
            CODES_TO_NAMES = codes;
        }
    }

    public static class RenderMessageSource
    extends MessageSource {
        private final Renderer renderer = new Renderer();

        public RenderMessageSource(String[] names) {
            super(names);
        }

        public RenderMessageSource(String name) {
            super(name);
        }

        public RenderMessageSource(Class[] types) {
            super(types);
        }

        public RenderMessageSource(Class type) {
            super(type);
        }

        public String getMessage(String code) {
            String msg = super.getMessage(code);
            if (Renderer.test(msg)) {
                return this.renderer.render(msg);
            }
            return msg;
        }
    }

    public static class RenderWriter
    extends PrintWriter {
        private final Renderer renderer = new Renderer();

        public RenderWriter(OutputStream out) {
            super(out);
        }

        public RenderWriter(OutputStream out, boolean autoFlush) {
            super(out, autoFlush);
        }

        public RenderWriter(Writer out) {
            super(out);
        }

        public RenderWriter(Writer out, boolean autoFlush) {
            super(out, autoFlush);
        }

        public void write(String s) {
            if (Renderer.test(s)) {
                super.write(this.renderer.render(s));
            } else {
                super.write(s);
            }
        }
    }

    public static class Renderer {
        public static final String BEGIN_TOKEN = "@|";
        private static final int BEGIN_TOKEN_SIZE;
        public static final String END_TOKEN = "|";
        private static final int END_TOKEN_SIZE;
        public static final String CODE_TEXT_SEPARATOR = " ";
        public static final String CODE_LIST_SEPARATOR = ",";
        private final Buffer buff = new Buffer();
        static final /* synthetic */ boolean $assertionsDisabled;

        public String render(String input) throws RenderException {
            int p;
            if (!$assertionsDisabled && input == null) {
                throw new AssertionError();
            }
            int c = 0;
            while (c < input.length() && (p = input.indexOf(BEGIN_TOKEN, c)) >= 0) {
                int s = input.indexOf(END_TOKEN, p + BEGIN_TOKEN_SIZE);
                if (s < 0) {
                    throw new RenderException("Missing '|': " + input);
                }
                String expr = input.substring(p + BEGIN_TOKEN_SIZE, s);
                this.buff.append(input.substring(c, p));
                this.evaluate(expr);
                c = s + END_TOKEN_SIZE;
            }
            this.buff.append(input.substring(c));
            return this.buff.toString();
        }

        private void evaluate(String input) throws RenderException {
            if (!$assertionsDisabled && input == null) {
                throw new AssertionError();
            }
            int i = input.indexOf(CODE_TEXT_SEPARATOR);
            if (i < 0) {
                throw new RenderException("Missing ANSI code/text separator ' ': " + input);
            }
            String tmp = input.substring(0, i);
            String[] codes = tmp.split(CODE_LIST_SEPARATOR);
            String text = input.substring(i + 1, input.length());
            for (int j = 0; j < codes.length; ++j) {
                int code = Code.forName(codes[j]);
                this.buff.attrib(code);
            }
            this.buff.append(text);
            this.buff.attrib(0);
        }

        public static boolean test(String text) {
            return text != null && text.indexOf(BEGIN_TOKEN) >= 0;
        }

        public static String encode(String text, int code) {
            return BEGIN_TOKEN + Code.name(code) + CODE_TEXT_SEPARATOR + text + END_TOKEN;
        }

        static {
            $assertionsDisabled = !(class$org$codehaus$groovy$tools$shell$util$ANSI == null ? (class$org$codehaus$groovy$tools$shell$util$ANSI = ANSI.class$("org.codehaus.groovy.tools.shell.util.ANSI")) : class$org$codehaus$groovy$tools$shell$util$ANSI).desiredAssertionStatus();
            BEGIN_TOKEN_SIZE = BEGIN_TOKEN.length();
            END_TOKEN_SIZE = END_TOKEN.length();
        }

        public static class RenderException
        extends RuntimeException {
            public RenderException(String msg) {
                super(msg);
            }
        }
    }
}

